"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.api.v0.luminarycloud.common.common_pb2
import luminarycloud._proto.quantity.quantity_pb2
import luminarycloud._proto.table.table_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CameraDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CameraDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CameraDirection.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNSPECIFIED: _CameraDirection.ValueType  # 0
    X_POSITIVE: _CameraDirection.ValueType  # 1
    Y_POSITIVE: _CameraDirection.ValueType  # 2
    Z_POSITIVE: _CameraDirection.ValueType  # 3
    X_NEGATIVE: _CameraDirection.ValueType  # 4
    Y_NEGATIVE: _CameraDirection.ValueType  # 5
    Z_NEGATIVE: _CameraDirection.ValueType  # 6

class CameraDirection(_CameraDirection, metaclass=_CameraDirectionEnumTypeWrapper): ...

UNSPECIFIED: CameraDirection.ValueType  # 0
X_POSITIVE: CameraDirection.ValueType  # 1
Y_POSITIVE: CameraDirection.ValueType  # 2
Z_POSITIVE: CameraDirection.ValueType  # 3
X_NEGATIVE: CameraDirection.ValueType  # 4
Y_NEGATIVE: CameraDirection.ValueType  # 5
Z_NEGATIVE: CameraDirection.ValueType  # 6
global___CameraDirection = CameraDirection

class _CameraProjection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CameraProjectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CameraProjection.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ORTHOGRAPHIC: _CameraProjection.ValueType  # 0
    PERSPECTIVE: _CameraProjection.ValueType  # 1

class CameraProjection(_CameraProjection, metaclass=_CameraProjectionEnumTypeWrapper): ...

ORTHOGRAPHIC: CameraProjection.ValueType  # 0
PERSPECTIVE: CameraProjection.ValueType  # 1
global___CameraProjection = CameraProjection

class _Representation:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RepresentationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Representation.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SURFACE: _Representation.ValueType  # 0
    SURFACE_WITH_EDGES: _Representation.ValueType  # 1
    WIREFRAME: _Representation.ValueType  # 2
    POINTS: _Representation.ValueType  # 3

class Representation(_Representation, metaclass=_RepresentationEnumTypeWrapper):
    """Render representation modes."""

SURFACE: Representation.ValueType  # 0
SURFACE_WITH_EDGES: Representation.ValueType  # 1
WIREFRAME: Representation.ValueType  # 2
POINTS: Representation.ValueType  # 3
global___Representation = Representation

class _StreamlinesDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StreamlinesDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StreamlinesDirection.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STREAMLINES_DIRECTION_UNSPECIFIED: _StreamlinesDirection.ValueType  # 0
    STREAMLINES_DIRECTION_FORWARD: _StreamlinesDirection.ValueType  # 1
    STREAMLINES_DIRECTION_BACKWARD: _StreamlinesDirection.ValueType  # 2
    STREAMLINES_DIRECTION_BOTH: _StreamlinesDirection.ValueType  # 3

class StreamlinesDirection(_StreamlinesDirection, metaclass=_StreamlinesDirectionEnumTypeWrapper): ...

STREAMLINES_DIRECTION_UNSPECIFIED: StreamlinesDirection.ValueType  # 0
STREAMLINES_DIRECTION_FORWARD: StreamlinesDirection.ValueType  # 1
STREAMLINES_DIRECTION_BACKWARD: StreamlinesDirection.ValueType  # 2
STREAMLINES_DIRECTION_BOTH: StreamlinesDirection.ValueType  # 3
global___StreamlinesDirection = StreamlinesDirection

class _GlyphSamplingMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GlyphSamplingModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GlyphSamplingMode.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    GLYPH_SAMPLING_MODE_UNSPECIFIED: _GlyphSamplingMode.ValueType  # 0
    GLYPH_SAMPLING_MODE_EVERY_NTH: _GlyphSamplingMode.ValueType  # 1

class GlyphSamplingMode(_GlyphSamplingMode, metaclass=_GlyphSamplingModeEnumTypeWrapper): ...

GLYPH_SAMPLING_MODE_UNSPECIFIED: GlyphSamplingMode.ValueType  # 0
GLYPH_SAMPLING_MODE_EVERY_NTH: GlyphSamplingMode.ValueType  # 1
global___GlyphSamplingMode = GlyphSamplingMode

class _ColorMapName:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ColorMapNameEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ColorMapName.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    COLOR_MAP_NAME_UNSPECIFIED: _ColorMapName.ValueType  # 0
    COLOR_MAP_NAME_VIRIDIS: _ColorMapName.ValueType  # 1
    COLOR_MAP_NAME_COOL_TO_WARM: _ColorMapName.ValueType  # 2
    COLOR_MAP_NAME_TURBO: _ColorMapName.ValueType  # 3
    COLOR_MAP_NAME_JET: _ColorMapName.ValueType  # 4
    COLOR_MAP_NAME_WAVE: _ColorMapName.ValueType  # 5
    COLOR_MAP_NAME_XRAY: _ColorMapName.ValueType  # 6
    COLOR_MAP_NAME_PLASMA: _ColorMapName.ValueType  # 7

class ColorMapName(_ColorMapName, metaclass=_ColorMapNameEnumTypeWrapper):
    """Predefined color maps these values need to stay in sync with the
    visualization service proto names.
    """

COLOR_MAP_NAME_UNSPECIFIED: ColorMapName.ValueType  # 0
COLOR_MAP_NAME_VIRIDIS: ColorMapName.ValueType  # 1
COLOR_MAP_NAME_COOL_TO_WARM: ColorMapName.ValueType  # 2
COLOR_MAP_NAME_TURBO: ColorMapName.ValueType  # 3
COLOR_MAP_NAME_JET: ColorMapName.ValueType  # 4
COLOR_MAP_NAME_WAVE: ColorMapName.ValueType  # 5
COLOR_MAP_NAME_XRAY: ColorMapName.ValueType  # 6
COLOR_MAP_NAME_PLASMA: ColorMapName.ValueType  # 7
global___ColorMapName = ColorMapName

class _ExtractStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ExtractStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ExtractStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    Invalid: _ExtractStatus.ValueType  # 0
    """Sentinel. A good job will never have this value"""
    Active: _ExtractStatus.ValueType  # 1
    """Currently running"""
    Completed: _ExtractStatus.ValueType  # 2
    """Finished successfully"""
    Failed: _ExtractStatus.ValueType  # 3
    """Job failed"""

class ExtractStatus(_ExtractStatus, metaclass=_ExtractStatusEnumTypeWrapper): ...

Invalid: ExtractStatus.ValueType  # 0
"""Sentinel. A good job will never have this value"""
Active: ExtractStatus.ValueType  # 1
"""Currently running"""
Completed: ExtractStatus.ValueType  # 2
"""Finished successfully"""
Failed: ExtractStatus.ValueType  # 3
"""Job failed"""
global___ExtractStatus = ExtractStatus

class _RenderDataUrlsStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RenderDataUrlsStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RenderDataUrlsStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RenderDataUrlsInvalid: _RenderDataUrlsStatus.ValueType  # 0
    """Sentinel. A good job will never have this value"""
    RenderDataUrlsCompleted: _RenderDataUrlsStatus.ValueType  # 2
    """Finished successfully"""
    RenderDataUrlsFailed: _RenderDataUrlsStatus.ValueType  # 3
    """Job failed"""

class RenderDataUrlsStatus(_RenderDataUrlsStatus, metaclass=_RenderDataUrlsStatusEnumTypeWrapper): ...

RenderDataUrlsInvalid: RenderDataUrlsStatus.ValueType  # 0
"""Sentinel. A good job will never have this value"""
RenderDataUrlsCompleted: RenderDataUrlsStatus.ValueType  # 2
"""Finished successfully"""
RenderDataUrlsFailed: RenderDataUrlsStatus.ValueType  # 3
"""Job failed"""
global___RenderDataUrlsStatus = RenderDataUrlsStatus

class _FieldAssociation:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FieldAssociationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FieldAssociation.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FIELD_ASSOCIATION_UNSPECIFIED: _FieldAssociation.ValueType  # 0
    FIELD_ASSOCIATION_CELLS: _FieldAssociation.ValueType  # 1
    FIELD_ASSOCIATION_POINTS: _FieldAssociation.ValueType  # 2

class FieldAssociation(_FieldAssociation, metaclass=_FieldAssociationEnumTypeWrapper): ...

FIELD_ASSOCIATION_UNSPECIFIED: FieldAssociation.ValueType  # 0
FIELD_ASSOCIATION_CELLS: FieldAssociation.ValueType  # 1
FIELD_ASSOCIATION_POINTS: FieldAssociation.ValueType  # 2
global___FieldAssociation = FieldAssociation

class Pan(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    X_FIELD_NUMBER: builtins.int
    Y_FIELD_NUMBER: builtins.int
    x: builtins.float
    y: builtins.float
    def __init__(
        self,
        *,
        x: builtins.float = ...,
        y: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["x", b"x", "y", b"y"]) -> None: ...

global___Pan = Pan

class CameraLookAt(google.protobuf.message.Message):
    """Camera location based on the look at convention."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITION_FIELD_NUMBER: builtins.int
    LOOK_AT_FIELD_NUMBER: builtins.int
    UP_FIELD_NUMBER: builtins.int
    PAN_FIELD_NUMBER: builtins.int
    @property
    def position(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Position of the camera."""
    @property
    def look_at(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Point to which the camera is looking."""
    @property
    def up(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Up vector of the camera."""
    @property
    def pan(self) -> global___Pan: ...
    def __init__(
        self,
        *,
        position: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        look_at: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        up: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        pan: global___Pan | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_pan", b"_pan", "look_at", b"look_at", "pan", b"pan", "position", b"position", "up", b"up"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_pan", b"_pan", "look_at", b"look_at", "pan", b"pan", "position", b"position", "up", b"up"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_pan", b"_pan"]) -> typing_extensions.Literal["pan"] | None: ...

global___CameraLookAt = CameraLookAt

class Resolution(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    width: builtins.int
    height: builtins.int
    def __init__(
        self,
        *,
        width: builtins.int = ...,
        height: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["height", b"height", "width", b"width"]) -> None: ...

global___Resolution = Resolution

class Camera(google.protobuf.message.Message):
    """Defines a camera used to render."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECTION_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    LOOK_AT_FIELD_NUMBER: builtins.int
    ZOOM_FIELD_NUMBER: builtins.int
    projection: global___CameraProjection.ValueType
    direction: global___CameraDirection.ValueType
    @property
    def look_at(self) -> global___CameraLookAt: ...
    zoom: builtins.float
    def __init__(
        self,
        *,
        projection: global___CameraProjection.ValueType = ...,
        direction: global___CameraDirection.ValueType = ...,
        look_at: global___CameraLookAt | None = ...,
        zoom: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_zoom", b"_zoom", "direction", b"direction", "look_at", b"look_at", "specification", b"specification", "zoom", b"zoom"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_zoom", b"_zoom", "direction", b"direction", "look_at", b"look_at", "projection", b"projection", "specification", b"specification", "zoom", b"zoom"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_zoom", b"_zoom"]) -> typing_extensions.Literal["zoom"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["specification", b"specification"]) -> typing_extensions.Literal["direction", "look_at"] | None: ...

global___Camera = Camera

class AnimationSettingsStatic(google.protobuf.message.Message):
    """Animation settings to generate a sole static(single result) image."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMERA_FIELD_NUMBER: builtins.int
    RESOLUTION_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    @property
    def camera(self) -> global___Camera: ...
    @property
    def resolution(self) -> global___Resolution: ...
    label: builtins.str
    """User defined label to distinguish this image from many."""
    def __init__(
        self,
        *,
        camera: global___Camera | None = ...,
        resolution: global___Resolution | None = ...,
        label: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["camera", b"camera", "resolution", b"resolution"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["camera", b"camera", "label", b"label", "resolution", b"resolution"]) -> None: ...

global___AnimationSettingsStatic = AnimationSettingsStatic

class AnimationSettingsTimeStep(google.protobuf.message.Message):
    """Animation settings to generate a video for transient simulations."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Format:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AnimationSettingsTimeStep._Format.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FORMAT_UNSPECIFIED: AnimationSettingsTimeStep._Format.ValueType  # 0
        FORMAT_GIF: AnimationSettingsTimeStep._Format.ValueType  # 1
        FORMAT_MP4: AnimationSettingsTimeStep._Format.ValueType  # 2

    class Format(_Format, metaclass=_FormatEnumTypeWrapper): ...
    FORMAT_UNSPECIFIED: AnimationSettingsTimeStep.Format.ValueType  # 0
    FORMAT_GIF: AnimationSettingsTimeStep.Format.ValueType  # 1
    FORMAT_MP4: AnimationSettingsTimeStep.Format.ValueType  # 2

    CAMERA_FIELD_NUMBER: builtins.int
    RESOLUTION_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    SKIP_FRAMES_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    @property
    def camera(self) -> global___Camera: ...
    @property
    def resolution(self) -> global___Resolution: ...
    format: global___AnimationSettingsTimeStep.Format.ValueType
    skip_frames: builtins.int
    label: builtins.str
    """User defined label to distinguish this animation from many."""
    def __init__(
        self,
        *,
        camera: global___Camera | None = ...,
        resolution: global___Resolution | None = ...,
        format: global___AnimationSettingsTimeStep.Format.ValueType = ...,
        skip_frames: builtins.int = ...,
        label: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["camera", b"camera", "resolution", b"resolution"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["camera", b"camera", "format", b"format", "label", b"label", "resolution", b"resolution", "skip_frames", b"skip_frames"]) -> None: ...

global___AnimationSettingsTimeStep = AnimationSettingsTimeStep

class StaticSettings(google.protobuf.message.Message):
    """We need a containter for the repeated animation settings.  This is meant to
    support multiple setting of either type, since oneof definitions can't have
    repeated fields.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AnimationSettingsStatic]: ...
    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___AnimationSettingsStatic] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["items", b"items"]) -> None: ...

global___StaticSettings = StaticSettings

class TimeStepSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AnimationSettingsTimeStep]: ...
    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___AnimationSettingsTimeStep] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["items", b"items"]) -> None: ...

global___TimeStepSettings = TimeStepSettings

class AnimationProperties(google.protobuf.message.Message):
    """Animation properties."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATICS_FIELD_NUMBER: builtins.int
    TIME_STEPS_FIELD_NUMBER: builtins.int
    @property
    def statics(self) -> global___StaticSettings: ...
    @property
    def time_steps(self) -> global___TimeStepSettings: ...
    def __init__(
        self,
        *,
        statics: global___StaticSettings | None = ...,
        time_steps: global___TimeStepSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["settings", b"settings", "statics", b"statics", "time_steps", b"time_steps"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["settings", b"settings", "statics", b"statics", "time_steps", b"time_steps"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["settings", b"settings"]) -> typing_extensions.Literal["statics", "time_steps"] | None: ...

global___AnimationProperties = AnimationProperties

class Field(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Component:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ComponentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Field._Component.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        COMPONENT_UNSPECIFIED: Field._Component.ValueType  # 0
        COMPONENT_X: Field._Component.ValueType  # 1
        COMPONENT_Y: Field._Component.ValueType  # 2
        COMPONENT_Z: Field._Component.ValueType  # 3
        COMPONENT_MAGNITUDE: Field._Component.ValueType  # -1

    class Component(_Component, metaclass=_ComponentEnumTypeWrapper): ...
    COMPONENT_UNSPECIFIED: Field.Component.ValueType  # 0
    COMPONENT_X: Field.Component.ValueType  # 1
    COMPONENT_Y: Field.Component.ValueType  # 2
    COMPONENT_Z: Field.Component.ValueType  # 3
    COMPONENT_MAGNITUDE: Field.Component.ValueType  # -1

    QUANTITY_TYP_FIELD_NUMBER: builtins.int
    COMPONENT_FIELD_NUMBER: builtins.int
    quantity_typ: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType
    component: global___Field.Component.ValueType
    def __init__(
        self,
        *,
        quantity_typ: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType = ...,
        component: global___Field.Component.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["component", b"component", "quantity_typ", b"quantity_typ"]) -> None: ...

global___Field = Field

class DisplayAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    VISIBLE_FIELD_NUMBER: builtins.int
    REPRESENTATION_FIELD_NUMBER: builtins.int
    OPACITY_FIELD_NUMBER: builtins.int
    @property
    def field(self) -> global___Field:
        """Display variable to be visualized. Optional if the extract referes to a
        mesh entity.
        """
    visible: builtins.bool
    """Visibility"""
    representation: global___Representation.ValueType
    """Render representation of the entity."""
    opacity: builtins.float
    """Opacity of the entity. Optional. Default is 1."""
    def __init__(
        self,
        *,
        field: global___Field | None = ...,
        visible: builtins.bool | None = ...,
        representation: global___Representation.ValueType = ...,
        opacity: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_opacity", b"_opacity", "_visible", b"_visible", "field", b"field", "opacity", b"opacity", "visible", b"visible"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_opacity", b"_opacity", "_visible", b"_visible", "field", b"field", "opacity", b"opacity", "representation", b"representation", "visible", b"visible"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_opacity", b"_opacity"]) -> typing_extensions.Literal["opacity"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visible", b"_visible"]) -> typing_extensions.Literal["visible"] | None: ...

global___DisplayAttributes = DisplayAttributes

class Plane(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGIN_FIELD_NUMBER: builtins.int
    NORMAL_FIELD_NUMBER: builtins.int
    @property
    def origin(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """A point on the slice plane"""
    @property
    def normal(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """The plane normal"""
    def __init__(
        self,
        *,
        origin: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        normal: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["normal", b"normal", "origin", b"origin"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["normal", b"normal", "origin", b"origin"]) -> None: ...

global___Plane = Plane

class AABB(google.protobuf.message.Message):
    """Axis-aligned bounding box"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_FIELD_NUMBER: builtins.int
    MAX_FIELD_NUMBER: builtins.int
    @property
    def min(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3: ...
    @property
    def max(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3: ...
    def __init__(
        self,
        *,
        min: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        max: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["max", b"max", "min", b"min"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max", b"max", "min", b"min"]) -> None: ...

global___AABB = AABB

class Slice(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANE_FIELD_NUMBER: builtins.int
    PROJECT_VECTORS_FIELD_NUMBER: builtins.int
    @property
    def plane(self) -> global___Plane: ...
    project_vectors: builtins.bool
    """Project vectors onto the plane of the slice."""
    def __init__(
        self,
        *,
        plane: global___Plane | None = ...,
        project_vectors: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["plane", b"plane"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["plane", b"plane", "project_vectors", b"project_vectors"]) -> None: ...

global___Slice = Slice

class Contour(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    ISO_VALUES_FIELD_NUMBER: builtins.int
    @property
    def field(self) -> global___Field: ...
    @property
    def iso_values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        field: global___Field | None = ...,
        iso_values: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["field", b"field"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["field", b"field", "iso_values", b"iso_values"]) -> None: ...

global___Contour = Contour

class Threshold(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    RANGE_FIELD_NUMBER: builtins.int
    SMOOTH_FIELD_NUMBER: builtins.int
    INVERT_FIELD_NUMBER: builtins.int
    STRICT_FIELD_NUMBER: builtins.int
    @property
    def field(self) -> global___Field: ...
    @property
    def range(self) -> global___Range: ...
    smooth: builtins.bool
    invert: builtins.bool
    strict: builtins.bool
    def __init__(
        self,
        *,
        field: global___Field | None = ...,
        range: global___Range | None = ...,
        smooth: builtins.bool | None = ...,
        invert: builtins.bool | None = ...,
        strict: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_invert", b"_invert", "_smooth", b"_smooth", "_strict", b"_strict", "field", b"field", "invert", b"invert", "range", b"range", "smooth", b"smooth", "strict", b"strict"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_invert", b"_invert", "_smooth", b"_smooth", "_strict", b"_strict", "field", b"field", "invert", b"invert", "range", b"range", "smooth", b"smooth", "strict", b"strict"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_invert", b"_invert"]) -> typing_extensions.Literal["invert"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_smooth", b"_smooth"]) -> typing_extensions.Literal["smooth"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_strict", b"_strict"]) -> typing_extensions.Literal["strict"] | None: ...

global___Threshold = Threshold

class SeedRakeConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Starting point."""
    @property
    def end(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """End point"""
    def __init__(
        self,
        *,
        start: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        end: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> None: ...

global___SeedRakeConfig = SeedRakeConfig

class SeedSurfaceConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OFFSET_FIELD_NUMBER: builtins.int
    PROJECT_ON_SURFACE_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_FIELD_NUMBER: builtins.int
    SURFACE_NAMES_FIELD_NUMBER: builtins.int
    offset: builtins.float
    project_on_surface: builtins.bool
    sample_rate: builtins.int
    @property
    def surface_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        offset: builtins.float | None = ...,
        project_on_surface: builtins.bool | None = ...,
        sample_rate: builtins.int | None = ...,
        surface_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_offset", b"_offset", "_project_on_surface", b"_project_on_surface", "_sample_rate", b"_sample_rate", "offset", b"offset", "project_on_surface", b"project_on_surface", "sample_rate", b"sample_rate"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_offset", b"_offset", "_project_on_surface", b"_project_on_surface", "_sample_rate", b"_sample_rate", "offset", b"offset", "project_on_surface", b"project_on_surface", "sample_rate", b"sample_rate", "surface_names", b"surface_names"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_offset", b"_offset"]) -> typing_extensions.Literal["offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_project_on_surface", b"_project_on_surface"]) -> typing_extensions.Literal["project_on_surface"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_sample_rate", b"_sample_rate"]) -> typing_extensions.Literal["sample_rate"] | None: ...

global___SeedSurfaceConfig = SeedSurfaceConfig

class SeedGridConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAKE_RES_FIELD_NUMBER: builtins.int
    SEED_RES_FIELD_NUMBER: builtins.int
    SEED_SPACING_FIELD_NUMBER: builtins.int
    RAKE_SPACING_FIELD_NUMBER: builtins.int
    CENTER_FIELD_NUMBER: builtins.int
    U_VEC_FIELD_NUMBER: builtins.int
    V_VEC_FIELD_NUMBER: builtins.int
    rake_res: builtins.int
    """Number of seeds in a rake."""
    seed_res: builtins.int
    """Number of rakes."""
    seed_spacing: builtins.float
    """Spacing between seeds."""
    rake_spacing: builtins.float
    """Spacing between parallel rakes."""
    @property
    def center(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Center of the grid."""
    @property
    def u_vec(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Parallel to the rakes."""
    @property
    def v_vec(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Normal to the slider."""
    def __init__(
        self,
        *,
        rake_res: builtins.int | None = ...,
        seed_res: builtins.int | None = ...,
        seed_spacing: builtins.float | None = ...,
        rake_spacing: builtins.float | None = ...,
        center: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        u_vec: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        v_vec: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_rake_res", b"_rake_res", "_rake_spacing", b"_rake_spacing", "_seed_res", b"_seed_res", "_seed_spacing", b"_seed_spacing", "center", b"center", "rake_res", b"rake_res", "rake_spacing", b"rake_spacing", "seed_res", b"seed_res", "seed_spacing", b"seed_spacing", "u_vec", b"u_vec", "v_vec", b"v_vec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_rake_res", b"_rake_res", "_rake_spacing", b"_rake_spacing", "_seed_res", b"_seed_res", "_seed_spacing", b"_seed_spacing", "center", b"center", "rake_res", b"rake_res", "rake_spacing", b"rake_spacing", "seed_res", b"seed_res", "seed_spacing", b"seed_spacing", "u_vec", b"u_vec", "v_vec", b"v_vec"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_rake_res", b"_rake_res"]) -> typing_extensions.Literal["rake_res"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_rake_spacing", b"_rake_spacing"]) -> typing_extensions.Literal["rake_spacing"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_seed_res", b"_seed_res"]) -> typing_extensions.Literal["seed_res"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_seed_spacing", b"_seed_spacing"]) -> typing_extensions.Literal["seed_spacing"] | None: ...

global___SeedGridConfig = SeedGridConfig

class Streamlines(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAKE_FIELD_NUMBER: builtins.int
    SURFACE_FIELD_NUMBER: builtins.int
    GRID_FIELD_NUMBER: builtins.int
    N_STREAMLINES_FIELD_NUMBER: builtins.int
    MAX_LENGTH_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    FIELD_FIELD_NUMBER: builtins.int
    @property
    def rake(self) -> global___SeedRakeConfig: ...
    @property
    def surface(self) -> global___SeedSurfaceConfig: ...
    @property
    def grid(self) -> global___SeedGridConfig: ...
    n_streamlines: builtins.int
    max_length: builtins.float
    direction: global___StreamlinesDirection.ValueType
    @property
    def field(self) -> global___Field: ...
    def __init__(
        self,
        *,
        rake: global___SeedRakeConfig | None = ...,
        surface: global___SeedSurfaceConfig | None = ...,
        grid: global___SeedGridConfig | None = ...,
        n_streamlines: builtins.int | None = ...,
        max_length: builtins.float | None = ...,
        direction: global___StreamlinesDirection.ValueType = ...,
        field: global___Field | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_max_length", b"_max_length", "_n_streamlines", b"_n_streamlines", "field", b"field", "grid", b"grid", "max_length", b"max_length", "n_streamlines", b"n_streamlines", "rake", b"rake", "seed_type", b"seed_type", "surface", b"surface"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_max_length", b"_max_length", "_n_streamlines", b"_n_streamlines", "direction", b"direction", "field", b"field", "grid", b"grid", "max_length", b"max_length", "n_streamlines", b"n_streamlines", "rake", b"rake", "seed_type", b"seed_type", "surface", b"surface"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_max_length", b"_max_length"]) -> typing_extensions.Literal["max_length"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_n_streamlines", b"_n_streamlines"]) -> typing_extensions.Literal["n_streamlines"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["seed_type", b"seed_type"]) -> typing_extensions.Literal["rake", "surface", "grid"] | None: ...

global___Streamlines = Streamlines

class Glyph(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    N_GLYPHS_FIELD_NUMBER: builtins.int
    SAMPLING_MODE_FIELD_NUMBER: builtins.int
    FIXED_SIZE_GLYPHS_FIELD_NUMBER: builtins.int
    GLYPH_SCALE_SIZE_FIELD_NUMBER: builtins.int
    @property
    def field(self) -> global___Field: ...
    n_glyphs: builtins.int
    sampling_mode: global___GlyphSamplingMode.ValueType
    fixed_size_glyphs: builtins.float
    glyph_scale_size: builtins.float
    def __init__(
        self,
        *,
        field: global___Field | None = ...,
        n_glyphs: builtins.int | None = ...,
        sampling_mode: global___GlyphSamplingMode.ValueType = ...,
        fixed_size_glyphs: builtins.float = ...,
        glyph_scale_size: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_n_glyphs", b"_n_glyphs", "field", b"field", "fixed_size_glyphs", b"fixed_size_glyphs", "glyph_scale_size", b"glyph_scale_size", "glyph_size", b"glyph_size", "n_glyphs", b"n_glyphs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_n_glyphs", b"_n_glyphs", "field", b"field", "fixed_size_glyphs", b"fixed_size_glyphs", "glyph_scale_size", b"glyph_scale_size", "glyph_size", b"glyph_size", "n_glyphs", b"n_glyphs", "sampling_mode", b"sampling_mode"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_n_glyphs", b"_n_glyphs"]) -> typing_extensions.Literal["n_glyphs"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["glyph_size", b"glyph_size"]) -> typing_extensions.Literal["fixed_size_glyphs", "glyph_scale_size"] | None: ...

global___Glyph = Glyph

class SurfaceLICGeomtery(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SURFACE_NAMES_FIELD_NUMBER: builtins.int
    @property
    def surface_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        surface_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["surface_names", b"surface_names"]) -> None: ...

global___SurfaceLICGeomtery = SurfaceLICGeomtery

class SurfaceLICPlane(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANE_FIELD_NUMBER: builtins.int
    CLIP_BOX_FIELD_NUMBER: builtins.int
    @property
    def plane(self) -> global___Plane:
        """The plane for the surface LIC."""
    @property
    def clip_box(self) -> global___AABB:
        """The clip box to constrain the plane."""
    def __init__(
        self,
        *,
        plane: global___Plane | None = ...,
        clip_box: global___AABB | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["clip_box", b"clip_box", "plane", b"plane"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["clip_box", b"clip_box", "plane", b"plane"]) -> None: ...

global___SurfaceLICPlane = SurfaceLICPlane

class SurfaceLIC(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    GEOMETRY_FIELD_NUMBER: builtins.int
    PLANE_FIELD_NUMBER: builtins.int
    CONTRAST_FIELD_NUMBER: builtins.int
    @property
    def field(self) -> global___Field: ...
    @property
    def geometry(self) -> global___SurfaceLICGeomtery: ...
    @property
    def plane(self) -> global___SurfaceLICPlane: ...
    contrast: builtins.float
    def __init__(
        self,
        *,
        field: global___Field | None = ...,
        geometry: global___SurfaceLICGeomtery | None = ...,
        plane: global___SurfaceLICPlane | None = ...,
        contrast: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["field", b"field", "geometry", b"geometry", "lic_type", b"lic_type", "plane", b"plane"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["contrast", b"contrast", "field", b"field", "geometry", b"geometry", "lic_type", b"lic_type", "plane", b"plane"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["lic_type", b"lic_type"]) -> typing_extensions.Literal["geometry", "plane"] | None: ...

global___SurfaceLIC = SurfaceLIC

class IntersectionCurve(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANE_FIELD_NUMBER: builtins.int
    SURFACES_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    @property
    def plane(self) -> global___Plane: ...
    @property
    def surfaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    label: builtins.str
    def __init__(
        self,
        *,
        plane: global___Plane | None = ...,
        surfaces: collections.abc.Iterable[builtins.str] | None = ...,
        label: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["plane", b"plane"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["label", b"label", "plane", b"plane", "surfaces", b"surfaces"]) -> None: ...

global___IntersectionCurve = IntersectionCurve

class LineSampleMeshResolution(google.protobuf.message.Message):
    """This type has no params"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___LineSampleMeshResolution = LineSampleMeshResolution

class LineSample(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    MESH_RESOLUTION_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3: ...
    @property
    def end(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3: ...
    label: builtins.str
    @property
    def mesh_resolution(self) -> global___LineSampleMeshResolution: ...
    def __init__(
        self,
        *,
        start: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        end: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        label: builtins.str = ...,
        mesh_resolution: global___LineSampleMeshResolution | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end", b"end", "mesh_resolution", b"mesh_resolution", "sample_type", b"sample_type", "start", b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end", b"end", "label", b"label", "mesh_resolution", b"mesh_resolution", "sample_type", b"sample_type", "start", b"start"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["sample_type", b"sample_type"]) -> typing_extensions.Literal["mesh_resolution"] | None: ...

global___LineSample = LineSample

class Filter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SLICE_FIELD_NUMBER: builtins.int
    CLIP_FIELD_NUMBER: builtins.int
    CONTOUR_FIELD_NUMBER: builtins.int
    THRESHOLD_FIELD_NUMBER: builtins.int
    STREAMLINES_FIELD_NUMBER: builtins.int
    GLYPH_FIELD_NUMBER: builtins.int
    SURFACE_LIC_FIELD_NUMBER: builtins.int
    INTERSECTION_CURVE_FIELD_NUMBER: builtins.int
    LINE_SAMPLE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique identifier for this filter."""
    name: builtins.str
    """A name for this filter. Can be provided by the user."""
    @property
    def slice(self) -> global___Slice: ...
    @property
    def clip(self) -> global___Clip: ...
    @property
    def contour(self) -> global___Contour: ...
    @property
    def threshold(self) -> global___Threshold: ...
    @property
    def streamlines(self) -> global___Streamlines: ...
    @property
    def glyph(self) -> global___Glyph: ...
    @property
    def surface_lic(self) -> global___SurfaceLIC: ...
    @property
    def intersection_curve(self) -> global___IntersectionCurve: ...
    @property
    def line_sample(self) -> global___LineSample: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        slice: global___Slice | None = ...,
        clip: global___Clip | None = ...,
        contour: global___Contour | None = ...,
        threshold: global___Threshold | None = ...,
        streamlines: global___Streamlines | None = ...,
        glyph: global___Glyph | None = ...,
        surface_lic: global___SurfaceLIC | None = ...,
        intersection_curve: global___IntersectionCurve | None = ...,
        line_sample: global___LineSample | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["clip", b"clip", "contour", b"contour", "glyph", b"glyph", "intersection_curve", b"intersection_curve", "line_sample", b"line_sample", "slice", b"slice", "streamlines", b"streamlines", "surface_lic", b"surface_lic", "threshold", b"threshold", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["clip", b"clip", "contour", b"contour", "glyph", b"glyph", "id", b"id", "intersection_curve", b"intersection_curve", "line_sample", b"line_sample", "name", b"name", "slice", b"slice", "streamlines", b"streamlines", "surface_lic", b"surface_lic", "threshold", b"threshold", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["slice", "clip", "contour", "threshold", "streamlines", "glyph", "surface_lic", "intersection_curve", "line_sample"] | None: ...

global___Filter = Filter

class MeshEntity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___MeshEntity = MeshEntity

class SimulationEntity(google.protobuf.message.Message):
    """Used to generate post processing extractions on a given solution of a
    simulation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SOLUTION_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    solution_id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        solution_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "solution_id", b"solution_id"]) -> None: ...

global___SimulationEntity = SimulationEntity

class GeometryEntity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    geometry_version_id: builtins.str
    """Optional. If provided, the geometry version will be the last one at an
    arbitrary time when the extraction is performed by our services.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_version_id", b"geometry_version_id", "id", b"id"]) -> None: ...

global___GeometryEntity = GeometryEntity

class ExtractEntity(google.protobuf.message.Message):
    """Entity to which the extract is associated."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_FIELD_NUMBER: builtins.int
    SIMULATION_FIELD_NUMBER: builtins.int
    GEOMETRY_FIELD_NUMBER: builtins.int
    @property
    def mesh(self) -> global___MeshEntity: ...
    @property
    def simulation(self) -> global___SimulationEntity: ...
    @property
    def geometry(self) -> global___GeometryEntity: ...
    def __init__(
        self,
        *,
        mesh: global___MeshEntity | None = ...,
        simulation: global___SimulationEntity | None = ...,
        geometry: global___GeometryEntity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity", "geometry", b"geometry", "mesh", b"mesh", "simulation", b"simulation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "geometry", b"geometry", "mesh", b"mesh", "simulation", b"simulation"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["entity", b"entity"]) -> typing_extensions.Literal["mesh", "simulation", "geometry"] | None: ...

global___ExtractEntity = ExtractEntity

class Range(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_FIELD_NUMBER: builtins.int
    MAX_FIELD_NUMBER: builtins.int
    min: builtins.float
    max: builtins.float
    def __init__(
        self,
        *,
        min: builtins.float = ...,
        max: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max", b"max", "min", b"min"]) -> None: ...

global___Range = Range

class ColorMap(google.protobuf.message.Message):
    """Color map for a given display variable."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AutomaticLocation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AutomaticLocationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ColorMap._AutomaticLocation.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUTOMATIC_LOCATION_UNSPECIFIED: ColorMap._AutomaticLocation.ValueType  # 0
        """Not specified. Defaults to right horizontal."""
        AUTOMATIC_LOCATION_RIGHT: ColorMap._AutomaticLocation.ValueType  # 1
        """Automatic location of the color map to the center right of the image."""
        AUTOMATIC_LOCATION_LEFT: ColorMap._AutomaticLocation.ValueType  # 2
        """Automatic location of the color map to the center left of the image."""
        AUTOMATIC_LOCATION_BOTTOM: ColorMap._AutomaticLocation.ValueType  # 3
        """Automatic location of the color map to the bottom center of the image.
        It is recommended to set the horizontal property to true when using this
        location mode.
        """
        AUTOMATIC_LOCATION_TOP: ColorMap._AutomaticLocation.ValueType  # 4
        """Automatic location of the color map to the top center of the image.
        It is recommended to set the horizontal property to true when using this
        location mode.
        """

    class AutomaticLocation(_AutomaticLocation, metaclass=_AutomaticLocationEnumTypeWrapper): ...
    AUTOMATIC_LOCATION_UNSPECIFIED: ColorMap.AutomaticLocation.ValueType  # 0
    """Not specified. Defaults to right horizontal."""
    AUTOMATIC_LOCATION_RIGHT: ColorMap.AutomaticLocation.ValueType  # 1
    """Automatic location of the color map to the center right of the image."""
    AUTOMATIC_LOCATION_LEFT: ColorMap.AutomaticLocation.ValueType  # 2
    """Automatic location of the color map to the center left of the image."""
    AUTOMATIC_LOCATION_BOTTOM: ColorMap.AutomaticLocation.ValueType  # 3
    """Automatic location of the color map to the bottom center of the image.
    It is recommended to set the horizontal property to true when using this
    location mode.
    """
    AUTOMATIC_LOCATION_TOP: ColorMap.AutomaticLocation.ValueType  # 4
    """Automatic location of the color map to the top center of the image.
    It is recommended to set the horizontal property to true when using this
    location mode.
    """

    class AnchorLocation(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        X_FIELD_NUMBER: builtins.int
        Y_FIELD_NUMBER: builtins.int
        x: builtins.float
        y: builtins.float
        def __init__(
            self,
            *,
            x: builtins.float | None = ...,
            y: builtins.float | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_x", b"_x", "_y", b"_y", "x", b"x", "y", b"y"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_x", b"_x", "_y", b"_y", "x", b"x", "y", b"y"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_x", b"_x"]) -> typing_extensions.Literal["x"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_y", b"_y"]) -> typing_extensions.Literal["y"] | None: ...

    class Automatic(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    class MinMaxOnly(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    FIELD_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    RANGE_FIELD_NUMBER: builtins.int
    VISIBLE_FIELD_NUMBER: builtins.int
    DISCRETIZE_FIELD_NUMBER: builtins.int
    N_COLORS_FIELD_NUMBER: builtins.int
    AUTOMATIC_LOCATION_FIELD_NUMBER: builtins.int
    LOWER_LEFT_ANCHOR_LOCATION_FIELD_NUMBER: builtins.int
    AUTOMATIC_TICK_FIELD_NUMBER: builtins.int
    MIN_MAX_ONLY_TICK_FIELD_NUMBER: builtins.int
    TEXT_SIZE_FIELD_NUMBER: builtins.int
    HORIZONTAL_FIELD_NUMBER: builtins.int
    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    @property
    def field(self) -> global___Field:
        """Display variable to which the color map is applied."""
    name: global___ColorMapName.ValueType
    """Predefined color map name."""
    @property
    def range(self) -> global___Range:
        """Optional range for the color map. If not provided, the global range of the
        variable is used.
        """
    visible: builtins.bool
    """Whether the color map is visible."""
    discretize: builtins.bool
    """If true, we discretize the color map into n_colors bins."""
    n_colors: builtins.int
    """The number of discrete bins for the color map."""
    automatic_location: global___ColorMap.AutomaticLocation.ValueType
    """Automatic location of the color map."""
    @property
    def lower_left_anchor_location(self) -> global___ColorMap.AnchorLocation:
        """Anchor point of the color map in normalized coordinates."""
    @property
    def automatic_tick(self) -> global___ColorMap.Automatic: ...
    @property
    def min_max_only_tick(self) -> global___ColorMap.MinMaxOnly: ...
    text_size: builtins.float
    """Text size in pixel units."""
    horizontal: builtins.bool
    """Whether the color map is horizontal. Defaults to false."""
    width: builtins.float
    """Horizontal size of the color map in normalized coordinates. If the color
    map is horizontal, this field represents the vertical size.
    """
    height: builtins.float
    """Vertical size of the color map in normalized coordinates. If the color
    map is horizontal, this field represents the horizontal size.
    """
    def __init__(
        self,
        *,
        field: global___Field | None = ...,
        name: global___ColorMapName.ValueType = ...,
        range: global___Range | None = ...,
        visible: builtins.bool | None = ...,
        discretize: builtins.bool | None = ...,
        n_colors: builtins.int | None = ...,
        automatic_location: global___ColorMap.AutomaticLocation.ValueType = ...,
        lower_left_anchor_location: global___ColorMap.AnchorLocation | None = ...,
        automatic_tick: global___ColorMap.Automatic | None = ...,
        min_max_only_tick: global___ColorMap.MinMaxOnly | None = ...,
        text_size: builtins.float | None = ...,
        horizontal: builtins.bool | None = ...,
        width: builtins.float | None = ...,
        height: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_discretize", b"_discretize", "_height", b"_height", "_horizontal", b"_horizontal", "_n_colors", b"_n_colors", "_range", b"_range", "_text_size", b"_text_size", "_visible", b"_visible", "_width", b"_width", "automatic_location", b"automatic_location", "automatic_tick", b"automatic_tick", "discretize", b"discretize", "field", b"field", "height", b"height", "horizontal", b"horizontal", "location", b"location", "lower_left_anchor_location", b"lower_left_anchor_location", "min_max_only_tick", b"min_max_only_tick", "n_colors", b"n_colors", "range", b"range", "text_size", b"text_size", "tick_specification", b"tick_specification", "visible", b"visible", "width", b"width"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_discretize", b"_discretize", "_height", b"_height", "_horizontal", b"_horizontal", "_n_colors", b"_n_colors", "_range", b"_range", "_text_size", b"_text_size", "_visible", b"_visible", "_width", b"_width", "automatic_location", b"automatic_location", "automatic_tick", b"automatic_tick", "discretize", b"discretize", "field", b"field", "height", b"height", "horizontal", b"horizontal", "location", b"location", "lower_left_anchor_location", b"lower_left_anchor_location", "min_max_only_tick", b"min_max_only_tick", "n_colors", b"n_colors", "name", b"name", "range", b"range", "text_size", b"text_size", "tick_specification", b"tick_specification", "visible", b"visible", "width", b"width"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_discretize", b"_discretize"]) -> typing_extensions.Literal["discretize"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_height", b"_height"]) -> typing_extensions.Literal["height"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_horizontal", b"_horizontal"]) -> typing_extensions.Literal["horizontal"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_n_colors", b"_n_colors"]) -> typing_extensions.Literal["n_colors"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_range", b"_range"]) -> typing_extensions.Literal["range"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_text_size", b"_text_size"]) -> typing_extensions.Literal["text_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visible", b"_visible"]) -> typing_extensions.Literal["visible"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_width", b"_width"]) -> typing_extensions.Literal["width"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["location", b"location"]) -> typing_extensions.Literal["automatic_location", "lower_left_anchor_location"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["tick_specification", b"tick_specification"]) -> typing_extensions.Literal["automatic_tick", "min_max_only_tick"] | None: ...

global___ColorMap = ColorMap

class Color(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    R_FIELD_NUMBER: builtins.int
    G_FIELD_NUMBER: builtins.int
    B_FIELD_NUMBER: builtins.int
    A_FIELD_NUMBER: builtins.int
    r: builtins.float
    """Red component."""
    g: builtins.float
    """Green component."""
    b: builtins.float
    """Blue component."""
    a: builtins.float
    """Alpha component."""
    def __init__(
        self,
        *,
        r: builtins.float = ...,
        g: builtins.float = ...,
        b: builtins.float = ...,
        a: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["a", b"a", "b", b"b", "g", b"g", "r", b"r"]) -> None: ...

global___Color = Color

class BackgroundProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLOR_FIELD_NUMBER: builtins.int
    @property
    def color(self) -> global___Color:
        """Background uniform color."""
    def __init__(
        self,
        *,
        color: global___Color | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["color", b"color", "properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["color", b"color", "properties", b"properties"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["properties", b"properties"]) -> typing_extensions.Literal["color"] | None: ...

global___BackgroundProperties = BackgroundProperties

class TriadProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VISIBLE_FIELD_NUMBER: builtins.int
    visible: builtins.bool
    """Whether the triad is visible."""
    def __init__(
        self,
        *,
        visible: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_visible", b"_visible", "visible", b"visible"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_visible", b"_visible", "visible", b"visible"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visible", b"_visible"]) -> typing_extensions.Literal["visible"] | None: ...

global___TriadProperties = TriadProperties

class FilterConnections(google.protobuf.message.Message):
    """Expresses the connections between filters. Each parent filter can have
    multiple children filters. These are the direct children of a filter. The
    distance between the parent and the children is one level.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHILDREN_ID_FIELD_NUMBER: builtins.int
    @property
    def children_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        children_id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["children_id", b"children_id"]) -> None: ...

global___FilterConnections = FilterConnections

class AxesGridProperties(google.protobuf.message.Message):
    """Properties of the axes grid."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VISIBLE_FIELD_NUMBER: builtins.int
    visible: builtins.bool
    def __init__(
        self,
        *,
        visible: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_visible", b"_visible", "visible", b"visible"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_visible", b"_visible", "visible", b"visible"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visible", b"_visible"]) -> typing_extensions.Literal["visible"] | None: ...

global___AxesGridProperties = AxesGridProperties

class ExtractSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class FilterConnectionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___FilterConnections: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___FilterConnections | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class DisplayAttributesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___DisplayAttributes: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___DisplayAttributes | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ENTITY_TYPE_FIELD_NUMBER: builtins.int
    AXES_GRID_PROPERTIES_FIELD_NUMBER: builtins.int
    FILTERS_FIELD_NUMBER: builtins.int
    FILTER_CONNECTIONS_FIELD_NUMBER: builtins.int
    GLOBAL_DISPLAY_ATTRIBUTES_FIELD_NUMBER: builtins.int
    DISPLAY_ATTRIBUTES_FIELD_NUMBER: builtins.int
    COLOR_MAPS_FIELD_NUMBER: builtins.int
    ANIMATION_PROPERTIES_FIELD_NUMBER: builtins.int
    TRIAD_PROPERTIES_FIELD_NUMBER: builtins.int
    BACKGROUND_PROPERTIES_FIELD_NUMBER: builtins.int
    SUPERSAMPLING_RATIO_FIELD_NUMBER: builtins.int
    DATA_ONLY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """User-define name of the extract."""
    description: builtins.str
    """User-defined description of the extract."""
    @property
    def entity_type(self) -> global___ExtractEntity:
        """Type of the entity to which the extract is associated."""
    @property
    def axes_grid_properties(self) -> global___AxesGridProperties:
        """Whether to show the axes grid."""
    @property
    def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Filter]:
        """List of filters to be applied on EntityType."""
    @property
    def filter_connections(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___FilterConnections]:
        """List of connections between filters. Maps a parent filter to its children."""
    @property
    def global_display_attributes(self) -> global___DisplayAttributes:
        """Global display attributes for the extract."""
    @property
    def display_attributes(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___DisplayAttributes]:
        """Display attributes for each entity of the mesh or geometry. Tag IDs are
        supported. It overrides the global display attributes.
        """
    @property
    def color_maps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ColorMap]:
        """Color maps. At most one per display variable. No duplicates can be found."""
    @property
    def animation_properties(self) -> global___AnimationProperties:
        """Animation properties. Specifies cameras and if this is transient or static."""
    @property
    def triad_properties(self) -> global___TriadProperties:
        """Properties of the triad."""
    @property
    def background_properties(self) -> global___BackgroundProperties:
        """Properties of the image background."""
    supersampling_ratio: builtins.int
    """Anti aliasing through super sampling. 1 means none. 2 means render
    internally at double the resolution.
    """
    data_only: builtins.bool
    """Flag for skipping validation for data only requests (i.e, no-images)."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        entity_type: global___ExtractEntity | None = ...,
        axes_grid_properties: global___AxesGridProperties | None = ...,
        filters: collections.abc.Iterable[global___Filter] | None = ...,
        filter_connections: collections.abc.Mapping[builtins.str, global___FilterConnections] | None = ...,
        global_display_attributes: global___DisplayAttributes | None = ...,
        display_attributes: collections.abc.Mapping[builtins.str, global___DisplayAttributes] | None = ...,
        color_maps: collections.abc.Iterable[global___ColorMap] | None = ...,
        animation_properties: global___AnimationProperties | None = ...,
        triad_properties: global___TriadProperties | None = ...,
        background_properties: global___BackgroundProperties | None = ...,
        supersampling_ratio: builtins.int | None = ...,
        data_only: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_background_properties", b"_background_properties", "_data_only", b"_data_only", "_supersampling_ratio", b"_supersampling_ratio", "animation_properties", b"animation_properties", "axes_grid_properties", b"axes_grid_properties", "background_properties", b"background_properties", "data_only", b"data_only", "entity_type", b"entity_type", "global_display_attributes", b"global_display_attributes", "supersampling_ratio", b"supersampling_ratio", "triad_properties", b"triad_properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_background_properties", b"_background_properties", "_data_only", b"_data_only", "_supersampling_ratio", b"_supersampling_ratio", "animation_properties", b"animation_properties", "axes_grid_properties", b"axes_grid_properties", "background_properties", b"background_properties", "color_maps", b"color_maps", "data_only", b"data_only", "description", b"description", "display_attributes", b"display_attributes", "entity_type", b"entity_type", "filter_connections", b"filter_connections", "filters", b"filters", "global_display_attributes", b"global_display_attributes", "name", b"name", "supersampling_ratio", b"supersampling_ratio", "triad_properties", b"triad_properties"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_background_properties", b"_background_properties"]) -> typing_extensions.Literal["background_properties"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_data_only", b"_data_only"]) -> typing_extensions.Literal["data_only"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_supersampling_ratio", b"_supersampling_ratio"]) -> typing_extensions.Literal["supersampling_ratio"] | None: ...

global___ExtractSpec = ExtractSpec

class CreateExtractRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The project id"""
    @property
    def spec(self) -> global___ExtractSpec: ...
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        spec: global___ExtractSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id", "spec", b"spec"]) -> None: ...

global___CreateExtractRequest = CreateExtractRequest

class Extract(google.protobuf.message.Message):
    """We are not returning the full extract spec atm. Use just enough information to
    be able to request the data associated with the extract and provide the user
    the ability to do some filtering.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTRACT_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    extract_id: builtins.str
    """The request is an async call. We return the extract id, so we can query the
    job status and retrieve the image once it complete.
    """
    name: builtins.str
    """The user provide name of the extract."""
    description: builtins.str
    """The user provide description of the extract."""
    project_id: builtins.str
    """The project id."""
    status: global___ExtractStatus.ValueType
    """The current status"""
    def __init__(
        self,
        *,
        extract_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        project_id: builtins.str = ...,
        status: global___ExtractStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "extract_id", b"extract_id", "name", b"name", "project_id", b"project_id", "status", b"status"]) -> None: ...

global___Extract = Extract

class Box(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CENTER_FIELD_NUMBER: builtins.int
    LENGTHS_FIELD_NUMBER: builtins.int
    ANGLES_FIELD_NUMBER: builtins.int
    @property
    def center(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3: ...
    @property
    def lengths(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3: ...
    @property
    def angles(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Euler angles in radians applied in XYZ order."""
    def __init__(
        self,
        *,
        center: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        lengths: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        angles: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["angles", b"angles", "center", b"center", "lengths", b"lengths"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["angles", b"angles", "center", b"center", "lengths", b"lengths"]) -> None: ...

global___Box = Box

class Clip(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANE_FIELD_NUMBER: builtins.int
    BOX_FIELD_NUMBER: builtins.int
    INVERTED_FIELD_NUMBER: builtins.int
    SMOOTH_FIELD_NUMBER: builtins.int
    @property
    def plane(self) -> global___Plane: ...
    @property
    def box(self) -> global___Box: ...
    inverted: builtins.bool
    smooth: builtins.bool
    def __init__(
        self,
        *,
        plane: global___Plane | None = ...,
        box: global___Box | None = ...,
        inverted: builtins.bool | None = ...,
        smooth: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_inverted", b"_inverted", "_smooth", b"_smooth", "box", b"box", "clip_function", b"clip_function", "inverted", b"inverted", "plane", b"plane", "smooth", b"smooth"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_inverted", b"_inverted", "_smooth", b"_smooth", "box", b"box", "clip_function", b"clip_function", "inverted", b"inverted", "plane", b"plane", "smooth", b"smooth"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_inverted", b"_inverted"]) -> typing_extensions.Literal["inverted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_smooth", b"_smooth"]) -> typing_extensions.Literal["smooth"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["clip_function", b"clip_function"]) -> typing_extensions.Literal["plane", "box"] | None: ...

global___Clip = Clip

class CreateExtractResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTRACT_FIELD_NUMBER: builtins.int
    @property
    def extract(self) -> global___Extract: ...
    def __init__(
        self,
        *,
        extract: global___Extract | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["extract", b"extract"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extract", b"extract"]) -> None: ...

global___CreateExtractResponse = CreateExtractResponse

class GetExtractResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTRACT_FIELD_NUMBER: builtins.int
    @property
    def extract(self) -> global___Extract: ...
    def __init__(
        self,
        *,
        extract: global___Extract | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["extract", b"extract"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extract", b"extract"]) -> None: ...

global___GetExtractResponse = GetExtractResponse

class GetExtractSpecResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEC_FIELD_NUMBER: builtins.int
    @property
    def spec(self) -> global___ExtractSpec: ...
    def __init__(
        self,
        *,
        spec: global___ExtractSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> None: ...

global___GetExtractSpecResponse = GetExtractSpecResponse

class GetExtractRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTRACT_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    extract_id: builtins.str
    project_id: builtins.str
    def __init__(
        self,
        *,
        extract_id: builtins.str = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extract_id", b"extract_id", "project_id", b"project_id"]) -> None: ...

global___GetExtractRequest = GetExtractRequest

class DownloadExtractRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    EXTRACT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    extract_id: builtins.str
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        extract_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extract_id", b"extract_id", "project_id", b"project_id"]) -> None: ...

global___DownloadExtractRequest = DownloadExtractRequest

class Images(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILES_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File]: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        files: collections.abc.Iterable[luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File] | None = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["files", b"files", "labels", b"labels"]) -> None: ...

global___Images = Images

class DownloadExtractResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGES_FIELD_NUMBER: builtins.int
    LINE_DATA_FIELD_NUMBER: builtins.int
    @property
    def images(self) -> global___Images: ...
    @property
    def line_data(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """If preset, this is a serialized proto of message type LineDataExtract."""
    def __init__(
        self,
        *,
        images: global___Images | None = ...,
        line_data: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["images", b"images", "line_data", b"line_data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["images", b"images", "line_data", b"line_data"]) -> None: ...

global___DownloadExtractResponse = DownloadExtractResponse

class ListExtractsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    ENTITY_FIELD_NUMBER: builtins.int
    DATA_ONLY_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The project id to query."""
    @property
    def entity(self) -> global___ExtractEntity:
        """The type of entity to query."""
    data_only: builtins.bool
    """Search for images or data extracts."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        entity: global___ExtractEntity | None = ...,
        data_only: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["data_only", b"data_only", "entity", b"entity", "project_id", b"project_id"]) -> None: ...

global___ListExtractsRequest = ListExtractsRequest

class ListExtractsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTRACTS_FIELD_NUMBER: builtins.int
    @property
    def extracts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Extract]: ...
    def __init__(
        self,
        *,
        extracts: collections.abc.Iterable[global___Extract] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extracts", b"extracts"]) -> None: ...

global___ListExtractsResponse = ListExtractsResponse

class DeleteExtractRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTRACT_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    extract_id: builtins.str
    project_id: builtins.str
    def __init__(
        self,
        *,
        extract_id: builtins.str = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extract_id", b"extract_id", "project_id", b"project_id"]) -> None: ...

global___DeleteExtractRequest = DeleteExtractRequest

class DeleteExtractResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteExtractResponse = DeleteExtractResponse

class GetRenderDataUrlsRequest(google.protobuf.message.Message):
    """For render data geometry APIs"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class FilterConnectionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___FilterConnections: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___FilterConnections | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    PROJECT_ID_FIELD_NUMBER: builtins.int
    ENTITY_FIELD_NUMBER: builtins.int
    FILTERS_FIELD_NUMBER: builtins.int
    FILTER_CONNECTIONS_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The project id"""
    @property
    def entity(self) -> global___ExtractEntity: ...
    @property
    def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Filter]:
        """An optional list of filters."""
    @property
    def filter_connections(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___FilterConnections]:
        """List of connections between filters. Maps a parent filter to its children."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        entity: global___ExtractEntity | None = ...,
        filters: collections.abc.Iterable[global___Filter] | None = ...,
        filter_connections: collections.abc.Mapping[builtins.str, global___FilterConnections] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "filter_connections", b"filter_connections", "filters", b"filters", "project_id", b"project_id"]) -> None: ...

global___GetRenderDataUrlsRequest = GetRenderDataUrlsRequest

class RenderDataUrls(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_IDS_FIELD_NUMBER: builtins.int
    DATA_FILES_FIELD_NUMBER: builtins.int
    @property
    def filter_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """For each filter id in the workspace_state, we list the ids and associated
        signed render data urls for the client to download them
        """
    @property
    def data_files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File]: ...
    def __init__(
        self,
        *,
        filter_ids: collections.abc.Iterable[builtins.str] | None = ...,
        data_files: collections.abc.Iterable[luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data_files", b"data_files", "filter_ids", b"filter_ids"]) -> None: ...

global___RenderDataUrls = RenderDataUrls

class GetRenderDataUrlsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKSPACE_STATE_FIELD_NUMBER: builtins.int
    URLS_FIELD_NUMBER: builtins.int
    workspace_state: builtins.str
    """The workspace state string, can be empty if execution failed"""
    @property
    def urls(self) -> global___RenderDataUrls:
        """Can be empty if execution failed"""
    def __init__(
        self,
        *,
        workspace_state: builtins.str | None = ...,
        urls: global___RenderDataUrls | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_urls", b"_urls", "_workspace_state", b"_workspace_state", "urls", b"urls", "workspace_state", b"workspace_state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_urls", b"_urls", "_workspace_state", b"_workspace_state", "urls", b"urls", "workspace_state", b"workspace_state"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_urls", b"_urls"]) -> typing_extensions.Literal["urls"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_workspace_state", b"_workspace_state"]) -> typing_extensions.Literal["workspace_state"] | None: ...

global___GetRenderDataUrlsResponse = GetRenderDataUrlsResponse

class ListSolutionFieldsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    @property
    def simulation(self) -> global___SimulationEntity: ...
    project_id: builtins.str
    def __init__(
        self,
        *,
        simulation: global___SimulationEntity | None = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation", b"simulation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id", "simulation", b"simulation"]) -> None: ...

global___ListSolutionFieldsRequest = ListSolutionFieldsRequest

class ListSolutionFieldsReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUANTITIES_FIELD_NUMBER: builtins.int
    @property
    def quantities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType]: ...
    def __init__(
        self,
        *,
        quantities: collections.abc.Iterable[luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["quantities", b"quantities"]) -> None: ...

global___ListSolutionFieldsReply = ListSolutionFieldsReply

class CameraEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CAMERA_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    camera_id: builtins.int
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        camera_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["camera_id", b"camera_id", "name", b"name"]) -> None: ...

global___CameraEntry = CameraEntry

class ListCamerasRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Optional project id. Empty means list global cameras."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id"]) -> None: ...

global___ListCamerasRequest = ListCamerasRequest

class ListCamerasReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMERA_FIELD_NUMBER: builtins.int
    @property
    def camera(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CameraEntry]: ...
    def __init__(
        self,
        *,
        camera: collections.abc.Iterable[global___CameraEntry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["camera", b"camera"]) -> None: ...

global___ListCamerasReply = ListCamerasReply

class GetCameraRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMERA_ID_FIELD_NUMBER: builtins.int
    RESOLUTION_FIELD_NUMBER: builtins.int
    camera_id: builtins.int
    @property
    def resolution(self) -> global___Resolution:
        """Exact camera params need an aspect ratio to produce the correct camera
        params
        """
    def __init__(
        self,
        *,
        camera_id: builtins.int = ...,
        resolution: global___Resolution | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resolution", b"resolution"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["camera_id", b"camera_id", "resolution", b"resolution"]) -> None: ...

global___GetCameraRequest = GetCameraRequest

class GetCameraReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMERA_FIELD_NUMBER: builtins.int
    @property
    def camera(self) -> global___Camera: ...
    def __init__(
        self,
        *,
        camera: global___Camera | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["camera", b"camera"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["camera", b"camera"]) -> None: ...

global___GetCameraReply = GetCameraReply

class LineDataExtract(google.protobuf.message.Message):
    """This is present to derserialize line data in python. Needs to be in sync
    with visualizationservice.proto.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Table(google.protobuf.message.Message):
        """One table per line segment since the segments are unstructured."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LINES_TABLE_FIELD_NUMBER: builtins.int
        @property
        def lines_table(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.table.table_pb2.RectilinearTable]: ...
        def __init__(
            self,
            *,
            lines_table: collections.abc.Iterable[luminarycloud._proto.table.table_pb2.RectilinearTable] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["lines_table", b"lines_table"]) -> None: ...

    class LinesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___LineDataExtract.Table: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___LineDataExtract.Table | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    LINES_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    @property
    def lines(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___LineDataExtract.Table]:
        """The key is the filter ID."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Filter id to user labels."""
    def __init__(
        self,
        *,
        lines: collections.abc.Mapping[builtins.str, global___LineDataExtract.Table] | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels", b"labels", "lines", b"lines"]) -> None: ...

global___LineDataExtract = LineDataExtract

class RangeEntity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_FIELD_NUMBER: builtins.int
    @property
    def simulation(self) -> global___SimulationEntity: ...
    def __init__(
        self,
        *,
        simulation: global___SimulationEntity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity", "simulation", b"simulation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "simulation", b"simulation"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["entity", b"entity"]) -> typing_extensions.Literal["simulation"] | None: ...

global___RangeEntity = RangeEntity

class RangeQueryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    ENTITY_FIELD_NUMBER: builtins.int
    FIELD_ASSOCIATION_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    @property
    def entity(self) -> global___RangeEntity: ...
    field_association: global___FieldAssociation.ValueType
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        entity: global___RangeEntity | None = ...,
        field_association: global___FieldAssociation.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "field_association", b"field_association", "project_id", b"project_id"]) -> None: ...

global___RangeQueryRequest = RangeQueryRequest

class RangeResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RANGE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    FIELD_NAME_FIELD_NUMBER: builtins.int
    @property
    def range(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Range]: ...
    quantity: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType
    field_name: builtins.str
    def __init__(
        self,
        *,
        range: collections.abc.Iterable[global___Range] | None = ...,
        quantity: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType = ...,
        field_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["field_name", b"field_name", "quantity", b"quantity", "range", b"range"]) -> None: ...

global___RangeResult = RangeResult

class RangeQueryReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RANGE_FIELD_NUMBER: builtins.int
    @property
    def range(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RangeResult]: ...
    def __init__(
        self,
        *,
        range: collections.abc.Iterable[global___RangeResult] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["range", b"range"]) -> None: ...

global___RangeQueryReply = RangeQueryReply
