"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.lcstatus.lcstatus_pb2
import luminarycloud._proto.quantity.quantity_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Subcode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SubcodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Subcode.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SUBCODE_UNSPECIFIED: _Subcode.ValueType  # 0
    """The default subcode."""
    SUBCODE_USER_NOT_FOUND: _Subcode.ValueType  # 1
    """Set only if Status.code=UNAUTHORIZED. USER_NOT_FOUND indicates that the
    backend server couldn't find the user in database. The client must start
    the user registration process.
    """
    SUBCODE_JOB_CANCELED_BY_USER: _Subcode.ValueType  # 2
    """Set if the user canceled a job."""
    SUBCODE_JOB_CANCELED_DIVERGENCE: _Subcode.ValueType  # 3
    """Set if the job was canceled because of divergence of the solver."""
    SUBCODE_JOB_CANCELED_SETUP_ERROR: _Subcode.ValueType  # 4
    """Set if the job was canceled because of bad setup."""
    SUBCODE_INCOMPATIBLE_CLIENT: _Subcode.ValueType  # 5
    """Set if the client version is incompatible with the backend."""
    SUBCODE_INSUFFICIENT_QUOTA: _Subcode.ValueType  # 6
    """Set if the user doesn't have enough quota for a given resource."""
    SUBCODE_EMAIL_DOMAIN_NOT_IN_ALLOWED_DOMAINS: _Subcode.ValueType  # 7
    """Set if the user's email domain is not in the list of allowed domains."""
    SUBCODE_TRIAL_ACCOUNT_USER_BLOCKED: _Subcode.ValueType  # 8
    """Set if a trial user attempts to access restricted features."""
    SUBCODE_UNLIMITED_PLAN_EXCEEDS_QUOTA: _Subcode.ValueType  # 9
    """Set if unlimited plan user exceeds quota for a given resource."""
    SUBCODE_DATE_RANGE_TOO_LARGE: _Subcode.ValueType  # 10
    """Set if a date range is too large (e.g. for usage records)"""
    SUBCODE_GEO_ERROR_TO_USER: _Subcode.ValueType  # 11
    """Set if the geometry error should be surfaced to the user."""
    SUBCODE_GEO_UNSUPPORTED: _Subcode.ValueType  # 12
    """Set if the provided CAD is not supported. Should be shown to the user."""

class Subcode(_Subcode, metaclass=_SubcodeEnumTypeWrapper):
    """Subcode is stored in StatusPayload.subcode.  It classifies the error type in
    finer grain.
    """

SUBCODE_UNSPECIFIED: Subcode.ValueType  # 0
"""The default subcode."""
SUBCODE_USER_NOT_FOUND: Subcode.ValueType  # 1
"""Set only if Status.code=UNAUTHORIZED. USER_NOT_FOUND indicates that the
backend server couldn't find the user in database. The client must start
the user registration process.
"""
SUBCODE_JOB_CANCELED_BY_USER: Subcode.ValueType  # 2
"""Set if the user canceled a job."""
SUBCODE_JOB_CANCELED_DIVERGENCE: Subcode.ValueType  # 3
"""Set if the job was canceled because of divergence of the solver."""
SUBCODE_JOB_CANCELED_SETUP_ERROR: Subcode.ValueType  # 4
"""Set if the job was canceled because of bad setup."""
SUBCODE_INCOMPATIBLE_CLIENT: Subcode.ValueType  # 5
"""Set if the client version is incompatible with the backend."""
SUBCODE_INSUFFICIENT_QUOTA: Subcode.ValueType  # 6
"""Set if the user doesn't have enough quota for a given resource."""
SUBCODE_EMAIL_DOMAIN_NOT_IN_ALLOWED_DOMAINS: Subcode.ValueType  # 7
"""Set if the user's email domain is not in the list of allowed domains."""
SUBCODE_TRIAL_ACCOUNT_USER_BLOCKED: Subcode.ValueType  # 8
"""Set if a trial user attempts to access restricted features."""
SUBCODE_UNLIMITED_PLAN_EXCEEDS_QUOTA: Subcode.ValueType  # 9
"""Set if unlimited plan user exceeds quota for a given resource."""
SUBCODE_DATE_RANGE_TOO_LARGE: Subcode.ValueType  # 10
"""Set if a date range is too large (e.g. for usage records)"""
SUBCODE_GEO_ERROR_TO_USER: Subcode.ValueType  # 11
"""Set if the geometry error should be surfaced to the user."""
SUBCODE_GEO_UNSUPPORTED: Subcode.ValueType  # 12
"""Set if the provided CAD is not supported. Should be shown to the user."""
global___Subcode = Subcode

class _JobStatusType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _JobStatusTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_JobStatusType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    Invalid: _JobStatusType.ValueType  # 0
    """Sentinel. A good job will never have this value"""
    Active: _JobStatusType.ValueType  # 1
    """Currently running"""
    Completed: _JobStatusType.ValueType  # 2
    """Finished successfully"""
    Failed: _JobStatusType.ValueType  # 3
    """Finished unsuccessfully"""
    Suspended: _JobStatusType.ValueType  # 4
    """Suspended by the user. Suspension is similar to Failed. The differences
    are: (1) JobStatus.status is not set when suspended, and (2) The job status
    will turn Active again when the user resumes the job. OTOH, a failed job
    cannot be restarted.
    """
    PendingRetry: _JobStatusType.ValueType  # 5
    """Transient error leading to a retry.
    Note: this is a status that may exist in the DB for jobs, but not for workflows.
    """
    Suspending: _JobStatusType.ValueType  # 6
    """Intermediate state that triggers cleanup/accounting, and transitions to Suspended as a terminal state.
    Note: this is a status that may exist in the DB for jobs, but not for workflows.
    """

class JobStatusType(_JobStatusType, metaclass=_JobStatusTypeEnumTypeWrapper):
    """Mappings between a nodelet job status and a job status is defined as follows:

    - if >0 pods are in Completed state => job is in Completed state
    - else if >0 process is in Failed state => job is in Failed state
    - else job is in Active state
    """

Invalid: JobStatusType.ValueType  # 0
"""Sentinel. A good job will never have this value"""
Active: JobStatusType.ValueType  # 1
"""Currently running"""
Completed: JobStatusType.ValueType  # 2
"""Finished successfully"""
Failed: JobStatusType.ValueType  # 3
"""Finished unsuccessfully"""
Suspended: JobStatusType.ValueType  # 4
"""Suspended by the user. Suspension is similar to Failed. The differences
are: (1) JobStatus.status is not set when suspended, and (2) The job status
will turn Active again when the user resumes the job. OTOH, a failed job
cannot be restarted.
"""
PendingRetry: JobStatusType.ValueType  # 5
"""Transient error leading to a retry.
Note: this is a status that may exist in the DB for jobs, but not for workflows.
"""
Suspending: JobStatusType.ValueType  # 6
"""Intermediate state that triggers cleanup/accounting, and transitions to Suspended as a terminal state.
Note: this is a status that may exist in the DB for jobs, but not for workflows.
"""
global___JobStatusType = JobStatusType

class _Vector3Component:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _Vector3ComponentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Vector3Component.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VECTOR_3_COMPONENT_INVALID: _Vector3Component.ValueType  # 0
    VECTOR_3_COMPONENT_X: _Vector3Component.ValueType  # 1
    VECTOR_3_COMPONENT_Y: _Vector3Component.ValueType  # 2
    VECTOR_3_COMPONENT_Z: _Vector3Component.ValueType  # 3

class Vector3Component(_Vector3Component, metaclass=_Vector3ComponentEnumTypeWrapper): ...

VECTOR_3_COMPONENT_INVALID: Vector3Component.ValueType  # 0
VECTOR_3_COMPONENT_X: Vector3Component.ValueType  # 1
VECTOR_3_COMPONENT_Y: Vector3Component.ValueType  # 2
VECTOR_3_COMPONENT_Z: Vector3Component.ValueType  # 3
global___Vector3Component = Vector3Component

class Checksum(google.protobuf.message.Message):
    """Checksum is a cryptographic checksum of data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHA256_FIELD_NUMBER: builtins.int
    sha256: builtins.bytes
    """Raw SHA256 32 byte string. Not a hex string."""
    def __init__(
        self,
        *,
        sha256: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm", "sha256", b"sha256"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm", "sha256", b"sha256"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["algorithm", b"algorithm"]) -> typing_extensions.Literal["sha256"] | None: ...

global___Checksum = Checksum

class Status(google.protobuf.message.Message):
    """Serialization of absl::Status. Represents the result of an operation.  This
    type is identical to
    https://github.com/grpc/grpc/blob/master/src/proto/grpc/status/status.proto

    It is replicated here, because the grpc proto isn't available in all
    languages (in particular Javascript/Typescript).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    code: builtins.int
    """GRPC/GCP/ABSL error code.
    https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
    """
    message: builtins.str
    """Messages that's suitable in a log file. It combines all the details found
    in StatusPayload.

    Caution: message is for internal consumption, and it should not be shown in
    the UI.  The UI should show the last entry in the detail.detail; it
    typically contains the most high-level description of the error.
    """
    @property
    def details(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.any_pb2.Any]:
        """List of payloads. Luminary-specific payload is stored in
        type.googleapis.com/luminary.proto.base.StatusPayload.
        """
    def __init__(
        self,
        *,
        code: builtins.int = ...,
        message: builtins.str = ...,
        details: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "details", b"details", "message", b"message"]) -> None: ...

global___Status = Status

class StatusPayload(google.protobuf.message.Message):
    """StatusPayload is stored in Status.details and absl::Status details."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBCODE_FIELD_NUMBER: builtins.int
    DETAIL_FIELD_NUMBER: builtins.int
    subcode: global___Subcode.ValueType
    """Subcode provides more context about the error type."""
    @property
    def detail(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StatusPayloadDetail]:
        """List of detailed error messages. By convention, the messages are stored in
        the call chain order. The first message is the most detailed, and the last
        message is at the top of the call chain.
        """
    def __init__(
        self,
        *,
        subcode: global___Subcode.ValueType = ...,
        detail: collections.abc.Iterable[global___StatusPayloadDetail] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["detail", b"detail", "subcode", b"subcode"]) -> None: ...

global___StatusPayload = StatusPayload

class StatusPayloadDetail(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    WHERE_FIELD_NUMBER: builtins.int
    message: builtins.str
    """Detailed error message. Lines should be separated by a single '\\n'."""
    where: builtins.str
    """The location of the code that generated Status.message. May be empty.  It
    is the function name or file:lineno.
    """
    def __init__(
        self,
        *,
        message: builtins.str = ...,
        where: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "where", b"where"]) -> None: ...

global___StatusPayloadDetail = StatusPayloadDetail

class JobStatus(google.protobuf.message.Message):
    """Status of a job or a workflow. The definition must match the JobStatus type
    in the DB schema.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYP_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    LCSTATUS_FIELD_NUMBER: builtins.int
    typ: global___JobStatusType.ValueType
    @property
    def status(self) -> global___Status:
        """GRPC-like status usually emitted when system errors occur"""
    @property
    def lcstatus(self) -> luminarycloud._proto.lcstatus.lcstatus_pb2.LCStatus:
        """Status that offers a more structured way for reporting errors.
        Usually used for user or internal errors.
        """
    def __init__(
        self,
        *,
        typ: global___JobStatusType.ValueType = ...,
        status: global___Status | None = ...,
        lcstatus: luminarycloud._proto.lcstatus.lcstatus_pb2.LCStatus | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["failed_reason", b"failed_reason", "lcstatus", b"lcstatus", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["failed_reason", b"failed_reason", "lcstatus", b"lcstatus", "status", b"status", "typ", b"typ"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["failed_reason", b"failed_reason"]) -> typing_extensions.Literal["status", "lcstatus"] | None: ...

global___JobStatus = JobStatus

class AdVector3(google.protobuf.message.Message):
    """3D vector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    X_FIELD_NUMBER: builtins.int
    Y_FIELD_NUMBER: builtins.int
    Z_FIELD_NUMBER: builtins.int
    @property
    def x(self) -> global___AdFloatType: ...
    @property
    def y(self) -> global___AdFloatType: ...
    @property
    def z(self) -> global___AdFloatType: ...
    def __init__(
        self,
        *,
        x: global___AdFloatType | None = ...,
        y: global___AdFloatType | None = ...,
        z: global___AdFloatType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["x", b"x", "y", b"y", "z", b"z"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["x", b"x", "y", b"y", "z", b"z"]) -> None: ...

global___AdVector3 = AdVector3

class Vector3(google.protobuf.message.Message):
    """Passive 3D vector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    X_FIELD_NUMBER: builtins.int
    Y_FIELD_NUMBER: builtins.int
    Z_FIELD_NUMBER: builtins.int
    x: builtins.float
    y: builtins.float
    z: builtins.float
    def __init__(
        self,
        *,
        x: builtins.float = ...,
        y: builtins.float = ...,
        z: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["x", b"x", "y", b"y", "z", b"z"]) -> None: ...

global___Vector3 = Vector3

class IntVector3(google.protobuf.message.Message):
    """Passive 3D vector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    X_FIELD_NUMBER: builtins.int
    Y_FIELD_NUMBER: builtins.int
    Z_FIELD_NUMBER: builtins.int
    x: builtins.int
    y: builtins.int
    z: builtins.int
    def __init__(
        self,
        *,
        x: builtins.int = ...,
        y: builtins.int = ...,
        z: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["x", b"x", "y", b"y", "z", b"z"]) -> None: ...

global___IntVector3 = IntVector3

class Matrix3(google.protobuf.message.Message):
    """Passive 3x3 matrix."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    A_FIELD_NUMBER: builtins.int
    B_FIELD_NUMBER: builtins.int
    C_FIELD_NUMBER: builtins.int
    @property
    def a(self) -> global___Vector3: ...
    @property
    def b(self) -> global___Vector3: ...
    @property
    def c(self) -> global___Vector3: ...
    def __init__(
        self,
        *,
        a: global___Vector3 | None = ...,
        b: global___Vector3 | None = ...,
        c: global___Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["a", b"a", "b", b"b", "c", b"c"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["a", b"a", "b", b"b", "c", b"c"]) -> None: ...

global___Matrix3 = Matrix3

class FirstOrderAdType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    TANGENT_FIELD_NUMBER: builtins.int
    ADJOINT_FIELD_NUMBER: builtins.int
    value: builtins.float
    @property
    def tangent(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def adjoint(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        value: builtins.float = ...,
        tangent: collections.abc.Iterable[builtins.float] | None = ...,
        adjoint: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["adjoint", b"adjoint", "tangent", b"tangent", "value", b"value"]) -> None: ...

global___FirstOrderAdType = FirstOrderAdType

class SecondOrderAdType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    TANGENT_FIELD_NUMBER: builtins.int
    ADJOINT_FIELD_NUMBER: builtins.int
    @property
    def value(self) -> global___FirstOrderAdType: ...
    @property
    def tangent(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FirstOrderAdType]: ...
    @property
    def adjoint(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FirstOrderAdType]: ...
    def __init__(
        self,
        *,
        value: global___FirstOrderAdType | None = ...,
        tangent: collections.abc.Iterable[global___FirstOrderAdType] | None = ...,
        adjoint: collections.abc.Iterable[global___FirstOrderAdType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["adjoint", b"adjoint", "tangent", b"tangent", "value", b"value"]) -> None: ...

global___SecondOrderAdType = SecondOrderAdType

class ExpressionType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    value: builtins.float
    expression: builtins.str
    def __init__(
        self,
        *,
        value: builtins.float = ...,
        expression: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["expression", b"expression", "value", b"value"]) -> None: ...

global___ExpressionType = ExpressionType

class AdFloatType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    FIRST_ORDER_FIELD_NUMBER: builtins.int
    SECOND_ORDER_FIELD_NUMBER: builtins.int
    VARIABLE_FIELD_NUMBER: builtins.int
    QUANTITY_TYPE_FIELD_NUMBER: builtins.int
    value: builtins.float
    @property
    def first_order(self) -> global___FirstOrderAdType: ...
    @property
    def second_order(self) -> global___SecondOrderAdType: ...
    @property
    def variable(self) -> global___ExpressionType: ...
    quantity_type: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType
    def __init__(
        self,
        *,
        value: builtins.float = ...,
        first_order: global___FirstOrderAdType | None = ...,
        second_order: global___SecondOrderAdType | None = ...,
        variable: global___ExpressionType | None = ...,
        quantity_type: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["ad_types", b"ad_types", "first_order", b"first_order", "quantity", b"quantity", "quantity_type", b"quantity_type", "second_order", b"second_order", "value", b"value", "variable", b"variable"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["ad_types", b"ad_types", "first_order", b"first_order", "quantity", b"quantity", "quantity_type", b"quantity_type", "second_order", b"second_order", "value", b"value", "variable", b"variable"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["ad_types", b"ad_types"]) -> typing_extensions.Literal["value", "first_order", "second_order", "variable"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["quantity", b"quantity"]) -> typing_extensions.Literal["quantity_type"] | None: ...

global___AdFloatType = AdFloatType

class Int(google.protobuf.message.Message):
    """An object that wraps an integer. It is used in types such as fvm.Param so
    that we can distinguish a missing field and a field that's set to the zero
    value.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.int
    def __init__(
        self,
        *,
        value: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

global___Int = Int

class Float(google.protobuf.message.Message):
    """An object that wraps an float. Used by stable schema types to represent
    a real field. See the doc for the Int field too.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.float
    def __init__(
        self,
        *,
        value: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

global___Float = Float

class Bool(google.protobuf.message.Message):
    """Wraps a boolean to distinguish a missing field and a field that's set to
    false.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.bool
    def __init__(
        self,
        *,
        value: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

global___Bool = Bool

class AdRow(google.protobuf.message.Message):
    """Arbitrary length AD vector"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    @property
    def element(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AdFloatType]: ...
    def __init__(
        self,
        *,
        element: collections.abc.Iterable[global___AdFloatType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element"]) -> None: ...

global___AdRow = AdRow

class AdMatrix(google.protobuf.message.Message):
    """AD matrix"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_FIELD_NUMBER: builtins.int
    @property
    def row(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AdRow]: ...
    def __init__(
        self,
        *,
        row: collections.abc.Iterable[global___AdRow] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["row", b"row"]) -> None: ...

global___AdMatrix = AdMatrix
