"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import luminarycloud._proto.base.base_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Sphere(google.protobuf.message.Message):
    """Sphere defines the location and size of a sphere."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CENTER_FIELD_NUMBER: builtins.int
    RADIUS_FIELD_NUMBER: builtins.int
    @property
    def center(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the spheres center."""
    radius: builtins.float
    """Radius of the sphere in meters."""
    def __init__(
        self,
        *,
        center: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        radius: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["center", b"center"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["center", b"center", "radius", b"radius"]) -> None: ...

global___Sphere = Sphere

class SphereShell(google.protobuf.message.Message):
    """SphereShell defines the location and size of a spherical shell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CENTER_FIELD_NUMBER: builtins.int
    RADIUS_FIELD_NUMBER: builtins.int
    RADIUS_INNER_FIELD_NUMBER: builtins.int
    @property
    def center(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the spheres center."""
    radius: builtins.float
    """Radius of the sphere in meters."""
    radius_inner: builtins.float
    """Inner radius of a spherical shell in meters."""
    def __init__(
        self,
        *,
        center: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        radius: builtins.float = ...,
        radius_inner: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["center", b"center"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["center", b"center", "radius", b"radius", "radius_inner", b"radius_inner"]) -> None: ...

global___SphereShell = SphereShell

class HalfSphere(google.protobuf.message.Message):
    """HalfSphere defines the location, size, and orientation of a hemisphere."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CENTER_FIELD_NUMBER: builtins.int
    RADIUS_FIELD_NUMBER: builtins.int
    NORMAL_FIELD_NUMBER: builtins.int
    @property
    def center(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the center of circular flat bottom of the hemisphere."""
    radius: builtins.float
    """Radius of the sphere in meters."""
    @property
    def normal(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Vector relative to the center pointing in the direction of the dome-size
        of the hemisphere.
        """
    def __init__(
        self,
        *,
        center: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        radius: builtins.float = ...,
        normal: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["center", b"center", "normal", b"normal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["center", b"center", "normal", b"normal", "radius", b"radius"]) -> None: ...

global___HalfSphere = HalfSphere

class Cube(google.protobuf.message.Message):
    """Cube defines the location and size of a rectangular prism."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_FIELD_NUMBER: builtins.int
    MAX_FIELD_NUMBER: builtins.int
    @property
    def min(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the prism's corner closest to (-Inf, -Inf, -Inf)."""
    @property
    def max(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the prism's corner closest to (+Inf, +Inf, +Inf)."""
    def __init__(
        self,
        *,
        min: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        max: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["max", b"max", "min", b"min"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max", b"max", "min", b"min"]) -> None: ...

global___Cube = Cube

class OrientedCube(google.protobuf.message.Message):
    """OrientedCube defines the location and size of a rectangular prism
    arbitrarily translated and rotated. min and max in transformed coordinates
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_FIELD_NUMBER: builtins.int
    MAX_FIELD_NUMBER: builtins.int
    ORIGIN_FIELD_NUMBER: builtins.int
    X_AXIS_FIELD_NUMBER: builtins.int
    Y_AXIS_FIELD_NUMBER: builtins.int
    @property
    def min(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location in the prism reference frame of the prism's corner closest to
        (-Inf, -Inf, -Inf).
        """
    @property
    def max(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location in the prism reference frame of the prism's corner closest to
        (+Inf, +Inf, +Inf).
        """
    @property
    def origin(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the prism reference frame's origin in meters."""
    @property
    def x_axis(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Direction of the prism reference frame's x-axis."""
    @property
    def y_axis(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Direction of the prism reference frame's y-axis."""
    def __init__(
        self,
        *,
        min: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        max: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        origin: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        x_axis: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        y_axis: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["max", b"max", "min", b"min", "origin", b"origin", "x_axis", b"x_axis", "y_axis", b"y_axis"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max", b"max", "min", b"min", "origin", b"origin", "x_axis", b"x_axis", "y_axis", b"y_axis"]) -> None: ...

global___OrientedCube = OrientedCube

class Cylinder(google.protobuf.message.Message):
    """Cylinder defines the location and size of a cylinder."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    RADIUS_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the cylinder's first base's center."""
    @property
    def end(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the cylinder's second base's center."""
    radius: builtins.float
    """Radius of the cylinder in meters."""
    def __init__(
        self,
        *,
        start: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        end: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        radius: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end", b"end", "radius", b"radius", "start", b"start"]) -> None: ...

global___Cylinder = Cylinder

class AnnularCylinder(google.protobuf.message.Message):
    """AnnularCylinder defines the location and size of an annular cylinder."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    RADIUS_FIELD_NUMBER: builtins.int
    RADIUS_INNER_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the cylinder's first base's center."""
    @property
    def end(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the cylinder's second base's center."""
    radius: builtins.float
    """Radius of the cylinder in meters."""
    radius_inner: builtins.float
    """Inner radius of an annular cylinder in meters."""
    def __init__(
        self,
        *,
        start: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        end: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        radius: builtins.float = ...,
        radius_inner: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end", b"end", "radius", b"radius", "radius_inner", b"radius_inner", "start", b"start"]) -> None: ...

global___AnnularCylinder = AnnularCylinder

class Torus(google.protobuf.message.Message):
    """Torus defines the location and size of a torus."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CENTER_FIELD_NUMBER: builtins.int
    NORMAL_FIELD_NUMBER: builtins.int
    MAJOR_RADIUS_FIELD_NUMBER: builtins.int
    MINOR_RADIUS_FIELD_NUMBER: builtins.int
    @property
    def center(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the torus's center in meters."""
    @property
    def normal(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Vector relative to the center pointing in the normal direction of the plane
        of the torus.
        """
    major_radius: builtins.float
    """Radius of the torus's cross-section in meters."""
    minor_radius: builtins.float
    """Radius of the torus's spine in meters."""
    def __init__(
        self,
        *,
        center: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        normal: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        major_radius: builtins.float = ...,
        minor_radius: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["center", b"center", "normal", b"normal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["center", b"center", "major_radius", b"major_radius", "minor_radius", b"minor_radius", "normal", b"normal"]) -> None: ...

global___Torus = Torus

class Cone(google.protobuf.message.Message):
    """Cone defines the location and size of a cone."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APEX_FIELD_NUMBER: builtins.int
    BASE_CENTER_FIELD_NUMBER: builtins.int
    BASE_RADIUS_FIELD_NUMBER: builtins.int
    @property
    def apex(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the cone's apex in meters."""
    @property
    def base_center(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Location of the cone's base center in meters."""
    base_radius: builtins.float
    """Radius of the cone's base in meters."""
    def __init__(
        self,
        *,
        apex: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        base_center: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        base_radius: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["apex", b"apex", "base_center", b"base_center"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["apex", b"apex", "base_center", b"base_center", "base_radius", b"base_radius"]) -> None: ...

global___Cone = Cone
