"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.base.base_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _MeshFileFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MeshFileFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MeshFileFormat.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID: _MeshFileFormat.ValueType  # 0
    LCMESH: _MeshFileFormat.ValueType  # 1
    VTK: _MeshFileFormat.ValueType  # 2
    """May be ASCII or binary."""

class MeshFileFormat(_MeshFileFormat, metaclass=_MeshFileFormatEnumTypeWrapper):
    """File formats for mesh/solution files."""

INVALID: MeshFileFormat.ValueType  # 0
LCMESH: MeshFileFormat.ValueType  # 1
VTK: MeshFileFormat.ValueType  # 2
"""May be ASCII or binary."""
global___MeshFileFormat = MeshFileFormat

class FileSetManifest(google.protobuf.message.Message):
    """FileSetManifest describes a set of files uploaded by a user as one unit.  It
    is used to treat a mesh definition consisting of multiple files as one
    logical file. As of 2021-04, OpenFOAM mesh
    (https://cfd.direct/openfoam/user-guide/v6-basic-file-format/) uses this
    format.


    Example layout:
       rooturl/.lcfilesetmanifest
       rooturl/file0
       rooturl/dir0%2Ffile1
       rooturl/dir0%2Ffile2

    - rooturl is an arbitrary URL prefix. See go/core/jobmaster/filesetUploader
      for a real example of rooturl generation.

    - File .lcfilesetmanifest stores a binary-serialized FileSetManifest.
    - The rest of the directory store a flat list of user-provided files.
      The filenames are URL-encoded pathnames.

    - In the above example, the contents of .lcfilesetmanifest will be:

      entry: {
        rel_path: "file0"
        size: .. size of file0 ..
        checksum: .. SHA256 checksum of file0 ..
        encoded_rel_path: "file0"
      }
      entry: {
        rel_path: "dir0/file1"
        size: .. size of dir0/file1 ..
        checksum: .. SHA256 checksum of dir0/file1 ..
        encoded_rel_path: "dir0%2Ffile1"
      }
      entry: {
        rel_path: "dir0/file2"
        size: .. size of dir0/file2 ..
        checksum: .. SHA256 checksum of dir0/file2 ..
        encoded_rel_path: "dir0%2Ffile2"
      }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRY_FIELD_NUMBER: builtins.int
    @property
    def entry(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FileSetEntry]:
        """List of files in the fileset."""
    def __init__(
        self,
        *,
        entry: collections.abc.Iterable[global___FileSetEntry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entry", b"entry"]) -> None: ...

global___FileSetManifest = FileSetManifest

class FileSetEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REL_PATH_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    CHECKSUM_FIELD_NUMBER: builtins.int
    ENCODED_REL_PATH_FIELD_NUMBER: builtins.int
    rel_path: builtins.str
    """Name of the file in the user's file system, relative to the directory root."""
    size: builtins.int
    """File size, in bytes"""
    @property
    def checksum(self) -> luminarycloud._proto.base.base_pb2.Checksum:
        """Checksum of the whole file contents."""
    encoded_rel_path: builtins.str
    """URL-encoded rel_path. It is set by jobmaster when creating the
    manifest.
    """
    def __init__(
        self,
        *,
        rel_path: builtins.str = ...,
        size: builtins.int = ...,
        checksum: luminarycloud._proto.base.base_pb2.Checksum | None = ...,
        encoded_rel_path: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["checksum", b"checksum"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["checksum", b"checksum", "encoded_rel_path", b"encoded_rel_path", "rel_path", b"rel_path", "size", b"size"]) -> None: ...

global___FileSetEntry = FileSetEntry

class FileMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    EXT_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    SHA256_CHECKSUM_FIELD_NUMBER: builtins.int
    CRC32C_CHECKSUM_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The file name without extension."""
    ext: builtins.str
    """File extension if known; please leave empty otherwise.
    Using ext here since field name "extension" is not supported in TypeScript.
    """
    size: builtins.int
    """The total size of the file in bytes."""
    sha256_checksum: builtins.bytes
    """Checksum of the whole file contents, as a raw SHA256 32 byte string. Not a
    hex string.
    """
    crc32c_checksum: builtins.str
    """crc32c checksum of entire file as a base64 string."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        ext: builtins.str = ...,
        size: builtins.int = ...,
        sha256_checksum: builtins.bytes = ...,
        crc32c_checksum: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["crc32c_checksum", b"crc32c_checksum", "ext", b"ext", "name", b"name", "sha256_checksum", b"sha256_checksum", "size", b"size"]) -> None: ...

global___FileMetadata = FileMetadata

class ByteChunk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_OFFSET_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    NEXT_OFFSET_FIELD_NUMBER: builtins.int
    LAST_CHUNK_FIELD_NUMBER: builtins.int
    start_offset: builtins.int
    """The start offset of the included chunk."""
    data: builtins.bytes
    """The included chunk."""
    next_offset: builtins.int
    """If last_chunk is set to false then this value should be sent as the start_offset to request the next
    chunk to return.
    """
    last_chunk: builtins.bool
    """Denotes if this is the last chunk of the file. If this field is set to true then you have received all
    contents and you can stop sending requests.
    """
    def __init__(
        self,
        *,
        start_offset: builtins.int = ...,
        data: builtins.bytes = ...,
        next_offset: builtins.int = ...,
        last_chunk: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "last_chunk", b"last_chunk", "next_offset", b"next_offset", "start_offset", b"start_offset"]) -> None: ...

global___ByteChunk = ByteChunk

class File(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    FULL_CONTENTS_FIELD_NUMBER: builtins.int
    SIGNED_URL_FIELD_NUMBER: builtins.int
    FILE_ID_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> global___FileMetadata:
        """Metadata of the file."""
    full_contents: builtins.bytes
    """File contents as bytes, included directly in the response."""
    signed_url: builtins.str
    """Signed URL which can be used to download the file."""
    file_id: builtins.str
    """A file ID that may be fetched using the /fetch/{file_id} endpoint."""
    def __init__(
        self,
        *,
        metadata: global___FileMetadata | None = ...,
        full_contents: builtins.bytes = ...,
        signed_url: builtins.str = ...,
        file_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["contents", b"contents", "file_id", b"file_id", "full_contents", b"full_contents", "metadata", b"metadata", "signed_url", b"signed_url"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["contents", b"contents", "file_id", b"file_id", "full_contents", b"full_contents", "metadata", b"metadata", "signed_url", b"signed_url"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["contents", b"contents"]) -> typing_extensions.Literal["full_contents", "signed_url", "file_id"] | None: ...

global___File = File
