"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.cad.boolean_pb2
import luminarycloud._proto.cad.shape_pb2
import luminarycloud._proto.cad.transformation_pb2
import luminarycloud._proto.lcstatus.lcstatus_pb2
import luminarycloud._proto.parametricworker.parametricworker_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _EntityType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EntityTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EntityType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNSPECIFIED: _EntityType.ValueType  # 0
    BODY: _EntityType.ValueType  # 1
    VOLUME: _EntityType.ValueType  # 2
    FACE: _EntityType.ValueType  # 3
    EDGE: _EntityType.ValueType  # 4
    VERTEX: _EntityType.ValueType  # 5

class EntityType(_EntityType, metaclass=_EntityTypeEnumTypeWrapper): ...

UNSPECIFIED: EntityType.ValueType  # 0
BODY: EntityType.ValueType  # 1
VOLUME: EntityType.ValueType  # 2
FACE: EntityType.ValueType  # 3
EDGE: EntityType.ValueType  # 4
VERTEX: EntityType.ValueType  # 5
global___EntityType = EntityType

class _ShrinkwrapMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ShrinkwrapModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ShrinkwrapMode.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUTOMATIC: _ShrinkwrapMode.ValueType  # 0
    MINMAX: _ShrinkwrapMode.ValueType  # 1
    UNIFORM: _ShrinkwrapMode.ValueType  # 2

class ShrinkwrapMode(_ShrinkwrapMode, metaclass=_ShrinkwrapModeEnumTypeWrapper): ...

AUTOMATIC: ShrinkwrapMode.ValueType  # 0
MINMAX: ShrinkwrapMode.ValueType  # 1
UNIFORM: ShrinkwrapMode.ValueType  # 2
global___ShrinkwrapMode = ShrinkwrapMode

class _KernelType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _KernelTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_KernelType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _KernelType.ValueType  # 0
    CONTINUOUS: _KernelType.ValueType  # 1
    """Currently, ACIS"""
    DISCRETE: _KernelType.ValueType  # 2

class KernelType(_KernelType, metaclass=_KernelTypeEnumTypeWrapper): ...

UNKNOWN: KernelType.ValueType  # 0
CONTINUOUS: KernelType.ValueType  # 1
"""Currently, ACIS"""
DISCRETE: KernelType.ValueType  # 2
global___KernelType = KernelType

class ImportGeometry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_URL_FIELD_NUMBER: builtins.int
    SCALING_FLOAT_FIELD_NUMBER: builtins.int
    SCALING_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    WEB_GEOMETRY_ID_FIELD_NUMBER: builtins.int
    geometry_url: builtins.str
    """Path to geometry file"""
    scaling_float: builtins.float
    """One of scaling/scaling_float required. scaling will take priority.
    (deprecated) Scaling of geometry at import
    """
    @property
    def scaling(self) -> luminarycloud._proto.base.base_pb2.AdFloatType:
        """One of scaling/scaling_float required. scaling will take priority.
        Scaling of geometry at import. Takes precedence over `scaling`
        """
    @property
    def parameters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.parametricworker.parametricworker_pb2.Parameter]:
        """Parameters (as in parametric CAD) to update"""
    web_geometry_id: builtins.str
    """WebGeometryId for importing web geometries, like Onshape."""
    def __init__(
        self,
        *,
        geometry_url: builtins.str = ...,
        scaling_float: builtins.float = ...,
        scaling: luminarycloud._proto.base.base_pb2.AdFloatType | None = ...,
        parameters: collections.abc.Iterable[luminarycloud._proto.parametricworker.parametricworker_pb2.Parameter] | None = ...,
        web_geometry_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["scaling", b"scaling"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_url", b"geometry_url", "parameters", b"parameters", "scaling", b"scaling", "scaling_float", b"scaling_float", "web_geometry_id", b"web_geometry_id"]) -> None: ...

global___ImportGeometry = ImportGeometry

class Create(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPHERE_FIELD_NUMBER: builtins.int
    BOX_FIELD_NUMBER: builtins.int
    CYLINDER_FIELD_NUMBER: builtins.int
    TORUS_FIELD_NUMBER: builtins.int
    CONE_FIELD_NUMBER: builtins.int
    HALF_SPHERE_FIELD_NUMBER: builtins.int
    RESULT_BODY_TAG_FIELD_NUMBER: builtins.int
    @property
    def sphere(self) -> luminarycloud._proto.cad.shape_pb2.Sphere:
        """Sphere"""
    @property
    def box(self) -> luminarycloud._proto.cad.shape_pb2.Cube:
        """Box"""
    @property
    def cylinder(self) -> luminarycloud._proto.cad.shape_pb2.Cylinder:
        """Cylinder"""
    @property
    def torus(self) -> luminarycloud._proto.cad.shape_pb2.Torus:
        """Torus"""
    @property
    def cone(self) -> luminarycloud._proto.cad.shape_pb2.Cone:
        """Cone"""
    @property
    def half_sphere(self) -> luminarycloud._proto.cad.shape_pb2.HalfSphere:
        """Half-sphere"""
    result_body_tag: builtins.str
    """Add a tag to the resulting body."""
    def __init__(
        self,
        *,
        sphere: luminarycloud._proto.cad.shape_pb2.Sphere | None = ...,
        box: luminarycloud._proto.cad.shape_pb2.Cube | None = ...,
        cylinder: luminarycloud._proto.cad.shape_pb2.Cylinder | None = ...,
        torus: luminarycloud._proto.cad.shape_pb2.Torus | None = ...,
        cone: luminarycloud._proto.cad.shape_pb2.Cone | None = ...,
        half_sphere: luminarycloud._proto.cad.shape_pb2.HalfSphere | None = ...,
        result_body_tag: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["box", b"box", "cone", b"cone", "cylinder", b"cylinder", "half_sphere", b"half_sphere", "shape", b"shape", "sphere", b"sphere", "torus", b"torus"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["box", b"box", "cone", b"cone", "cylinder", b"cylinder", "half_sphere", b"half_sphere", "result_body_tag", b"result_body_tag", "shape", b"shape", "sphere", b"sphere", "torus", b"torus"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["shape", b"shape"]) -> typing_extensions.Literal["sphere", "box", "cylinder", "torus", "cone", "half_sphere"] | None: ...

global___Create = Create

class Delete(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    IDS_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    type: global___EntityType.ValueType
    """Type of entities. All entities must be of the same type."""
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """ID of the entities. Must not have repeated fields."""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Entity to delete, by tag. Type is still required."""
    def __init__(
        self,
        *,
        type: global___EntityType.ValueType = ...,
        ids: collections.abc.Iterable[builtins.int] | None = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ids", b"ids", "tags", b"tags", "type", b"type"]) -> None: ...

global___Delete = Delete

class Boolean(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REG_UNION_FIELD_NUMBER: builtins.int
    REG_SUBTRACTION_FIELD_NUMBER: builtins.int
    REG_INTERSECTION_FIELD_NUMBER: builtins.int
    REG_CHOP_FIELD_NUMBER: builtins.int
    @property
    def reg_union(self) -> luminarycloud._proto.cad.boolean_pb2.RegularUnion:
        """Regular union"""
    @property
    def reg_subtraction(self) -> luminarycloud._proto.cad.boolean_pb2.RegularSubtraction:
        """Regular subtraction"""
    @property
    def reg_intersection(self) -> luminarycloud._proto.cad.boolean_pb2.RegularIntersection:
        """Regular intersection"""
    @property
    def reg_chop(self) -> luminarycloud._proto.cad.boolean_pb2.RegularChop:
        """Regular chop"""
    def __init__(
        self,
        *,
        reg_union: luminarycloud._proto.cad.boolean_pb2.RegularUnion | None = ...,
        reg_subtraction: luminarycloud._proto.cad.boolean_pb2.RegularSubtraction | None = ...,
        reg_intersection: luminarycloud._proto.cad.boolean_pb2.RegularIntersection | None = ...,
        reg_chop: luminarycloud._proto.cad.boolean_pb2.RegularChop | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["op", b"op", "reg_chop", b"reg_chop", "reg_intersection", b"reg_intersection", "reg_subtraction", b"reg_subtraction", "reg_union", b"reg_union"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["op", b"op", "reg_chop", b"reg_chop", "reg_intersection", b"reg_intersection", "reg_subtraction", b"reg_subtraction", "reg_union", b"reg_union"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["op", b"op"]) -> typing_extensions.Literal["reg_union", "reg_subtraction", "reg_intersection", "reg_chop"] | None: ...

global___Boolean = Boolean

class Imprint(google.protobuf.message.Message):
    """Imprint operation. All bodies will be imprinted against each order in
    arbitrary order.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ImprintBehavior:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ImprintBehaviorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Imprint._ImprintBehavior.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IMPRINT_ALL: Imprint._ImprintBehavior.ValueType  # 0
        IMPRINT_SELECTED: Imprint._ImprintBehavior.ValueType  # 1

    class ImprintBehavior(_ImprintBehavior, metaclass=_ImprintBehaviorEnumTypeWrapper):
        """Possible behaviors for imprinting bodies."""

    IMPRINT_ALL: Imprint.ImprintBehavior.ValueType  # 0
    IMPRINT_SELECTED: Imprint.ImprintBehavior.ValueType  # 1

    BEHAVIOR_FIELD_NUMBER: builtins.int
    BODY_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    behavior: global___Imprint.ImprintBehavior.ValueType
    """Choose between old or new behavior (all volumes or only selected ones)."""
    @property
    def body(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Body IDs. Not used when behavior is IMPRINT_ALL."""
    @property
    def tag(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Body tags. Not used when behavior is IMPRINT_ALL."""
    def __init__(
        self,
        *,
        behavior: global___Imprint.ImprintBehavior.ValueType = ...,
        body: collections.abc.Iterable[builtins.int] | None = ...,
        tag: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["behavior", b"behavior", "body", b"body", "tag", b"tag"]) -> None: ...

global___Imprint = Imprint

class Transform(google.protobuf.message.Message):
    """Transformation operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BODY_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    MATRIX_FIELD_NUMBER: builtins.int
    TRANSLATION_FIELD_NUMBER: builtins.int
    ROTATION_FIELD_NUMBER: builtins.int
    SCALING_FIELD_NUMBER: builtins.int
    REFLECTION_FIELD_NUMBER: builtins.int
    KEEP_FIELD_NUMBER: builtins.int
    @property
    def body(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Body IDs."""
    @property
    def tag(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Body tags."""
    @property
    def matrix(self) -> luminarycloud._proto.cad.transformation_pb2.AugmentedMatrix: ...
    @property
    def translation(self) -> luminarycloud._proto.cad.transformation_pb2.Translation: ...
    @property
    def rotation(self) -> luminarycloud._proto.cad.transformation_pb2.Rotation: ...
    @property
    def scaling(self) -> luminarycloud._proto.cad.transformation_pb2.Scaling: ...
    @property
    def reflection(self) -> luminarycloud._proto.cad.transformation_pb2.Reflection: ...
    keep: builtins.bool
    """Whether to keep a copy of the original bodies or transform in place"""
    def __init__(
        self,
        *,
        body: collections.abc.Iterable[builtins.int] | None = ...,
        tag: collections.abc.Iterable[builtins.str] | None = ...,
        matrix: luminarycloud._proto.cad.transformation_pb2.AugmentedMatrix | None = ...,
        translation: luminarycloud._proto.cad.transformation_pb2.Translation | None = ...,
        rotation: luminarycloud._proto.cad.transformation_pb2.Rotation | None = ...,
        scaling: luminarycloud._proto.cad.transformation_pb2.Scaling | None = ...,
        reflection: luminarycloud._proto.cad.transformation_pb2.Reflection | None = ...,
        keep: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["matrix", b"matrix", "reflection", b"reflection", "rotation", b"rotation", "scaling", b"scaling", "t", b"t", "translation", b"translation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["body", b"body", "keep", b"keep", "matrix", b"matrix", "reflection", b"reflection", "rotation", b"rotation", "scaling", b"scaling", "t", b"t", "tag", b"tag", "translation", b"translation"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["t", b"t"]) -> typing_extensions.Literal["matrix", "translation", "rotation", "scaling", "reflection"] | None: ...

global___Transform = Transform

class Shrinkwrap(google.protobuf.message.Message):
    """Shrinkwrap operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BODY_FIELD_NUMBER: builtins.int
    TAG_BODY_FIELD_NUMBER: builtins.int
    TOOL_FIELD_NUMBER: builtins.int
    TAG_TOOL_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    RESOLUTION_MIN_FIELD_NUMBER: builtins.int
    RESOLUTION_MAX_FIELD_NUMBER: builtins.int
    RESOLUTION_UNIFORM_FIELD_NUMBER: builtins.int
    @property
    def body(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Bodies to shrinkwrap together."""
    @property
    def tag_body(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Bodies to shrinkwrap together, by tag."""
    @property
    def tool(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Bodies to subtract from the shrinkwrap body."""
    @property
    def tag_tool(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Bodies to subtract from the shrinkwrap body, by tag."""
    mode: global___ShrinkwrapMode.ValueType
    """Mode of shrinkwrap."""
    resolution_min: builtins.float
    """Finest resolution used, under which geometrical features are ignored."""
    resolution_max: builtins.float
    """Coarsest resolution used, above which geometrical features are ignored."""
    resolution_uniform: builtins.float
    """Uniform resolution used"""
    def __init__(
        self,
        *,
        body: collections.abc.Iterable[builtins.int] | None = ...,
        tag_body: collections.abc.Iterable[builtins.str] | None = ...,
        tool: collections.abc.Iterable[builtins.int] | None = ...,
        tag_tool: collections.abc.Iterable[builtins.str] | None = ...,
        mode: global___ShrinkwrapMode.ValueType = ...,
        resolution_min: builtins.float = ...,
        resolution_max: builtins.float = ...,
        resolution_uniform: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["body", b"body", "mode", b"mode", "resolution_max", b"resolution_max", "resolution_min", b"resolution_min", "resolution_uniform", b"resolution_uniform", "tag_body", b"tag_body", "tag_tool", b"tag_tool", "tool", b"tool"]) -> None: ...

global___Shrinkwrap = Shrinkwrap

class Farfield(google.protobuf.message.Message):
    """Farfield is an operation that combines a create operation with a boolean
    subtraction.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_FIELD_NUMBER: builtins.int
    BODIES_FIELD_NUMBER: builtins.int
    TAG_BODIES_FIELD_NUMBER: builtins.int
    KEEP_SOURCE_BODIES_FIELD_NUMBER: builtins.int
    KEEP_TOOL_BODIES_FIELD_NUMBER: builtins.int
    PROPAGATE_TOOL_TAGS_FIELD_NUMBER: builtins.int
    @property
    def create(self) -> global___Create:
        """Shape that will act as tool body in the farfield subtraction boolean."""
    @property
    def bodies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Bodies to be subtracted from create body.
        If both "bodies" and "tag_bodies" are empty, all bodies will be subtracted.
        """
    @property
    def tag_bodies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Bodies to be subtracted from create body, by tag.
        If both "bodies" and "tag_bodies" are empty, all bodies will be subtracted.
        """
    keep_source_bodies: builtins.bool
    keep_tool_bodies: builtins.bool
    propagate_tool_tags: builtins.bool
    """Propagate tool body tags to faces."""
    def __init__(
        self,
        *,
        create: global___Create | None = ...,
        bodies: collections.abc.Iterable[builtins.int] | None = ...,
        tag_bodies: collections.abc.Iterable[builtins.str] | None = ...,
        keep_source_bodies: builtins.bool = ...,
        keep_tool_bodies: builtins.bool = ...,
        propagate_tool_tags: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create", b"create"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bodies", b"bodies", "create", b"create", "keep_source_bodies", b"keep_source_bodies", "keep_tool_bodies", b"keep_tool_bodies", "propagate_tool_tags", b"propagate_tool_tags", "tag_bodies", b"tag_bodies"]) -> None: ...

global___Farfield = Farfield

class Pattern(google.protobuf.message.Message):
    """Pattern operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Direction(google.protobuf.message.Message):
        """Describes the direction of the pattern."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Circular(google.protobuf.message.Message):
            """Circular rotation."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            ROTATION_FIELD_NUMBER: builtins.int
            FULL_FIELD_NUMBER: builtins.int
            @property
            def rotation(self) -> luminarycloud._proto.cad.transformation_pb2.Rotation:
                """Rotation transformation."""
            full: builtins.bool
            """Whether it's a full rotation: invalidates the andle in 'rotation'."""
            def __init__(
                self,
                *,
                rotation: luminarycloud._proto.cad.transformation_pb2.Rotation | None = ...,
                full: builtins.bool = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["rotation", b"rotation"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["full", b"full", "rotation", b"rotation"]) -> None: ...

        QUANTITY_FIELD_NUMBER: builtins.int
        SYMMETRIC_FIELD_NUMBER: builtins.int
        LINEAR_SPACING_FIELD_NUMBER: builtins.int
        CIRCULAR_DISTRIBUTION_FIELD_NUMBER: builtins.int
        quantity: builtins.int
        """Total number of instances, incl. the original body."""
        symmetric: builtins.bool
        """Whether the pattern is symmetric."""
        @property
        def linear_spacing(self) -> luminarycloud._proto.cad.transformation_pb2.Translation:
            """Linear pattern."""
        @property
        def circular_distribution(self) -> global___Pattern.Direction.Circular:
            """Circular pattern."""
        def __init__(
            self,
            *,
            quantity: builtins.int = ...,
            symmetric: builtins.bool = ...,
            linear_spacing: luminarycloud._proto.cad.transformation_pb2.Translation | None = ...,
            circular_distribution: global___Pattern.Direction.Circular | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["circular_distribution", b"circular_distribution", "linear_spacing", b"linear_spacing", "type", b"type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["circular_distribution", b"circular_distribution", "linear_spacing", b"linear_spacing", "quantity", b"quantity", "symmetric", b"symmetric", "type", b"type"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["linear_spacing", "circular_distribution"] | None: ...

    BODY_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    @property
    def body(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Body IDs."""
    @property
    def tag(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Body tags."""
    @property
    def direction(self) -> global___Pattern.Direction:
        """Directions of the pattern."""
    def __init__(
        self,
        *,
        body: collections.abc.Iterable[builtins.int] | None = ...,
        tag: collections.abc.Iterable[builtins.str] | None = ...,
        direction: global___Pattern.Direction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["direction", b"direction"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["body", b"body", "direction", b"direction", "tag", b"tag"]) -> None: ...

global___Pattern = Pattern

class Configurations(google.protobuf.message.Message):
    """Configurations operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Configuration(google.protobuf.message.Message):
        """Single configuration."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BODY_FIELD_NUMBER: builtins.int
        TAG_FIELD_NUMBER: builtins.int
        @property
        def body(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """Body IDs."""
        @property
        def tag(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Body tags."""
        def __init__(
            self,
            *,
            body: collections.abc.Iterable[builtins.int] | None = ...,
            tag: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["body", b"body", "tag", b"tag"]) -> None: ...

    class ConfigurationEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Configurations.Configuration: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Configurations.Configuration | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONFIGURATION_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    @property
    def configuration(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Configurations.Configuration]:
        """List of configurations."""
    active: builtins.str
    """Active configuration."""
    def __init__(
        self,
        *,
        configuration: collections.abc.Mapping[builtins.str, global___Configurations.Configuration] | None = ...,
        active: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["active", b"active", "configuration", b"configuration"]) -> None: ...

global___Configurations = Configurations

class FeatureIssues(google.protobuf.message.Message):
    """Describes the issues associated with a given feature with ID feature_id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISSUES_FIELD_NUMBER: builtins.int
    FEATURE_ID_FIELD_NUMBER: builtins.int
    @property
    def issues(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.lcstatus.lcstatus_pb2.LCStatus]: ...
    feature_id: builtins.str
    def __init__(
        self,
        *,
        issues: collections.abc.Iterable[luminarycloud._proto.lcstatus.lcstatus_pb2.LCStatus] | None = ...,
        feature_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["feature_id", b"feature_id", "issues", b"issues"]) -> None: ...

global___FeatureIssues = FeatureIssues

class Feature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMPORT_GEOMETRY_FIELD_NUMBER: builtins.int
    CREATE_FIELD_NUMBER: builtins.int
    DELETE_FIELD_NUMBER: builtins.int
    BOOLEAN_FIELD_NUMBER: builtins.int
    IMPRINT_FIELD_NUMBER: builtins.int
    TRANSFORM_FIELD_NUMBER: builtins.int
    SHRINKWRAP_FIELD_NUMBER: builtins.int
    FARFIELD_FIELD_NUMBER: builtins.int
    PATTERN_FIELD_NUMBER: builtins.int
    CONFIGURATIONS_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    FEATURE_NAME_FIELD_NUMBER: builtins.int
    @property
    def import_geometry(self) -> global___ImportGeometry:
        """Import a new geometry file into the current geometry"""
    @property
    def create(self) -> global___Create:
        """Create a new canonical shape"""
    @property
    def delete(self) -> global___Delete:
        """Delete an entity"""
    @property
    def boolean(self) -> global___Boolean:
        """Boolean bodies"""
    @property
    def imprint(self) -> global___Imprint:
        """Imprint bodies."""
    @property
    def transform(self) -> global___Transform:
        """Transform bodies."""
    @property
    def shrinkwrap(self) -> global___Shrinkwrap:
        """Shrinkwrap bodies."""
    @property
    def farfield(self) -> global___Farfield:
        """Create a shape and subtract existing bodies from it."""
    @property
    def pattern(self) -> global___Pattern:
        """Create a pattern of bodies."""
    @property
    def configurations(self) -> global___Configurations:
        """Configurations: keep 1 configuration and delete the rest."""
    id: builtins.str
    """internal feature ID"""
    feature_name: builtins.str
    """User-facing feature name, e.g. in the feature list"""
    def __init__(
        self,
        *,
        import_geometry: global___ImportGeometry | None = ...,
        create: global___Create | None = ...,
        delete: global___Delete | None = ...,
        boolean: global___Boolean | None = ...,
        imprint: global___Imprint | None = ...,
        transform: global___Transform | None = ...,
        shrinkwrap: global___Shrinkwrap | None = ...,
        farfield: global___Farfield | None = ...,
        pattern: global___Pattern | None = ...,
        configurations: global___Configurations | None = ...,
        id: builtins.str = ...,
        feature_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["boolean", b"boolean", "configurations", b"configurations", "create", b"create", "delete", b"delete", "farfield", b"farfield", "import_geometry", b"import_geometry", "imprint", b"imprint", "operation", b"operation", "pattern", b"pattern", "shrinkwrap", b"shrinkwrap", "transform", b"transform"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["boolean", b"boolean", "configurations", b"configurations", "create", b"create", "delete", b"delete", "farfield", b"farfield", "feature_name", b"feature_name", "id", b"id", "import_geometry", b"import_geometry", "imprint", b"imprint", "operation", b"operation", "pattern", b"pattern", "shrinkwrap", b"shrinkwrap", "transform", b"transform"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["operation", b"operation"]) -> typing_extensions.Literal["import_geometry", "create", "delete", "boolean", "imprint", "transform", "shrinkwrap", "farfield", "pattern", "configurations"] | None: ...

global___Feature = Feature

class CreateOrUpdateTag(google.protobuf.message.Message):
    """Add a tag in a failsafe manner.
    If entities are defined, add the tag.
    Otherwise, add the tag to all entities.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BODIES_FIELD_NUMBER: builtins.int
    FACES_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def bodies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def faces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        bodies: collections.abc.Iterable[builtins.int] | None = ...,
        faces: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bodies", b"bodies", "faces", b"faces", "name", b"name"]) -> None: ...

global___CreateOrUpdateTag = CreateOrUpdateTag

class RenameTag(google.protobuf.message.Message):
    """Rename an existing tag in a failsafe manner."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OLD_NAME_FIELD_NUMBER: builtins.int
    NEW_NAME_FIELD_NUMBER: builtins.int
    old_name: builtins.str
    new_name: builtins.str
    def __init__(
        self,
        *,
        old_name: builtins.str = ...,
        new_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["new_name", b"new_name", "old_name", b"old_name"]) -> None: ...

global___RenameTag = RenameTag

class DeleteTag(google.protobuf.message.Message):
    """Delete a tag in a failsafe manner.
    If entities are defined, remove the tag from those entities.
    Otherwise, remove the tag from all entities.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BODIES_FIELD_NUMBER: builtins.int
    FACES_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def bodies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def faces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        bodies: collections.abc.Iterable[builtins.int] | None = ...,
        faces: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bodies", b"bodies", "faces", b"faces", "name", b"name"]) -> None: ...

global___DeleteTag = DeleteTag

class DeleteTags(google.protobuf.message.Message):
    """Removes multiple tags in a failsafe manner."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMES_FIELD_NUMBER: builtins.int
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["names", b"names"]) -> None: ...

global___DeleteTags = DeleteTags

class Modification(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ModificationType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModificationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Modification._ModificationType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODIFICATION_TYPE_UNSPECIFIED: Modification._ModificationType.ValueType  # 0
        MODIFICATION_TYPE_CREATE_FEATURE: Modification._ModificationType.ValueType  # 1
        MODIFICATION_TYPE_UPDATE_FEATURE: Modification._ModificationType.ValueType  # 2
        MODIFICATION_TYPE_DELETE_FEATURE: Modification._ModificationType.ValueType  # 3
        MODIFICATION_TYPE_UNDO: Modification._ModificationType.ValueType  # 4
        MODIFICATION_TYPE_REDO: Modification._ModificationType.ValueType  # 5
        MODIFICATION_TYPE_RENAME_FEATURE: Modification._ModificationType.ValueType  # 6
        """Action used to rename a given feature. If specified, the feature message
        must contain the new name and the ID. The other fields will be ignored.
        """
        MODIFICATION_TYPE_CREATE_TAG: Modification._ModificationType.ValueType  # 7
        MODIFICATION_TYPE_UPDATE_TAG: Modification._ModificationType.ValueType  # 8
        MODIFICATION_TYPE_DELETE_TAG: Modification._ModificationType.ValueType  # 9
        MODIFICATION_TYPE_RENAME_TAG: Modification._ModificationType.ValueType  # 10
        MODIFICATION_TYPE_DELETE_TAGS: Modification._ModificationType.ValueType  # 11
        MODIFICATION_TYPE_UPDATE_NAMED_VARIABLE_SET: Modification._ModificationType.ValueType  # 12
        MODIFICATION_TYPE_CONVERT_COLORS_TO_TAGS: Modification._ModificationType.ValueType  # 13

    class ModificationType(_ModificationType, metaclass=_ModificationTypeEnumTypeWrapper): ...
    MODIFICATION_TYPE_UNSPECIFIED: Modification.ModificationType.ValueType  # 0
    MODIFICATION_TYPE_CREATE_FEATURE: Modification.ModificationType.ValueType  # 1
    MODIFICATION_TYPE_UPDATE_FEATURE: Modification.ModificationType.ValueType  # 2
    MODIFICATION_TYPE_DELETE_FEATURE: Modification.ModificationType.ValueType  # 3
    MODIFICATION_TYPE_UNDO: Modification.ModificationType.ValueType  # 4
    MODIFICATION_TYPE_REDO: Modification.ModificationType.ValueType  # 5
    MODIFICATION_TYPE_RENAME_FEATURE: Modification.ModificationType.ValueType  # 6
    """Action used to rename a given feature. If specified, the feature message
    must contain the new name and the ID. The other fields will be ignored.
    """
    MODIFICATION_TYPE_CREATE_TAG: Modification.ModificationType.ValueType  # 7
    MODIFICATION_TYPE_UPDATE_TAG: Modification.ModificationType.ValueType  # 8
    MODIFICATION_TYPE_DELETE_TAG: Modification.ModificationType.ValueType  # 9
    MODIFICATION_TYPE_RENAME_TAG: Modification.ModificationType.ValueType  # 10
    MODIFICATION_TYPE_DELETE_TAGS: Modification.ModificationType.ValueType  # 11
    MODIFICATION_TYPE_UPDATE_NAMED_VARIABLE_SET: Modification.ModificationType.ValueType  # 12
    MODIFICATION_TYPE_CONVERT_COLORS_TO_TAGS: Modification.ModificationType.ValueType  # 13

    MOD_TYPE_FIELD_NUMBER: builtins.int
    FEATURE_FIELD_NUMBER: builtins.int
    CREATE_OR_UPDATE_TAG_FIELD_NUMBER: builtins.int
    RENAME_TAG_FIELD_NUMBER: builtins.int
    DELETE_TAG_FIELD_NUMBER: builtins.int
    DELETE_TAGS_FIELD_NUMBER: builtins.int
    UPDATE_NAMED_VARIABLE_SET_VERSION_ID_FIELD_NUMBER: builtins.int
    mod_type: global___Modification.ModificationType.ValueType
    @property
    def feature(self) -> global___Feature:
        """Required for create/update feature modification types. Creates or Updates
        the feature with the matching feature.id to the given value.
        """
    @property
    def create_or_update_tag(self) -> global___CreateOrUpdateTag:
        """Required for the create/update tag modification type."""
    @property
    def rename_tag(self) -> global___RenameTag:
        """Required for the rename tag modification type."""
    @property
    def delete_tag(self) -> global___DeleteTag:
        """Required for the delete tag modification type."""
    @property
    def delete_tags(self) -> global___DeleteTags:
        """Required for the delete tags modification type."""
    update_named_variable_set_version_id: builtins.str
    """For MODIFICATION_TYPE_UPDATE_NAMED_VARIABLE_SET.
    The new named variable set version (by id) to be used for the geometry.
    """
    def __init__(
        self,
        *,
        mod_type: global___Modification.ModificationType.ValueType = ...,
        feature: global___Feature | None = ...,
        create_or_update_tag: global___CreateOrUpdateTag | None = ...,
        rename_tag: global___RenameTag | None = ...,
        delete_tag: global___DeleteTag | None = ...,
        delete_tags: global___DeleteTags | None = ...,
        update_named_variable_set_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_or_update_tag", b"create_or_update_tag", "delete_tag", b"delete_tag", "delete_tags", b"delete_tags", "feature", b"feature", "rename_tag", b"rename_tag"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_or_update_tag", b"create_or_update_tag", "delete_tag", b"delete_tag", "delete_tags", b"delete_tags", "feature", b"feature", "mod_type", b"mod_type", "rename_tag", b"rename_tag", "update_named_variable_set_version_id", b"update_named_variable_set_version_id"]) -> None: ...

global___Modification = Modification

class Face(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    BBOX_MIN_FIELD_NUMBER: builtins.int
    BBOX_MAX_FIELD_NUMBER: builtins.int
    NATIVE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def bbox_min(self) -> luminarycloud._proto.base.base_pb2.Vector3: ...
    @property
    def bbox_max(self) -> luminarycloud._proto.base.base_pb2.Vector3: ...
    native_id: builtins.int
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        bbox_min: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        bbox_max: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        native_id: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bbox_max", b"bbox_max", "bbox_min", b"bbox_min"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bbox_max", b"bbox_max", "bbox_min", b"bbox_min", "id", b"id", "native_id", b"native_id"]) -> None: ...

global___Face = Face

class Body(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    BBOX_MIN_FIELD_NUMBER: builtins.int
    BBOX_MAX_FIELD_NUMBER: builtins.int
    LCN_ID_FIELD_NUMBER: builtins.int
    id: builtins.int
    @property
    def bbox_min(self) -> luminarycloud._proto.base.base_pb2.Vector3: ...
    @property
    def bbox_max(self) -> luminarycloud._proto.base.base_pb2.Vector3: ...
    lcn_id: builtins.int
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        bbox_min: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        bbox_max: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        lcn_id: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bbox_max", b"bbox_max", "bbox_min", b"bbox_min"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bbox_max", b"bbox_max", "bbox_min", b"bbox_min", "id", b"id", "lcn_id", b"lcn_id"]) -> None: ...

global___Body = Body

class Volume(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    id: builtins.int
    name: builtins.str
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "name", b"name"]) -> None: ...

global___Volume = Volume

class Tags(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Tag(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        BODIES_FIELD_NUMBER: builtins.int
        LCN_BODIES_FIELD_NUMBER: builtins.int
        FACES_FIELD_NUMBER: builtins.int
        BODIES_OF_FACES_FIELD_NUMBER: builtins.int
        LCN_BODIES_OF_FACES_FIELD_NUMBER: builtins.int
        id: builtins.str
        """Unique identifier for the tag. This string has enough entropy that the
        client can use it to uniquely identify the tag. Consumers of the tags
        will always suppose that the tag will be referened by its ID. The ID
        is not random and it's related to the name. Two tags cannot share the
        same name nor the same ID.
        """
        name: builtins.str
        @property
        def bodies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
        @property
        def lcn_bodies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
        @property
        def faces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
        @property
        def bodies_of_faces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
        @property
        def lcn_bodies_of_faces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
        def __init__(
            self,
            *,
            id: builtins.str = ...,
            name: builtins.str = ...,
            bodies: collections.abc.Iterable[builtins.int] | None = ...,
            lcn_bodies: collections.abc.Iterable[builtins.int] | None = ...,
            faces: collections.abc.Iterable[builtins.int] | None = ...,
            bodies_of_faces: collections.abc.Iterable[builtins.int] | None = ...,
            lcn_bodies_of_faces: collections.abc.Iterable[builtins.int] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["bodies", b"bodies", "bodies_of_faces", b"bodies_of_faces", "faces", b"faces", "id", b"id", "lcn_bodies", b"lcn_bodies", "lcn_bodies_of_faces", b"lcn_bodies_of_faces", "name", b"name"]) -> None: ...

    TAGS_FIELD_NUMBER: builtins.int
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Tags.Tag]: ...
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[global___Tags.Tag] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tags", b"tags"]) -> None: ...

global___Tags = Tags
