"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
This file defines the format of lcmesh files.

A lcmesh file authoritatively describes an unstructured grid.  It is created
by meshconverter from *.su2, *.msh, etc. Typically, one large lcmesh file
fully defines a grid. MPI ranks of a FVM solver or ParaView job will
range-shard the file first, then invoke (par)metis to topologically partition
the mesh, then shuffles the CVs, faces, and points between ranks so that the
topology of each partition is self-contained.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.entitygroup.entitygroup_pb2
import luminarycloud._proto.fvm.param_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _GridType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GridTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GridType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    InvalidGridType: _GridType.ValueType  # 0
    """Sentinel. Unused."""
    Polyhedral: _GridType.ValueType  # 2
    """Polyhedral mesh
    The grid consists of the following datasets:

    <name>/<point_name> : list of points

      Shape: 1D-array of Vector3<Float64>

      Stores (x,y,z) coordinates of each point in the mesh.

    <name>/<face_name> : VLA of global point Ids that define a face

      Shape: 1D-VLA of Int64

      This dataset contains an entry for every face that is part of a CV of the
      mesh, or a face in a bound. Within one face, points are laid out in
      either clockwise or counterclockwise order.  The direction of the face
      normal is stored in the dataset "<name>/<cv_name>" (see below).

    <name>/<cv_name> : VLA of faces that define a CV

      Shape: VLA of structures with the following layout:
      struct CvFace {
        Int64 id;
        UInt8 orientation;
      };

      List of faces in each CV. CvFace.id indexes an element in
      "<name>/<face_name>". CvFace.orientation is true if the face normal
      points outward if we traverse the points in order stored in
      "<name>/face", and compute the normal using the right-hand rule.

    <name>/<face_patch_id_name> : List of patch ids

      Shape: 1D-array of Int32

      For every face it indicates which CAD surface patch that face belongs to.
      A CAD surface patch is a open or closed 2d manifold that defines a region
      of interest in the domain. Note that also internal faces (i.e. faces not
      on any physical boundary) can be on a CAD surface and might have a patch
      id. A patch id value of "-1" means that this face is not on any surface.

    <name>/<walldistance_name> : List of floating point values.

      Shape: 1D array of Float64

      Stores the distance to the nearest physical wall for every cv.

    For boundaries (datasets are optional and not required for fvm solver):

    <name>/<bound_name>/<point_name> : list of points

      Shape: 1D-array of Vector3<Float64>

      Stores (x,y,z) coordinates of each point on the boundary.

    <name>/<bound_name>/<face_name> : VLA of global point Ids that define a
                                      face
      Shape: 1D-VLA of Int64

      This dataset contains an entry for every face of the boundary. Within
      one face, points are laid out in either clockwise or counterclockwise
      order.
    """

class GridType(_GridType, metaclass=_GridTypeEnumTypeWrapper):
    """Defines the encoding of a grid."""

InvalidGridType: GridType.ValueType  # 0
"""Sentinel. Unused."""
Polyhedral: GridType.ValueType  # 2
"""Polyhedral mesh
The grid consists of the following datasets:

<name>/<point_name> : list of points

  Shape: 1D-array of Vector3<Float64>

  Stores (x,y,z) coordinates of each point in the mesh.

<name>/<face_name> : VLA of global point Ids that define a face

  Shape: 1D-VLA of Int64

  This dataset contains an entry for every face that is part of a CV of the
  mesh, or a face in a bound. Within one face, points are laid out in
  either clockwise or counterclockwise order.  The direction of the face
  normal is stored in the dataset "<name>/<cv_name>" (see below).

<name>/<cv_name> : VLA of faces that define a CV

  Shape: VLA of structures with the following layout:
  struct CvFace {
    Int64 id;
    UInt8 orientation;
  };

  List of faces in each CV. CvFace.id indexes an element in
  "<name>/<face_name>". CvFace.orientation is true if the face normal
  points outward if we traverse the points in order stored in
  "<name>/face", and compute the normal using the right-hand rule.

<name>/<face_patch_id_name> : List of patch ids

  Shape: 1D-array of Int32

  For every face it indicates which CAD surface patch that face belongs to.
  A CAD surface patch is a open or closed 2d manifold that defines a region
  of interest in the domain. Note that also internal faces (i.e. faces not
  on any physical boundary) can be on a CAD surface and might have a patch
  id. A patch id value of "-1" means that this face is not on any surface.

<name>/<walldistance_name> : List of floating point values.

  Shape: 1D array of Float64

  Stores the distance to the nearest physical wall for every cv.

For boundaries (datasets are optional and not required for fvm solver):

<name>/<bound_name>/<point_name> : list of points

  Shape: 1D-array of Vector3<Float64>

  Stores (x,y,z) coordinates of each point on the boundary.

<name>/<bound_name>/<face_name> : VLA of global point Ids that define a
                                  face
  Shape: 1D-VLA of Int64

  This dataset contains an entry for every face of the boundary. Within
  one face, points are laid out in either clockwise or counterclockwise
  order.
"""
global___GridType = GridType

class _GenerationMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GenerationModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GenerationMode.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    InvalidGenerationMode: _GenerationMode.ValueType  # 0
    Unknown: _GenerationMode.ValueType  # 1
    """Provenance/generation unknown - may be a code path that's not fully updated"""
    Generative: _GenerationMode.ValueType  # 2
    """Standard mesh generation from user parameter (blmesh)"""
    Fast: _GenerationMode.ValueType  # 3
    """Coarsened user parameters for fast mesh generation iteration
    Helps to set up minimal refinement near refinement regions, overset, etc.
    Unlikely to be exposed to users
    """
    Adapt: _GenerationMode.ValueType  # 4
    """Lumi Mesh Adaptation"""
    Smallest: _GenerationMode.ValueType  # 5
    """Smallest achievable mesh given geometry and BL parameters"""
    Minimal: _GenerationMode.ValueType  # 6
    """Coarse 'base' mesh for solution preview, LMA bootstrapping, etc."""
    External: _GenerationMode.ValueType  # 7
    """Mesh comes from outside Luminary app"""
    Tesselation: _GenerationMode.ValueType  # 8
    """Tesselation of surface generated by geometry stage"""
    MesherMixed: _GenerationMode.ValueType  # 9
    """'mesher' stage mesh generated by a mix of LcSurface & Spatial MeshGems"""
    LcSurface: _GenerationMode.ValueType  # 10
    """Intermediate volume mesh generated by 'mesher' stage"""
    MeshGems: _GenerationMode.ValueType  # 11
    """Intermediate volume mesh generated by Spatial MeshGems 'mesher' stage"""

class GenerationMode(_GenerationMode, metaclass=_GenerationModeEnumTypeWrapper): ...

InvalidGenerationMode: GenerationMode.ValueType  # 0
Unknown: GenerationMode.ValueType  # 1
"""Provenance/generation unknown - may be a code path that's not fully updated"""
Generative: GenerationMode.ValueType  # 2
"""Standard mesh generation from user parameter (blmesh)"""
Fast: GenerationMode.ValueType  # 3
"""Coarsened user parameters for fast mesh generation iteration
Helps to set up minimal refinement near refinement regions, overset, etc.
Unlikely to be exposed to users
"""
Adapt: GenerationMode.ValueType  # 4
"""Lumi Mesh Adaptation"""
Smallest: GenerationMode.ValueType  # 5
"""Smallest achievable mesh given geometry and BL parameters"""
Minimal: GenerationMode.ValueType  # 6
"""Coarse 'base' mesh for solution preview, LMA bootstrapping, etc."""
External: GenerationMode.ValueType  # 7
"""Mesh comes from outside Luminary app"""
Tesselation: GenerationMode.ValueType  # 8
"""Tesselation of surface generated by geometry stage"""
MesherMixed: GenerationMode.ValueType  # 9
"""'mesher' stage mesh generated by a mix of LcSurface & Spatial MeshGems"""
LcSurface: GenerationMode.ValueType  # 10
"""Intermediate volume mesh generated by 'mesher' stage"""
MeshGems: GenerationMode.ValueType  # 11
"""Intermediate volume mesh generated by Spatial MeshGems 'mesher' stage"""
global___GenerationMode = GenerationMode

class MeshFileMetadata(google.protobuf.message.Message):
    """MeshFileMetadata is stored in FileIndex.metadata. It defines the logical
    structure of a mesh.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZONE_FIELD_NUMBER: builtins.int
    PARENT_MESH_URL_FIELD_NUMBER: builtins.int
    LCCAD_URL_FIELD_NUMBER: builtins.int
    COMPUTATIONAL_MESH_URL_FIELD_NUMBER: builtins.int
    TET_MESH_URL_FIELD_NUMBER: builtins.int
    TET_METRIC_URL_FIELD_NUMBER: builtins.int
    ENTITY_GROUPS_FIELD_NUMBER: builtins.int
    MESH_BCS_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def zone(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ZoneMetadata]:
        """List of zones. A zone is a combination of a grid + boundary surface
        definitions. Most mesh files contain one zone named "0".
        """
    parent_mesh_url: builtins.str
    """The URL of the parent mesh for linking if this is a child mesh."""
    lccad_url: builtins.str
    """LC geometry representation URL"""
    computational_mesh_url: builtins.str
    """Primal volume mesh URL for mesh adaptation and remeshing"""
    tet_mesh_url: builtins.str
    """Primal volume mesh before mixed element insertion URL
    for mesh adaptation and remeshing
    """
    tet_metric_url: builtins.str
    """Primal volume metric before mixed element insertion URL
    for remeshing
    """
    @property
    def entity_groups(self) -> luminarycloud._proto.entitygroup.entitygroup_pb2.EntityGroups:
        """Guess groups of entities"""
    mesh_bcs: builtins.bool
    """Use boundary conditions present in the mesh. This is used during mesh
    conversion process. e.g. Plot3D files with namelist input or OpenFOAM
    meshes with patches that have been defined.
    """
    @property
    def description(self) -> global___MeshDescription:
        """Mesh description"""
    def __init__(
        self,
        *,
        zone: collections.abc.Iterable[global___ZoneMetadata] | None = ...,
        parent_mesh_url: builtins.str = ...,
        lccad_url: builtins.str = ...,
        computational_mesh_url: builtins.str = ...,
        tet_mesh_url: builtins.str = ...,
        tet_metric_url: builtins.str = ...,
        entity_groups: luminarycloud._proto.entitygroup.entitygroup_pb2.EntityGroups | None = ...,
        mesh_bcs: builtins.bool = ...,
        description: global___MeshDescription | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["description", b"description", "entity_groups", b"entity_groups"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["computational_mesh_url", b"computational_mesh_url", "description", b"description", "entity_groups", b"entity_groups", "lccad_url", b"lccad_url", "mesh_bcs", b"mesh_bcs", "parent_mesh_url", b"parent_mesh_url", "tet_mesh_url", b"tet_mesh_url", "tet_metric_url", b"tet_metric_url", "zone", b"zone"]) -> None: ...

global___MeshFileMetadata = MeshFileMetadata

class ZoneMetadata(google.protobuf.message.Message):
    """Zone defines a mesh + boundaries.  Most mesh files have one zone, named "0"."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    POINT_NAME_FIELD_NUMBER: builtins.int
    FACE_NAME_FIELD_NUMBER: builtins.int
    MAIN_GRID_TYPE_FIELD_NUMBER: builtins.int
    BOUND_FIELD_NUMBER: builtins.int
    CV_NAME_FIELD_NUMBER: builtins.int
    FACE_PATCH_ID_NAME_FIELD_NUMBER: builtins.int
    WALLDISTANCE_NAME_FIELD_NUMBER: builtins.int
    STATS_FIELD_NUMBER: builtins.int
    ZONE_ID_NAME_FIELD_NUMBER: builtins.int
    VOLUME_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Dataset name prefix of this zone. Typically, "0", "1", ..."""
    point_name: builtins.str
    """Dataset name for the points in the mesh. Typically "<name>/point"."""
    face_name: builtins.str
    """Dataset name for faces in the mesh. Typically, "<name>/face"."""
    main_grid_type: global___GridType.ValueType
    """Grid encoding spec for the main grid."""
    @property
    def bound(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BoundMetadata]:
        """Boundary surfaces."""
    cv_name: builtins.str
    """Dataset name for Cvs in the mesh. Typically, "<name>/cv_face"."""
    face_patch_id_name: builtins.str
    """Dataset name for patch IDs of the faces. Typically,
    "<name>/face_patch_ids".
    """
    walldistance_name: builtins.str
    """Dataset name for the walldistance of every Cv. Typically
    "<name>/walldistance".
    """
    @property
    def stats(self) -> global___MeshStats:
        """Data set store a domain id for a given zone
        Mesh statistics
        """
    zone_id_name: builtins.str
    """"<name>/zone_ids"."""
    volume_display_name: builtins.str
    """volume name"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        point_name: builtins.str = ...,
        face_name: builtins.str = ...,
        main_grid_type: global___GridType.ValueType = ...,
        bound: collections.abc.Iterable[global___BoundMetadata] | None = ...,
        cv_name: builtins.str = ...,
        face_patch_id_name: builtins.str = ...,
        walldistance_name: builtins.str = ...,
        stats: global___MeshStats | None = ...,
        zone_id_name: builtins.str = ...,
        volume_display_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bound", b"bound", "cv_name", b"cv_name", "face_name", b"face_name", "face_patch_id_name", b"face_patch_id_name", "main_grid_type", b"main_grid_type", "name", b"name", "point_name", b"point_name", "stats", b"stats", "volume_display_name", b"volume_display_name", "walldistance_name", b"walldistance_name", "zone_id_name", b"zone_id_name"]) -> None: ...

global___ZoneMetadata = ZoneMetadata

class MeshStats(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class PatchIdsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    N_POINTS_FIELD_NUMBER: builtins.int
    N_FACES_FIELD_NUMBER: builtins.int
    N_CVS_FIELD_NUMBER: builtins.int
    PATCH_IDS_FIELD_NUMBER: builtins.int
    MIN_COORD_FIELD_NUMBER: builtins.int
    MAX_COORD_FIELD_NUMBER: builtins.int
    n_points: builtins.int
    """Number of points"""
    n_faces: builtins.int
    """Number of faces"""
    n_cvs: builtins.int
    """Number of cvs"""
    @property
    def patch_ids(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.int]:
        """Patch Id map (first: Id, second: number of faces with this id)"""
    @property
    def min_coord(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Min coordinate in the mesh"""
    @property
    def max_coord(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Max coordinate in the mesh"""
    def __init__(
        self,
        *,
        n_points: builtins.int = ...,
        n_faces: builtins.int = ...,
        n_cvs: builtins.int = ...,
        patch_ids: collections.abc.Mapping[builtins.int, builtins.int] | None = ...,
        min_coord: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        max_coord: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["max_coord", b"max_coord", "min_coord", b"min_coord"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_coord", b"max_coord", "min_coord", b"min_coord", "n_cvs", b"n_cvs", "n_faces", b"n_faces", "n_points", b"n_points", "patch_ids", b"patch_ids"]) -> None: ...

global___MeshStats = MeshStats

class BoundMetadata(google.protobuf.message.Message):
    """Boundary surface definition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    GRID_TYPE_FIELD_NUMBER: builtins.int
    FACE_NAME_FIELD_NUMBER: builtins.int
    POINT_NAME_FIELD_NUMBER: builtins.int
    STATS_FIELD_NUMBER: builtins.int
    BOUND_TYPE_FIELD_NUMBER: builtins.int
    GLOBAL_FACE_ID_NAME_FIELD_NUMBER: builtins.int
    GLOBAL_POINT_ID_NAME_FIELD_NUMBER: builtins.int
    START_ALLBOUND_FACE_ID_FIELD_NUMBER: builtins.int
    ALLBOUND_POINT_ID_NAME_FIELD_NUMBER: builtins.int
    SURFACE_ID_NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Dataset name prefix of this zone. E.g.: "0/bound/airfoil",
    "1/bound/farfield",
    ...
    """
    grid_type: global___GridType.ValueType
    """Grid encoding spec."""
    face_name: builtins.str
    """Dataset name for faces in the mesh. Typically, "<name>/face"."""
    point_name: builtins.str
    """Dataset name for the points in the mesh. Typically "<name>/point"."""
    @property
    def stats(self) -> global___MeshStats:
        """Mesh statistics"""
    bound_type: luminarycloud._proto.fvm.param_pb2.PhysicalBoundary.ValueType
    """Type of physical boundary (INVALID_PHYSICAL_BOUNDARY if not known)
    Used for visualization
    """
    global_face_id_name: builtins.str
    """Dataset name for the global face IDs from the volume mesh numbering for
    each face on the boundary. Typically "<name>/global_face".
    """
    global_point_id_name: builtins.str
    """Dataset name for the global point IDs from the volume mesh numbering for
    each point on the boundary. Typically "<name>/global_point".
    """
    start_allbound_face_id: builtins.int
    """Starting face ID for the first face on this boundary from the consecutive
    numbering of faces over all boundaries.
    """
    allbound_point_id_name: builtins.str
    """Dataset name for the point IDs on this boundary from the consecutive
    numbering of points over all boundaries. Typically "<name>/allbound_point".
    """
    surface_id_name: builtins.str
    """Dataset name for the surface ID for each face found on the boundary. The
    IDs will all be equal unless multiple surfaces are merged upstream and
    written to a single bound in the file. Typically "<name>/surface_id".
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        grid_type: global___GridType.ValueType = ...,
        face_name: builtins.str = ...,
        point_name: builtins.str = ...,
        stats: global___MeshStats | None = ...,
        bound_type: luminarycloud._proto.fvm.param_pb2.PhysicalBoundary.ValueType = ...,
        global_face_id_name: builtins.str = ...,
        global_point_id_name: builtins.str = ...,
        start_allbound_face_id: builtins.int = ...,
        allbound_point_id_name: builtins.str = ...,
        surface_id_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["allbound_point_id_name", b"allbound_point_id_name", "bound_type", b"bound_type", "face_name", b"face_name", "global_face_id_name", b"global_face_id_name", "global_point_id_name", b"global_point_id_name", "grid_type", b"grid_type", "name", b"name", "point_name", b"point_name", "start_allbound_face_id", b"start_allbound_face_id", "stats", b"stats", "surface_id_name", b"surface_id_name"]) -> None: ...

global___BoundMetadata = BoundMetadata

class MeshDescription(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODE_FIELD_NUMBER: builtins.int
    mode: global___GenerationMode.ValueType
    """Mesh generation method"""
    def __init__(
        self,
        *,
        mode: global___GenerationMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["mode", b"mode"]) -> None: ...

global___MeshDescription = MeshDescription
