"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
This file defines the format of lcmeshcheckpoint files.

A lcmeshcheckpoint stores mesh contents of one MPI rank after the original
mesh is spatially partitioned. It is written and read by
fvm::Mesh::{Save,Load}Checkpoint. *.lcmeshcheckpoint file gives a quick way
for an MPI-based solver or viewer to load the same mesh repeatedly.  The
contents of this file can be regenerated from the original *.lcmesh file, so
it can be freely deleted, and also its format can change over time.

Mesh format:

<name>/<cv_name> : VLA of faces that define a CV

  Shape: VLA of lcn::CvFace (cc/lcn/lcmesh.h).

  This dataset contains CVs that this MPI rank stores. It includes the owned
  CVs and halo CVs.  It does not include dummy CVs.

  CvFace.id indexes an element in "<name>/<face_name>". CvFace.orientation is
  true if the face normal points outward if we traverse the points in order
  stored in "<name>/face", and compute the normal using the right-hand rule.

<name>/<cv_aux_attr_name> : global IDs of each CV in <name>/<cv_name>

  Shape: 1D array of lcn::CvAuxAttr (cc/lcn/lcmeshcheckpoint.h)

  The datasets <cv_name> and <cv_aux_attr_name> always store the same number
  of elementss.

<name>/<face_name> : VLA of global point Ids that define a face

  Shape: 1D-VLA of GlobalPointId.

  This dataset contains an entry for every face that is part of a CV in
  <name>/<cv_name>.

<name>/<face_aux_attr_name> : Defines the attribute of each face.
  Shape: 1D array of lcn::FaceAuxAttr  (cc/lcn/lcmesh.h)

  The datasets <face_name> and <face_aux_attr_name> always store the same
  number of elementss.

<name>/<point_name> : list of points

  Shape: 1D-array of Vector3<Float64>

  Stores (x,y,z) coordinates of each point that is part of <name>/<face_name>

<name>/<point_aux_attr_name> : Attribute of each point.

  Shape: 1D array of lcn::PointAuxAttr

  The datasets <point_name> and <point_aux_attr_name> always store the same
  number of elementss.

<name>/<bound_name>/<face_name> : Faces in the boundary.
  Shape: 1D array of GlobalFaceId

  This dataset contains a subset of face ID in <name>/<face_name> that are
  contained in the given bound.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class MeshCheckpointFileMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZONE_FIELD_NUMBER: builtins.int
    @property
    def zone(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ZoneCheckpointMetadata]:
        """NOTE: It was decided to not write a checkpoint per mesh zone but to write a
        checkpoint with the agglomerated elements coming from all the zones read by
        a Mesh object. For backwards compatibility reasons, we keep the file
        structure despite the fact that the checkpoint "0 zone" potentially
        contains information from other multiple zones.
        """
    def __init__(
        self,
        *,
        zone: collections.abc.Iterable[global___ZoneCheckpointMetadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["zone", b"zone"]) -> None: ...

global___MeshCheckpointFileMetadata = MeshCheckpointFileMetadata

class ZoneCheckpointMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CV_NAME_FIELD_NUMBER: builtins.int
    CV_AUX_ATTR_NAME_FIELD_NUMBER: builtins.int
    POINT_NAME_FIELD_NUMBER: builtins.int
    POINT_AUX_ATTR_NAME_FIELD_NUMBER: builtins.int
    FACE_NAME_FIELD_NUMBER: builtins.int
    BOUND_POINT_NAME_FIELD_NUMBER: builtins.int
    FACE_AUX_ATTR_NAME_FIELD_NUMBER: builtins.int
    WALL_DISTANCE_FIELD_NUMBER: builtins.int
    N_GLOBAL_CVS_FIELD_NUMBER: builtins.int
    N_GLOBAL_FACES_FIELD_NUMBER: builtins.int
    N_GLOBAL_POINTS_FIELD_NUMBER: builtins.int
    N_GLOBAL_OWNED_POINTS_FIELD_NUMBER: builtins.int
    BOUND_FIELD_NUMBER: builtins.int
    OWNED_ZONES_FIELD_NUMBER: builtins.int
    ZONE_OFFSET_CVS_FIELD_NUMBER: builtins.int
    ZONE_OFFSET_FACES_FIELD_NUMBER: builtins.int
    ZONE_OFFSET_POINTS_FIELD_NUMBER: builtins.int
    N_ZONES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Dataset name prefix of this zone. Must always be "0" as explained in the
    MeshCheckpointFileMetadata message.
    """
    cv_name: builtins.str
    """Dataset name for Cvs in the mesh. Typically, "<name>/cv_face"."""
    cv_aux_attr_name: builtins.str
    point_name: builtins.str
    """Dataset name for the points in the mesh. Typically "<name>/point"."""
    point_aux_attr_name: builtins.str
    face_name: builtins.str
    """Dataset name for faces in the mesh. Typically, "<name>/face"."""
    bound_point_name: builtins.str
    face_aux_attr_name: builtins.str
    wall_distance: builtins.float
    n_global_cvs: builtins.int
    """Copy of global count variables in member data of MeshImpl."""
    n_global_faces: builtins.int
    n_global_points: builtins.int
    n_global_owned_points: builtins.int
    @property
    def bound(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BoundCheckpointMetadata]:
        """Boundary surfaces."""
    @property
    def owned_zones(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Zone IDs of the owned zones found in the mesh described by the checkpoint."""
    @property
    def zone_offset_cvs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Zone-based entities offsets. Used to compute (between others) per-zone
        counts.
        """
    @property
    def zone_offset_faces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def zone_offset_points(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    n_zones: builtins.int
    """Total number of zones found in the input mesh file."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cv_name: builtins.str = ...,
        cv_aux_attr_name: builtins.str = ...,
        point_name: builtins.str = ...,
        point_aux_attr_name: builtins.str = ...,
        face_name: builtins.str = ...,
        bound_point_name: builtins.str = ...,
        face_aux_attr_name: builtins.str = ...,
        wall_distance: builtins.float = ...,
        n_global_cvs: builtins.int = ...,
        n_global_faces: builtins.int = ...,
        n_global_points: builtins.int = ...,
        n_global_owned_points: builtins.int = ...,
        bound: collections.abc.Iterable[global___BoundCheckpointMetadata] | None = ...,
        owned_zones: collections.abc.Iterable[builtins.int] | None = ...,
        zone_offset_cvs: collections.abc.Iterable[builtins.int] | None = ...,
        zone_offset_faces: collections.abc.Iterable[builtins.int] | None = ...,
        zone_offset_points: collections.abc.Iterable[builtins.int] | None = ...,
        n_zones: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bound", b"bound", "bound_point_name", b"bound_point_name", "cv_aux_attr_name", b"cv_aux_attr_name", "cv_name", b"cv_name", "face_aux_attr_name", b"face_aux_attr_name", "face_name", b"face_name", "n_global_cvs", b"n_global_cvs", "n_global_faces", b"n_global_faces", "n_global_owned_points", b"n_global_owned_points", "n_global_points", b"n_global_points", "n_zones", b"n_zones", "name", b"name", "owned_zones", b"owned_zones", "point_aux_attr_name", b"point_aux_attr_name", "point_name", b"point_name", "wall_distance", b"wall_distance", "zone_offset_cvs", b"zone_offset_cvs", "zone_offset_faces", b"zone_offset_faces", "zone_offset_points", b"zone_offset_points"]) -> None: ...

global___ZoneCheckpointMetadata = ZoneCheckpointMetadata

class BoundCheckpointMetadata(google.protobuf.message.Message):
    """Boundary surface definition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    GLOBAL_ID_FIELD_NUMBER: builtins.int
    N_GLOBAL_FACES_FIELD_NUMBER: builtins.int
    IS_PERIODIC_FIELD_NUMBER: builtins.int
    FACE_NAME_FIELD_NUMBER: builtins.int
    N_GLOBAL_POINTS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Dataset name prefix of this zone. E.g.: "0/bound/airfoil",
    "1/bound/farfield",
    ...
    """
    global_id: builtins.int
    """Copy of Boundary::global_id"""
    n_global_faces: builtins.int
    is_periodic: builtins.bool
    face_name: builtins.str
    n_global_points: builtins.int
    zone_id: builtins.int
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        global_id: builtins.int = ...,
        n_global_faces: builtins.int = ...,
        is_periodic: builtins.bool = ...,
        face_name: builtins.str = ...,
        n_global_points: builtins.int = ...,
        zone_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["face_name", b"face_name", "global_id", b"global_id", "is_periodic", b"is_periodic", "n_global_faces", b"n_global_faces", "n_global_points", b"n_global_points", "name", b"name", "zone_id", b"zone_id"]) -> None: ...

global___BoundCheckpointMetadata = BoundCheckpointMetadata
