"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ScalarType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ScalarTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ScalarType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    InvalidScalarType: _ScalarType.ValueType  # 0
    Float64: _ScalarType.ValueType  # 1
    """IEEE 64bit floating point"""
    Float32: _ScalarType.ValueType  # 2
    """IEEE 32bit floating point"""
    Int64LE: _ScalarType.ValueType  # 3
    """Little endian int64"""
    Int32LE: _ScalarType.ValueType  # 4
    """Little endian int32"""
    Uint8: _ScalarType.ValueType  # 5
    """An unsigned byte. Used to encode utf8-strings."""
    Uint16: _ScalarType.ValueType  # 6
    """An unsigned short int. Used to encode domain ids."""

class ScalarType(_ScalarType, metaclass=_ScalarTypeEnumTypeWrapper): ...

InvalidScalarType: ScalarType.ValueType  # 0
Float64: ScalarType.ValueType  # 1
"""IEEE 64bit floating point"""
Float32: ScalarType.ValueType  # 2
"""IEEE 32bit floating point"""
Int64LE: ScalarType.ValueType  # 3
"""Little endian int64"""
Int32LE: ScalarType.ValueType  # 4
"""Little endian int32"""
Uint8: ScalarType.ValueType  # 5
"""An unsigned byte. Used to encode utf8-strings."""
Uint16: ScalarType.ValueType  # 6
"""An unsigned short int. Used to encode domain ids."""
global___ScalarType = ScalarType

class FileIndex(google.protobuf.message.Message):
    """FlieIndex defines the overall structure of the file.

    For all practical purposes, FileIndex is a one-level index. FileIndex.index
    stores a sequence of DatasetIndexes, and each DatasetIndex defines the
    attributes of a dataset chunk. DatasetIndexes are sorted lexicographically,
    first by name, then range_limit within the index.

    Note: the dataset chunk payloadx need not be stored in file-offset order.

    FileIndex does support multi-level index, but we don't expect it to be used
    any time soon. In multi-level index, FileIndex.index points to a non_leaf
    node, which stores a serialized FileIndex for a contiguous subregion of a
    file.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    NODE_FIELD_NUMBER: builtins.int
    SHARD_FILE_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> google.protobuf.any_pb2.Any: ...
    @property
    def node(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IndexNode]: ...
    @property
    def shard_file(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ShardFile]: ...
    def __init__(
        self,
        *,
        metadata: google.protobuf.any_pb2.Any | None = ...,
        node: collections.abc.Iterable[global___IndexNode] | None = ...,
        shard_file: collections.abc.Iterable[global___ShardFile] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "node", b"node", "shard_file", b"shard_file"]) -> None: ...

global___FileIndex = FileIndex

class ShardFile(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    id: builtins.int
    """matches DatasetIndex.shard_file_id."""
    url: builtins.str
    """the filenameo"""
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "url", b"url"]) -> None: ...

global___ShardFile = ShardFile

class IndexNode(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_FIELD_NUMBER: builtins.int
    NON_LEAF_FIELD_NUMBER: builtins.int
    @property
    def dataset(self) -> global___DatasetIndex:
        """leaf node."""
    @property
    def non_leaf(self) -> global___NonLeafIndex:
        """nonleaf node; not common."""
    def __init__(
        self,
        *,
        dataset: global___DatasetIndex | None = ...,
        non_leaf: global___NonLeafIndex | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["dataset", b"dataset", "node_type", b"node_type", "non_leaf", b"non_leaf"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dataset", b"dataset", "node_type", b"node_type", "non_leaf", b"non_leaf"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["node_type", b"node_type"]) -> typing_extensions.Literal["dataset", "non_leaf"] | None: ...

global___IndexNode = IndexNode

class NonLeafIndex(google.protobuf.message.Message):
    """Used to build a multi-level index."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_NAME_FIELD_NUMBER: builtins.int
    START_ELEM_FIELD_NUMBER: builtins.int
    LIMIT_NAME_FIELD_NUMBER: builtins.int
    LIMIT_ELEM_FIELD_NUMBER: builtins.int
    FILE_OFFSET_FIELD_NUMBER: builtins.int
    N_BYTE_FIELD_NUMBER: builtins.int
    OPT_FIELD_NUMBER: builtins.int
    CHECKSUM_FIELD_NUMBER: builtins.int
    start_name: builtins.str
    """The range of dataset chunks covered by this index entry."""
    start_elem: builtins.int
    limit_name: builtins.str
    limit_elem: builtins.int
    file_offset: builtins.int
    """File block [file_offset, file_offset + n_byte] contains a serialized
    IndexNodeList.
    """
    n_byte: builtins.int
    @property
    def opt(self) -> global___EncodingOpt:
        """encoding of the file block"""
    checksum: builtins.int
    """checksum of the file block"""
    def __init__(
        self,
        *,
        start_name: builtins.str = ...,
        start_elem: builtins.int = ...,
        limit_name: builtins.str = ...,
        limit_elem: builtins.int = ...,
        file_offset: builtins.int = ...,
        n_byte: builtins.int = ...,
        opt: global___EncodingOpt | None = ...,
        checksum: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["opt", b"opt"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["checksum", b"checksum", "file_offset", b"file_offset", "limit_elem", b"limit_elem", "limit_name", b"limit_name", "n_byte", b"n_byte", "opt", b"opt", "start_elem", b"start_elem", "start_name", b"start_name"]) -> None: ...

global___NonLeafIndex = NonLeafIndex

class IndexNodeList(google.protobuf.message.Message):
    """Payload of non-leaf index."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INDEX_FIELD_NUMBER: builtins.int
    @property
    def index(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IndexNode]: ...
    def __init__(
        self,
        *,
        index: collections.abc.Iterable[global___IndexNode] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["index", b"index"]) -> None: ...

global___IndexNodeList = IndexNodeList

class DatasetIndex(google.protobuf.message.Message):
    """DatasetIndex is the leaf index entry."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYP_FIELD_NUMBER: builtins.int
    SHAPE_FIELD_NUMBER: builtins.int
    VARIABLE_LENGTH_ARRAY_FIELD_NUMBER: builtins.int
    OPT_FIELD_NUMBER: builtins.int
    CHUNK_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    """dataset name, e.g., "vertices" """
    @property
    def typ(self) -> global___ElementType:
        """element type"""
    @property
    def shape(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Shape of the array. For example:

        - if shape=[120], then the dataset is a 1-D 120-element vector of <typ>.

        - if shape=[120, 4], then the dataset is a 2-D (120, 4) matrix of
          <typ>. Internally, the dataset is always stored as a flat sequence in
          row-major order. Row-major means that the 2nd dimension (of size 4) moves
          more quickly.

        REQUIRES: shape[i] > 0, ∀ i ∈ [0,shape.size())
        """
    variable_length_array: builtins.bool
    """Is each element itself a variable length array?"""
    @property
    def opt(self) -> global___EncodingOpt:
        """Encoding of each chunk"""
    @property
    def chunk(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DatasetChunkIndex]:
        """List of chunks; sorted ascendingly by range"""
    @property
    def metadata(self) -> google.protobuf.any_pb2.Any:
        """Any user-defined payload."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        typ: global___ElementType | None = ...,
        shape: collections.abc.Iterable[builtins.int] | None = ...,
        variable_length_array: builtins.bool = ...,
        opt: global___EncodingOpt | None = ...,
        chunk: collections.abc.Iterable[global___DatasetChunkIndex] | None = ...,
        metadata: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "opt", b"opt", "typ", b"typ"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk", b"chunk", "metadata", b"metadata", "name", b"name", "opt", b"opt", "shape", b"shape", "typ", b"typ", "variable_length_array", b"variable_length_array"]) -> None: ...

global___DatasetIndex = DatasetIndex

class DatasetChunkIndex(google.protobuf.message.Message):
    """Defines the location of a chunk."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_ELEM_FIELD_NUMBER: builtins.int
    START_FILE_OFFSET_FIELD_NUMBER: builtins.int
    N_ELEMS_FIELD_NUMBER: builtins.int
    N_BYTES_ENCODED_FIELD_NUMBER: builtins.int
    N_BYTES_RAW_FIELD_NUMBER: builtins.int
    CHECKSUM_FIELD_NUMBER: builtins.int
    SHARD_FILE_ID_FIELD_NUMBER: builtins.int
    start_elem: builtins.int
    """Start element number of this chunk (inclusive). The first chunk has
    Defines the location of a chunkrange_start=0.
    """
    start_file_offset: builtins.int
    """Defines the region of the file where the payload is stored."""
    n_elems: builtins.int
    """Limit element number of this chunk (exclusive)."""
    n_bytes_encoded: builtins.int
    """Number of bytes in the file, post compression."""
    n_bytes_raw: builtins.int
    """Number of bytes in the chunk, pre compression"""
    checksum: builtins.int
    """Checksum of the payload. The algorithm is defined by
    DatasetIndex.opt.checksum.
    """
    shard_file_id: builtins.int
    def __init__(
        self,
        *,
        start_elem: builtins.int = ...,
        start_file_offset: builtins.int = ...,
        n_elems: builtins.int = ...,
        n_bytes_encoded: builtins.int = ...,
        n_bytes_raw: builtins.int = ...,
        checksum: builtins.int = ...,
        shard_file_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["checksum", b"checksum", "n_bytes_encoded", b"n_bytes_encoded", "n_bytes_raw", b"n_bytes_raw", "n_elems", b"n_elems", "shard_file_id", b"shard_file_id", "start_elem", b"start_elem", "start_file_offset", b"start_file_offset"]) -> None: ...

global___DatasetChunkIndex = DatasetChunkIndex

class EncodingOpt(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPRESSION_FIELD_NUMBER: builtins.int
    CHECKSUM_FIELD_NUMBER: builtins.int
    compression: builtins.str
    """e.g., "zstd 1" """
    checksum: builtins.str
    """e.g., "xxh64" """
    def __init__(
        self,
        *,
        compression: builtins.str = ...,
        checksum: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["checksum", b"checksum", "compression", b"compression"]) -> None: ...

global___EncodingOpt = EncodingOpt

class ElementType(google.protobuf.message.Message):
    """ElementType defines the type of each leaf value.  ElementType is used to
    compute the bytesize of each element.  Other than that, this type is used
    largely for documentation purposes.

    An element type can be:
     - scalar (int64, etc)

     - fixed-length array of ElementType.

     - a struct, which is a heterogeneous list of ElementTypes. The field names
       are for documentation only.

    For example:

      - if a dataset stores a flat sequence of C++ doubles, then its
        ElementType will be {scalar: Float64}.

      - if a dataset stores a sequence of 3D coordinates (x,y,z), then its
        element type will be is {array: {typ: {scalar: Float64}, dim: 3}}.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCALAR_FIELD_NUMBER: builtins.int
    ARRAY_FIELD_NUMBER: builtins.int
    STRUC_FIELD_NUMBER: builtins.int
    scalar: global___ScalarType.ValueType
    @property
    def array(self) -> global___ArrayType: ...
    @property
    def struc(self) -> global___StructType: ...
    def __init__(
        self,
        *,
        scalar: global___ScalarType.ValueType = ...,
        array: global___ArrayType | None = ...,
        struc: global___StructType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["array", b"array", "scalar", b"scalar", "struc", b"struc", "typ", b"typ"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["array", b"array", "scalar", b"scalar", "struc", b"struc", "typ", b"typ"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["typ", b"typ"]) -> typing_extensions.Literal["scalar", "array", "struc"] | None: ...

global___ElementType = ElementType

class ArrayType(google.protobuf.message.Message):
    """ArrayType represents a C++ std::array."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYP_FIELD_NUMBER: builtins.int
    DIM_FIELD_NUMBER: builtins.int
    @property
    def typ(self) -> global___ElementType:
        """element type."""
    dim: builtins.int
    """size of the array. must be >0."""
    def __init__(
        self,
        *,
        typ: global___ElementType | None = ...,
        dim: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["typ", b"typ"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dim", b"dim", "typ", b"typ"]) -> None: ...

global___ArrayType = ArrayType

class StructType(google.protobuf.message.Message):
    """ArrayType represents a C++ struct.  LCN demands that struct fields are
    tightly packed without a gap using __attribute__((packed)).

    For example, if you want to store a struct with int64 and bool, declare it
    like following:

    struct __attribute__((packed)) FaceAndOrientation {
      int64_t face_id;
      bool orientation;
    }

    template <>
    inline proto::lcn::ElementType Type<CvFace>() {
      proto::lcn::ElementType t;
      auto* s = t.mutable_struc();
      auto* f = s->add_field();
      f->set_name("id");
      *f->mutable_typ() = Type<int64_t>();
      f = s->add_field();
      f->set_name("orientation");
      *f->mutable_typ() = Type<bool>();
      return t;
    }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Field(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        TYP_FIELD_NUMBER: builtins.int
        name: builtins.str
        """field name"""
        @property
        def typ(self) -> global___ElementType:
            """field type."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            typ: global___ElementType | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["typ", b"typ"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "typ", b"typ"]) -> None: ...

    FIELD_FIELD_NUMBER: builtins.int
    @property
    def field(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructType.Field]: ...
    def __init__(
        self,
        *,
        field: collections.abc.Iterable[global___StructType.Field] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["field", b"field"]) -> None: ...

global___StructType = StructType
