"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
This file defines the format of lcvis files.

A lcvis file authoritatively describes extracts created by the vis library.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.lcn.lcsoln_pb2
import luminarycloud._proto.quantity.quantity_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _VisGridType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _VisGridTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_VisGridType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    InvalidVisGridType: _VisGridType.ValueType  # 0
    """Sentinel. Unused."""
    Unstructured: _VisGridType.ValueType  # 1
    """Unstructured mesh
    The grid consists of the following datasets:

    <name>/<point_name> : list of points

      Shape: 1D-array of Vector3<Float64>

      Stores (x,y,z) coordinates of each point in the mesh.

    <name>/<shapes> : VLA of the vtk shapes types each cell.

      Shape: 1D-VLA of UInt8

      This dataset constains the vtk shape type of every cell. The shape is needed
      to interpret the connectivity for each cell.

    <name>/<offsets> : VLA of the offset for each cell in the connectivity VLA.

      Shape: 1D-VLA of Int64

      This dataset constains the offset for each cell in the connectivity, i.e.,
      cell i connectivity starts at offsets[i].

    <name>/<connectivity> : VLA of the connectivity of each cell.

      Shape: 1D-array of Int64

      This data set contains the connectivity for each cell. Each cell
      contains a list consisting of the number of pt ids for the cell followed
      by the point ids in vtk ordering.
    """

class VisGridType(_VisGridType, metaclass=_VisGridTypeEnumTypeWrapper):
    """Defines the encoding of a grid."""

InvalidVisGridType: VisGridType.ValueType  # 0
"""Sentinel. Unused."""
Unstructured: VisGridType.ValueType  # 1
"""Unstructured mesh
The grid consists of the following datasets:

<name>/<point_name> : list of points

  Shape: 1D-array of Vector3<Float64>

  Stores (x,y,z) coordinates of each point in the mesh.

<name>/<shapes> : VLA of the vtk shapes types each cell.

  Shape: 1D-VLA of UInt8

  This dataset constains the vtk shape type of every cell. The shape is needed
  to interpret the connectivity for each cell.

<name>/<offsets> : VLA of the offset for each cell in the connectivity VLA.

  Shape: 1D-VLA of Int64

  This dataset constains the offset for each cell in the connectivity, i.e.,
  cell i connectivity starts at offsets[i].

<name>/<connectivity> : VLA of the connectivity of each cell.

  Shape: 1D-array of Int64

  This data set contains the connectivity for each cell. Each cell
  contains a list consisting of the number of pt ids for the cell followed
  by the point ids in vtk ordering.
"""
global___VisGridType = VisGridType

class _FieldAssociation:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FieldAssociationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FieldAssociation.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    InvalidFieldAssociation: _FieldAssociation.ValueType  # 0
    """Sentinel. Unused."""
    Cells: _FieldAssociation.ValueType  # 1
    """Field is cell associated."""
    Points: _FieldAssociation.ValueType  # 2
    """Field is point associated."""

class FieldAssociation(_FieldAssociation, metaclass=_FieldAssociationEnumTypeWrapper):
    """Defines association of a field to mesh topology."""

InvalidFieldAssociation: FieldAssociation.ValueType  # 0
"""Sentinel. Unused."""
Cells: FieldAssociation.ValueType  # 1
"""Field is cell associated."""
Points: FieldAssociation.ValueType  # 2
"""Field is point associated."""
global___FieldAssociation = FieldAssociation

class VisFileMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZONE_FIELD_NUMBER: builtins.int
    @property
    def zone(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VisZoneMetadata]:
        """List of zones. Each zone is a collections of blocks, where each block is a
        mesh that is logically associated with the other blocks.  Examples of
        grouped blocks could be spatially decomposed volume meshes, sets of slices
        created from the same volume, sets of contours, or any other logical
        grouping. The grouping facilitates importing meshes into paraview as
        multi-block data sets, which allows us to easily hide and show blocks for
        animation or exploration.
        """
    def __init__(
        self,
        *,
        zone: collections.abc.Iterable[global___VisZoneMetadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["zone", b"zone"]) -> None: ...

global___VisFileMetadata = VisFileMetadata

class VisZoneMetadata(google.protobuf.message.Message):
    """Zone defines a logical collection of blocks."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BLOCK_FIELD_NUMBER: builtins.int
    STATS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Dataset name prefix of this zone."""
    @property
    def block(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BlockMetadata]:
        """Block meta data."""
    @property
    def stats(self) -> global___VisMeshStats:
        """Mesh statistics for all blocks"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        block: collections.abc.Iterable[global___BlockMetadata] | None = ...,
        stats: global___VisMeshStats | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["block", b"block", "name", b"name", "stats", b"stats"]) -> None: ...

global___VisZoneMetadata = VisZoneMetadata

class VisMeshStats(google.protobuf.message.Message):
    """Stats about the topololgy."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    N_POINTS_FIELD_NUMBER: builtins.int
    N_CELLS_FIELD_NUMBER: builtins.int
    N_CONN_FIELD_NUMBER: builtins.int
    MIN_COORD_FIELD_NUMBER: builtins.int
    MAX_COORD_FIELD_NUMBER: builtins.int
    n_points: builtins.int
    """Number of points"""
    n_cells: builtins.int
    """Number of cells"""
    n_conn: builtins.int
    """Size of connectivity array"""
    @property
    def min_coord(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Min coordinate in the mesh"""
    @property
    def max_coord(self) -> luminarycloud._proto.base.base_pb2.Vector3:
        """Max coordinate in the mesh"""
    def __init__(
        self,
        *,
        n_points: builtins.int = ...,
        n_cells: builtins.int = ...,
        n_conn: builtins.int = ...,
        min_coord: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
        max_coord: luminarycloud._proto.base.base_pb2.Vector3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["max_coord", b"max_coord", "min_coord", b"min_coord"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_coord", b"max_coord", "min_coord", b"min_coord", "n_cells", b"n_cells", "n_conn", b"n_conn", "n_points", b"n_points"]) -> None: ...

global___VisMeshStats = VisMeshStats

class BlockMetadata(google.protobuf.message.Message):
    """Block definition: a self contianed mesh that can belong to
    a logical grouping of other blocks.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    GRID_TYPE_FIELD_NUMBER: builtins.int
    SHAPES_NAME_FIELD_NUMBER: builtins.int
    POINTS_NAME_FIELD_NUMBER: builtins.int
    OFFSETS_NAME_FIELD_NUMBER: builtins.int
    CONNECTIVITY_NAME_FIELD_NUMBER: builtins.int
    STATS_FIELD_NUMBER: builtins.int
    FIELD_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Dataset name prefix of this block. E.g.: "zone_name/block_name/" """
    grid_type: global___VisGridType.ValueType
    """Grid encoding spec."""
    shapes_name: builtins.str
    """Dataset name for shapes array, Typically, "<name>/shapes"."""
    points_name: builtins.str
    """Dataset name for the points in the mesh. Typically "<name>/points"."""
    offsets_name: builtins.str
    """Dataset name for the offsets in the mesh. Typically "<name>/offsets"."""
    connectivity_name: builtins.str
    """Dataset name for the connectivity in the mesh. Typically "<name>/connectivity"."""
    @property
    def stats(self) -> global___VisMeshStats:
        """VisMesh statistics for this block"""
    @property
    def field(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FieldMetadata]:
        """Metadata for all fields for this block."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        grid_type: global___VisGridType.ValueType = ...,
        shapes_name: builtins.str = ...,
        points_name: builtins.str = ...,
        offsets_name: builtins.str = ...,
        connectivity_name: builtins.str = ...,
        stats: global___VisMeshStats | None = ...,
        field: collections.abc.Iterable[global___FieldMetadata] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connectivity_name", b"connectivity_name", "field", b"field", "grid_type", b"grid_type", "name", b"name", "offsets_name", b"offsets_name", "points_name", b"points_name", "shapes_name", b"shapes_name", "stats", b"stats"]) -> None: ...

global___BlockMetadata = BlockMetadata

class FieldMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    RANGE_FIELD_NUMBER: builtins.int
    ASSOC_FIELD_NUMBER: builtins.int
    QUANTITY_FALLBACK_NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Dataset name for the field. Typically: "zone_name/block_name/fields/field_name" """
    quantity: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType
    """Quantities for the field. TODO(matt): not sure what to do about derived
    quantities like vector magnitude.
    """
    @property
    def range(self) -> luminarycloud._proto.lcn.lcsoln_pb2.FieldRange: ...
    assoc: global___FieldAssociation.ValueType
    quantity_fallback_name: builtins.str
    """Guard names used to identify DEBUG_QUANTITY quantities."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        quantity: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType = ...,
        range: luminarycloud._proto.lcn.lcsoln_pb2.FieldRange | None = ...,
        assoc: global___FieldAssociation.ValueType = ...,
        quantity_fallback_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["range", b"range"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["assoc", b"assoc", "name", b"name", "quantity", b"quantity", "quantity_fallback_name", b"quantity_fallback_name", "range", b"range"]) -> None: ...

global___FieldMetadata = FieldMetadata

class CustomField(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    expression: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        expression: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["expression", b"expression", "name", b"name"]) -> None: ...

global___CustomField = CustomField

class CustomFields(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CUSTOM_FIELDS_FIELD_NUMBER: builtins.int
    @property
    def custom_fields(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CustomField]: ...
    def __init__(
        self,
        *,
        custom_fields: collections.abc.Iterable[global___CustomField] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["custom_fields", b"custom_fields"]) -> None: ...

global___CustomFields = CustomFields
