"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.quantity.quantity_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _TimeAnalysisType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TimeAnalysisTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TimeAnalysisType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_TIME_ANALYSIS_TYPE: _TimeAnalysisType.ValueType  # 0
    """An invalid time analysis type."""
    TIME_AVERAGE: _TimeAnalysisType.ValueType  # 1
    """Compute the mean of the data over all time steps."""
    TIME_SERIES: _TimeAnalysisType.ValueType  # 2
    """Return a list of values for every time step."""
    TIME_MAX: _TimeAnalysisType.ValueType  # 3
    """Return the maximum value over all time steps."""
    TIME_MIN: _TimeAnalysisType.ValueType  # 4
    """Return the minimum value over all time steps."""
    TIME_MOVING_AVERAGE: _TimeAnalysisType.ValueType  # 5
    """Return the moving average for every time step."""
    TIME_AVERAGE_CAUCHY: _TimeAnalysisType.ValueType  # 6
    """Return average of the relative difference between subsequent time steps."""
    TIME_SERIES_CAUCHY: _TimeAnalysisType.ValueType  # 7
    """Return average of the relative difference between subsequent time steps
    as a time-series.
    """
    TIME_MOVING_AVERAGE_CAUCHY: _TimeAnalysisType.ValueType  # 8
    """Return moving average of the relative difference between
    subsequent time steps as a time-series.
    """
    PERCENT_MAX_DEV: _TimeAnalysisType.ValueType  # 9
    """Return maximum percent deviation in range of previous iterations from
    the current value.
    """
    PERCENT_MAX_DEV_SERIES: _TimeAnalysisType.ValueType  # 10
    """Return max percent deviation in range of previous iterations from
    each value in a series.
    """
    PERCENT_MAX_DEV_AVG: _TimeAnalysisType.ValueType  # 11
    """Return max percent deviation of trailing average in range of previous
    iterations from current trailing average.
    """
    PERCENT_MAX_DEV_AVG_SERIES: _TimeAnalysisType.ValueType  # 12
    """Return max percent deviation of trailing average in range of previous
    iterations from each trailing average in a series.
    """
    TIME_TRAILING_AVG_SERIES: _TimeAnalysisType.ValueType  # 13
    """Return the trailing average for every time step."""

class TimeAnalysisType(_TimeAnalysisType, metaclass=_TimeAnalysisTypeEnumTypeWrapper): ...

INVALID_TIME_ANALYSIS_TYPE: TimeAnalysisType.ValueType  # 0
"""An invalid time analysis type."""
TIME_AVERAGE: TimeAnalysisType.ValueType  # 1
"""Compute the mean of the data over all time steps."""
TIME_SERIES: TimeAnalysisType.ValueType  # 2
"""Return a list of values for every time step."""
TIME_MAX: TimeAnalysisType.ValueType  # 3
"""Return the maximum value over all time steps."""
TIME_MIN: TimeAnalysisType.ValueType  # 4
"""Return the minimum value over all time steps."""
TIME_MOVING_AVERAGE: TimeAnalysisType.ValueType  # 5
"""Return the moving average for every time step."""
TIME_AVERAGE_CAUCHY: TimeAnalysisType.ValueType  # 6
"""Return average of the relative difference between subsequent time steps."""
TIME_SERIES_CAUCHY: TimeAnalysisType.ValueType  # 7
"""Return average of the relative difference between subsequent time steps
as a time-series.
"""
TIME_MOVING_AVERAGE_CAUCHY: TimeAnalysisType.ValueType  # 8
"""Return moving average of the relative difference between
subsequent time steps as a time-series.
"""
PERCENT_MAX_DEV: TimeAnalysisType.ValueType  # 9
"""Return maximum percent deviation in range of previous iterations from
the current value.
"""
PERCENT_MAX_DEV_SERIES: TimeAnalysisType.ValueType  # 10
"""Return max percent deviation in range of previous iterations from
each value in a series.
"""
PERCENT_MAX_DEV_AVG: TimeAnalysisType.ValueType  # 11
"""Return max percent deviation of trailing average in range of previous
iterations from current trailing average.
"""
PERCENT_MAX_DEV_AVG_SERIES: TimeAnalysisType.ValueType  # 12
"""Return max percent deviation of trailing average in range of previous
iterations from each trailing average in a series.
"""
TIME_TRAILING_AVG_SERIES: TimeAnalysisType.ValueType  # 13
"""Return the trailing average for every time step."""
global___TimeAnalysisType = TimeAnalysisType

class _SpaceAveragingType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SpaceAveragingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SpaceAveragingType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_SPACE_AVERAGING_TYPE: _SpaceAveragingType.ValueType  # 0
    """An invalid averaging type."""
    SPACE_MASS_FLOW_AVERAGING: _SpaceAveragingType.ValueType  # 1
    """Average using the mass flow at each face divided by the total mass flow."""
    SPACE_AREA_AVERAGING: _SpaceAveragingType.ValueType  # 2
    """Average using the area of each face divided by the total area."""
    SPACE_NO_AVERAGING: _SpaceAveragingType.ValueType  # 3
    """No Averaging."""

class SpaceAveragingType(_SpaceAveragingType, metaclass=_SpaceAveragingTypeEnumTypeWrapper): ...

INVALID_SPACE_AVERAGING_TYPE: SpaceAveragingType.ValueType  # 0
"""An invalid averaging type."""
SPACE_MASS_FLOW_AVERAGING: SpaceAveragingType.ValueType  # 1
"""Average using the mass flow at each face divided by the total mass flow."""
SPACE_AREA_AVERAGING: SpaceAveragingType.ValueType  # 2
"""Average using the area of each face divided by the total area."""
SPACE_NO_AVERAGING: SpaceAveragingType.ValueType  # 3
"""No Averaging."""
global___SpaceAveragingType = SpaceAveragingType

class _VolumeReductionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _VolumeReductionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_VolumeReductionType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_VOLUME_REDUCTION_TYPE: _VolumeReductionType.ValueType  # 0
    """An invalid reduction type."""
    VOLUME_MINIMUM: _VolumeReductionType.ValueType  # 1
    """Minimum value over the domain."""
    VOLUME_MAXIMUM: _VolumeReductionType.ValueType  # 2
    """Maximum value over the domain."""
    VOLUME_AVERAGING: _VolumeReductionType.ValueType  # 3
    """Volume averaging."""

class VolumeReductionType(_VolumeReductionType, metaclass=_VolumeReductionTypeEnumTypeWrapper): ...

INVALID_VOLUME_REDUCTION_TYPE: VolumeReductionType.ValueType  # 0
"""An invalid reduction type."""
VOLUME_MINIMUM: VolumeReductionType.ValueType  # 1
"""Minimum value over the domain."""
VOLUME_MAXIMUM: VolumeReductionType.ValueType  # 2
"""Maximum value over the domain."""
VOLUME_AVERAGING: VolumeReductionType.ValueType  # 3
"""Volume averaging."""
global___VolumeReductionType = VolumeReductionType

class _ForceDirectionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ForceDirectionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ForceDirectionType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_FORCE_DIRECTION_TYPE: _ForceDirectionType.ValueType  # 0
    """Invalid force direction type."""
    FORCE_DIRECTION_CUSTOM: _ForceDirectionType.ValueType  # 1
    """Custom direction."""
    FORCE_DIRECTION_BODY_ORIENTATION_AND_FLOW_DIR: _ForceDirectionType.ValueType  # 2
    """Automatic computation of the direction based on the body-x, body-y vector
    and a flow direction.
    """

class ForceDirectionType(_ForceDirectionType, metaclass=_ForceDirectionTypeEnumTypeWrapper): ...

INVALID_FORCE_DIRECTION_TYPE: ForceDirectionType.ValueType  # 0
"""Invalid force direction type."""
FORCE_DIRECTION_CUSTOM: ForceDirectionType.ValueType  # 1
"""Custom direction."""
FORCE_DIRECTION_BODY_ORIENTATION_AND_FLOW_DIR: ForceDirectionType.ValueType  # 2
"""Automatic computation of the direction based on the body-x, body-y vector
and a flow direction.
"""
global___ForceDirectionType = ForceDirectionType

class _MomentConventionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MomentConventionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MomentConventionType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_MOMENT_CONVENTION_TYPE: _MomentConventionType.ValueType  # 0
    """An invalid moment frame type."""
    MOMENT_CONVENTION_BODY_FRAME: _MomentConventionType.ValueType  # 1
    """Use the body frame for pitch, roll, and yaw moments."""
    MOMENT_CONVENTION_STABILITY_FRAME: _MomentConventionType.ValueType  # 2
    """Use the stability frame for pitch, roll, and yaw moments."""

class MomentConventionType(_MomentConventionType, metaclass=_MomentConventionTypeEnumTypeWrapper): ...

INVALID_MOMENT_CONVENTION_TYPE: MomentConventionType.ValueType  # 0
"""An invalid moment frame type."""
MOMENT_CONVENTION_BODY_FRAME: MomentConventionType.ValueType  # 1
"""Use the body frame for pitch, roll, and yaw moments."""
MOMENT_CONVENTION_STABILITY_FRAME: MomentConventionType.ValueType  # 2
"""Use the stability frame for pitch, roll, and yaw moments."""
global___MomentConventionType = MomentConventionType

class _ResidualType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResidualTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResidualType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_RESIDUAL_TYPE: _ResidualType.ValueType  # 0
    RESIDUAL_ABSOLUTE: _ResidualType.ValueType  # 1
    RESIDUAL_RELATIVE: _ResidualType.ValueType  # 2
    RESIDUAL_MAX: _ResidualType.ValueType  # 3
    RESIDUAL_MIN: _ResidualType.ValueType  # 4

class ResidualType(_ResidualType, metaclass=_ResidualTypeEnumTypeWrapper): ...

INVALID_RESIDUAL_TYPE: ResidualType.ValueType  # 0
RESIDUAL_ABSOLUTE: ResidualType.ValueType  # 1
RESIDUAL_RELATIVE: ResidualType.ValueType  # 2
RESIDUAL_MAX: ResidualType.ValueType  # 3
RESIDUAL_MIN: ResidualType.ValueType  # 4
global___ResidualType = ResidualType

class _StoppingConditionOp:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StoppingConditionOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StoppingConditionOp.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_STOP_COND_OP: _StoppingConditionOp.ValueType  # 0
    STOP_COND_OP_ALL: _StoppingConditionOp.ValueType  # 1
    """All stopping conditions have to be satisfied."""
    STOP_COND_OP_ANY: _StoppingConditionOp.ValueType  # 2
    """Any stopping condition has to be satisfied."""
    STOP_COND_OP_FORCE: _StoppingConditionOp.ValueType  # 3
    """Solver will stop if condition is satisfied, regardless of any other condition."""

class StoppingConditionOp(_StoppingConditionOp, metaclass=_StoppingConditionOpEnumTypeWrapper): ...

INVALID_STOP_COND_OP: StoppingConditionOp.ValueType  # 0
STOP_COND_OP_ALL: StoppingConditionOp.ValueType  # 1
"""All stopping conditions have to be satisfied."""
STOP_COND_OP_ANY: StoppingConditionOp.ValueType  # 2
"""Any stopping condition has to be satisfied."""
STOP_COND_OP_FORCE: StoppingConditionOp.ValueType  # 3
"""Solver will stop if condition is satisfied, regardless of any other condition."""
global___StoppingConditionOp = StoppingConditionOp

class ForceProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FORCE_DIR_TYPE_FIELD_NUMBER: builtins.int
    FORCE_DIRECTION_FIELD_NUMBER: builtins.int
    MOMENT_CENTER_FIELD_NUMBER: builtins.int
    POROUS_FIELD_NUMBER: builtins.int
    MOMENT_CONVENTION_TYPE_FIELD_NUMBER: builtins.int
    force_dir_type: global___ForceDirectionType.ValueType
    """Force direction type."""
    @property
    def force_direction(self) -> luminarycloud._proto.base.base_pb2.AdVector3:
        """The force direction."""
    @property
    def moment_center(self) -> luminarycloud._proto.base.base_pb2.AdVector3:
        """Center of moments."""
    porous: builtins.bool
    """Whether the force is porous."""
    moment_convention_type: global___MomentConventionType.ValueType
    """Whether to use the body or stability frame for pitch, roll, and yaw moments."""
    def __init__(
        self,
        *,
        force_dir_type: global___ForceDirectionType.ValueType = ...,
        force_direction: luminarycloud._proto.base.base_pb2.AdVector3 | None = ...,
        moment_center: luminarycloud._proto.base.base_pb2.AdVector3 | None = ...,
        porous: builtins.bool = ...,
        moment_convention_type: global___MomentConventionType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["force_direction", b"force_direction", "moment_center", b"moment_center"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["force_dir_type", b"force_dir_type", "force_direction", b"force_direction", "moment_center", b"moment_center", "moment_convention_type", b"moment_convention_type", "porous", b"porous"]) -> None: ...

global___ForceProperties = ForceProperties

class ResidualProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    PHYSICS_INDEX_FIELD_NUMBER: builtins.int
    type: global___ResidualType.ValueType
    physics_index: builtins.int
    def __init__(
        self,
        *,
        type: global___ResidualType.ValueType = ...,
        physics_index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["physics_index", b"physics_index", "type", b"type"]) -> None: ...

global___ResidualProperties = ResidualProperties

class SurfaceAverageProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AVERAGING_TYPE_FIELD_NUMBER: builtins.int
    averaging_type: global___SpaceAveragingType.ValueType
    def __init__(
        self,
        *,
        averaging_type: global___SpaceAveragingType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["averaging_type", b"averaging_type"]) -> None: ...

global___SurfaceAverageProperties = SurfaceAverageProperties

class VolumeReductionProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REDUCTION_TYPE_FIELD_NUMBER: builtins.int
    reduction_type: global___VolumeReductionType.ValueType
    def __init__(
        self,
        *,
        reduction_type: global___VolumeReductionType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["reduction_type", b"reduction_type"]) -> None: ...

global___VolumeReductionProperties = VolumeReductionProperties

class IterationRange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BEGIN_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    begin: builtins.int
    """Begin iteration."""
    end: builtins.int
    """End iteration."""
    def __init__(
        self,
        *,
        begin: builtins.int = ...,
        end: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["begin", b"begin", "end", b"end"]) -> None: ...

global___IterationRange = IterationRange

class BasicType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___BasicType = BasicType

class PointProbeType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PointProbeType = PointProbeType

class DerivedType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXPRESSION_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    expression: builtins.str
    @property
    def dependencies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Output]: ...
    def __init__(
        self,
        *,
        expression: builtins.str = ...,
        dependencies: collections.abc.Iterable[global___Output] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dependencies", b"dependencies", "expression", b"expression"]) -> None: ...

global___DerivedType = DerivedType

class Output(google.protobuf.message.Message):
    """A quantity that the user wants reported in the outputs of a simulation.
    Next available tag is 15.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUANTITY_FIELD_NUMBER: builtins.int
    VECTOR_COMPONENT_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    IN_SURFACES_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SHORT_NAME_FIELD_NUMBER: builtins.int
    TIME_ANALYSIS_FIELD_NUMBER: builtins.int
    FORCE_PROPERTIES_FIELD_NUMBER: builtins.int
    SURFACE_AVERAGE_PROPERTIES_FIELD_NUMBER: builtins.int
    RESIDUAL_PROPERTIES_FIELD_NUMBER: builtins.int
    BASIC_PROPERTIES_FIELD_NUMBER: builtins.int
    PROBE_PROPERTIES_FIELD_NUMBER: builtins.int
    DERIVED_PROPERTIES_FIELD_NUMBER: builtins.int
    VOLUME_REDUCTION_PROPERTIES_FIELD_NUMBER: builtins.int
    RANGE_FIELD_NUMBER: builtins.int
    AVG_ITERS_FIELD_NUMBER: builtins.int
    ANALYSIS_ITERS_FIELD_NUMBER: builtins.int
    FRAME_ID_FIELD_NUMBER: builtins.int
    INNER_ITERS_FIELD_NUMBER: builtins.int
    quantity: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType
    vector_component: luminarycloud._proto.base.base_pb2.Vector3Component.ValueType
    """If the quantity is a vector this defines the component that is requested.
    Field is ignored if the quantity is not a vector.
    """
    id: builtins.str
    """A unique ID for this output."""
    @property
    def in_surfaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of entities on which to evaluate the output"""
    name: builtins.str
    """The name of this output."""
    short_name: builtins.str
    """A shortened name for the output that is sometimes used."""
    time_analysis: global___TimeAnalysisType.ValueType
    """The type of time analysis to perform."""
    @property
    def force_properties(self) -> global___ForceProperties: ...
    @property
    def surface_average_properties(self) -> global___SurfaceAverageProperties: ...
    @property
    def residual_properties(self) -> global___ResidualProperties: ...
    @property
    def basic_properties(self) -> global___BasicType: ...
    @property
    def probe_properties(self) -> global___PointProbeType: ...
    @property
    def derived_properties(self) -> global___DerivedType: ...
    @property
    def volume_reduction_properties(self) -> global___VolumeReductionProperties: ...
    @property
    def range(self) -> global___IterationRange: ...
    avg_iters: builtins.int
    analysis_iters: builtins.int
    frame_id: builtins.str
    """ID of the reference frame that this output should be reported in."""
    inner_iters: builtins.bool
    """If true, analyzer will include inner iterations."""
    def __init__(
        self,
        *,
        quantity: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType = ...,
        vector_component: luminarycloud._proto.base.base_pb2.Vector3Component.ValueType = ...,
        id: builtins.str = ...,
        in_surfaces: collections.abc.Iterable[builtins.str] | None = ...,
        name: builtins.str = ...,
        short_name: builtins.str = ...,
        time_analysis: global___TimeAnalysisType.ValueType = ...,
        force_properties: global___ForceProperties | None = ...,
        surface_average_properties: global___SurfaceAverageProperties | None = ...,
        residual_properties: global___ResidualProperties | None = ...,
        basic_properties: global___BasicType | None = ...,
        probe_properties: global___PointProbeType | None = ...,
        derived_properties: global___DerivedType | None = ...,
        volume_reduction_properties: global___VolumeReductionProperties | None = ...,
        range: global___IterationRange | None = ...,
        avg_iters: builtins.int = ...,
        analysis_iters: builtins.int = ...,
        frame_id: builtins.str = ...,
        inner_iters: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["basic_properties", b"basic_properties", "derived_properties", b"derived_properties", "force_properties", b"force_properties", "output_properties", b"output_properties", "probe_properties", b"probe_properties", "range", b"range", "residual_properties", b"residual_properties", "surface_average_properties", b"surface_average_properties", "volume_reduction_properties", b"volume_reduction_properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["analysis_iters", b"analysis_iters", "avg_iters", b"avg_iters", "basic_properties", b"basic_properties", "derived_properties", b"derived_properties", "force_properties", b"force_properties", "frame_id", b"frame_id", "id", b"id", "in_surfaces", b"in_surfaces", "inner_iters", b"inner_iters", "name", b"name", "output_properties", b"output_properties", "probe_properties", b"probe_properties", "quantity", b"quantity", "range", b"range", "residual_properties", b"residual_properties", "short_name", b"short_name", "surface_average_properties", b"surface_average_properties", "time_analysis", b"time_analysis", "vector_component", b"vector_component", "volume_reduction_properties", b"volume_reduction_properties"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["output_properties", b"output_properties"]) -> typing_extensions.Literal["force_properties", "surface_average_properties", "residual_properties", "basic_properties", "probe_properties", "derived_properties", "volume_reduction_properties"] | None: ...

global___Output = Output

class Result(google.protobuf.message.Message):
    """Result is the result of a query.
    If multiple outputs were requested in an Output query,
    each sub query will have a value in the order of the
    sub query.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.base.base_pb2.AdFloatType]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[luminarycloud._proto.base.base_pb2.AdFloatType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Result = Result

class StoppingCondition(google.protobuf.message.Message):
    """Stopping condition for the solver"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUT_FIELD_NUMBER: builtins.int
    THRESHOLD_FIELD_NUMBER: builtins.int
    OP_FIELD_NUMBER: builtins.int
    @property
    def output(self) -> global___Output: ...
    @property
    def threshold(self) -> luminarycloud._proto.base.base_pb2.AdFloatType:
        """Threshold value (might be min or max, depending on the output quantity)."""
    op: global___StoppingConditionOp.ValueType
    """"""
    def __init__(
        self,
        *,
        output: global___Output | None = ...,
        threshold: luminarycloud._proto.base.base_pb2.AdFloatType | None = ...,
        op: global___StoppingConditionOp.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["output", b"output", "threshold", b"threshold"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["op", b"op", "output", b"output", "threshold", b"threshold"]) -> None: ...

global___StoppingCondition = StoppingCondition

class StoppingConditionStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    COND_SUCCESS_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    FORCE_STOP_FIELD_NUMBER: builtins.int
    success: builtins.bool
    """Indicates result of the set of conditions (excluding conditions in with STOP_COND_OP_FORCE)."""
    @property
    def cond_success(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """Indicates result of each individual condition."""
    @property
    def value(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Result]:
        """The numerical value of the output quantity used in the convergence check."""
    force_stop: builtins.bool
    """Indicates whether a condition with STOP_COND_OP_FORCE is satisfied."""
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        cond_success: collections.abc.Iterable[builtins.bool] | None = ...,
        value: collections.abc.Iterable[global___Result] | None = ...,
        force_stop: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cond_success", b"cond_success", "force_stop", b"force_stop", "success", b"success", "value", b"value"]) -> None: ...

global___StoppingConditionStatus = StoppingConditionStatus
