"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Metadata definition for physical quantities used throughout the luminary
platform
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.condition.condition_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _QuantityTag:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _QuantityTagEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_QuantityTag.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TAG_INVALID: _QuantityTag.ValueType  # 0
    """Invalid tag"""
    TAG_BASIC: _QuantityTag.ValueType  # 1
    """Basic physical dimension (time, length, volume etc)."""
    TAG_FIELD: _QuantityTag.ValueType  # 2
    """Is a function of space and time and can be integrated."""
    TAG_FORCE: _QuantityTag.ValueType  # 3
    """Defines a force."""
    TAG_MOMENT: _QuantityTag.ValueType  # 4
    """Defines a moment."""
    TAG_EXTERNAL: _QuantityTag.ValueType  # 5
    """Used in external flow problems."""
    TAG_AERODYNAMICS: _QuantityTag.ValueType  # 6
    """Used in aerodynamic problems."""
    TAG_INTERNAL: _QuantityTag.ValueType  # 7
    """Used in internal flow problems."""
    TAG_TORQUE: _QuantityTag.ValueType  # 8
    """Defines a torque."""
    TAG_DROP: _QuantityTag.ValueType  # 9
    """Difference between two quantities."""
    TAG_AUTO_DIRECTION: _QuantityTag.ValueType  # 10
    """Indicates that the force/moment direction can be computed automatically for
    this quantity.
    """
    TAG_COEFFICIENT: _QuantityTag.ValueType  # 11
    """Dimensionless coefficient."""
    TAG_ANALYZER_AVERAGE: _QuantityTag.ValueType  # 12
    """Computed by the surface average analyzer."""
    TAG_ANALYZER_FORCES: _QuantityTag.ValueType  # 13
    """Computed by the forces analyzer."""
    TAG_TIME_AVERAGE: _QuantityTag.ValueType  # 14
    """Time verage quantity"""
    TAG_RESIDUAL: _QuantityTag.ValueType  # 15
    """Residuals"""
    TAG_ANALYZER_RESIDUAL: _QuantityTag.ValueType  # 16
    """Computed by residual analyzer"""
    TAG_ANALYZER_BASIC: _QuantityTag.ValueType  # 17
    """Computed by basic analyzer"""
    TAG_TURBULENCE: _QuantityTag.ValueType  # 18
    """Turbulence quantities"""
    TAG_POINT_PROBE: _QuantityTag.ValueType  # 19
    """Point probe"""
    TAG_HIDDEN_SOLVER_STATE: _QuantityTag.ValueType  # 20
    """Solver state that is hidden from users"""
    TAG_SURFACE_FIELD: _QuantityTag.ValueType  # 21
    """Solution fields whose values are only meaningful at boundaries. This is
    useful to optimize the solution reading in the visualizer.
    """
    TAG_ACTUATOR_DISK: _QuantityTag.ValueType  # 22
    """Quantities only defined on actuator disk"""
    TAG_ANALYZER_VOLUME: _QuantityTag.ValueType  # 23
    """Computed by the volume reductions analyzer"""
    TAG_AERO_MOMENT: _QuantityTag.ValueType  # 24
    """Aerodynamic moments."""

class QuantityTag(_QuantityTag, metaclass=_QuantityTagEnumTypeWrapper): ...

TAG_INVALID: QuantityTag.ValueType  # 0
"""Invalid tag"""
TAG_BASIC: QuantityTag.ValueType  # 1
"""Basic physical dimension (time, length, volume etc)."""
TAG_FIELD: QuantityTag.ValueType  # 2
"""Is a function of space and time and can be integrated."""
TAG_FORCE: QuantityTag.ValueType  # 3
"""Defines a force."""
TAG_MOMENT: QuantityTag.ValueType  # 4
"""Defines a moment."""
TAG_EXTERNAL: QuantityTag.ValueType  # 5
"""Used in external flow problems."""
TAG_AERODYNAMICS: QuantityTag.ValueType  # 6
"""Used in aerodynamic problems."""
TAG_INTERNAL: QuantityTag.ValueType  # 7
"""Used in internal flow problems."""
TAG_TORQUE: QuantityTag.ValueType  # 8
"""Defines a torque."""
TAG_DROP: QuantityTag.ValueType  # 9
"""Difference between two quantities."""
TAG_AUTO_DIRECTION: QuantityTag.ValueType  # 10
"""Indicates that the force/moment direction can be computed automatically for
this quantity.
"""
TAG_COEFFICIENT: QuantityTag.ValueType  # 11
"""Dimensionless coefficient."""
TAG_ANALYZER_AVERAGE: QuantityTag.ValueType  # 12
"""Computed by the surface average analyzer."""
TAG_ANALYZER_FORCES: QuantityTag.ValueType  # 13
"""Computed by the forces analyzer."""
TAG_TIME_AVERAGE: QuantityTag.ValueType  # 14
"""Time verage quantity"""
TAG_RESIDUAL: QuantityTag.ValueType  # 15
"""Residuals"""
TAG_ANALYZER_RESIDUAL: QuantityTag.ValueType  # 16
"""Computed by residual analyzer"""
TAG_ANALYZER_BASIC: QuantityTag.ValueType  # 17
"""Computed by basic analyzer"""
TAG_TURBULENCE: QuantityTag.ValueType  # 18
"""Turbulence quantities"""
TAG_POINT_PROBE: QuantityTag.ValueType  # 19
"""Point probe"""
TAG_HIDDEN_SOLVER_STATE: QuantityTag.ValueType  # 20
"""Solver state that is hidden from users"""
TAG_SURFACE_FIELD: QuantityTag.ValueType  # 21
"""Solution fields whose values are only meaningful at boundaries. This is
useful to optimize the solution reading in the visualizer.
"""
TAG_ACTUATOR_DISK: QuantityTag.ValueType  # 22
"""Quantities only defined on actuator disk"""
TAG_ANALYZER_VOLUME: QuantityTag.ValueType  # 23
"""Computed by the volume reductions analyzer"""
TAG_AERO_MOMENT: QuantityTag.ValueType  # 24
"""Aerodynamic moments."""
global___QuantityTag = QuantityTag

class _UnitType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _UnitTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_UnitType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNIT_INVALID: _UnitType.ValueType  # 0
    UNIT_DIMENSIONLESS: _UnitType.ValueType  # 1
    UNIT_TEMPERATURE: _UnitType.ValueType  # 2
    UNIT_MASS: _UnitType.ValueType  # 3
    UNIT_LENGTH: _UnitType.ValueType  # 4
    UNIT_ANGLE: _UnitType.ValueType  # 5
    UNIT_TIME: _UnitType.ValueType  # 6
    UNIT_VELOCITY: _UnitType.ValueType  # 7
    UNIT_ANGULAR_VELOCITY: _UnitType.ValueType  # 8
    UNIT_FORCE: _UnitType.ValueType  # 9
    UNIT_MOMENT: _UnitType.ValueType  # 10
    UNIT_PRESSURE: _UnitType.ValueType  # 11
    UNIT_ENERGY: _UnitType.ValueType  # 12
    UNIT_POWER: _UnitType.ValueType  # 13
    UNIT_VOLUME: _UnitType.ValueType  # 14
    UNIT_VOLUMETRIC_FLOW: _UnitType.ValueType  # 15
    UNIT_VISCOSITY: _UnitType.ValueType  # 16
    UNIT_CONDUCTIVITY: _UnitType.ValueType  # 17
    UNIT_MOLECULAR_WEIGHT: _UnitType.ValueType  # 18
    UNIT_DERIVED: _UnitType.ValueType  # 19

class UnitType(_UnitType, metaclass=_UnitTypeEnumTypeWrapper): ...

UNIT_INVALID: UnitType.ValueType  # 0
UNIT_DIMENSIONLESS: UnitType.ValueType  # 1
UNIT_TEMPERATURE: UnitType.ValueType  # 2
UNIT_MASS: UnitType.ValueType  # 3
UNIT_LENGTH: UnitType.ValueType  # 4
UNIT_ANGLE: UnitType.ValueType  # 5
UNIT_TIME: UnitType.ValueType  # 6
UNIT_VELOCITY: UnitType.ValueType  # 7
UNIT_ANGULAR_VELOCITY: UnitType.ValueType  # 8
UNIT_FORCE: UnitType.ValueType  # 9
UNIT_MOMENT: UnitType.ValueType  # 10
UNIT_PRESSURE: UnitType.ValueType  # 11
UNIT_ENERGY: UnitType.ValueType  # 12
UNIT_POWER: UnitType.ValueType  # 13
UNIT_VOLUME: UnitType.ValueType  # 14
UNIT_VOLUMETRIC_FLOW: UnitType.ValueType  # 15
UNIT_VISCOSITY: UnitType.ValueType  # 16
UNIT_CONDUCTIVITY: UnitType.ValueType  # 17
UNIT_MOLECULAR_WEIGHT: UnitType.ValueType  # 18
UNIT_DERIVED: UnitType.ValueType  # 19
global___UnitType = UnitType

class Tags(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALS_FIELD_NUMBER: builtins.int
    @property
    def vals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___QuantityTag.ValueType]: ...
    def __init__(
        self,
        *,
        vals: collections.abc.Iterable[global___QuantityTag.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vals", b"vals"]) -> None: ...

global___Tags = Tags

class Children(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALS_FIELD_NUMBER: builtins.int
    @property
    def vals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        vals: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vals", b"vals"]) -> None: ...

global___Children = Children

class Parents(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALS_FIELD_NUMBER: builtins.int
    @property
    def vals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        vals: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vals", b"vals"]) -> None: ...

global___Parents = Parents

class ConditionalParents(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALS_FIELD_NUMBER: builtins.int
    @property
    def vals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        vals: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vals", b"vals"]) -> None: ...

global___ConditionalParents = ConditionalParents

class Quantity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    HELP_FIELD_NUMBER: builtins.int
    CHILD_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    CONDITIONAL_PARENT_FIELD_NUMBER: builtins.int
    COND_FIELD_NUMBER: builtins.int
    UNIT_TYPE_FIELD_NUMBER: builtins.int
    UNIT_DERIVATION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Internal name of the quantity."""
    text: builtins.str
    """User facing name of the quantity."""
    size: builtins.int
    """Number of components (usually 1 for scalar and 3 for vector)."""
    unit: builtins.str
    """Default unit of the quantity."""
    @property
    def tags(self) -> global___Tags:
        """Tags that can be used to add certain properties or to define what can be
        done with the quantity (for example TAG_FIELD declares the quantity as a
        field variable that can be integrated on a surface or in a volume).
        """
    help: builtins.str
    """Help string describing the quantity."""
    @property
    def child(self) -> global___Children:
        """An array of quantity IDs that depend on this parameter."""
    @property
    def parent(self) -> global___Parents:
        """An array of quantity IDs that this parameter depends on.  Used for
        computing derived fields in the vis service.
        """
    @property
    def conditional_parent(self) -> global___ConditionalParents:
        """An array of quantity IDs that this parameter may depend on.  When the
        params satisfy the conditional parent .cond field, the parent is
        expected/required.  Used for computing derived fields in the vis service
        """
    @property
    def cond(self) -> luminarycloud._proto.condition.condition_pb2.Condition: ...
    unit_type: global___UnitType.ValueType
    unit_derivation: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        text: builtins.str = ...,
        size: builtins.int = ...,
        unit: builtins.str = ...,
        tags: global___Tags | None = ...,
        help: builtins.str = ...,
        child: global___Children | None = ...,
        parent: global___Parents | None = ...,
        conditional_parent: global___ConditionalParents | None = ...,
        cond: luminarycloud._proto.condition.condition_pb2.Condition | None = ...,
        unit_type: global___UnitType.ValueType = ...,
        unit_derivation: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["child", b"child", "cond", b"cond", "conditional_parent", b"conditional_parent", "parent", b"parent", "tags", b"tags"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["child", b"child", "cond", b"cond", "conditional_parent", b"conditional_parent", "help", b"help", "name", b"name", "parent", b"parent", "size", b"size", "tags", b"tags", "text", b"text", "unit", b"unit", "unit_derivation", b"unit_derivation", "unit_type", b"unit_type"]) -> None: ...

global___Quantity = Quantity
