"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import luminarycloud._proto.file.file_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Method:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MethodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Method.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    METHOD_UNSPECIFIED: _Method.ValueType  # 0
    METHOD_SIMPLE: _Method.ValueType  # 1
    """See SimpleMethod"""
    METHOD_GCS_RESUMABLE: _Method.ValueType  # 2
    """See GCSResumableMethod"""

class Method(_Method, metaclass=_MethodEnumTypeWrapper):
    """Available upload methods"""

METHOD_UNSPECIFIED: Method.ValueType  # 0
METHOD_SIMPLE: Method.ValueType  # 1
"""See SimpleMethod"""
METHOD_GCS_RESUMABLE: Method.ValueType  # 2
"""See GCSResumableMethod"""
global___Method = Method

class _MeshType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MeshTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MeshType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MESH_TYPE_UNSPECIFIED: _MeshType.ValueType  # 0
    MESH_TYPE_ANSYS: _MeshType.ValueType  # 1
    """ANSYS mesh file, .ansys"""
    MESH_TYPE_CGNS: _MeshType.ValueType  # 2
    """open-standard .cgns"""
    MESH_TYPE_OPENFOAM: _MeshType.ValueType  # 3
    """openFOAM mesh"""

class MeshType(_MeshType, metaclass=_MeshTypeEnumTypeWrapper):
    """Currently supported mesh types"""

MESH_TYPE_UNSPECIFIED: MeshType.ValueType  # 0
MESH_TYPE_ANSYS: MeshType.ValueType  # 1
"""ANSYS mesh file, .ansys"""
MESH_TYPE_CGNS: MeshType.ValueType  # 2
"""open-standard .cgns"""
MESH_TYPE_OPENFOAM: MeshType.ValueType  # 3
"""openFOAM mesh"""
global___MeshType = MeshType

class _MeshConversionStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MeshConversionStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MeshConversionStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NOT_REQUIRED: _MeshConversionStatus.ValueType  # 0
    IN_PROGRESS: _MeshConversionStatus.ValueType  # 2
    COMPLETE: _MeshConversionStatus.ValueType  # 3
    FAILED: _MeshConversionStatus.ValueType  # 4

class MeshConversionStatus(_MeshConversionStatus, metaclass=_MeshConversionStatusEnumTypeWrapper): ...

NOT_REQUIRED: MeshConversionStatus.ValueType  # 0
IN_PROGRESS: MeshConversionStatus.ValueType  # 2
COMPLETE: MeshConversionStatus.ValueType  # 3
FAILED: MeshConversionStatus.ValueType  # 4
global___MeshConversionStatus = MeshConversionStatus

class UnspecifiedMethod(google.protobuf.message.Message):
    """Type used for an Upload which has not yet been started."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UnspecifiedMethod = UnspecifiedMethod

class SimpleMethod(google.protobuf.message.Message):
    """A file upload where data is uploaded in chunks via UploadData.
    Corresponds to METHOD_SIMPLE
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SimpleMethod = SimpleMethod

class GCSResumableMethod(google.protobuf.message.Message):
    """A GCS resumable upload.  The provided signed URL and headers should
    be used for the initial resumable upload POST request, with subsequent
    PUT requests to persist the data performed according to the GCS docs:
    https://cloud.google.com/storage/docs/performing-resumable-uploads
    Corresponds to METHOD_GCS_RESUMABLE
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HttpHeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SIGNED_URL_FIELD_NUMBER: builtins.int
    HTTP_HEADERS_FIELD_NUMBER: builtins.int
    signed_url: builtins.str
    @property
    def http_headers(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        signed_url: builtins.str = ...,
        http_headers: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["http_headers", b"http_headers", "signed_url", b"signed_url"]) -> None: ...

global___GCSResumableMethod = GCSResumableMethod

class Upload(google.protobuf.message.Message):
    """Represents an in-progress upload."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    UNSPECIFIED_FIELD_NUMBER: builtins.int
    SIMPLE_FIELD_NUMBER: builtins.int
    GCS_RESUMABLE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID used to uniquely identify this file upload in API calls."""
    @property
    def unspecified(self) -> global___UnspecifiedMethod: ...
    @property
    def simple(self) -> global___SimpleMethod: ...
    @property
    def gcs_resumable(self) -> global___GCSResumableMethod: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        unspecified: global___UnspecifiedMethod | None = ...,
        simple: global___SimpleMethod | None = ...,
        gcs_resumable: global___GCSResumableMethod | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["gcs_resumable", b"gcs_resumable", "method", b"method", "simple", b"simple", "unspecified", b"unspecified"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["gcs_resumable", b"gcs_resumable", "id", b"id", "method", b"method", "simple", b"simple", "unspecified", b"unspecified"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["method", b"method"]) -> typing_extensions.Literal["unspecified", "simple", "gcs_resumable"] | None: ...

global___Upload = Upload

class MeshParams(google.protobuf.message.Message):
    """Parameters to be passed to meshconverter"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCALING_FIELD_NUMBER: builtins.int
    DISCONNECT_FIELD_NUMBER: builtins.int
    MESH_TYPE_FIELD_NUMBER: builtins.int
    DO_NOT_READ_ZONES_OPENFOAM_FIELD_NUMBER: builtins.int
    MESH_NAME_FIELD_NUMBER: builtins.int
    scaling: builtins.float
    """apply scaling to mesh"""
    disconnect: builtins.bool
    """Related to the --disconnect meshconverter cli arg"""
    mesh_type: global___MeshType.ValueType
    """The type of mesh being uploaded"""
    do_not_read_zones_openfoam: builtins.bool
    """True if the meshconverter should disable "read cell zones" for OpenFOAM
    meshes
    """
    mesh_name: builtins.str
    """Optional. Name of the mesh resource on Luminary Cloud. Server will set a
    default mesh name if not provided.
    """
    def __init__(
        self,
        *,
        scaling: builtins.float = ...,
        disconnect: builtins.bool = ...,
        mesh_type: global___MeshType.ValueType = ...,
        do_not_read_zones_openfoam: builtins.bool = ...,
        mesh_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["disconnect", b"disconnect", "do_not_read_zones_openfoam", b"do_not_read_zones_openfoam", "mesh_name", b"mesh_name", "mesh_type", b"mesh_type", "scaling", b"scaling"]) -> None: ...

global___MeshParams = MeshParams

class GeometryParams(google.protobuf.message.Message):
    """TODO: are there any geometry-specific parameters needed
    at upload time?
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GeometryParams = GeometryParams

class C81Params(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___C81Params = C81Params

class SurfDeformParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SurfDeformParams = SurfDeformParams

class ResourceParams(google.protobuf.message.Message):
    """Resource-specific parameters for this upload"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_PARAMS_FIELD_NUMBER: builtins.int
    GEOMETRY_PARAMS_FIELD_NUMBER: builtins.int
    C81_PARAMS_FIELD_NUMBER: builtins.int
    SURF_DEFORM_PARAMS_FIELD_NUMBER: builtins.int
    @property
    def mesh_params(self) -> global___MeshParams: ...
    @property
    def geometry_params(self) -> global___GeometryParams: ...
    @property
    def c81_params(self) -> global___C81Params: ...
    @property
    def surf_deform_params(self) -> global___SurfDeformParams: ...
    def __init__(
        self,
        *,
        mesh_params: global___MeshParams | None = ...,
        geometry_params: global___GeometryParams | None = ...,
        c81_params: global___C81Params | None = ...,
        surf_deform_params: global___SurfDeformParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["c81_params", b"c81_params", "geometry_params", b"geometry_params", "mesh_params", b"mesh_params", "params", b"params", "surf_deform_params", b"surf_deform_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["c81_params", b"c81_params", "geometry_params", b"geometry_params", "mesh_params", b"mesh_params", "params", b"params", "surf_deform_params", b"surf_deform_params"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["params", b"params"]) -> typing_extensions.Literal["mesh_params", "geometry_params", "c81_params", "surf_deform_params"] | None: ...

global___ResourceParams = ResourceParams

class CreateUploadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    FILE_META_FIELD_NUMBER: builtins.int
    RESOURCE_PARAMS_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The project to which the file should be uploaded"""
    @property
    def file_meta(self) -> luminarycloud._proto.file.file_pb2.FileMetadata:
        """Information about the file to be uploaded"""
    @property
    def resource_params(self) -> global___ResourceParams:
        """Resource-specific params needed for the upload to properly
        generate the resource at FinishUpload time.
        """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        file_meta: luminarycloud._proto.file.file_pb2.FileMetadata | None = ...,
        resource_params: global___ResourceParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file_meta", b"file_meta", "resource_params", b"resource_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_meta", b"file_meta", "project_id", b"project_id", "resource_params", b"resource_params"]) -> None: ...

global___CreateUploadRequest = CreateUploadRequest

class CreateUploadReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPLOAD_FIELD_NUMBER: builtins.int
    @property
    def upload(self) -> global___Upload:
        """Upload to be used for uploading file data."""
    def __init__(
        self,
        *,
        upload: global___Upload | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["upload", b"upload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["upload", b"upload"]) -> None: ...

global___CreateUploadReply = CreateUploadReply

class StartUploadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPLOAD_ID_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    upload_id: builtins.str
    method: global___Method.ValueType
    """Which method should be used for the upload."""
    def __init__(
        self,
        *,
        upload_id: builtins.str = ...,
        method: global___Method.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["method", b"method", "upload_id", b"upload_id"]) -> None: ...

global___StartUploadRequest = StartUploadRequest

class StartUploadReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPLOAD_FIELD_NUMBER: builtins.int
    @property
    def upload(self) -> global___Upload: ...
    def __init__(
        self,
        *,
        upload: global___Upload | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["upload", b"upload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["upload", b"upload"]) -> None: ...

global___StartUploadReply = StartUploadReply

class UploadDataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPLOAD_ID_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    upload_id: builtins.str
    """Upload for which to upload file data.  Upload.method must be METHOD_SIMPLE."""
    offset: builtins.int
    """Offset of attached chunk of data in the file."""
    data: builtins.bytes
    """The data to be written."""
    def __init__(
        self,
        *,
        upload_id: builtins.str = ...,
        offset: builtins.int = ...,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "offset", b"offset", "upload_id", b"upload_id"]) -> None: ...

global___UploadDataRequest = UploadDataRequest

class UploadDataReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_OFFSET_FIELD_NUMBER: builtins.int
    COMPLETE_FIELD_NUMBER: builtins.int
    limit_offset: builtins.int
    """The offset of the next byte needed (1 + offset of last byte written)"""
    complete: builtins.bool
    """true iff the file has been completely uploaded.  Once complete=true,
    FinishUpload may be called.
    """
    def __init__(
        self,
        *,
        limit_offset: builtins.int = ...,
        complete: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["complete", b"complete", "limit_offset", b"limit_offset"]) -> None: ...

global___UploadDataReply = UploadDataReply

class FinishUploadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPLOAD_ID_FIELD_NUMBER: builtins.int
    upload_id: builtins.str
    """Upload to finish.  All file data must be
    successfully uploaded before an upload may be finished.
    """
    def __init__(
        self,
        *,
        upload_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["upload_id", b"upload_id"]) -> None: ...

global___FinishUploadRequest = FinishUploadRequest

class FinishUploadReply(google.protobuf.message.Message):
    """The resource which is the result of the completed upload.
    Will change this message definition, using existing definition meanwhile.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    CONVERSION_FIELD_NUMBER: builtins.int
    MESH_ID_FIELD_NUMBER: builtins.int
    url: builtins.str
    """The absolute path of the file on the server."""
    conversion: global___MeshConversionStatus.ValueType
    """Mesh conversion status. If conversion is NOT_REQUIRED,
    then the upload is complete. If the conversion is IN_PROGRESS,
    then the client has to invoke MeshConversionStatus to get the status
    of the conversion.
    """
    mesh_id: builtins.str
    """If conversion is not NOT_REQUIRED, then the mesh_id of the uploaded mesh
    will be returned.
    """
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        conversion: global___MeshConversionStatus.ValueType = ...,
        mesh_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["conversion", b"conversion", "mesh_id", b"mesh_id", "url", b"url"]) -> None: ...

global___FinishUploadReply = FinishUploadReply

class WebGeometryUploadMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PART_IDS_FIELD_NUMBER: builtins.int
    PART_NAMES_FIELD_NUMBER: builtins.int
    @property
    def part_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def part_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        part_ids: collections.abc.Iterable[builtins.str] | None = ...,
        part_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["part_ids", b"part_ids", "part_names", b"part_names"]) -> None: ...

global___WebGeometryUploadMetadata = WebGeometryUploadMetadata

class UploadWebGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    url: builtins.str
    @property
    def metadata(self) -> global___WebGeometryUploadMetadata: ...
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        url: builtins.str = ...,
        metadata: global___WebGeometryUploadMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "project_id", b"project_id", "url", b"url"]) -> None: ...

global___UploadWebGeometryRequest = UploadWebGeometryRequest

class UploadWebGeometryReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WEB_GEOMETRY_ID_FIELD_NUMBER: builtins.int
    web_geometry_id: builtins.str
    def __init__(
        self,
        *,
        web_geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["web_geometry_id", b"web_geometry_id"]) -> None: ...

global___UploadWebGeometryReply = UploadWebGeometryReply

class GetWebGeometryBaseUrlRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    WEB_GEOMETRY_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    web_geometry_id: builtins.str
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        web_geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id", "web_geometry_id", b"web_geometry_id"]) -> None: ...

global___GetWebGeometryBaseUrlRequest = GetWebGeometryBaseUrlRequest

class GetWebGeometryBaseUrlReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASE_URL_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    base_url: builtins.str
    @property
    def metadata(self) -> global___WebGeometryUploadMetadata: ...
    def __init__(
        self,
        *,
        base_url: builtins.str = ...,
        metadata: global___WebGeometryUploadMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["base_url", b"base_url", "metadata", b"metadata"]) -> None: ...

global___GetWebGeometryBaseUrlReply = GetWebGeometryBaseUrlReply
