# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from enum import IntEnum as _IntEnum

from luminarycloud._proto.client import simulation_pb2 as _clientpb


class HeatFluxConvention(_IntEnum):
    """
    Convention for the direction of positive heat flux.

    Attributes
    ----------
    CONVENTION_HEAT_FLUX_OUT
        Heat leaving the domain is positive.
    CONVENTION_HEAT_FLUX_IN
        Heat entering the domain is positive


    Examples
    --------
    >>> from luminarycloud.params.enum import HeatFluxConvention
    >>> HeatFluxConvention.CONVENTION_HEAT_FLUX_OUT
    >>> HeatFluxConvention.CONVENTION_HEAT_FLUX_IN
    """

    INVALID = _clientpb.INVALID_HEAT_FLUX_CONVENTION
    CONVENTION_HEAT_FLUX_OUT = _clientpb.CONVENTION_HEAT_FLUX_OUT
    CONVENTION_HEAT_FLUX_IN = _clientpb.CONVENTION_HEAT_FLUX_IN


class UnitSystem(_IntEnum):
    """
    Collection of units used for all quantities.

    Attributes
    ----------
    UNIT_SYSTEM_CUSTOM
        Customize the units used for the main types of quantities.
    UNIT_SYSTEM_SI
        International System of Units (SI).
    UNIT_SYSTEM_US
        US Customary Units.


    Examples
    --------
    >>> from luminarycloud.params.enum import UnitSystem
    >>> UnitSystem.UNIT_SYSTEM_CUSTOM
    >>> UnitSystem.UNIT_SYSTEM_SI
    >>> UnitSystem.UNIT_SYSTEM_US
    """

    INVALID = _clientpb.INVALID_UNIT_SYSTEM
    UNIT_SYSTEM_CUSTOM = _clientpb.UNIT_SYSTEM_CUSTOM
    UNIT_SYSTEM_SI = _clientpb.UNIT_SYSTEM_SI
    UNIT_SYSTEM_US = _clientpb.UNIT_SYSTEM_US


class TemperatureUnit(_IntEnum):
    """
    Unit used for temperature.

    Attributes
    ----------
    UNIT_KELVIN
        Kelvin scale.
    UNIT_CELSIUS
        Degree Celsius.
    UNIT_RANKINE
        Degree Rankine.
    UNIT_FAHRENHEIT
        Degree Fahrenheit.


    Examples
    --------
    >>> from luminarycloud.params.enum import TemperatureUnit
    >>> TemperatureUnit.UNIT_KELVIN
    >>> TemperatureUnit.UNIT_CELSIUS
    >>> TemperatureUnit.UNIT_RANKINE
    >>> TemperatureUnit.UNIT_FAHRENHEIT
    """

    INVALID = _clientpb.INVALID_TEMPERATURE_UNIT
    UNIT_KELVIN = _clientpb.UNIT_KELVIN
    UNIT_CELSIUS = _clientpb.UNIT_CELSIUS
    UNIT_RANKINE = _clientpb.UNIT_RANKINE
    UNIT_FAHRENHEIT = _clientpb.UNIT_FAHRENHEIT


class MassUnit(_IntEnum):
    """
    Unit used for mass.

    Attributes
    ----------
    UNIT_KILOGRAM
        Kilogram.
    UNIT_GRAM
        Gram.
    UNIT_POUND
        Pound.


    Examples
    --------
    >>> from luminarycloud.params.enum import MassUnit
    >>> MassUnit.UNIT_KILOGRAM
    >>> MassUnit.UNIT_GRAM
    >>> MassUnit.UNIT_POUND
    """

    INVALID = _clientpb.INVALID_MASS_UNIT
    UNIT_KILOGRAM = _clientpb.UNIT_KILOGRAM
    UNIT_GRAM = _clientpb.UNIT_GRAM
    UNIT_POUND = _clientpb.UNIT_POUND


class LengthUnit(_IntEnum):
    """
    Unit used for length.

    Attributes
    ----------
    UNIT_METER
        Meter.
    UNIT_MILLIMETER
        Millimeter.
    UNIT_FOOT
        Foot.
    UNIT_INCH
        Inch.


    Examples
    --------
    >>> from luminarycloud.params.enum import LengthUnit
    >>> LengthUnit.UNIT_METER
    >>> LengthUnit.UNIT_MILLIMETER
    >>> LengthUnit.UNIT_FOOT
    >>> LengthUnit.UNIT_INCH
    """

    INVALID = _clientpb.INVALID_LENGTH_UNIT
    UNIT_METER = _clientpb.UNIT_METER
    UNIT_MILLIMETER = _clientpb.UNIT_MILLIMETER
    UNIT_FOOT = _clientpb.UNIT_FOOT
    UNIT_INCH = _clientpb.UNIT_INCH


class AngleUnit(_IntEnum):
    """
    Unit used for angles.

    Attributes
    ----------
    UNIT_DEGREE
        Degree.
    UNIT_RADIAN
        Radian.


    Examples
    --------
    >>> from luminarycloud.params.enum import AngleUnit
    >>> AngleUnit.UNIT_DEGREE
    >>> AngleUnit.UNIT_RADIAN
    """

    INVALID = _clientpb.INVALID_ANGLE_UNIT
    UNIT_DEGREE = _clientpb.UNIT_DEGREE
    UNIT_RADIAN = _clientpb.UNIT_RADIAN


class TimeUnit(_IntEnum):
    """
    Unit used for time.

    Attributes
    ----------
    UNIT_SECOND
        Second.


    Examples
    --------
    >>> from luminarycloud.params.enum import TimeUnit
    >>> TimeUnit.UNIT_SECOND
    """

    INVALID = _clientpb.INVALID_TIME_UNIT
    UNIT_SECOND = _clientpb.UNIT_SECOND


class VelocityUnit(_IntEnum):
    """
    Unit used for velocity.

    Attributes
    ----------
    UNIT_METER_PER_SECOND
        Meters per second.
    UNIT_KM_PER_HOUR
        Kilometers per hour.
    UNIT_FEET_PER_SECOND
        Feet per second.
    UNIT_MILES_PER_HOUR
        Miles per hour.


    Examples
    --------
    >>> from luminarycloud.params.enum import VelocityUnit
    >>> VelocityUnit.UNIT_METER_PER_SECOND
    >>> VelocityUnit.UNIT_KM_PER_HOUR
    >>> VelocityUnit.UNIT_FEET_PER_SECOND
    >>> VelocityUnit.UNIT_MILES_PER_HOUR
    """

    INVALID = _clientpb.INVALID_VELOCITY_UNIT
    UNIT_METER_PER_SECOND = _clientpb.UNIT_METER_PER_SECOND
    UNIT_KM_PER_HOUR = _clientpb.UNIT_KM_PER_HOUR
    UNIT_FEET_PER_SECOND = _clientpb.UNIT_FEET_PER_SECOND
    UNIT_MILES_PER_HOUR = _clientpb.UNIT_MILES_PER_HOUR


class AngularVelocityUnit(_IntEnum):
    """
    Unit used for angular velocity.

    Attributes
    ----------
    UNIT_RADIAN_PER_SECOND
        Radian per second.
    UNIT_RPM
        Revolutions per minute.


    Examples
    --------
    >>> from luminarycloud.params.enum import AngularVelocityUnit
    >>> AngularVelocityUnit.UNIT_RADIAN_PER_SECOND
    >>> AngularVelocityUnit.UNIT_RPM
    """

    INVALID = _clientpb.INVALID_ANGULAR_VELOCITY_UNIT
    UNIT_RADIAN_PER_SECOND = _clientpb.UNIT_RADIAN_PER_SECOND
    UNIT_RPM = _clientpb.UNIT_RPM


class ForceUnit(_IntEnum):
    """
    Unit used for force.

    Attributes
    ----------
    UNIT_NEWTON
        Newton.
    UNIT_POUND_FORCE
        Pound-force.


    Examples
    --------
    >>> from luminarycloud.params.enum import ForceUnit
    >>> ForceUnit.UNIT_NEWTON
    >>> ForceUnit.UNIT_POUND_FORCE
    """

    INVALID = _clientpb.INVALID_FORCE_UNIT
    UNIT_NEWTON = _clientpb.UNIT_NEWTON
    UNIT_POUND_FORCE = _clientpb.UNIT_POUND_FORCE


class MomentUnit(_IntEnum):
    """
    Unit used for moment.

    Attributes
    ----------
    UNIT_NEWTON_METER
        Newton-meter.
    UNIT_POUND_FOOT
        Pound-foot.


    Examples
    --------
    >>> from luminarycloud.params.enum import MomentUnit
    >>> MomentUnit.UNIT_NEWTON_METER
    >>> MomentUnit.UNIT_POUND_FOOT
    """

    INVALID = _clientpb.INVALID_MOMENT_UNIT
    UNIT_NEWTON_METER = _clientpb.UNIT_NEWTON_METER
    UNIT_POUND_FOOT = _clientpb.UNIT_POUND_FOOT


class PressureUnit(_IntEnum):
    """
    Unit used for pressure.

    Attributes
    ----------
    UNIT_PASCAL
        Pascal.
    UNIT_BAR
        Bar.
    UNIT_PSI
        Pound per square inch.


    Examples
    --------
    >>> from luminarycloud.params.enum import PressureUnit
    >>> PressureUnit.UNIT_PASCAL
    >>> PressureUnit.UNIT_BAR
    >>> PressureUnit.UNIT_PSI
    """

    INVALID = _clientpb.INVALID_PRESSURE_UNIT
    UNIT_PASCAL = _clientpb.UNIT_PASCAL
    UNIT_BAR = _clientpb.UNIT_BAR
    UNIT_PSI = _clientpb.UNIT_PSI


class EnergyUnit(_IntEnum):
    """
    Unit used for energy.

    Attributes
    ----------
    UNIT_JOULE
        Joule.
    UNIT_BTU
        British thermal unit.


    Examples
    --------
    >>> from luminarycloud.params.enum import EnergyUnit
    >>> EnergyUnit.UNIT_JOULE
    >>> EnergyUnit.UNIT_BTU
    """

    INVALID = _clientpb.INVALID_ENERGY_UNIT
    UNIT_JOULE = _clientpb.UNIT_JOULE
    UNIT_BTU = _clientpb.UNIT_BTU


class PowerUnit(_IntEnum):
    """
    Unit used for power.

    Attributes
    ----------
    UNIT_WATT
        Watt.
    UNIT_HORSEPOWER
        Horsepower.


    Examples
    --------
    >>> from luminarycloud.params.enum import PowerUnit
    >>> PowerUnit.UNIT_WATT
    >>> PowerUnit.UNIT_HORSEPOWER
    """

    INVALID = _clientpb.INVALID_POWER_UNIT
    UNIT_WATT = _clientpb.UNIT_WATT
    UNIT_HORSEPOWER = _clientpb.UNIT_HORSEPOWER


class VolumeUnit(_IntEnum):
    """
    Unit used for volume.

    Attributes
    ----------
    UNIT_CUBIC_METER
        Cubic meter.
    UNIT_LITER
        Liter.
    UNIT_GALLON
        US gallon.
    UNIT_CUBIC_INCH
        Cubic inch.
    UNIT_CUBIC_FOOT
        Cubic foot.


    Examples
    --------
    >>> from luminarycloud.params.enum import VolumeUnit
    >>> VolumeUnit.UNIT_CUBIC_METER
    >>> VolumeUnit.UNIT_LITER
    >>> VolumeUnit.UNIT_GALLON
    >>> VolumeUnit.UNIT_CUBIC_INCH
    >>> VolumeUnit.UNIT_CUBIC_FOOT
    """

    INVALID = _clientpb.INVALID_VOLUME_UNIT
    UNIT_CUBIC_METER = _clientpb.UNIT_CUBIC_METER
    UNIT_LITER = _clientpb.UNIT_LITER
    UNIT_GALLON = _clientpb.UNIT_GALLON
    UNIT_CUBIC_INCH = _clientpb.UNIT_CUBIC_INCH
    UNIT_CUBIC_FOOT = _clientpb.UNIT_CUBIC_FOOT


class VolumetricFlowUnit(_IntEnum):
    """
    Unit used for volumetric flow.

    Attributes
    ----------
    UNIT_CUBIC_METER_PER_SECOND
        Cubic meter per second.
    UNIT_CFM
        Cubic feet per minute.


    Examples
    --------
    >>> from luminarycloud.params.enum import VolumetricFlowUnit
    >>> VolumetricFlowUnit.UNIT_CUBIC_METER_PER_SECOND
    >>> VolumetricFlowUnit.UNIT_CFM
    """

    INVALID = _clientpb.INVALID_VOLUMETRIC_FLOW_UNIT
    UNIT_CUBIC_METER_PER_SECOND = _clientpb.UNIT_CUBIC_METER_PER_SECOND
    UNIT_CFM = _clientpb.UNIT_CFM


class ViscosityUnit(_IntEnum):
    """
    Unit used for dynamic viscosity.

    Attributes
    ----------
    UNIT_PASCAL_SECOND
        Pascal-second.
    UNIT_CENTIPOISE
        Centipoise.
    UNIT_POUND_SECOND_PER_SQUARE_FOOT
        Pound-seconds per square foot.


    Examples
    --------
    >>> from luminarycloud.params.enum import ViscosityUnit
    >>> ViscosityUnit.UNIT_PASCAL_SECOND
    >>> ViscosityUnit.UNIT_CENTIPOISE
    >>> ViscosityUnit.UNIT_POUND_SECOND_PER_SQUARE_FOOT
    """

    INVALID = _clientpb.INVALID_VISCOSITY_UNIT
    UNIT_PASCAL_SECOND = _clientpb.UNIT_PASCAL_SECOND
    UNIT_CENTIPOISE = _clientpb.UNIT_CENTIPOISE
    UNIT_POUND_SECOND_PER_SQUARE_FOOT = _clientpb.UNIT_POUND_SECOND_PER_SQUARE_FOOT


class ConductivityUnit(_IntEnum):
    """
    Unit used for thermal conductivity.

    Attributes
    ----------
    UNIT_WATT_PER_METER_KELVIN
        Watt per meter-Kelvin.
    UNIT_BTU_PER_HOUR_FOOT_FAHRENHEIT
        BTU per hour-foot-Fahrenheit.


    Examples
    --------
    >>> from luminarycloud.params.enum import ConductivityUnit
    >>> ConductivityUnit.UNIT_WATT_PER_METER_KELVIN
    >>> ConductivityUnit.UNIT_BTU_PER_HOUR_FOOT_FAHRENHEIT
    """

    INVALID = _clientpb.INVALID_CONDUCTIVITY_UNIT
    UNIT_WATT_PER_METER_KELVIN = _clientpb.UNIT_WATT_PER_METER_KELVIN
    UNIT_BTU_PER_HOUR_FOOT_FAHRENHEIT = _clientpb.UNIT_BTU_PER_HOUR_FOOT_FAHRENHEIT


class MolecularWeightUnit(_IntEnum):
    """
    Unit used for molecular weight.

    Attributes
    ----------
    UNIT_GRAM_PER_MOLE
        Grams per mole.
    UNIT_POUND_PER_POUND_MOLE
        Pounds per pound-mole.


    Examples
    --------
    >>> from luminarycloud.params.enum import MolecularWeightUnit
    >>> MolecularWeightUnit.UNIT_GRAM_PER_MOLE
    >>> MolecularWeightUnit.UNIT_POUND_PER_POUND_MOLE
    """

    INVALID = _clientpb.INVALID_MOLECULAR_WEIGHT_UNIT
    UNIT_GRAM_PER_MOLE = _clientpb.UNIT_GRAM_PER_MOLE
    UNIT_POUND_PER_POUND_MOLE = _clientpb.UNIT_POUND_PER_POUND_MOLE


class PtTableFluid(_IntEnum):
    """
    Fluid for which the real gas tables are created. The liquid phase is not
                included, properties in the saturation region are extrapolated to ensure numerical
                stability.

    Attributes
    ----------
    REAL_GAS_1_BUTENE
        1-Butene.
    REAL_GAS_ACETONE
        Acetone.
    REAL_GAS_AIR
        Air.
    REAL_GAS_AMMONIA
        Ammonia.
    REAL_GAS_ARGON
        Argon.
    REAL_GAS_BENZENE
        Benzene.
    REAL_GAS_CARBON_DIOXIDE
        Carbon Dioxide.
    REAL_GAS_CARBON_MONOXIDE
        Carbon Monoxide.
    REAL_GAS_CARBONYL_SULFIDE
        Carbonyl Sulfide.
    REAL_GAS_CIS_2_BUTENE
        cis-2-Butene.
    REAL_GAS_CYCLOHEXANE
        Cyclohexane.
    REAL_GAS_CYCLOPENTANE
        Cyclopentane.
    REAL_GAS_CYCLOPROPANE
        Cyclopropane.
    REAL_GAS_D4
        D4.
    REAL_GAS_D5
        D5.
    REAL_GAS_D6
        D6.
    REAL_GAS_DEUTERIUM
        Deuterium.
    REAL_GAS_DICHLOROETHANE
        Dichloroethane.
    REAL_GAS_DIETHYL_ETHER
        Diethyl Ether.
    REAL_GAS_DIMETHYL_CARBONATE
        Dimethyl Carbonate.
    REAL_GAS_DIMETHYL_ETHER
        Dimethyl Ether.
    REAL_GAS_ETHANE
        Ethane.
    REAL_GAS_ETHANOL
        Ethanol.
    REAL_GAS_ETHYL_BENZENE
        Ethyl Benzene.
    REAL_GAS_ETHYLENE
        Ethylene.
    REAL_GAS_ETHYLENE_OXIDE
        Ethylene Oxide.
    REAL_GAS_FLUORINE
        Fluorine.
    REAL_GAS_HEAVY_WATER
        Heavy Water.
    REAL_GAS_HELIUM
        Helium.
    REAL_GAS_HFE143M
        HFE143m.
    REAL_GAS_HYDROGEN
        Hydrogen.
    REAL_GAS_HYDROGEN_CHLORIDE
        Hydrogen Chloride.
    REAL_GAS_HYDROGEN_SULFIDE
        Hydrogen Sulfide.
    REAL_GAS_ISOBUTANE
        Isobutane.
    REAL_GAS_ISOBUTENE
        Isobutene.
    REAL_GAS_ISOHEXANE
        Isohexane.
    REAL_GAS_ISOPENTANE
        Isopentane.
    REAL_GAS_KRYPTON
        Krypton.
    REAL_GAS_M_XYLENE
        m-Xylene.
    REAL_GAS_MD2M
        MD2M.
    REAL_GAS_MD3M
        MD3M.
    REAL_GAS_MD4M
        MD4M.
    REAL_GAS_MDM
        MDM.
    REAL_GAS_METHANE
        Methane.
    REAL_GAS_METHANOL
        Methanol.
    REAL_GAS_METHYL_LINOLEATE
        Methyl Linoleate.
    REAL_GAS_METHYL_LINOLENATE
        Methyl Linolenate.
    REAL_GAS_METHYL_OLEATE
        Methyl Oleate.
    REAL_GAS_METHYL_PALMITATE
        Methyl Palmitate.
    REAL_GAS_METHYL_STEARATE
        Methyl Stearate.
    REAL_GAS_MM
        MM.
    REAL_GAS_N_BUTANE
        n-Butane.
    REAL_GAS_N_DECANE
        n-Decane.
    REAL_GAS_N_DODECANE
        n-Dodecane.
    REAL_GAS_N_HEPTANE
        n-Heptane.
    REAL_GAS_N_HEXANE
        n-Hexane.
    REAL_GAS_N_NONANE
        n-Nonane.
    REAL_GAS_N_OCTANE
        n-Octane.
    REAL_GAS_N_PENTANE
        n-Pentane.
    REAL_GAS_N_PROPANE
        n-Propane.
    REAL_GAS_N_UNDECANE
        n-Undecane.
    REAL_GAS_NEON
        Neon.
    REAL_GAS_NEOPENTANE
        Neopentane.
    REAL_GAS_NITROGEN
        Nitrogen.
    REAL_GAS_NITROUS_OXIDE
        Nitrous Oxide.
    REAL_GAS_NOVEC649
        Novec649.
    REAL_GAS_O_XYLENE
        o-Xylene.
    REAL_GAS_ORTHO_DEUTERIUM
        Ortho Deuterium.
    REAL_GAS_ORTHO_HYDROGEN
        Ortho Hydrogen.
    REAL_GAS_OXYGEN
        Oxygen.
    REAL_GAS_P_XYLENE
        p-Xylene.
    REAL_GAS_PARA_DEUTERIUM
        Para Deuterium.
    REAL_GAS_PARA_HYDROGEN
        Para Hydrogen.
    REAL_GAS_PROPYLENE
        Propylene.
    REAL_GAS_PROPYNE
        Propyne.
    REAL_GAS_R11
        R11.
    REAL_GAS_R113
        R113.
    REAL_GAS_R114
        R114.
    REAL_GAS_R115
        R115.
    REAL_GAS_R116
        R116.
    REAL_GAS_R12
        R12.
    REAL_GAS_R123
        R123.
    REAL_GAS_R1233ZDE
        R1233zd(E).
    REAL_GAS_R1234YF
        R1234yf.
    REAL_GAS_R1234ZEE
        R1234ze(E).
    REAL_GAS_R1234ZEZ
        R1234ze(Z).
    REAL_GAS_R124
        R124.
    REAL_GAS_R1243ZF
        R1243zf.
    REAL_GAS_R125
        R125.
    REAL_GAS_R13
        R13.
    REAL_GAS_R134A
        R134a.
    REAL_GAS_R13I1
        R13I1.
    REAL_GAS_R14
        R14.
    REAL_GAS_R141B
        R141b.
    REAL_GAS_R142B
        R142b.
    REAL_GAS_R143A
        R143a.
    REAL_GAS_R152A
        R152A.
    REAL_GAS_R161
        R161.
    REAL_GAS_R21
        R21.
    REAL_GAS_R218
        R218.
    REAL_GAS_R22
        R22.
    REAL_GAS_R227EA
        R227EA.
    REAL_GAS_R23
        R23.
    REAL_GAS_R236EA
        R236EA.
    REAL_GAS_R236FA
        R236FA.
    REAL_GAS_R245CA
        R245ca.
    REAL_GAS_R245FA
        R245fa.
    REAL_GAS_R32
        R32.
    REAL_GAS_R365MFC
        R365MFC.
    REAL_GAS_R40
        R40.
    REAL_GAS_R404A
        R404A.
    REAL_GAS_R407C
        R407C.
    REAL_GAS_R41
        R41.
    REAL_GAS_R410A
        R410A.
    REAL_GAS_R507A
        R507A.
    REAL_GAS_RC318
        RC318.
    REAL_GAS_SES36
        SES36.
    REAL_GAS_SULFUR_DIOXIDE
        Sulfur Dioxide.
    REAL_GAS_SULFUR_HEXAFLUORIDE
        Sulfur Hexafluoride.
    REAL_GAS_TOLUENE
        Toluene.
    REAL_GAS_TRANS_2_BUTENE
        trans-2-Butene.
    REAL_GAS_WATER
        Water.
    REAL_GAS_XENON
        Xenon.


    Examples
    --------
    >>> from luminarycloud.params.enum import PtTableFluid
    >>> PtTableFluid.REAL_GAS_1_BUTENE
    >>> PtTableFluid.REAL_GAS_ACETONE
    >>> PtTableFluid.REAL_GAS_AIR
    >>> PtTableFluid.REAL_GAS_AMMONIA
    >>> PtTableFluid.REAL_GAS_ARGON
    >>> PtTableFluid.REAL_GAS_BENZENE
    >>> PtTableFluid.REAL_GAS_CARBON_DIOXIDE
    >>> PtTableFluid.REAL_GAS_CARBON_MONOXIDE
    >>> PtTableFluid.REAL_GAS_CARBONYL_SULFIDE
    >>> PtTableFluid.REAL_GAS_CIS_2_BUTENE
    >>> PtTableFluid.REAL_GAS_CYCLOHEXANE
    >>> PtTableFluid.REAL_GAS_CYCLOPENTANE
    >>> PtTableFluid.REAL_GAS_CYCLOPROPANE
    >>> PtTableFluid.REAL_GAS_D4
    >>> PtTableFluid.REAL_GAS_D5
    >>> PtTableFluid.REAL_GAS_D6
    >>> PtTableFluid.REAL_GAS_DEUTERIUM
    >>> PtTableFluid.REAL_GAS_DICHLOROETHANE
    >>> PtTableFluid.REAL_GAS_DIETHYL_ETHER
    >>> PtTableFluid.REAL_GAS_DIMETHYL_CARBONATE
    >>> PtTableFluid.REAL_GAS_DIMETHYL_ETHER
    >>> PtTableFluid.REAL_GAS_ETHANE
    >>> PtTableFluid.REAL_GAS_ETHANOL
    >>> PtTableFluid.REAL_GAS_ETHYL_BENZENE
    >>> PtTableFluid.REAL_GAS_ETHYLENE
    >>> PtTableFluid.REAL_GAS_ETHYLENE_OXIDE
    >>> PtTableFluid.REAL_GAS_FLUORINE
    >>> PtTableFluid.REAL_GAS_HEAVY_WATER
    >>> PtTableFluid.REAL_GAS_HELIUM
    >>> PtTableFluid.REAL_GAS_HFE143M
    >>> PtTableFluid.REAL_GAS_HYDROGEN
    >>> PtTableFluid.REAL_GAS_HYDROGEN_CHLORIDE
    >>> PtTableFluid.REAL_GAS_HYDROGEN_SULFIDE
    >>> PtTableFluid.REAL_GAS_ISOBUTANE
    >>> PtTableFluid.REAL_GAS_ISOBUTENE
    >>> PtTableFluid.REAL_GAS_ISOHEXANE
    >>> PtTableFluid.REAL_GAS_ISOPENTANE
    >>> PtTableFluid.REAL_GAS_KRYPTON
    >>> PtTableFluid.REAL_GAS_M_XYLENE
    >>> PtTableFluid.REAL_GAS_MD2M
    >>> PtTableFluid.REAL_GAS_MD3M
    >>> PtTableFluid.REAL_GAS_MD4M
    >>> PtTableFluid.REAL_GAS_MDM
    >>> PtTableFluid.REAL_GAS_METHANE
    >>> PtTableFluid.REAL_GAS_METHANOL
    >>> PtTableFluid.REAL_GAS_METHYL_LINOLEATE
    >>> PtTableFluid.REAL_GAS_METHYL_LINOLENATE
    >>> PtTableFluid.REAL_GAS_METHYL_OLEATE
    >>> PtTableFluid.REAL_GAS_METHYL_PALMITATE
    >>> PtTableFluid.REAL_GAS_METHYL_STEARATE
    >>> PtTableFluid.REAL_GAS_MM
    >>> PtTableFluid.REAL_GAS_N_BUTANE
    >>> PtTableFluid.REAL_GAS_N_DECANE
    >>> PtTableFluid.REAL_GAS_N_DODECANE
    >>> PtTableFluid.REAL_GAS_N_HEPTANE
    >>> PtTableFluid.REAL_GAS_N_HEXANE
    >>> PtTableFluid.REAL_GAS_N_NONANE
    >>> PtTableFluid.REAL_GAS_N_OCTANE
    >>> PtTableFluid.REAL_GAS_N_PENTANE
    >>> PtTableFluid.REAL_GAS_N_PROPANE
    >>> PtTableFluid.REAL_GAS_N_UNDECANE
    >>> PtTableFluid.REAL_GAS_NEON
    >>> PtTableFluid.REAL_GAS_NEOPENTANE
    >>> PtTableFluid.REAL_GAS_NITROGEN
    >>> PtTableFluid.REAL_GAS_NITROUS_OXIDE
    >>> PtTableFluid.REAL_GAS_NOVEC649
    >>> PtTableFluid.REAL_GAS_O_XYLENE
    >>> PtTableFluid.REAL_GAS_ORTHO_DEUTERIUM
    >>> PtTableFluid.REAL_GAS_ORTHO_HYDROGEN
    >>> PtTableFluid.REAL_GAS_OXYGEN
    >>> PtTableFluid.REAL_GAS_P_XYLENE
    >>> PtTableFluid.REAL_GAS_PARA_DEUTERIUM
    >>> PtTableFluid.REAL_GAS_PARA_HYDROGEN
    >>> PtTableFluid.REAL_GAS_PROPYLENE
    >>> PtTableFluid.REAL_GAS_PROPYNE
    >>> PtTableFluid.REAL_GAS_R11
    >>> PtTableFluid.REAL_GAS_R113
    >>> PtTableFluid.REAL_GAS_R114
    >>> PtTableFluid.REAL_GAS_R115
    >>> PtTableFluid.REAL_GAS_R116
    >>> PtTableFluid.REAL_GAS_R12
    >>> PtTableFluid.REAL_GAS_R123
    >>> PtTableFluid.REAL_GAS_R1233ZDE
    >>> PtTableFluid.REAL_GAS_R1234YF
    >>> PtTableFluid.REAL_GAS_R1234ZEE
    >>> PtTableFluid.REAL_GAS_R1234ZEZ
    >>> PtTableFluid.REAL_GAS_R124
    >>> PtTableFluid.REAL_GAS_R1243ZF
    >>> PtTableFluid.REAL_GAS_R125
    >>> PtTableFluid.REAL_GAS_R13
    >>> PtTableFluid.REAL_GAS_R134A
    >>> PtTableFluid.REAL_GAS_R13I1
    >>> PtTableFluid.REAL_GAS_R14
    >>> PtTableFluid.REAL_GAS_R141B
    >>> PtTableFluid.REAL_GAS_R142B
    >>> PtTableFluid.REAL_GAS_R143A
    >>> PtTableFluid.REAL_GAS_R152A
    >>> PtTableFluid.REAL_GAS_R161
    >>> PtTableFluid.REAL_GAS_R21
    >>> PtTableFluid.REAL_GAS_R218
    >>> PtTableFluid.REAL_GAS_R22
    >>> PtTableFluid.REAL_GAS_R227EA
    >>> PtTableFluid.REAL_GAS_R23
    >>> PtTableFluid.REAL_GAS_R236EA
    >>> PtTableFluid.REAL_GAS_R236FA
    >>> PtTableFluid.REAL_GAS_R245CA
    >>> PtTableFluid.REAL_GAS_R245FA
    >>> PtTableFluid.REAL_GAS_R32
    >>> PtTableFluid.REAL_GAS_R365MFC
    >>> PtTableFluid.REAL_GAS_R40
    >>> PtTableFluid.REAL_GAS_R404A
    >>> PtTableFluid.REAL_GAS_R407C
    >>> PtTableFluid.REAL_GAS_R41
    >>> PtTableFluid.REAL_GAS_R410A
    >>> PtTableFluid.REAL_GAS_R507A
    >>> PtTableFluid.REAL_GAS_RC318
    >>> PtTableFluid.REAL_GAS_SES36
    >>> PtTableFluid.REAL_GAS_SULFUR_DIOXIDE
    >>> PtTableFluid.REAL_GAS_SULFUR_HEXAFLUORIDE
    >>> PtTableFluid.REAL_GAS_TOLUENE
    >>> PtTableFluid.REAL_GAS_TRANS_2_BUTENE
    >>> PtTableFluid.REAL_GAS_WATER
    >>> PtTableFluid.REAL_GAS_XENON
    """

    INVALID = _clientpb.INVALID_PT_TABLE_FLUID
    REAL_GAS_1_BUTENE = _clientpb.REAL_GAS_1_BUTENE
    REAL_GAS_ACETONE = _clientpb.REAL_GAS_ACETONE
    REAL_GAS_AIR = _clientpb.REAL_GAS_AIR
    REAL_GAS_AMMONIA = _clientpb.REAL_GAS_AMMONIA
    REAL_GAS_ARGON = _clientpb.REAL_GAS_ARGON
    REAL_GAS_BENZENE = _clientpb.REAL_GAS_BENZENE
    REAL_GAS_CARBON_DIOXIDE = _clientpb.REAL_GAS_CARBON_DIOXIDE
    REAL_GAS_CARBON_MONOXIDE = _clientpb.REAL_GAS_CARBON_MONOXIDE
    REAL_GAS_CARBONYL_SULFIDE = _clientpb.REAL_GAS_CARBONYL_SULFIDE
    REAL_GAS_CIS_2_BUTENE = _clientpb.REAL_GAS_CIS_2_BUTENE
    REAL_GAS_CYCLOHEXANE = _clientpb.REAL_GAS_CYCLOHEXANE
    REAL_GAS_CYCLOPENTANE = _clientpb.REAL_GAS_CYCLOPENTANE
    REAL_GAS_CYCLOPROPANE = _clientpb.REAL_GAS_CYCLOPROPANE
    REAL_GAS_D4 = _clientpb.REAL_GAS_D4
    REAL_GAS_D5 = _clientpb.REAL_GAS_D5
    REAL_GAS_D6 = _clientpb.REAL_GAS_D6
    REAL_GAS_DEUTERIUM = _clientpb.REAL_GAS_DEUTERIUM
    REAL_GAS_DICHLOROETHANE = _clientpb.REAL_GAS_DICHLOROETHANE
    REAL_GAS_DIETHYL_ETHER = _clientpb.REAL_GAS_DIETHYL_ETHER
    REAL_GAS_DIMETHYL_CARBONATE = _clientpb.REAL_GAS_DIMETHYL_CARBONATE
    REAL_GAS_DIMETHYL_ETHER = _clientpb.REAL_GAS_DIMETHYL_ETHER
    REAL_GAS_ETHANE = _clientpb.REAL_GAS_ETHANE
    REAL_GAS_ETHANOL = _clientpb.REAL_GAS_ETHANOL
    REAL_GAS_ETHYL_BENZENE = _clientpb.REAL_GAS_ETHYL_BENZENE
    REAL_GAS_ETHYLENE = _clientpb.REAL_GAS_ETHYLENE
    REAL_GAS_ETHYLENE_OXIDE = _clientpb.REAL_GAS_ETHYLENE_OXIDE
    REAL_GAS_FLUORINE = _clientpb.REAL_GAS_FLUORINE
    REAL_GAS_HEAVY_WATER = _clientpb.REAL_GAS_HEAVY_WATER
    REAL_GAS_HELIUM = _clientpb.REAL_GAS_HELIUM
    REAL_GAS_HFE143M = _clientpb.REAL_GAS_HFE143M
    REAL_GAS_HYDROGEN = _clientpb.REAL_GAS_HYDROGEN
    REAL_GAS_HYDROGEN_CHLORIDE = _clientpb.REAL_GAS_HYDROGEN_CHLORIDE
    REAL_GAS_HYDROGEN_SULFIDE = _clientpb.REAL_GAS_HYDROGEN_SULFIDE
    REAL_GAS_ISOBUTANE = _clientpb.REAL_GAS_ISOBUTANE
    REAL_GAS_ISOBUTENE = _clientpb.REAL_GAS_ISOBUTENE
    REAL_GAS_ISOHEXANE = _clientpb.REAL_GAS_ISOHEXANE
    REAL_GAS_ISOPENTANE = _clientpb.REAL_GAS_ISOPENTANE
    REAL_GAS_KRYPTON = _clientpb.REAL_GAS_KRYPTON
    REAL_GAS_M_XYLENE = _clientpb.REAL_GAS_M_XYLENE
    REAL_GAS_MD2M = _clientpb.REAL_GAS_MD2M
    REAL_GAS_MD3M = _clientpb.REAL_GAS_MD3M
    REAL_GAS_MD4M = _clientpb.REAL_GAS_MD4M
    REAL_GAS_MDM = _clientpb.REAL_GAS_MDM
    REAL_GAS_METHANE = _clientpb.REAL_GAS_METHANE
    REAL_GAS_METHANOL = _clientpb.REAL_GAS_METHANOL
    REAL_GAS_METHYL_LINOLEATE = _clientpb.REAL_GAS_METHYL_LINOLEATE
    REAL_GAS_METHYL_LINOLENATE = _clientpb.REAL_GAS_METHYL_LINOLENATE
    REAL_GAS_METHYL_OLEATE = _clientpb.REAL_GAS_METHYL_OLEATE
    REAL_GAS_METHYL_PALMITATE = _clientpb.REAL_GAS_METHYL_PALMITATE
    REAL_GAS_METHYL_STEARATE = _clientpb.REAL_GAS_METHYL_STEARATE
    REAL_GAS_MM = _clientpb.REAL_GAS_MM
    REAL_GAS_N_BUTANE = _clientpb.REAL_GAS_N_BUTANE
    REAL_GAS_N_DECANE = _clientpb.REAL_GAS_N_DECANE
    REAL_GAS_N_DODECANE = _clientpb.REAL_GAS_N_DODECANE
    REAL_GAS_N_HEPTANE = _clientpb.REAL_GAS_N_HEPTANE
    REAL_GAS_N_HEXANE = _clientpb.REAL_GAS_N_HEXANE
    REAL_GAS_N_NONANE = _clientpb.REAL_GAS_N_NONANE
    REAL_GAS_N_OCTANE = _clientpb.REAL_GAS_N_OCTANE
    REAL_GAS_N_PENTANE = _clientpb.REAL_GAS_N_PENTANE
    REAL_GAS_N_PROPANE = _clientpb.REAL_GAS_N_PROPANE
    REAL_GAS_N_UNDECANE = _clientpb.REAL_GAS_N_UNDECANE
    REAL_GAS_NEON = _clientpb.REAL_GAS_NEON
    REAL_GAS_NEOPENTANE = _clientpb.REAL_GAS_NEOPENTANE
    REAL_GAS_NITROGEN = _clientpb.REAL_GAS_NITROGEN
    REAL_GAS_NITROUS_OXIDE = _clientpb.REAL_GAS_NITROUS_OXIDE
    REAL_GAS_NOVEC649 = _clientpb.REAL_GAS_NOVEC649
    REAL_GAS_O_XYLENE = _clientpb.REAL_GAS_O_XYLENE
    REAL_GAS_ORTHO_DEUTERIUM = _clientpb.REAL_GAS_ORTHO_DEUTERIUM
    REAL_GAS_ORTHO_HYDROGEN = _clientpb.REAL_GAS_ORTHO_HYDROGEN
    REAL_GAS_OXYGEN = _clientpb.REAL_GAS_OXYGEN
    REAL_GAS_P_XYLENE = _clientpb.REAL_GAS_P_XYLENE
    REAL_GAS_PARA_DEUTERIUM = _clientpb.REAL_GAS_PARA_DEUTERIUM
    REAL_GAS_PARA_HYDROGEN = _clientpb.REAL_GAS_PARA_HYDROGEN
    REAL_GAS_PROPYLENE = _clientpb.REAL_GAS_PROPYLENE
    REAL_GAS_PROPYNE = _clientpb.REAL_GAS_PROPYNE
    REAL_GAS_R11 = _clientpb.REAL_GAS_R11
    REAL_GAS_R113 = _clientpb.REAL_GAS_R113
    REAL_GAS_R114 = _clientpb.REAL_GAS_R114
    REAL_GAS_R115 = _clientpb.REAL_GAS_R115
    REAL_GAS_R116 = _clientpb.REAL_GAS_R116
    REAL_GAS_R12 = _clientpb.REAL_GAS_R12
    REAL_GAS_R123 = _clientpb.REAL_GAS_R123
    REAL_GAS_R1233ZDE = _clientpb.REAL_GAS_R1233ZDE
    REAL_GAS_R1234YF = _clientpb.REAL_GAS_R1234YF
    REAL_GAS_R1234ZEE = _clientpb.REAL_GAS_R1234ZEE
    REAL_GAS_R1234ZEZ = _clientpb.REAL_GAS_R1234ZEZ
    REAL_GAS_R124 = _clientpb.REAL_GAS_R124
    REAL_GAS_R1243ZF = _clientpb.REAL_GAS_R1243ZF
    REAL_GAS_R125 = _clientpb.REAL_GAS_R125
    REAL_GAS_R13 = _clientpb.REAL_GAS_R13
    REAL_GAS_R134A = _clientpb.REAL_GAS_R134A
    REAL_GAS_R13I1 = _clientpb.REAL_GAS_R13I1
    REAL_GAS_R14 = _clientpb.REAL_GAS_R14
    REAL_GAS_R141B = _clientpb.REAL_GAS_R141B
    REAL_GAS_R142B = _clientpb.REAL_GAS_R142B
    REAL_GAS_R143A = _clientpb.REAL_GAS_R143A
    REAL_GAS_R152A = _clientpb.REAL_GAS_R152A
    REAL_GAS_R161 = _clientpb.REAL_GAS_R161
    REAL_GAS_R21 = _clientpb.REAL_GAS_R21
    REAL_GAS_R218 = _clientpb.REAL_GAS_R218
    REAL_GAS_R22 = _clientpb.REAL_GAS_R22
    REAL_GAS_R227EA = _clientpb.REAL_GAS_R227EA
    REAL_GAS_R23 = _clientpb.REAL_GAS_R23
    REAL_GAS_R236EA = _clientpb.REAL_GAS_R236EA
    REAL_GAS_R236FA = _clientpb.REAL_GAS_R236FA
    REAL_GAS_R245CA = _clientpb.REAL_GAS_R245CA
    REAL_GAS_R245FA = _clientpb.REAL_GAS_R245FA
    REAL_GAS_R32 = _clientpb.REAL_GAS_R32
    REAL_GAS_R365MFC = _clientpb.REAL_GAS_R365MFC
    REAL_GAS_R40 = _clientpb.REAL_GAS_R40
    REAL_GAS_R404A = _clientpb.REAL_GAS_R404A
    REAL_GAS_R407C = _clientpb.REAL_GAS_R407C
    REAL_GAS_R41 = _clientpb.REAL_GAS_R41
    REAL_GAS_R410A = _clientpb.REAL_GAS_R410A
    REAL_GAS_R507A = _clientpb.REAL_GAS_R507A
    REAL_GAS_RC318 = _clientpb.REAL_GAS_RC318
    REAL_GAS_SES36 = _clientpb.REAL_GAS_SES36
    REAL_GAS_SULFUR_DIOXIDE = _clientpb.REAL_GAS_SULFUR_DIOXIDE
    REAL_GAS_SULFUR_HEXAFLUORIDE = _clientpb.REAL_GAS_SULFUR_HEXAFLUORIDE
    REAL_GAS_TOLUENE = _clientpb.REAL_GAS_TOLUENE
    REAL_GAS_TRANS_2_BUTENE = _clientpb.REAL_GAS_TRANS_2_BUTENE
    REAL_GAS_WATER = _clientpb.REAL_GAS_WATER
    REAL_GAS_XENON = _clientpb.REAL_GAS_XENON


class MaterialFluidPreset(_IntEnum):
    """
    Select a predefined set of material properties or allow a custom set of properties.

    Attributes
    ----------
    UNSET_MATERIAL_FLUID_PRESET
        Fluid material preset is not set.
    STANDARD_AIR
        Standard air material properties
    WATER_NTP
        Properties of water at 1 atmosphere and 20° Celsius
    CUSTOM_MATERIAL_FLUID
        A custom set of material properties.


    Examples
    --------
    >>> from luminarycloud.params.enum import MaterialFluidPreset
    >>> MaterialFluidPreset.UNSET_MATERIAL_FLUID_PRESET
    >>> MaterialFluidPreset.STANDARD_AIR
    >>> MaterialFluidPreset.WATER_NTP
    >>> MaterialFluidPreset.CUSTOM_MATERIAL_FLUID
    """

    INVALID = _clientpb.INVALID_MATERIAL_FLUID_PRESET
    UNSET_MATERIAL_FLUID_PRESET = _clientpb.UNSET_MATERIAL_FLUID_PRESET
    STANDARD_AIR = _clientpb.STANDARD_AIR
    WATER_NTP = _clientpb.WATER_NTP
    CUSTOM_MATERIAL_FLUID = _clientpb.CUSTOM_MATERIAL_FLUID


class ThermalConductivityModelSolid(_IntEnum):
    """
    Uniform or direction-dependent conductivity models.

    Attributes
    ----------
    ISOTROPIC_CONDUCTIVITY
        Equal thermal conductivity in all directions.
    ORTHOTROPIC_CONDUCTIVITY
        Different thermal conductivity along each axis of the frames to which
                        the volumes of this material are assigned.


    Examples
    --------
    >>> from luminarycloud.params.enum import ThermalConductivityModelSolid
    >>> ThermalConductivityModelSolid.ISOTROPIC_CONDUCTIVITY
    >>> ThermalConductivityModelSolid.ORTHOTROPIC_CONDUCTIVITY
    """

    INVALID = _clientpb.INVALID_THERMAL_CONDUCTIVITY_MODEL_SOLID
    ISOTROPIC_CONDUCTIVITY = _clientpb.ISOTROPIC_CONDUCTIVITY
    ORTHOTROPIC_CONDUCTIVITY = _clientpb.ORTHOTROPIC_CONDUCTIVITY


class MaterialSolidPreset(_IntEnum):
    """
    Select a predefined set of material properties or allow a custom set of properties.

    Attributes
    ----------
    ALUMINUM
        Properties of pure aluminum.
    COPPER
        Properties of pure copper.
    IRON
        Properties of pure iron.
    NICKEL
        Properties of pure nickel.
    TITANIUM
        Properties of pure titanium.
    CUSTOM_MATERIAL_SOLID
        A custom set of material properties.


    Examples
    --------
    >>> from luminarycloud.params.enum import MaterialSolidPreset
    >>> MaterialSolidPreset.ALUMINUM
    >>> MaterialSolidPreset.COPPER
    >>> MaterialSolidPreset.IRON
    >>> MaterialSolidPreset.NICKEL
    >>> MaterialSolidPreset.TITANIUM
    >>> MaterialSolidPreset.CUSTOM_MATERIAL_SOLID
    """

    INVALID = _clientpb.INVALID_MATERIAL_SOLID_PRESET
    ALUMINUM = _clientpb.ALUMINUM
    COPPER = _clientpb.COPPER
    IRON = _clientpb.IRON
    NICKEL = _clientpb.NICKEL
    TITANIUM = _clientpb.TITANIUM
    CUSTOM_MATERIAL_SOLID = _clientpb.CUSTOM_MATERIAL_SOLID


class FloatType(_IntEnum):
    """
    Type of equations solved for the physics.

    Attributes
    ----------
    DOUBLE
        Solve the normal set of governing equations.
    ADA1D
        Solve the discrete adjoint equations to obtain geometric
                        sensitivities with respect to an output of interest.


    Examples
    --------
    >>> from luminarycloud.params.enum import FloatType
    >>> FloatType.DOUBLE
    >>> FloatType.ADA1D
    """

    INVALID = _clientpb.INVALID_FLOAT_TYPE
    DOUBLE = _clientpb.DOUBLE
    ADA1D = _clientpb.ADA1D


class FlowBehavior(_IntEnum):
    """
    Importance of physical time for the current simulation.

    Attributes
    ----------
    STEADY
        Solve for a steady-state solution of the governing equations.
    TRANSIENT
        Solve for a time-accurate solution of the governing equations.


    Examples
    --------
    >>> from luminarycloud.params.enum import FlowBehavior
    >>> FlowBehavior.STEADY
    >>> FlowBehavior.TRANSIENT
    """

    INVALID = _clientpb.INVALID_FLOW_BEHAVIOR
    STEADY = _clientpb.STEADY
    TRANSIENT = _clientpb.TRANSIENT


class NonlinearControlMethod(_IntEnum):
    """
    The method used to determine 'input' such that 'output'('input') = 'target'.

    Attributes
    ----------
    CONTROL_METHOD_SECANT
        Use the secant method to solve the equations.


    Examples
    --------
    >>> from luminarycloud.params.enum import NonlinearControlMethod
    >>> NonlinearControlMethod.CONTROL_METHOD_SECANT
    """

    INVALID = _clientpb.INVALID_NONLINEAR_CONTROL_METHOD
    CONTROL_METHOD_SECANT = _clientpb.CONTROL_METHOD_SECANT


class TimeImplicitOrder(_IntEnum):
    """
    Temporal order of accuracy of the dual time stepping scheme for time-accurate integration.

    Attributes
    ----------
    TIME_SECOND
        Second-order backward Euler integration.
    TIME_FIRST
        First-order backward Euler integration.


    Examples
    --------
    >>> from luminarycloud.params.enum import TimeImplicitOrder
    >>> TimeImplicitOrder.TIME_SECOND
    >>> TimeImplicitOrder.TIME_FIRST
    """

    INVALID = _clientpb.INVALID_TIME_IMPLICIT_ORDER
    TIME_SECOND = _clientpb.TIME_SECOND
    TIME_FIRST = _clientpb.TIME_FIRST


class PhysicalTimeStepMethod(_IntEnum):
    """
    Method for obtaining the physical time step in a time-accurate simulation.

    Attributes
    ----------
    FIXED_TIME_STEP
        Apply a fixed physical time step.


    Examples
    --------
    >>> from luminarycloud.params.enum import PhysicalTimeStepMethod
    >>> PhysicalTimeStepMethod.FIXED_TIME_STEP
    """

    INVALID = _clientpb.INVALID_PHYSICAL_TIME_STEP_METHOD
    FIXED_TIME_STEP = _clientpb.FIXED_TIME_STEP


class MotionFormulation(_IntEnum):
    """
    Formulation used to model motion of volumes in transient simulations.

    Attributes
    ----------
    AUTOMATIC_MOTION_FORMULATION
        The mesh position is updated each time step.
    MRF_MOTION_FORMULATION
        The equations are solved in a moving reference frame without
                        moving the mesh. This choice affects the child frames of this frame.


    Examples
    --------
    >>> from luminarycloud.params.enum import MotionFormulation
    >>> MotionFormulation.AUTOMATIC_MOTION_FORMULATION
    >>> MotionFormulation.MRF_MOTION_FORMULATION
    """

    INVALID = _clientpb.INVALID_MOTION_FORMULATION
    AUTOMATIC_MOTION_FORMULATION = _clientpb.AUTOMATIC_MOTION_FORMULATION
    MRF_MOTION_FORMULATION = _clientpb.MRF_MOTION_FORMULATION


class MotionSpecification(_IntEnum):
    """
    Choice between repositioning volumes at simulation start, or specifying motion velocities

    Attributes
    ----------
    MOTION_SPECIFICATION_REPOSITION
        The mesh is repositioned at simulation start time using the initial displacement or rotation
    MOTION_SPECIFICATION_NORMAL
        Specify both initial translation or rotation and angular or translational velocities


    Examples
    --------
    >>> from luminarycloud.params.enum import MotionSpecification
    >>> MotionSpecification.MOTION_SPECIFICATION_REPOSITION
    >>> MotionSpecification.MOTION_SPECIFICATION_NORMAL
    """

    INVALID = _clientpb.INVALID_MOTION_SPECIFICATION
    MOTION_SPECIFICATION_REPOSITION = _clientpb.MOTION_SPECIFICATION_REPOSITION
    MOTION_SPECIFICATION_NORMAL = _clientpb.MOTION_SPECIFICATION_NORMAL


class DebugOutput(_IntEnum):
    """
    Output debug fields in solution files.

    Attributes
    ----------
    SOLN_DEBUG_OUTPUT_OFF
        Disable debug output.
    SOLN_DEBUG_OUTPUT_ON
        Enable debug output.


    Examples
    --------
    >>> from luminarycloud.params.enum import DebugOutput
    >>> DebugOutput.SOLN_DEBUG_OUTPUT_OFF
    >>> DebugOutput.SOLN_DEBUG_OUTPUT_ON
    """

    INVALID = _clientpb.INVALID_DEBUG_OUTPUT
    SOLN_DEBUG_OUTPUT_OFF = _clientpb.SOLN_DEBUG_OUTPUT_OFF
    SOLN_DEBUG_OUTPUT_ON = _clientpb.SOLN_DEBUG_OUTPUT_ON


class DebugOutputInteriorSurfaceData(_IntEnum):
    """
    Copy the interior volume data into the surface data.

    Attributes
    ----------
    SOLN_DEBUG_OUTPUT_INT_SURF_DATA_OFF
        Disable debug output.
    SOLN_DEBUG_OUTPUT_INT_SURF_DATA_ON
        Enable debug output.


    Examples
    --------
    >>> from luminarycloud.params.enum import DebugOutputInteriorSurfaceData
    >>> DebugOutputInteriorSurfaceData.SOLN_DEBUG_OUTPUT_INT_SURF_DATA_OFF
    >>> DebugOutputInteriorSurfaceData.SOLN_DEBUG_OUTPUT_INT_SURF_DATA_ON
    """

    INVALID = _clientpb.INVALID_DEBUG_OUTPUT_INTERIOR_SURFACE_DATA
    SOLN_DEBUG_OUTPUT_INT_SURF_DATA_OFF = _clientpb.SOLN_DEBUG_OUTPUT_INT_SURF_DATA_OFF
    SOLN_DEBUG_OUTPUT_INT_SURF_DATA_ON = _clientpb.SOLN_DEBUG_OUTPUT_INT_SURF_DATA_ON


class ReferenceType(_IntEnum):
    """
    Method of specification for the reference values used in force and moment computations.

    Attributes
    ----------
    PRESCRIBE_VALUES
        User-defined force reference values.
    REFERENCE_FARFIELD_VALUES
        Force reference values from the farfield conditions.


    Examples
    --------
    >>> from luminarycloud.params.enum import ReferenceType
    >>> ReferenceType.PRESCRIBE_VALUES
    >>> ReferenceType.REFERENCE_FARFIELD_VALUES
    """

    INVALID = _clientpb.INVALID_REFERENCE_TYPE
    PRESCRIBE_VALUES = _clientpb.PRESCRIBE_VALUES
    REFERENCE_FARFIELD_VALUES = _clientpb.REFERENCE_FARFIELD_VALUES


class MeshingMethod(_IntEnum):
    """
    The method to generate the computational mesh.

    Attributes
    ----------
    MESH_METHOD_MANUAL
        Using user inputs to guide single, manual mesh generation.
    MESH_METHOD_AUTO
        Using solution-based adaptive mesh refinement.


    Examples
    --------
    >>> from luminarycloud.params.enum import MeshingMethod
    >>> MeshingMethod.MESH_METHOD_MANUAL
    >>> MeshingMethod.MESH_METHOD_AUTO
    """

    INVALID = _clientpb.INVALID_MESHING_METHOD
    MESH_METHOD_MANUAL = _clientpb.MESH_METHOD_MANUAL
    MESH_METHOD_AUTO = _clientpb.MESH_METHOD_AUTO


class AllTet(_IntEnum):
    """
    Automatically inserts high aspect ratio mesh elements in the
                 boundary layer and ignores all adaptation boundary layer settings

    Attributes
    ----------
    ALL_TET_OFF
        Use classical prismatic boundary layer insertion.
    ALL_TET_ON
        Use high aspect ratio tetrahedra automatically in areas of the flow
                        field that require higher resolution (including boundary layers).


    Examples
    --------
    >>> from luminarycloud.params.enum import AllTet
    >>> AllTet.ALL_TET_OFF
    >>> AllTet.ALL_TET_ON
    """

    INVALID = _clientpb.INVALID_ALL_TET
    ALL_TET_OFF = _clientpb.ALL_TET_OFF
    ALL_TET_ON = _clientpb.ALL_TET_ON


class ImplicitMethod(_IntEnum):
    """
    Scheme for implicit relaxation of the governing equations.

    Attributes
    ----------
    BACKWARD_EULER
        First-order backward Euler scheme.


    Examples
    --------
    >>> from luminarycloud.params.enum import ImplicitMethod
    >>> ImplicitMethod.BACKWARD_EULER
    """

    INVALID = _clientpb.INVALID_IMPLICIT_METHOD
    BACKWARD_EULER = _clientpb.BACKWARD_EULER


class LinsolAmgCycleType(_IntEnum):
    """
    AMG cycle type

    Attributes
    ----------
    LINSOL_AMG_CYCLE_TYPE_V
        V cycle


    Examples
    --------
    >>> from luminarycloud.params.enum import LinsolAmgCycleType
    >>> LinsolAmgCycleType.LINSOL_AMG_CYCLE_TYPE_V
    """

    INVALID = _clientpb.INVALID_LINSOL_AMG_CYCLE_TYPE
    LINSOL_AMG_CYCLE_TYPE_V = _clientpb.LINSOL_AMG_CYCLE_TYPE_V


class LinsolAmgSmoother(_IntEnum):
    """
    AMG cycle smoother

    Attributes
    ----------
    LINSOL_AMG_SMOOTHER_JACOBI
        Jacobi
    LINSOL_AMG_SMOOTHER_GS
        Gauss-Seidel


    Examples
    --------
    >>> from luminarycloud.params.enum import LinsolAmgSmoother
    >>> LinsolAmgSmoother.LINSOL_AMG_SMOOTHER_JACOBI
    >>> LinsolAmgSmoother.LINSOL_AMG_SMOOTHER_GS
    """

    INVALID = _clientpb.INVALID_LINSOL_AMG_SMOOTHER
    LINSOL_AMG_SMOOTHER_JACOBI = _clientpb.LINSOL_AMG_SMOOTHER_JACOBI
    LINSOL_AMG_SMOOTHER_GS = _clientpb.LINSOL_AMG_SMOOTHER_GS


class ExplicitMethod(_IntEnum):
    """
    Scheme for explicit relaxation or explicit time-accurate integration of the governing equations.

    Attributes
    ----------
    RK_4
        Classical Runge-Kutta fourth-order scheme.
    TVD_RK_3
        Total Variation Diminishing Runge-Kutta third-order scheme.
    FORWARD_EULER
        First-order forward Euler scheme.


    Examples
    --------
    >>> from luminarycloud.params.enum import ExplicitMethod
    >>> ExplicitMethod.RK_4
    >>> ExplicitMethod.TVD_RK_3
    >>> ExplicitMethod.FORWARD_EULER
    """

    INVALID = _clientpb.INVALID_EXPLICIT_METHOD
    RK_4 = _clientpb.RK_4
    TVD_RK_3 = _clientpb.TVD_RK_3
    FORWARD_EULER = _clientpb.FORWARD_EULER


class SolutionControlsHeatPreset(_IntEnum):
    """
    Select suggested control settings or allow a custom choice. In general, assume a trade-off between speed and robustness (i.e. the ability to converge).

    Attributes
    ----------
    UNSET_SOLUTION_CONTROLS_HEAT_PRESET
        Solution controls preset is not set.
    DEFAULT_SOLUTION_CONTROLS_HEAT
        Conservative performance settings that emphasize robustness (ability to converge).
    INTERMEDIATE_SOLUTION_CONTROLS_HEAT
        Reasonable compromise between speed and robustness.
    AGGRESSIVE_SOLUTION_CONTROLS_HEAT
        Aggressive settings further biased towards speed.
    CUSTOM_SOLUTION_CONTROLS_HEAT
        Custom solution controls.


    Examples
    --------
    >>> from luminarycloud.params.enum import SolutionControlsHeatPreset
    >>> SolutionControlsHeatPreset.UNSET_SOLUTION_CONTROLS_HEAT_PRESET
    >>> SolutionControlsHeatPreset.DEFAULT_SOLUTION_CONTROLS_HEAT
    >>> SolutionControlsHeatPreset.INTERMEDIATE_SOLUTION_CONTROLS_HEAT
    >>> SolutionControlsHeatPreset.AGGRESSIVE_SOLUTION_CONTROLS_HEAT
    >>> SolutionControlsHeatPreset.CUSTOM_SOLUTION_CONTROLS_HEAT
    """

    INVALID = _clientpb.INVALID_SOLUTION_CONTROLS_HEAT_PRESET
    UNSET_SOLUTION_CONTROLS_HEAT_PRESET = _clientpb.UNSET_SOLUTION_CONTROLS_HEAT_PRESET
    DEFAULT_SOLUTION_CONTROLS_HEAT = _clientpb.DEFAULT_SOLUTION_CONTROLS_HEAT
    INTERMEDIATE_SOLUTION_CONTROLS_HEAT = _clientpb.INTERMEDIATE_SOLUTION_CONTROLS_HEAT
    AGGRESSIVE_SOLUTION_CONTROLS_HEAT = _clientpb.AGGRESSIVE_SOLUTION_CONTROLS_HEAT
    CUSTOM_SOLUTION_CONTROLS_HEAT = _clientpb.CUSTOM_SOLUTION_CONTROLS_HEAT


class AdjointSolutionMethod(_IntEnum):
    """
    The method used to solve the discrete adjoint equations.

    Attributes
    ----------
    ADJOINT_METHOD_GMRES
        Use the GMRES linear solver to solve the equations.


    Examples
    --------
    >>> from luminarycloud.params.enum import AdjointSolutionMethod
    >>> AdjointSolutionMethod.ADJOINT_METHOD_GMRES
    """

    INVALID = _clientpb.INVALID_ADJOINT_SOLUTION_METHOD
    ADJOINT_METHOD_GMRES = _clientpb.ADJOINT_METHOD_GMRES


class GradientMethod(_IntEnum):
    """
    Method for computing the spatial gradients of fluid variables.

    Attributes
    ----------
    HLSQ
        Standard hybrid least squares method with custom weighting.
    WEIGHTED_LEAST_SQUARES
        Least squares method with inverse distance weighting.
    GREEN_GAUSS
        Green-Gauss method.
    LC_HLSQ
        Luminary Cloud's custom hybrid least squares method.
    NODAL_GRADIENT
        Gradients computed using nodal values interpolated from the
                        cell-centered solution.


    Examples
    --------
    >>> from luminarycloud.params.enum import GradientMethod
    >>> GradientMethod.HLSQ
    >>> GradientMethod.WEIGHTED_LEAST_SQUARES
    >>> GradientMethod.GREEN_GAUSS
    >>> GradientMethod.LC_HLSQ
    >>> GradientMethod.NODAL_GRADIENT
    """

    INVALID = _clientpb.INVALID_GRADIENT_METHOD
    HLSQ = _clientpb.HLSQ
    WEIGHTED_LEAST_SQUARES = _clientpb.WEIGHTED_LEAST_SQUARES
    GREEN_GAUSS = _clientpb.GREEN_GAUSS
    LC_HLSQ = _clientpb.LC_HLSQ
    NODAL_GRADIENT = _clientpb.NODAL_GRADIENT


class GeometryFixes(_IntEnum):
    """
    Strategies to cope with problematic mesh regions (e.g. high skewness angles).

    Attributes
    ----------
    GEOMETRY_FIXES_ON
        Enable geometry fixes.
    GEOMETRY_FIXES_OFF
        Disable geometry fixes.


    Examples
    --------
    >>> from luminarycloud.params.enum import GeometryFixes
    >>> GeometryFixes.GEOMETRY_FIXES_ON
    >>> GeometryFixes.GEOMETRY_FIXES_OFF
    """

    INVALID = _clientpb.INVALID_GEOMETRY_FIXES
    GEOMETRY_FIXES_ON = _clientpb.GEOMETRY_FIXES_ON
    GEOMETRY_FIXES_OFF = _clientpb.GEOMETRY_FIXES_OFF


class SpatialDiscretizationHeatPreset(_IntEnum):
    """
    Select suggested control settings or allow a custom choice. In general, assume a trade-off between accuracy and robustness (i.e. the ability to converge).

    Attributes
    ----------
    UNSET_SPATIAL_DISCRETIZATION_HEAT_PRESET
        Spatial discretization preset is not set.
    DEFAULT_SPATIAL_DISCRETIZATION_HEAT
        Default settings, good compromise between accuracy and robustness (ability to converge).
    CONSERVATIVE_SPATIAL_DISCRETIZATION_HEAT
        Settings biased towards robustness over maximum accuracy (relative to default).
    HIGH_ACCURACY_SPATIAL_DISCRETIZATION_HEAT
        Settings that emphasize accuracy (relative to default).
    CUSTOM_SPATIAL_DISCRETIZATION_HEAT
        Custom discretization settings.


    Examples
    --------
    >>> from luminarycloud.params.enum import SpatialDiscretizationHeatPreset
    >>> SpatialDiscretizationHeatPreset.UNSET_SPATIAL_DISCRETIZATION_HEAT_PRESET
    >>> SpatialDiscretizationHeatPreset.DEFAULT_SPATIAL_DISCRETIZATION_HEAT
    >>> SpatialDiscretizationHeatPreset.CONSERVATIVE_SPATIAL_DISCRETIZATION_HEAT
    >>> SpatialDiscretizationHeatPreset.HIGH_ACCURACY_SPATIAL_DISCRETIZATION_HEAT
    >>> SpatialDiscretizationHeatPreset.CUSTOM_SPATIAL_DISCRETIZATION_HEAT
    """

    INVALID = _clientpb.INVALID_SPATIAL_DISCRETIZATION_HEAT_PRESET
    UNSET_SPATIAL_DISCRETIZATION_HEAT_PRESET = _clientpb.UNSET_SPATIAL_DISCRETIZATION_HEAT_PRESET
    DEFAULT_SPATIAL_DISCRETIZATION_HEAT = _clientpb.DEFAULT_SPATIAL_DISCRETIZATION_HEAT
    CONSERVATIVE_SPATIAL_DISCRETIZATION_HEAT = _clientpb.CONSERVATIVE_SPATIAL_DISCRETIZATION_HEAT
    HIGH_ACCURACY_SPATIAL_DISCRETIZATION_HEAT = _clientpb.HIGH_ACCURACY_SPATIAL_DISCRETIZATION_HEAT
    CUSTOM_SPATIAL_DISCRETIZATION_HEAT = _clientpb.CUSTOM_SPATIAL_DISCRETIZATION_HEAT


class ProfileType(_IntEnum):
    """
    Types of boundary condition profile.

    Attributes
    ----------
    CARTESIAN_X
        1D profile in X direction.
    CARTESIAN_Y
        1D profile in Y direction.
    CARTESIAN_Z
        1D profile in Z direction.
    RADIAL_X
        1D radial profile normal to the X direction.
    RADIAL_Y
        1D radial profile normal to the Y direction.
    RADIAL_Z
        1D radial profile normal to the Z direction.
    TIME
        Time varying profile.
    CARTESIAN_XY
        2D profile in X and Y direction.


    Examples
    --------
    >>> from luminarycloud.params.enum import ProfileType
    >>> ProfileType.CARTESIAN_X
    >>> ProfileType.CARTESIAN_Y
    >>> ProfileType.CARTESIAN_Z
    >>> ProfileType.RADIAL_X
    >>> ProfileType.RADIAL_Y
    >>> ProfileType.RADIAL_Z
    >>> ProfileType.TIME
    >>> ProfileType.CARTESIAN_XY
    """

    INVALID = _clientpb.INVALID_PROFILE_TYPE
    CARTESIAN_X = _clientpb.CARTESIAN_X
    CARTESIAN_Y = _clientpb.CARTESIAN_Y
    CARTESIAN_Z = _clientpb.CARTESIAN_Z
    RADIAL_X = _clientpb.RADIAL_X
    RADIAL_Y = _clientpb.RADIAL_Y
    RADIAL_Z = _clientpb.RADIAL_Z
    TIME = _clientpb.TIME
    CARTESIAN_XY = _clientpb.CARTESIAN_XY


class InterfaceType(_IntEnum):
    """
    Type of interface treatment

    Attributes
    ----------
    GENERAL_INTERFACE
        Automatic treatment based on geometry and settings. General
                        interface, frozen rotor, or sliding interface for fluids. General interface
                        with contact resistance for solids.
    MIXING_PLANE_INTERFACE
        Imposes a pitchwise average of the variables on either side of the interface.


    Examples
    --------
    >>> from luminarycloud.params.enum import InterfaceType
    >>> InterfaceType.GENERAL_INTERFACE
    >>> InterfaceType.MIXING_PLANE_INTERFACE
    """

    INVALID = _clientpb.INVALID_INTERFACE_TYPE
    GENERAL_INTERFACE = _clientpb.GENERAL_INTERFACE
    MIXING_PLANE_INTERFACE = _clientpb.MIXING_PLANE_INTERFACE


class PeriodicBcType(_IntEnum):
    """


    Attributes
    ----------
    TRANSLATIONAL

    ROTATIONAL



    Examples
    --------
    >>> from luminarycloud.params.enum import PeriodicBcType
    >>> PeriodicBcType.TRANSLATIONAL
    >>> PeriodicBcType.ROTATIONAL
    """

    INVALID = _clientpb.INVALID_PERIODIC_BC_TYPE
    TRANSLATIONAL = _clientpb.TRANSLATIONAL
    ROTATIONAL = _clientpb.ROTATIONAL


class FluidType(_IntEnum):
    """
    Fluid types available for use with the solver.

    Attributes
    ----------
    SINGLE_PHASE
        Standard single phase fluid
    CAVITATING_FLUID
        Single phase approximation for cavitation with a cavitation model
    VOF_FLUID
        VOF multiphase model for simulating flows with multiple fluids and immiscible interfaces.


    Examples
    --------
    >>> from luminarycloud.params.enum import FluidType
    >>> FluidType.SINGLE_PHASE
    >>> FluidType.CAVITATING_FLUID
    >>> FluidType.VOF_FLUID
    """

    INVALID = _clientpb.INVALID_FLUID_TYPE
    SINGLE_PHASE = _clientpb.SINGLE_PHASE
    CAVITATING_FLUID = _clientpb.CAVITATING_FLUID
    VOF_FLUID = _clientpb.VOF_FLUID


class ViscousModel(_IntEnum):
    """
    Set the viscous model for the fluid solver.

    Attributes
    ----------
    RANS
        Reynolds-averaged Navier-Stokes.
    DES
        Detached Eddy Simulation.
    LES
        Large Eddy Simulation.
    LAMINAR
        Laminar flow governed by the Navier-Stokes equations.
    INVISCID
        Inviscid flow governed by the Euler equations.


    Examples
    --------
    >>> from luminarycloud.params.enum import ViscousModel
    >>> ViscousModel.RANS
    >>> ViscousModel.DES
    >>> ViscousModel.LES
    >>> ViscousModel.LAMINAR
    >>> ViscousModel.INVISCID
    """

    INVALID = _clientpb.INVALID_VISCOUS_MODEL
    RANS = _clientpb.RANS
    DES = _clientpb.DES
    LES = _clientpb.LES
    LAMINAR = _clientpb.LAMINAR
    INVISCID = _clientpb.INVISCID


class RansRegion(_IntEnum):
    """
    Select a region where RANS behavior should be enforced.

    Attributes
    ----------
    INSIDE
        Force RANS behavior inside a prescribed bounding box.
    OUTSIDE
        Force RANS behavior outside a prescribed bounding box.


    Examples
    --------
    >>> from luminarycloud.params.enum import RansRegion
    >>> RansRegion.INSIDE
    >>> RansRegion.OUTSIDE
    """

    INVALID = _clientpb.INVALID_RANS_REGION
    INSIDE = _clientpb.INSIDE
    OUTSIDE = _clientpb.OUTSIDE


class TransitionModel(_IntEnum):
    """
    Laminar-turbulent transition models available for Reynolds-averaged Navier-Stokes (RANS).

    Attributes
    ----------
    NO_TRANSITION
        No transition modelling, the flow is fully turbulent.
    GAMMA_2015
        One-equation local correlation-based, γ-2015,
                        transition model (simplified γ-Re<sub>θ<sub>t</sub></sub>).
    GAMMA_RE_THETA_2009
        Two-equation local correlation-based, γ-Re<sub>θ<sub>t</sub></sub>-2009,
                        transition model.
    AFT_2019
        Two-equation amplification factor transport, AFT-2019,
                        transition model.


    Examples
    --------
    >>> from luminarycloud.params.enum import TransitionModel
    >>> TransitionModel.NO_TRANSITION
    >>> TransitionModel.GAMMA_2015
    >>> TransitionModel.GAMMA_RE_THETA_2009
    >>> TransitionModel.AFT_2019
    """

    INVALID = _clientpb.INVALID_TRANSITION_MODEL
    NO_TRANSITION = _clientpb.NO_TRANSITION
    GAMMA_2015 = _clientpb.GAMMA_2015
    GAMMA_RE_THETA_2009 = _clientpb.GAMMA_RE_THETA_2009
    AFT_2019 = _clientpb.AFT_2019


class TransitionModelCrossFlow(_IntEnum):
    """
    Crossflow instability treatment for transition model.

    Attributes
    ----------
    TRANSITION_MODEL_CROSS_FLOW_OFF
        Crossflow instability is not considered in transition modelling.
    TRANSITION_MODEL_CROSS_FLOW_ON
        Crossflow treatment is active in transition modelling.


    Examples
    --------
    >>> from luminarycloud.params.enum import TransitionModelCrossFlow
    >>> TransitionModelCrossFlow.TRANSITION_MODEL_CROSS_FLOW_OFF
    >>> TransitionModelCrossFlow.TRANSITION_MODEL_CROSS_FLOW_ON
    """

    INVALID = _clientpb.INVALID_TRANSITION_MODEL_CROSS_FLOW
    TRANSITION_MODEL_CROSS_FLOW_OFF = _clientpb.TRANSITION_MODEL_CROSS_FLOW_OFF
    TRANSITION_MODEL_CROSS_FLOW_ON = _clientpb.TRANSITION_MODEL_CROSS_FLOW_ON


class QcrSa(_IntEnum):
    """
    Modification of the traditional linear Boussinesq relation for the Spalart-Allmaras turbulence model via the quadratic constitutive relation (QCR).

    Attributes
    ----------
    QCR_OFF
        A QCR modification is not applied.
    QCR2000
        The 2000 version of the QCR modification is applied (QCR2000).


    Examples
    --------
    >>> from luminarycloud.params.enum import QcrSa
    >>> QcrSa.QCR_OFF
    >>> QcrSa.QCR2000
    """

    INVALID = _clientpb.INVALID_QCR_SA
    QCR_OFF = _clientpb.QCR_OFF
    QCR2000 = _clientpb.QCR2000


class RotationCorrectionSa(_IntEnum):
    """
    Apply a rotation correction to the Spalart-Allmaras turbulence model.

    Attributes
    ----------
    ROTATION_CORRECTION_OFF
        A rotation correction is not applied to the Spalart-Allmaras turbulence model.
    ROTATION_CORRECTION_ON
        The SA-R form of the rotation correction is applied to the Spalart-Allmaras turbulence model.


    Examples
    --------
    >>> from luminarycloud.params.enum import RotationCorrectionSa
    >>> RotationCorrectionSa.ROTATION_CORRECTION_OFF
    >>> RotationCorrectionSa.ROTATION_CORRECTION_ON
    """

    INVALID = _clientpb.INVALID_ROTATION_CORRECTION_SA
    ROTATION_CORRECTION_OFF = _clientpb.ROTATION_CORRECTION_OFF
    ROTATION_CORRECTION_ON = _clientpb.ROTATION_CORRECTION_ON


class QcrSst(_IntEnum):
    """
    Modification of the traditional linear Boussinesq relation for the SST turbulence model via the quadratic constitutive relation (QCR).

    Attributes
    ----------
    SST_QCR_OFF
        A QCR modification is not applied.
    SST_QCR2000
        The 2000 version of the QCR modification is applied (QCR2000).


    Examples
    --------
    >>> from luminarycloud.params.enum import QcrSst
    >>> QcrSst.SST_QCR_OFF
    >>> QcrSst.SST_QCR2000
    """

    INVALID = _clientpb.INVALID_QCR_SST
    SST_QCR_OFF = _clientpb.SST_QCR_OFF
    SST_QCR2000 = _clientpb.SST_QCR2000


class LocalTimeStepping(_IntEnum):
    """
    Compute local time steps in each control volume to accelerate convergence
                of steady-state simulations or the inner iterations of time-accurate simulations
                with dual time stepping.

    Attributes
    ----------
    LOCAL_TIME_STEPPING_ON
        Enable local time stepping.
    LOCAL_TIME_STEPPING_OFF
        Disable local time stepping.


    Examples
    --------
    >>> from luminarycloud.params.enum import LocalTimeStepping
    >>> LocalTimeStepping.LOCAL_TIME_STEPPING_ON
    >>> LocalTimeStepping.LOCAL_TIME_STEPPING_OFF
    """

    INVALID = _clientpb.INVALID_LOCAL_TIME_STEPPING
    LOCAL_TIME_STEPPING_ON = _clientpb.LOCAL_TIME_STEPPING_ON
    LOCAL_TIME_STEPPING_OFF = _clientpb.LOCAL_TIME_STEPPING_OFF


class JacobianUpdateMethod(_IntEnum):
    """
    Method for determining how often to

    Attributes
    ----------
    EXPLICIT_INTERVAL_AND_WARMUP
        Compute the jacobian every iteration for 'Jacobian Warmup Threshold' iterations, then compute every 'Jacobian Update Interval' iterations


    Examples
    --------
    >>> from luminarycloud.params.enum import JacobianUpdateMethod
    >>> JacobianUpdateMethod.EXPLICIT_INTERVAL_AND_WARMUP
    """

    INVALID = _clientpb.INVALID_JACOBIAN_UPDATE_METHOD
    EXPLICIT_INTERVAL_AND_WARMUP = _clientpb.EXPLICIT_INTERVAL_AND_WARMUP


class SolutionControlsFluidPreset(_IntEnum):
    """
    Select suggested control settings or allow a custom choice. In general, assume a trade-off between speed and robustness (i.e. the ability to converge).

    Attributes
    ----------
    UNSET_SOLUTION_CONTROLS_FLUID_PRESET
        Solution controls preset is not set.
    DEFAULT_SOLUTION_CONTROLS_FLUID
        Conservative performance settings that emphasize robustness (ability to converge).
    INTERMEDIATE_SOLUTION_CONTROLS_FLUID
        Reasonable compromise between speed and robustness, up to 2 times faster than the default settings.
    AGGRESSIVE_SOLUTION_CONTROLS_FLUID
        Aggressive settings further biased towards speed, up to 3 times faster than the default settings (these may not be suitable for all problems).
    CUSTOM_SOLUTION_CONTROLS_FLUID
        Custom solution controls.


    Examples
    --------
    >>> from luminarycloud.params.enum import SolutionControlsFluidPreset
    >>> SolutionControlsFluidPreset.UNSET_SOLUTION_CONTROLS_FLUID_PRESET
    >>> SolutionControlsFluidPreset.DEFAULT_SOLUTION_CONTROLS_FLUID
    >>> SolutionControlsFluidPreset.INTERMEDIATE_SOLUTION_CONTROLS_FLUID
    >>> SolutionControlsFluidPreset.AGGRESSIVE_SOLUTION_CONTROLS_FLUID
    >>> SolutionControlsFluidPreset.CUSTOM_SOLUTION_CONTROLS_FLUID
    """

    INVALID = _clientpb.INVALID_SOLUTION_CONTROLS_FLUID_PRESET
    UNSET_SOLUTION_CONTROLS_FLUID_PRESET = _clientpb.UNSET_SOLUTION_CONTROLS_FLUID_PRESET
    DEFAULT_SOLUTION_CONTROLS_FLUID = _clientpb.DEFAULT_SOLUTION_CONTROLS_FLUID
    INTERMEDIATE_SOLUTION_CONTROLS_FLUID = _clientpb.INTERMEDIATE_SOLUTION_CONTROLS_FLUID
    AGGRESSIVE_SOLUTION_CONTROLS_FLUID = _clientpb.AGGRESSIVE_SOLUTION_CONTROLS_FLUID
    CUSTOM_SOLUTION_CONTROLS_FLUID = _clientpb.CUSTOM_SOLUTION_CONTROLS_FLUID


class Preconditioning(_IntEnum):
    """
    Apply low-speed preconditioning to obtain Mach number-independent solutions for ideal gases.

    Attributes
    ----------
    PRECONDITIONING_ON
        Enable low-speed preconditioning.
    PRECONDITIONING_OFF
        Disable low-speed preconditioning.


    Examples
    --------
    >>> from luminarycloud.params.enum import Preconditioning
    >>> Preconditioning.PRECONDITIONING_ON
    >>> Preconditioning.PRECONDITIONING_OFF
    """

    INVALID = _clientpb.INVALID_PRECONDITIONING
    PRECONDITIONING_ON = _clientpb.PRECONDITIONING_ON
    PRECONDITIONING_OFF = _clientpb.PRECONDITIONING_OFF


class ArtificialViscosityModel(_IntEnum):
    """
    Artificial viscosity for shock and interface capturing.

    Attributes
    ----------
    NO_MODEL
        No artificial viscosity model.
    LAD
        Localized artificial diffusivity (LAD) model.


    Examples
    --------
    >>> from luminarycloud.params.enum import ArtificialViscosityModel
    >>> ArtificialViscosityModel.NO_MODEL
    >>> ArtificialViscosityModel.LAD
    """

    INVALID = _clientpb.INVALID_ARTIFICIAL_VISCOSITY_MODEL
    NO_MODEL = _clientpb.NO_MODEL
    LAD = _clientpb.LAD


class SkewSymmetricFormulation(_IntEnum):
    """
    Choice among skew-symmetric formulations.

    Attributes
    ----------
    CHANDRASEKHAR_EC2
        Praveen Chandrasekhar's EC2 formulation.
    CHANDRASEKHAR_EC1
        Praveen Chandrasekhar's EC1 formulation.
    KUYA
        Kuya et al's formulation.


    Examples
    --------
    >>> from luminarycloud.params.enum import SkewSymmetricFormulation
    >>> SkewSymmetricFormulation.CHANDRASEKHAR_EC2
    >>> SkewSymmetricFormulation.CHANDRASEKHAR_EC1
    >>> SkewSymmetricFormulation.KUYA
    """

    INVALID = _clientpb.INVALID_SKEW_SYMMETRIC_FORMULATION
    CHANDRASEKHAR_EC2 = _clientpb.CHANDRASEKHAR_EC2
    CHANDRASEKHAR_EC1 = _clientpb.CHANDRASEKHAR_EC1
    KUYA = _clientpb.KUYA


class RobustDissipation(_IntEnum):
    """
    Use a form of dissipation that improves robustness but that may reduce accuracy.

    Attributes
    ----------
    ROBUST_DISS_OFF
        Disable robust dissipation.
    ROBUST_DISS_ON
        Enable robust dissipation.


    Examples
    --------
    >>> from luminarycloud.params.enum import RobustDissipation
    >>> RobustDissipation.ROBUST_DISS_OFF
    >>> RobustDissipation.ROBUST_DISS_ON
    """

    INVALID = _clientpb.INVALID_ROBUST_DISSIPATION
    ROBUST_DISS_OFF = _clientpb.ROBUST_DISS_OFF
    ROBUST_DISS_ON = _clientpb.ROBUST_DISS_ON


class Limiter(_IntEnum):
    """
    Apply a slope limiter for second-order upwind schemes. This tends to increase
                robustness at the expense of solution time and higher dissipation in regions of the
                flow with sharp gradients. For this reason, it may be helpful to increase gradient
                blending parameters when using limiters.

    Attributes
    ----------
    NO_LIMITER
        Do not apply a slope limiter.
    INVARIANT_VENKATAKRISHNAN_CV
        Apply cell-based limiting with the limiter function of Venkatakrishnan.
    VAN_ALBADA_FACE
        Apply face-based limiting with the limiter function of Van Albada.
                        This limiter is more conservative than Venkatakrishnan-Wang.
    VENKATAKRISHNAN_CV
        This option was deprecated in favor of an implementation of the
                        same method that guarantees coordinate-system invariance.


    Examples
    --------
    >>> from luminarycloud.params.enum import Limiter
    >>> Limiter.NO_LIMITER
    >>> Limiter.INVARIANT_VENKATAKRISHNAN_CV
    >>> Limiter.VAN_ALBADA_FACE
    >>> Limiter.VENKATAKRISHNAN_CV
    """

    INVALID = _clientpb.INVALID_LIMITER
    NO_LIMITER = _clientpb.NO_LIMITER
    INVARIANT_VENKATAKRISHNAN_CV = _clientpb.INVARIANT_VENKATAKRISHNAN_CV
    VAN_ALBADA_FACE = _clientpb.VAN_ALBADA_FACE
    VENKATAKRISHNAN_CV = _clientpb.VENKATAKRISHNAN_CV


class SpatialDiscretizationFluidPreset(_IntEnum):
    """
    Select suggested control settings or allow a custom choice. In general, assume a trade-off between accuracy and robustness (i.e. the ability to converge).

    Attributes
    ----------
    UNSET_SPATIAL_DISCRETIZATION_FLUID_PRESET
        Spatial discretization preset is not set.
    DEFAULT_SPATIAL_DISCRETIZATION_FLUID
        Default settings, good compromise between accuracy and robustness (ability to converge).
    CONSERVATIVE_SPATIAL_DISCRETIZATION_FLUID
        Settings biased towards robustness over maximum accuracy (relative to default).
    HIGH_ACCURACY_SPATIAL_DISCRETIZATION_FLUID
        Settings that emphasize accuracy (relative to default).
    CUSTOM_SPATIAL_DISCRETIZATION_FLUID
        Custom discretization settings.


    Examples
    --------
    >>> from luminarycloud.params.enum import SpatialDiscretizationFluidPreset
    >>> SpatialDiscretizationFluidPreset.UNSET_SPATIAL_DISCRETIZATION_FLUID_PRESET
    >>> SpatialDiscretizationFluidPreset.DEFAULT_SPATIAL_DISCRETIZATION_FLUID
    >>> SpatialDiscretizationFluidPreset.CONSERVATIVE_SPATIAL_DISCRETIZATION_FLUID
    >>> SpatialDiscretizationFluidPreset.HIGH_ACCURACY_SPATIAL_DISCRETIZATION_FLUID
    >>> SpatialDiscretizationFluidPreset.CUSTOM_SPATIAL_DISCRETIZATION_FLUID
    """

    INVALID = _clientpb.INVALID_SPATIAL_DISCRETIZATION_FLUID_PRESET
    UNSET_SPATIAL_DISCRETIZATION_FLUID_PRESET = _clientpb.UNSET_SPATIAL_DISCRETIZATION_FLUID_PRESET
    DEFAULT_SPATIAL_DISCRETIZATION_FLUID = _clientpb.DEFAULT_SPATIAL_DISCRETIZATION_FLUID
    CONSERVATIVE_SPATIAL_DISCRETIZATION_FLUID = _clientpb.CONSERVATIVE_SPATIAL_DISCRETIZATION_FLUID
    HIGH_ACCURACY_SPATIAL_DISCRETIZATION_FLUID = (
        _clientpb.HIGH_ACCURACY_SPATIAL_DISCRETIZATION_FLUID
    )
    CUSTOM_SPATIAL_DISCRETIZATION_FLUID = _clientpb.CUSTOM_SPATIAL_DISCRETIZATION_FLUID


class InletEnergy(_IntEnum):
    """
    Method of defining the inlet energy conditions.

    Attributes
    ----------
    TOTAL_TEMPERATURE_INLET
        Specify total temperature.


    Examples
    --------
    >>> from luminarycloud.params.enum import InletEnergy
    >>> InletEnergy.TOTAL_TEMPERATURE_INLET
    """

    INVALID = _clientpb.INVALID_INLET_ENERGY
    TOTAL_TEMPERATURE_INLET = _clientpb.TOTAL_TEMPERATURE_INLET


class TurbulenceSpecificationSpalartAllmaras(_IntEnum):
    """
    Condition applied to the Spalart-Allmaras turbulence equation at the boundary.

    Attributes
    ----------
    TURBULENT_VISCOSITY_RATIO_SA
        Apply a ratio of turbulent viscosity to laminar viscosity at the boundary.
    TURBULENT_VISCOSITY_SA
        Set the turbulent viscosity at the boundary.
    BC_SA_VARIABLE
        Set the Spalart-Allmaras variable value at the boundary condition.


    Examples
    --------
    >>> from luminarycloud.params.enum import TurbulenceSpecificationSpalartAllmaras
    >>> TurbulenceSpecificationSpalartAllmaras.TURBULENT_VISCOSITY_RATIO_SA
    >>> TurbulenceSpecificationSpalartAllmaras.TURBULENT_VISCOSITY_SA
    >>> TurbulenceSpecificationSpalartAllmaras.BC_SA_VARIABLE
    """

    INVALID = _clientpb.INVALID_TURBULENCE_SPECIFICATION_SPALART_ALLMARAS
    TURBULENT_VISCOSITY_RATIO_SA = _clientpb.TURBULENT_VISCOSITY_RATIO_SA
    TURBULENT_VISCOSITY_SA = _clientpb.TURBULENT_VISCOSITY_SA
    BC_SA_VARIABLE = _clientpb.BC_SA_VARIABLE


class TurbulenceSpecificationKomega(_IntEnum):
    """
    Condition applied to the k-ω turbulence variables at the boundary.

    Attributes
    ----------
    BC_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA
        Apply a uniform ratio of turbulent viscosity to laminar viscosity and turbulence intensity at the boundary.
    BC_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA
        Set a uniform turbulent viscosity and turbulence intensity in the domain.
    BC_KOMEGA_VARIABLES
        Set the k-ω variables at the boundary condition.


    Examples
    --------
    >>> from luminarycloud.params.enum import TurbulenceSpecificationKomega
    >>> TurbulenceSpecificationKomega.BC_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA
    >>> TurbulenceSpecificationKomega.BC_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA
    >>> TurbulenceSpecificationKomega.BC_KOMEGA_VARIABLES
    """

    INVALID = _clientpb.INVALID_TURBULENCE_SPECIFICATION_KOMEGA
    BC_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA = (
        _clientpb.BC_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA
    )
    BC_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA = (
        _clientpb.BC_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA
    )
    BC_KOMEGA_VARIABLES = _clientpb.BC_KOMEGA_VARIABLES


class DirectionSpecification(_IntEnum):
    """
    Method of defining the flow direction at the inlet.

    Attributes
    ----------
    NORMAL_TO_BOUNDARY
        Impose a flow direction normal to the inlet boundary toward the interior of the domain.
    DIRECTION_VECTOR
        Specify a vector for the inlet flow direction.
    CYLINDRICAL_DIRECTIONS
        Specify the inlet flow direction in a cylindrical coordinate system whose main axis
                        is defined by the z axis of the inlet frame.


    Examples
    --------
    >>> from luminarycloud.params.enum import DirectionSpecification
    >>> DirectionSpecification.NORMAL_TO_BOUNDARY
    >>> DirectionSpecification.DIRECTION_VECTOR
    >>> DirectionSpecification.CYLINDRICAL_DIRECTIONS
    """

    INVALID = _clientpb.INVALID_DIRECTION_SPECIFICATION
    NORMAL_TO_BOUNDARY = _clientpb.NORMAL_TO_BOUNDARY
    DIRECTION_VECTOR = _clientpb.DIRECTION_VECTOR
    CYLINDRICAL_DIRECTIONS = _clientpb.CYLINDRICAL_DIRECTIONS


class DirectionFrame(_IntEnum):
    """
    Frame used to define the flow direction.

    Attributes
    ----------
    DIRECTION_FRAME_GLOBAL
        The direction vectors are defined by the global frame.
    DIRECTION_FRAME_BOUNDARY
        The direction vectors are defined by the frame to which the boundary surfaces are attached.


    Examples
    --------
    >>> from luminarycloud.params.enum import DirectionFrame
    >>> DirectionFrame.DIRECTION_FRAME_GLOBAL
    >>> DirectionFrame.DIRECTION_FRAME_BOUNDARY
    """

    INVALID = _clientpb.INVALID_DIRECTION_FRAME
    DIRECTION_FRAME_GLOBAL = _clientpb.DIRECTION_FRAME_GLOBAL
    DIRECTION_FRAME_BOUNDARY = _clientpb.DIRECTION_FRAME_BOUNDARY


class OutletPressureConstraint(_IntEnum):
    """
    Mode of imposing pressure at the outlet.

    Attributes
    ----------
    OUTLET_LOCAL_CONSTRAINT
        Pressure values are imposed locally at each mesh face,
                        thereby imposing a fixed pressure profile (e.g. uniform).
    OUTLET_AVERAGE_CONSTRAINT
        The area-averaged pressure is imposed while local values can deviate.
                        This allows a pressure profile to develop naturally, but can be less numerically
                        stable than the Local constraint mode.


    Examples
    --------
    >>> from luminarycloud.params.enum import OutletPressureConstraint
    >>> OutletPressureConstraint.OUTLET_LOCAL_CONSTRAINT
    >>> OutletPressureConstraint.OUTLET_AVERAGE_CONSTRAINT
    """

    INVALID = _clientpb.INVALID_OUTLET_PRESSURE_CONSTRAINT
    OUTLET_LOCAL_CONSTRAINT = _clientpb.OUTLET_LOCAL_CONSTRAINT
    OUTLET_AVERAGE_CONSTRAINT = _clientpb.OUTLET_AVERAGE_CONSTRAINT


class FarfieldMomentum(_IntEnum):
    """
    Method of defining the farfield momentum conditions.

    Attributes
    ----------
    FARFIELD_MACH_NUMBER
        Specify the freestream Mach number.
    FARFIELD_VELOCITY_MAGNITUDE
        Specify the freestream velocity magnitude.


    Examples
    --------
    >>> from luminarycloud.params.enum import FarfieldMomentum
    >>> FarfieldMomentum.FARFIELD_MACH_NUMBER
    >>> FarfieldMomentum.FARFIELD_VELOCITY_MAGNITUDE
    """

    INVALID = _clientpb.INVALID_FARFIELD_MOMENTUM
    FARFIELD_MACH_NUMBER = _clientpb.FARFIELD_MACH_NUMBER
    FARFIELD_VELOCITY_MAGNITUDE = _clientpb.FARFIELD_VELOCITY_MAGNITUDE


class FarFieldFlowDirectionSpecification(_IntEnum):
    """
    Method of defining the flow direction at the far-field.

    Attributes
    ----------
    FARFIELD_DIRECTION
        Specify a vector for the far-field flow direction.
    FARFIELD_ANGLES
        Specify body axes, angle of attack, and angle of sideslip to define the far-field flow direction.


    Examples
    --------
    >>> from luminarycloud.params.enum import FarFieldFlowDirectionSpecification
    >>> FarFieldFlowDirectionSpecification.FARFIELD_DIRECTION
    >>> FarFieldFlowDirectionSpecification.FARFIELD_ANGLES
    """

    INVALID = _clientpb.INVALID_FAR_FIELD_FLOW_DIRECTION_SPECIFICATION
    FARFIELD_DIRECTION = _clientpb.FARFIELD_DIRECTION
    FARFIELD_ANGLES = _clientpb.FARFIELD_ANGLES


class TurbulentVariableInitializationTypeSa(_IntEnum):
    """
    Type of initial condition for the turbulent variables.

    Attributes
    ----------
    INIT_TURBULENT_VISCOSITY_RATIO_SA
        Apply a uniform ratio of turbulent viscosity to laminar viscosity in the domain.
    INIT_TURBULENT_VISCOSITY_SA
        Set a uniform turbulent viscosity in the domain.
    INIT_SA_VARIABLE
        Uniform initial condition for the Spalart-Allmaras turbulence variable.
    INIT_FARFIELD_VALUES_SA
        Uniform initial condition for the Spalart-Allmaras turbulence variable from the far-field boundary.


    Examples
    --------
    >>> from luminarycloud.params.enum import TurbulentVariableInitializationTypeSa
    >>> TurbulentVariableInitializationTypeSa.INIT_TURBULENT_VISCOSITY_RATIO_SA
    >>> TurbulentVariableInitializationTypeSa.INIT_TURBULENT_VISCOSITY_SA
    >>> TurbulentVariableInitializationTypeSa.INIT_SA_VARIABLE
    >>> TurbulentVariableInitializationTypeSa.INIT_FARFIELD_VALUES_SA
    """

    INVALID = _clientpb.INVALID_TURBULENT_VARIABLE_INITIALIZATION_TYPE_SA
    INIT_TURBULENT_VISCOSITY_RATIO_SA = _clientpb.INIT_TURBULENT_VISCOSITY_RATIO_SA
    INIT_TURBULENT_VISCOSITY_SA = _clientpb.INIT_TURBULENT_VISCOSITY_SA
    INIT_SA_VARIABLE = _clientpb.INIT_SA_VARIABLE
    INIT_FARFIELD_VALUES_SA = _clientpb.INIT_FARFIELD_VALUES_SA


class TurbulentVariableInitializationTypeKomega(_IntEnum):
    """
    Type of initial condition for the turbulent variables.

    Attributes
    ----------
    INIT_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA
        Apply a uniform ratio of turbulent viscosity to laminar viscosity and turbulence intensity in the domain.
    INIT_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA
        Set a uniform turbulent viscosity and turbulence intensity in the domain.
    INIT_KOMEGA_VARIABLES
        Uniform initial conditions.
    INIT_FARFIELD_VALUES_KOMEGA
        Uniform initial condition from the far-field boundary.


    Examples
    --------
    >>> from luminarycloud.params.enum import TurbulentVariableInitializationTypeKomega
    >>> TurbulentVariableInitializationTypeKomega.INIT_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA
    >>> TurbulentVariableInitializationTypeKomega.INIT_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA
    >>> TurbulentVariableInitializationTypeKomega.INIT_KOMEGA_VARIABLES
    >>> TurbulentVariableInitializationTypeKomega.INIT_FARFIELD_VALUES_KOMEGA
    """

    INVALID = _clientpb.INVALID_TURBULENT_VARIABLE_INITIALIZATION_TYPE_KOMEGA
    INIT_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA = (
        _clientpb.INIT_TURBULENT_VISCOSITY_RATIO_AND_INTENSITY_KOMEGA
    )
    INIT_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA = (
        _clientpb.INIT_TURBULENT_VISCOSITY_AND_INTENSITY_KOMEGA
    )
    INIT_KOMEGA_VARIABLES = _clientpb.INIT_KOMEGA_VARIABLES
    INIT_FARFIELD_VALUES_KOMEGA = _clientpb.INIT_FARFIELD_VALUES_KOMEGA


class PotentialFlowPressureInitialization(_IntEnum):
    """
    Pressure initialization options when using potential flow initialization.

    Attributes
    ----------
    INITIALIZATION_POTENTIAL_FLOW_PRESSURE_OFF
        Do not initialize the pressure using the potential flow method
    INITIALIZATION_POTENTIAL_FLOW_PRESSURE_ON
        Initialize the pressure using Bernouilli's equation.


    Examples
    --------
    >>> from luminarycloud.params.enum import PotentialFlowPressureInitialization
    >>> PotentialFlowPressureInitialization.INITIALIZATION_POTENTIAL_FLOW_PRESSURE_OFF
    >>> PotentialFlowPressureInitialization.INITIALIZATION_POTENTIAL_FLOW_PRESSURE_ON
    """

    INVALID = _clientpb.INVALID_POTENTIAL_FLOW_PRESSURE_INITIALIZATION
    INITIALIZATION_POTENTIAL_FLOW_PRESSURE_OFF = (
        _clientpb.INITIALIZATION_POTENTIAL_FLOW_PRESSURE_OFF
    )
    INITIALIZATION_POTENTIAL_FLOW_PRESSURE_ON = _clientpb.INITIALIZATION_POTENTIAL_FLOW_PRESSURE_ON


class VerificationSolutions(_IntEnum):
    """
    Predefined verification problems built into the solver.

    Attributes
    ----------
    TAYLOR_GREEN_VORTEX
        Taylor-Green vortex problem.
    NS_MMS
        Method of manufactured solutions (MMS) for the Navier-Stokes equations.
    EULER_MMS
        Method of manufactured solutions (MMS) for the Euler equations.
    SHOCK_TUBE
        Shock tube problem.
    NORMAL_SHOCK
        Normal shock problem.
    SHOCK_VORTEX
        Shock vortex problem.
    SHU_OSHER
        Shu Osher problem.
    DISTURBANCE_WAVE
        Disturbance wave problem.
    INVISCID_VORTEX
        Invisvid vortex transport by uniform flow.
    INS_2D_LATTICE
        2D planar lattice flow for incompressible NS.
    CHECK_FLUX_SYMMETRY
        Run a debug check on the left/right symmetry of fluxes.


    Examples
    --------
    >>> from luminarycloud.params.enum import VerificationSolutions
    >>> VerificationSolutions.TAYLOR_GREEN_VORTEX
    >>> VerificationSolutions.NS_MMS
    >>> VerificationSolutions.EULER_MMS
    >>> VerificationSolutions.SHOCK_TUBE
    >>> VerificationSolutions.NORMAL_SHOCK
    >>> VerificationSolutions.SHOCK_VORTEX
    >>> VerificationSolutions.SHU_OSHER
    >>> VerificationSolutions.DISTURBANCE_WAVE
    >>> VerificationSolutions.INVISCID_VORTEX
    >>> VerificationSolutions.INS_2D_LATTICE
    >>> VerificationSolutions.CHECK_FLUX_SYMMETRY
    """

    INVALID = _clientpb.INVALID_VERIFICATION_SOLUTIONS
    TAYLOR_GREEN_VORTEX = _clientpb.TAYLOR_GREEN_VORTEX
    NS_MMS = _clientpb.NS_MMS
    EULER_MMS = _clientpb.EULER_MMS
    SHOCK_TUBE = _clientpb.SHOCK_TUBE
    NORMAL_SHOCK = _clientpb.NORMAL_SHOCK
    SHOCK_VORTEX = _clientpb.SHOCK_VORTEX
    SHU_OSHER = _clientpb.SHU_OSHER
    DISTURBANCE_WAVE = _clientpb.DISTURBANCE_WAVE
    INVISCID_VORTEX = _clientpb.INVISCID_VORTEX
    INS_2D_LATTICE = _clientpb.INS_2D_LATTICE
    CHECK_FLUX_SYMMETRY = _clientpb.CHECK_FLUX_SYMMETRY


class ActuatorDiskBemStrategy(_IntEnum):
    """
    Defines how the power of the propeller is specified in the blade element model

    Attributes
    ----------
    BEM_ROTATION_RATE
        Prescribes a rotation rate for the fictitious blades.
    BEM_TARGET_THRUST
        The rotation rate specified initially is adjusted to achieve a prescribed target thrust. The final rotation rate is available as a surface output


    Examples
    --------
    >>> from luminarycloud.params.enum import ActuatorDiskBemStrategy
    >>> ActuatorDiskBemStrategy.BEM_ROTATION_RATE
    >>> ActuatorDiskBemStrategy.BEM_TARGET_THRUST
    """

    INVALID = _clientpb.INVALID_ACTUATOR_DISK_BEM_STRATEGY
    BEM_ROTATION_RATE = _clientpb.BEM_ROTATION_RATE
    BEM_TARGET_THRUST = _clientpb.BEM_TARGET_THRUST


class CavitationModel(_IntEnum):
    """
    Cavitation models available for simulating flow with cavitation.

    Attributes
    ----------
    SAUER_SCHNERR
        Sauer-Schnerr one equation cavitation model.


    Examples
    --------
    >>> from luminarycloud.params.enum import CavitationModel
    >>> CavitationModel.SAUER_SCHNERR
    """

    INVALID = _clientpb.INVALID_CAVITATION_MODEL
    SAUER_SCHNERR = _clientpb.SAUER_SCHNERR


class PorousModelType(_IntEnum):
    """
    Type of porous model.

    Attributes
    ----------
    DARCY_FORCHHEIMER
        Darcy Forchheimer model.


    Examples
    --------
    >>> from luminarycloud.params.enum import PorousModelType
    >>> PorousModelType.DARCY_FORCHHEIMER
    """

    INVALID = _clientpb.INVALID_POROUS_MODEL_TYPE
    DARCY_FORCHHEIMER = _clientpb.DARCY_FORCHHEIMER


class MpCouplingLinSolCoupling(_IntEnum):
    """
    Turns on the use of enhanced coupling between the physics, which provides greater robustness at the cost of simulation speed.

    Attributes
    ----------
    MP_COUPLING_LIN_SOL_COUPLING_ON
        Enable enhanced coupling.
    MP_COUPLING_LIN_SOL_COUPLING_OFF
        Disable enhanced coupling.


    Examples
    --------
    >>> from luminarycloud.params.enum import MpCouplingLinSolCoupling
    >>> MpCouplingLinSolCoupling.MP_COUPLING_LIN_SOL_COUPLING_ON
    >>> MpCouplingLinSolCoupling.MP_COUPLING_LIN_SOL_COUPLING_OFF
    """

    INVALID = _clientpb.INVALID_MP_COUPLING_LIN_SOL_COUPLING
    MP_COUPLING_LIN_SOL_COUPLING_ON = _clientpb.MP_COUPLING_LIN_SOL_COUPLING_ON
    MP_COUPLING_LIN_SOL_COUPLING_OFF = _clientpb.MP_COUPLING_LIN_SOL_COUPLING_OFF
