# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class BoundaryLayerProfile(CodeRepr, ParamGroupWrapper[clientpb.BoundaryLayerProfile]):
    """"""

    n_layers: int = 40
    "Maximum number of prism layers within a boundary layer mesh."
    initial_size: LcFloat = 1e-06
    "Size of the mesh layer nearest the boundary surface in meters."
    growth_rate: LcFloat = 1.2
    "Ratio of size between 2 successive boundary mesh layers."
    surfaces: list[str] = field(default_factory=list)
    ""

    def _to_proto(self) -> clientpb.BoundaryLayerProfile:
        _proto = clientpb.BoundaryLayerProfile()
        _proto.n_layers.value = self.n_layers
        _proto.initial_size.CopyFrom(_to_ad_proto(self.initial_size))
        _proto.growth_rate.CopyFrom(_to_ad_proto(self.growth_rate))
        if self.surfaces is not None:
            _proto.surfaces.extend(self.surfaces)
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryLayerProfile) -> None:
        self.n_layers = proto.n_layers.value
        self.initial_size = _from_ad_proto(proto.initial_size)
        self.growth_rate = _from_ad_proto(proto.growth_rate)
        self.surfaces.extend(proto.surfaces)
        return None
