# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.adaptive_mesh_refinement.boundary_layer_profile_ import (
    BoundaryLayerProfile,
)
from luminarycloud.params.simulation.adaptive_mesh_refinement.boundary_layer_profile_ import *


@dataclass(kw_only=True)
class AdaptiveMeshRefinement(CodeRepr, ParamGroupWrapper[clientpb.AdaptiveMeshRefinement]):
    """Adaptive Mesh Refinement"""

    refinement_iterations: int = 0
    "Number of refinement iterations to perform."
    refinement_dispatch_interval: int = 0
    "Number of solver iterations to perform before dispatching refinement."
    max_refinement_interval: int = 0
    "Maximum number of solver iterations to perform before waiting for refinement to complete."
    initial_target_complexity: LcFloat = 0
    "Target Complexity on the first refinement iteration."
    final_target_complexity: LcFloat = 0
    "Target Complexity on the final refinement iteration."
    meshing_method: enum.MeshingMethod = enum.MeshingMethod.MESH_METHOD_MANUAL
    "The method to generate the computational mesh."
    target_cv_millions: int = 10
    "User-requested mesh size in millions of control volumes."
    all_tet: enum.AllTet = enum.AllTet.ALL_TET_ON
    "Automatically inserts high aspect ratio mesh elements in the boundary layer and ignores all adaptation boundary layer settings."
    user_scaling: LcFloat = 1.0
    "Scale factor between the geometry and the mesh."
    boundary_layer_profile: list[BoundaryLayerProfile] = field(default_factory=list)
    ""

    def _to_proto(self) -> clientpb.AdaptiveMeshRefinement:
        _proto = clientpb.AdaptiveMeshRefinement()
        _proto.refinement_iterations.value = self.refinement_iterations
        _proto.refinement_dispatch_interval.value = self.refinement_dispatch_interval
        _proto.max_refinement_interval.value = self.max_refinement_interval
        _proto.initial_target_complexity.CopyFrom(_to_ad_proto(self.initial_target_complexity))
        _proto.final_target_complexity.CopyFrom(_to_ad_proto(self.final_target_complexity))
        _proto.meshing_method = self.meshing_method.value
        _proto.target_cv_millions.value = self.target_cv_millions
        _proto.all_tet = self.all_tet.value
        _proto.user_scaling.CopyFrom(_to_ad_proto(self.user_scaling))
        if self.boundary_layer_profile is not None:
            _proto.boundary_layer_profile.extend(v._to_proto() for v in self.boundary_layer_profile)
        return _proto

    def _from_proto(self, proto: clientpb.AdaptiveMeshRefinement) -> None:
        self.refinement_iterations = proto.refinement_iterations.value
        self.refinement_dispatch_interval = proto.refinement_dispatch_interval.value
        self.max_refinement_interval = proto.max_refinement_interval.value
        self.initial_target_complexity = _from_ad_proto(proto.initial_target_complexity)
        self.final_target_complexity = _from_ad_proto(proto.final_target_complexity)
        self.meshing_method = enum.MeshingMethod(proto.meshing_method)
        self.target_cv_millions = proto.target_cv_millions.value
        self.all_tet = enum.AllTet(proto.all_tet)
        self.user_scaling = _from_ad_proto(proto.user_scaling)
        self.boundary_layer_profile = [
            BoundaryLayerProfile.from_proto(v) for v in proto.boundary_layer_profile
        ]
        return None
