# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class Adjoint(CodeRepr, ParamGroupWrapper[clientpb.Adjoint]):
    """Settings for adjoint sensitivity analysis."""

    _output: Any | None = None
    "Function to differentiate."
    surfaces: list[str] = field(default_factory=list)
    ""
    deformed_coords_id: str = ""
    "Upload ID of the file containing deformed coordinates for design surfaces. Setting this to 'template' instructs the solver to output a file with the current surface coordinates."
    primal_simulation_id: str = ""
    "ID of the primal simulation to differentiate."

    def _to_proto(self) -> clientpb.Adjoint:
        _proto = clientpb.Adjoint()
        if self._output is not None:
            _proto.adjoint_output.CopyFrom(self._output)
        if self.surfaces is not None:
            _proto.surfaces.extend(self.surfaces)
        if self.deformed_coords_id is not None:
            _proto.deformed_coords_id = self.deformed_coords_id
        if self.primal_simulation_id is not None:
            _proto.primal_simulation_id = self.primal_simulation_id
        return _proto

    def _from_proto(self, proto: clientpb.Adjoint) -> None:
        self._output = proto.adjoint_output
        self.surfaces.extend(proto.surfaces)
        self.deformed_coords_id = proto.deformed_coords_id
        self.primal_simulation_id = proto.primal_simulation_id
        return None
