# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.basic.gravity_ import Gravity
from luminarycloud.params.simulation.basic.gravity_ import *
from luminarycloud.params.simulation.basic.gravity.gravity_off_ import GravityOff
from luminarycloud.params.simulation.basic.gravity.gravity_off_ import *
from luminarycloud.params.simulation.basic.gravity.gravity_on_ import GravityOn
from luminarycloud.params.simulation.basic.gravity.gravity_on_ import *


@dataclass(kw_only=True)
class General(CodeRepr, ParamGroupWrapper[clientpb.General]):
    """Basic parameters used by a solution."""

    simulation_type: enum.FloatType = enum.FloatType.DOUBLE
    "Type of equations solved for the physics."
    gravity: Gravity = field(default_factory=GravityOff)
    "Apply an acceleration due to gravity or other body force. Possible types: ``GravityOff``, ``GravityOn`` from the ``gravity`` module."
    time: enum.FlowBehavior = enum.FlowBehavior.STEADY
    "Importance of physical time for the current simulation."

    def _to_proto(self) -> clientpb.General:
        _proto = clientpb.General()
        _proto.float_type = self.simulation_type.value
        if isinstance(self.gravity, GravityOff):
            _proto.gravity = clientpb.GRAVITY_OFF
        if isinstance(self.gravity, GravityOn):
            _proto.gravity = clientpb.GRAVITY_ON
            _proto.acceleration.CopyFrom(self.gravity.acceleration._to_ad_proto())
        _proto.flow_behavior = self.time.value
        return _proto

    def _from_proto(self, proto: clientpb.General) -> None:
        self.simulation_type = enum.FloatType(proto.float_type)
        if proto.gravity == clientpb.INVALID_GRAVITY:
            raise ValueError("Invalid gravity")
        elif proto.gravity == clientpb.GRAVITY_OFF:
            self.gravity = GravityOff()
        elif proto.gravity == clientpb.GRAVITY_ON:
            self.gravity = GravityOn()
            self.gravity.acceleration._from_ad_proto(proto.acceleration)
        self.time = enum.FlowBehavior(proto.flow_behavior)
        return None
