# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.material.fluid.boussinesq_approximation_ import (
    BoussinesqApproximation,
)
from luminarycloud.params.simulation.material.fluid.boussinesq_approximation_ import *
from luminarycloud.params.simulation.material.fluid.boussinesq_approximation.boussinesq_off_ import (
    BoussinesqOff,
)
from luminarycloud.params.simulation.material.fluid.boussinesq_approximation.boussinesq_off_ import *
from luminarycloud.params.simulation.material.fluid.boussinesq_approximation.boussinesq_on_ import (
    BoussinesqOn,
)
from luminarycloud.params.simulation.material.fluid.boussinesq_approximation.boussinesq_on_ import *
from luminarycloud.params.simulation.material.fluid.material_model.ideal_gas_ import IdealGas
from luminarycloud.params.simulation.material.fluid.material_model.ideal_gas_ import *
from luminarycloud.params.simulation.material.fluid.material_model.incompressible_fluid_ import (
    IncompressibleFluid,
)
from luminarycloud.params.simulation.material.fluid.material_model.incompressible_fluid_ import *
from luminarycloud.params.simulation.material.fluid.material_model.incompressible_fluid_with_energy_ import (
    IncompressibleFluidWithEnergy,
)
from luminarycloud.params.simulation.material.fluid.material_model.incompressible_fluid_with_energy_ import *
from luminarycloud.params.simulation.material.fluid.material_model_ import MaterialModel
from luminarycloud.params.simulation.material.fluid.material_model_ import *
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model.prescribed_conductivity_ import (
    PrescribedConductivity,
)
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model.prescribed_conductivity_ import *
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model.prescribed_prandtl_number_ import (
    PrescribedPrandtlNumber,
)
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model.prescribed_prandtl_number_ import *
from luminarycloud.params.simulation.material.fluid.viscosity_model.prescribed_viscosity_ import (
    PrescribedViscosity,
)
from luminarycloud.params.simulation.material.fluid.viscosity_model.prescribed_viscosity_ import *
from luminarycloud.params.simulation.material.fluid.viscosity_model.sutherland_ import Sutherland
from luminarycloud.params.simulation.material.fluid.viscosity_model.sutherland_ import *
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model.temperature_dependent_conductivity_ import (
    TemperatureDependentConductivity,
)
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model.temperature_dependent_conductivity_ import *
from luminarycloud.params.simulation.material.fluid.viscosity_model.temperature_dependent_viscosity_ import (
    TemperatureDependentViscosity,
)
from luminarycloud.params.simulation.material.fluid.viscosity_model.temperature_dependent_viscosity_ import *
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model_ import (
    ThermalConductivityModel,
)
from luminarycloud.params.simulation.material.fluid.thermal_conductivity_model_ import *
from luminarycloud.params.simulation.material.fluid.viscosity_model_ import ViscosityModel
from luminarycloud.params.simulation.material.fluid.viscosity_model_ import *


@dataclass(kw_only=True)
class MaterialFluid(CodeRepr, ParamGroupWrapper[clientpb.MaterialFluid]):
    """Configuration for Fluid materials"""

    reference_pressure: LcFloat = 0.0
    "Reference pressure for the simulation. Unless otherwise stated, all pressure values are relative to this field (i.e. gauge pressures)."
    material_model: MaterialModel = field(default_factory=IdealGas)
    "Material model. Possible types: ``IdealGas``, ``IncompressibleFluid``, ``IncompressibleFluidWithEnergy`` from the ``material_model`` module."
    thermal_conductivity_model: ThermalConductivityModel = field(
        default_factory=PrescribedPrandtlNumber
    )
    "Model for the laminar thermal conductivity of a fluid. Possible types: ``PrescribedPrandtlNumber``, ``PrescribedConductivity``, ``TemperatureDependentConductivity`` from the ``thermal_conductivity_model`` module."
    boussinesq_approximation: BoussinesqApproximation = field(default_factory=BoussinesqOn)
    "Introduce a body force due to thermal expansion without modifying the material density. Possible types: ``BoussinesqOff``, ``BoussinesqOn`` from the ``boussinesq_approximation`` module."
    preset: enum.MaterialFluidPreset = enum.MaterialFluidPreset.STANDARD_AIR
    "Select a predefined set of material properties or allow a custom set of properties."
    viscosity_model: ViscosityModel = field(default_factory=Sutherland)
    "Models available for the dynamic viscosity of the fluid. Possible types: ``Sutherland``, ``PrescribedViscosity``, ``TemperatureDependentViscosity`` from the ``viscosity_model`` module."

    def _to_proto(self) -> clientpb.MaterialFluid:
        _proto = clientpb.MaterialFluid()
        _proto.reference_pressure.CopyFrom(_to_ad_proto(self.reference_pressure))
        if isinstance(self.material_model, IdealGas):
            _proto.density_relationship = clientpb.IDEAL_GAS
            _proto.molecular_weight.CopyFrom(_to_ad_proto(self.material_model.molecular_weight))
            _proto.specific_heat_cp.CopyFrom(_to_ad_proto(self.material_model.specific_heat_cp))
        if isinstance(self.material_model, IncompressibleFluid):
            _proto.density_relationship = clientpb.CONSTANT_DENSITY
            _proto.constant_density_value.CopyFrom(_to_ad_proto(self.material_model.density))
        if isinstance(self.material_model, IncompressibleFluidWithEnergy):
            _proto.density_relationship = clientpb.CONSTANT_DENSITY_ENERGY
            _proto.constant_density_value.CopyFrom(_to_ad_proto(self.material_model.density))
            _proto.specific_heat_cp.CopyFrom(_to_ad_proto(self.material_model.specific_heat_cp))
        if isinstance(self.thermal_conductivity_model, PrescribedPrandtlNumber):
            _proto.laminar_thermal_conductivity = clientpb.LAMINAR_CONSTANT_THERMAL_PRANDTL
            _proto.laminar_constant_thermal_prandtl_constant.CopyFrom(
                _to_ad_proto(self.thermal_conductivity_model.prandtl_number)
            )
        if isinstance(self.thermal_conductivity_model, PrescribedConductivity):
            _proto.laminar_thermal_conductivity = clientpb.LAMINAR_CONSTANT_THERMAL_CONDUCTIVITY
            _proto.laminar_constant_thermal_conductivity_constant.CopyFrom(
                _to_ad_proto(self.thermal_conductivity_model.conductivity)
            )
        if isinstance(self.thermal_conductivity_model, TemperatureDependentConductivity):
            _proto.laminar_thermal_conductivity = (
                clientpb.TEMPERATURE_DEPENDENT_THERMAL_CONDUCTIVITY
            )
            if self.thermal_conductivity_model.conductivity_table is not None:
                if (
                    self.thermal_conductivity_model.conductivity_table.table_type
                    != _param_name_to_table_type("thermal_conductivity_table_data")
                ):
                    raise TypeError(
                        "Wrong TableType used for self.thermal_conductivity_model.conductivity_table"
                    )
                _proto.thermal_conductivity_table_data = (
                    self.thermal_conductivity_model.conductivity_table.id
                )
        if isinstance(self.boussinesq_approximation, BoussinesqOff):
            _proto.boussinesq_approximation = clientpb.BOUSSINESQ_OFF
        if isinstance(self.boussinesq_approximation, BoussinesqOn):
            _proto.boussinesq_approximation = clientpb.BOUSSINESQ_ON
            _proto.boussinesq_temp_ref.CopyFrom(
                _to_ad_proto(self.boussinesq_approximation.reference_temperature)
            )
            _proto.thermal_expansion_coefficient.CopyFrom(
                _to_ad_proto(self.boussinesq_approximation.thermal_expansion_coefficient)
            )
        _proto.material_fluid_preset = self.preset.value
        if isinstance(self.viscosity_model, Sutherland):
            _proto.laminar_viscosity_model_newtonian = clientpb.SUTHERLAND
            _proto.sutherland_viscosity_ref.CopyFrom(
                _to_ad_proto(self.viscosity_model.reference_viscosity)
            )
            _proto.sutherland_viscosity_temp_ref.CopyFrom(
                _to_ad_proto(self.viscosity_model.reference_temperature)
            )
            _proto.sutherland_constant.CopyFrom(
                _to_ad_proto(self.viscosity_model.sutherland_constant)
            )
        if isinstance(self.viscosity_model, PrescribedViscosity):
            _proto.laminar_viscosity_model_newtonian = clientpb.LAMINAR_CONSTANT_VISCOSITY
            _proto.laminar_constant_viscosity_constant.CopyFrom(
                _to_ad_proto(self.viscosity_model.viscosity)
            )
        if isinstance(self.viscosity_model, TemperatureDependentViscosity):
            _proto.laminar_viscosity_model_newtonian = (
                clientpb.TEMPERATURE_DEPENDENT_LAMINAR_VISCOSITY
            )
            if self.viscosity_model.viscosity_table is not None:
                if self.viscosity_model.viscosity_table.table_type != _param_name_to_table_type(
                    "dynamic_viscosity_table_data"
                ):
                    raise TypeError("Wrong TableType used for self.viscosity_model.viscosity_table")
                _proto.dynamic_viscosity_table_data = self.viscosity_model.viscosity_table.id
        return _proto

    def _from_proto(self, proto: clientpb.MaterialFluid) -> None:
        self.reference_pressure = _from_ad_proto(proto.reference_pressure)
        if proto.density_relationship == clientpb.INVALID_DENSITY_RELATIONSHIP:
            raise ValueError("Invalid material_model")
        elif proto.density_relationship == clientpb.IDEAL_GAS:
            self.material_model = IdealGas()
            self.material_model.molecular_weight = _from_ad_proto(proto.molecular_weight)
            self.material_model.specific_heat_cp = _from_ad_proto(proto.specific_heat_cp)
        elif proto.density_relationship == clientpb.CONSTANT_DENSITY:
            self.material_model = IncompressibleFluid()
            self.material_model.density = _from_ad_proto(proto.constant_density_value)
        elif proto.density_relationship == clientpb.CONSTANT_DENSITY_ENERGY:
            self.material_model = IncompressibleFluidWithEnergy()
            self.material_model.density = _from_ad_proto(proto.constant_density_value)
            self.material_model.specific_heat_cp = _from_ad_proto(proto.specific_heat_cp)
        if proto.laminar_thermal_conductivity == clientpb.INVALID_LAMINAR_THERMAL_CONDUCTIVITY:
            raise ValueError("Invalid thermal_conductivity_model")
        elif proto.laminar_thermal_conductivity == clientpb.LAMINAR_CONSTANT_THERMAL_PRANDTL:
            self.thermal_conductivity_model = PrescribedPrandtlNumber()
            self.thermal_conductivity_model.prandtl_number = _from_ad_proto(
                proto.laminar_constant_thermal_prandtl_constant
            )
        elif proto.laminar_thermal_conductivity == clientpb.LAMINAR_CONSTANT_THERMAL_CONDUCTIVITY:
            self.thermal_conductivity_model = PrescribedConductivity()
            self.thermal_conductivity_model.conductivity = _from_ad_proto(
                proto.laminar_constant_thermal_conductivity_constant
            )
        elif (
            proto.laminar_thermal_conductivity
            == clientpb.TEMPERATURE_DEPENDENT_THERMAL_CONDUCTIVITY
        ):
            self.thermal_conductivity_model = TemperatureDependentConductivity()
            if proto.thermal_conductivity_table_data != "":
                self.thermal_conductivity_model.conductivity_table = RectilinearTable(
                    id=proto.thermal_conductivity_table_data,
                    name=proto.thermal_conductivity_table_data,
                    table_type=_param_name_to_table_type("thermal_conductivity_table_data"),
                )
        if proto.boussinesq_approximation == clientpb.INVALID_BOUSSINESQ_APPROXIMATION:
            raise ValueError("Invalid boussinesq_approximation")
        elif proto.boussinesq_approximation == clientpb.BOUSSINESQ_OFF:
            self.boussinesq_approximation = BoussinesqOff()
        elif proto.boussinesq_approximation == clientpb.BOUSSINESQ_ON:
            self.boussinesq_approximation = BoussinesqOn()
            self.boussinesq_approximation.reference_temperature = _from_ad_proto(
                proto.boussinesq_temp_ref
            )
            self.boussinesq_approximation.thermal_expansion_coefficient = _from_ad_proto(
                proto.thermal_expansion_coefficient
            )
        self.preset = enum.MaterialFluidPreset(proto.material_fluid_preset)
        if (
            proto.laminar_viscosity_model_newtonian
            == clientpb.INVALID_LAMINAR_VISCOSITY_MODEL_NEWTONIAN
        ):
            raise ValueError("Invalid viscosity_model")
        elif proto.laminar_viscosity_model_newtonian == clientpb.SUTHERLAND:
            self.viscosity_model = Sutherland()
            self.viscosity_model.reference_viscosity = _from_ad_proto(
                proto.sutherland_viscosity_ref
            )
            self.viscosity_model.reference_temperature = _from_ad_proto(
                proto.sutherland_viscosity_temp_ref
            )
            self.viscosity_model.sutherland_constant = _from_ad_proto(proto.sutherland_constant)
        elif proto.laminar_viscosity_model_newtonian == clientpb.LAMINAR_CONSTANT_VISCOSITY:
            self.viscosity_model = PrescribedViscosity()
            self.viscosity_model.viscosity = _from_ad_proto(
                proto.laminar_constant_viscosity_constant
            )
        elif (
            proto.laminar_viscosity_model_newtonian
            == clientpb.TEMPERATURE_DEPENDENT_LAMINAR_VISCOSITY
        ):
            self.viscosity_model = TemperatureDependentViscosity()
            if proto.dynamic_viscosity_table_data != "":
                self.viscosity_model.viscosity_table = RectilinearTable(
                    id=proto.dynamic_viscosity_table_data,
                    name=proto.dynamic_viscosity_table_data,
                    table_type=_param_name_to_table_type("dynamic_viscosity_table_data"),
                )
        return None
