# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class MaterialSolid(CodeRepr, ParamGroupWrapper[clientpb.MaterialSolid]):
    """Configuration for Solid materials"""

    density: LcFloat = 2700
    "Constant density value."
    specific_heat_cp: LcFloat = 896
    "Specific heat."
    conductivity_model: enum.ThermalConductivityModelSolid = (
        enum.ThermalConductivityModelSolid.ISOTROPIC_CONDUCTIVITY
    )
    "Uniform or direction-dependent conductivity models."
    thermal_conductivity: LcFloat = 167
    "The thermal conductivity of the material."
    orthotropic_conductivity: Vector3 = field(default_factory=lambda: Vector3(167, 167, 167))
    "The thermal conductivities of the material along each axis."
    thermal_conductivity_table: RectilinearTable | None = None
    "Correlation between thermal conductivity and temperature."
    preset: enum.MaterialSolidPreset = enum.MaterialSolidPreset.ALUMINUM
    "Select a predefined set of material properties or allow a custom set of properties."

    def _to_proto(self) -> clientpb.MaterialSolid:
        _proto = clientpb.MaterialSolid()
        _proto.constant_density_value_solid.CopyFrom(_to_ad_proto(self.density))
        _proto.specific_heat_cp_solid.CopyFrom(_to_ad_proto(self.specific_heat_cp))
        _proto.thermal_conductivity_model_solid = self.conductivity_model.value
        _proto.thermal_conductivity_constant_solid.CopyFrom(_to_ad_proto(self.thermal_conductivity))
        _proto.thermal_conductivity_orthotropic_solid.CopyFrom(
            self.orthotropic_conductivity._to_ad_proto()
        )
        if self.thermal_conductivity_table is not None:
            if self.thermal_conductivity_table.table_type != _param_name_to_table_type(
                "thermal_conductivity_table_data"
            ):
                raise TypeError("Wrong TableType used for self.thermal_conductivity_table")
            _proto.thermal_conductivity_table_data = self.thermal_conductivity_table.id
        _proto.material_solid_preset = self.preset.value
        return _proto

    def _from_proto(self, proto: clientpb.MaterialSolid) -> None:
        self.density = _from_ad_proto(proto.constant_density_value_solid)
        self.specific_heat_cp = _from_ad_proto(proto.specific_heat_cp_solid)
        self.conductivity_model = enum.ThermalConductivityModelSolid(
            proto.thermal_conductivity_model_solid
        )
        self.thermal_conductivity = _from_ad_proto(proto.thermal_conductivity_constant_solid)
        self.orthotropic_conductivity._from_ad_proto(proto.thermal_conductivity_orthotropic_solid)
        if proto.thermal_conductivity_table_data != "":
            self.thermal_conductivity_table = RectilinearTable(
                id=proto.thermal_conductivity_table_data,
                name=proto.thermal_conductivity_table_data,
                table_type=_param_name_to_table_type("thermal_conductivity_table_data"),
            )
        self.preset = enum.MaterialSolidPreset(proto.material_solid_preset)
        return None
