# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.material.material_fluid_ import MaterialFluid
from luminarycloud.params.simulation.material.material_fluid_ import *
from luminarycloud.params.simulation.material.material_solid_ import MaterialSolid
from luminarycloud.params.simulation.material.material_solid_ import *


@dataclass(kw_only=True)
class MaterialEntity(CodeRepr, ParamGroupWrapper[clientpb.MaterialEntity]):
    """Material entity."""

    material_identifier: EntityIdentifier = field(
        default_factory=_create_entity_identifier, init=True
    )
    "Unique identifier for a material entity."
    fluid: MaterialFluid | None = None
    "Configuration for Fluid materials."
    solid: MaterialSolid | None = None
    "Configuration for Solid materials."

    def _to_proto(self) -> clientpb.MaterialEntity:
        _proto = clientpb.MaterialEntity()
        if self.material_identifier is not None:
            _proto.material_identifier.id = self.material_identifier.id
            _proto.material_identifier.name = self.material_identifier.name
        if self.fluid is not None:
            _proto.material_fluid.CopyFrom(self.fluid._to_proto())
        if self.solid is not None:
            _proto.material_solid.CopyFrom(self.solid._to_proto())
        return _proto

    def _from_proto(self, proto: clientpb.MaterialEntity) -> None:
        self.material_identifier = proto.material_identifier
        if proto.material_fluid.ByteSize() > 0:
            self.fluid = MaterialFluid.from_proto(proto.material_fluid)
        if proto.material_solid.ByteSize() > 0:
            self.solid = MaterialSolid.from_proto(proto.material_solid)
        return None
