# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class MonitorPlane(CodeRepr, ParamGroupWrapper[clientpb.MonitorPlane]):
    """Monitor plane."""

    id: str = field(default_factory=create_unique_id, init=False)
    ""
    name: str = ""
    ""
    point: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "A point on the plane."
    normal: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 1.0))
    "A vector normal to the plane."
    enable_box_clip: bool = False
    "Turn on or off the ability to clip a monitor plane using a box."
    box_center: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "Center of the box used to clip the monitor plane."
    box_side_lengths: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "Side lengths of the box used to clip the monitor plane."
    box_rotation_angles: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "Rotation vector of Euler angles (XYZ order) that transforms the box used to clip the monitor plane."
    enable_volume_clip: bool = False
    "Turn on or off the ability to constrain a monitor plane to specific volumes of the geometry."
    volumes: list[EntityIdentifier] = field(default_factory=list)
    "List of volumes used to clip the monitor plane."

    def _to_proto(self) -> clientpb.MonitorPlane:
        _proto = clientpb.MonitorPlane()
        if self.id is not None:
            _proto.monitor_plane_id = self.id
        if self.name is not None:
            _proto.monitor_plane_name = self.name
        _proto.monitor_plane_point.CopyFrom(self.point._to_ad_proto())
        _proto.monitor_plane_normal.CopyFrom(self.normal._to_ad_proto())
        _proto.monitor_plane_box_clip = self.enable_box_clip
        _proto.monitor_plane_clip_center.CopyFrom(self.box_center._to_ad_proto())
        _proto.monitor_plane_clip_size.CopyFrom(self.box_side_lengths._to_ad_proto())
        _proto.monitor_plane_clip_rotation.CopyFrom(self.box_rotation_angles._to_ad_proto())
        _proto.monitor_plane_volume_clip = self.enable_volume_clip
        if self.volumes is not None:
            _proto.monitor_plane_volumes.extend(self.volumes)
        return _proto

    def _from_proto(self, proto: clientpb.MonitorPlane) -> None:
        self.id = proto.monitor_plane_id
        self.name = proto.monitor_plane_name
        self.point._from_ad_proto(proto.monitor_plane_point)
        self.normal._from_ad_proto(proto.monitor_plane_normal)
        self.enable_box_clip = proto.monitor_plane_box_clip
        self.box_center._from_ad_proto(proto.monitor_plane_clip_center)
        self.box_side_lengths._from_ad_proto(proto.monitor_plane_clip_size)
        self.box_rotation_angles._from_ad_proto(proto.monitor_plane_clip_rotation)
        self.enable_volume_clip = proto.monitor_plane_volume_clip
        self.volumes.extend(proto.monitor_plane_volumes)
        return None
