# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.motion_data.motion_type.constant_angular_motion_ import (
    ConstantAngularMotion,
)
from luminarycloud.params.simulation.motion_data.motion_type.constant_angular_motion_ import *
from luminarycloud.params.simulation.motion_data.motion_type.constant_translation_motion_ import (
    ConstantTranslationMotion,
)
from luminarycloud.params.simulation.motion_data.motion_type.constant_translation_motion_ import *
from luminarycloud.params.simulation.motion_data.frame_transforms_ import FrameTransforms
from luminarycloud.params.simulation.motion_data.frame_transforms_ import *
from luminarycloud.params.simulation.motion_data.motion_type_ import MotionType
from luminarycloud.params.simulation.motion_data.motion_type_ import *
from luminarycloud.params.simulation.motion_data.frame_transforms.no_transform_ import NoTransform
from luminarycloud.params.simulation.motion_data.frame_transforms.no_transform_ import *
from luminarycloud.params.simulation.motion_data.frame_transforms.rotational_transform_ import (
    RotationalTransform,
)
from luminarycloud.params.simulation.motion_data.frame_transforms.rotational_transform_ import *
from luminarycloud.params.simulation.motion_data.frame_transforms.translational_transform_ import (
    TranslationalTransform,
)
from luminarycloud.params.simulation.motion_data.frame_transforms.translational_transform_ import *


@dataclass(kw_only=True)
class MotionData(CodeRepr, ParamGroupWrapper[clientpb.MotionData]):
    """Motion data."""

    frame_id: str = ""
    "ID of the Coordinate Frame."
    frame_name: str = ""
    "Name of the Coordinate Frame."
    frame_parent: str = ""
    "ID of the parent frame."
    attached_domains: list[str] = field(default_factory=list)
    "Domains that are attached to this frame."
    attached_boundaries: list[str] = field(default_factory=list)
    "Surfaces that are attached to this frame."
    motion_type: MotionType | None = None
    "Type of the Motion. Possible types: ``ConstantTranslationMotion``, ``ConstantAngularMotion`` from the ``motion_type`` module."
    frame_transforms: list[FrameTransforms] = field(default_factory=list)
    "Type of the Transformation. Possible types: ``NoTransform``, ``RotationalTransform``, ``TranslationalTransform`` from the ``frame_transforms`` module."

    def _to_proto(self) -> clientpb.MotionData:
        _proto = clientpb.MotionData()
        if self.frame_id is not None:
            _proto.frame_id = self.frame_id
        if self.frame_name is not None:
            _proto.frame_name = self.frame_name
        if self.frame_parent is not None:
            _proto.frame_parent = self.frame_parent
        if self.attached_domains is not None:
            _proto.attached_domains.extend(self.attached_domains)
        if self.attached_boundaries is not None:
            _proto.attached_boundaries.extend(self.attached_boundaries)
        if self.motion_type is None:
            _proto.motion_type = clientpb.NO_MOTION
        if isinstance(self.motion_type, ConstantTranslationMotion):
            _proto.motion_type = clientpb.CONSTANT_TRANSLATION_MOTION
            _proto.motion_formulation = self.motion_type.motion_formulation.value
            _proto.motion_translation_velocity.CopyFrom(
                self.motion_type.translation_velocity._to_ad_proto()
            )
            _proto.motion_translation.CopyFrom(self.motion_type.translation._to_ad_proto())
        if isinstance(self.motion_type, ConstantAngularMotion):
            _proto.motion_type = clientpb.CONSTANT_ANGULAR_MOTION
            _proto.motion_formulation = self.motion_type.motion_formulation.value
            _proto.motion_angular_velocity.CopyFrom(
                self.motion_type.angular_velocity._to_ad_proto()
            )
            _proto.motion_rotation_angles.CopyFrom(self.motion_type.rotation_angles._to_ad_proto())
        if self.frame_transforms is not None:
            _proto.frame_transforms.extend(v._to_proto() for v in self.frame_transforms)
        return _proto

    def _from_proto(self, proto: clientpb.MotionData) -> None:
        self.frame_id = proto.frame_id
        self.frame_name = proto.frame_name
        self.frame_parent = proto.frame_parent
        self.attached_domains.extend(proto.attached_domains)
        self.attached_boundaries.extend(proto.attached_boundaries)
        if proto.motion_type == clientpb.INVALID_MOTION_TYPE:
            raise ValueError("Invalid motion_type")
        elif proto.motion_type == clientpb.NO_MOTION:
            self.motion_type = None
        elif proto.motion_type == clientpb.CONSTANT_TRANSLATION_MOTION:
            self.motion_type = ConstantTranslationMotion()
            self.motion_type.motion_formulation = enum.MotionFormulation(proto.motion_formulation)
            self.motion_type.translation_velocity._from_ad_proto(proto.motion_translation_velocity)
            self.motion_type.translation._from_ad_proto(proto.motion_translation)
        elif proto.motion_type == clientpb.CONSTANT_ANGULAR_MOTION:
            self.motion_type = ConstantAngularMotion()
            self.motion_type.motion_formulation = enum.MotionFormulation(proto.motion_formulation)
            self.motion_type.angular_velocity._from_ad_proto(proto.motion_angular_velocity)
            self.motion_type.rotation_angles._from_ad_proto(proto.motion_rotation_angles)
        for proto_frame_transforms in proto.frame_transforms:
            if proto_frame_transforms.transform_type == clientpb.INVALID_TRANSFORM_TYPE:
                raise ValueError("Invalid frame_transforms")
            elif proto_frame_transforms.transform_type == clientpb.NO_TRANSFORM:
                self.frame_transforms.append(NoTransform())
                self.frame_transforms[-1]._from_proto(proto_frame_transforms)
            elif proto_frame_transforms.transform_type == clientpb.ROTATIONAL_TRANSFORM:
                self.frame_transforms.append(RotationalTransform())
                self.frame_transforms[-1]._from_proto(proto_frame_transforms)
            elif proto_frame_transforms.transform_type == clientpb.TRANSLATIONAL_TRANSFORM:
                self.frame_transforms.append(TranslationalTransform())
                self.frame_transforms[-1]._from_proto(proto_frame_transforms)
        return None
