# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.particle_group.particle_group_type.actuator_disk_ import (
    ActuatorDisk,
)
from luminarycloud.params.simulation.particle_group.particle_group_type.actuator_disk_ import *
from luminarycloud.params.simulation.particle_group.particle_group_type.actuator_line_ import (
    ActuatorLine,
)
from luminarycloud.params.simulation.particle_group.particle_group_type.actuator_line_ import *
from luminarycloud.params.simulation.particle_group.particle_group_type_ import ParticleGroupType
from luminarycloud.params.simulation.particle_group.particle_group_type_ import *
from luminarycloud.params.simulation.particle_group.particle_group_type.probe_points_ import (
    ProbePoints,
)
from luminarycloud.params.simulation.particle_group.particle_group_type.probe_points_ import *
from luminarycloud.params.simulation.particle_group.particle_group_type.source_points_ import (
    SourcePoints,
)
from luminarycloud.params.simulation.particle_group.particle_group_type.source_points_ import *


@dataclass(kw_only=True)
class ParticleGroup(CodeRepr, ParamGroupWrapper[clientpb.ParticleGroup]):
    """Particle groups."""

    id: str = field(default_factory=create_unique_id, init=False)
    ""
    name: str = ""
    ""
    particle_group_behavior_model_ref: str = ""
    ""
    particle_group_type: ParticleGroupType = field(default_factory=ActuatorDisk)
    "Defines the behavior of the particles. Possible types: ``ActuatorDisk``, ``ActuatorLine``, ``SourcePoints``, ``ProbePoints`` from the ``particle_group_type`` module."

    def _to_proto(self) -> clientpb.ParticleGroup:
        _proto = clientpb.ParticleGroup()
        if self.id is not None:
            _proto.particle_group_id = self.id
        if self.name is not None:
            _proto.particle_group_name = self.name
        if self.particle_group_behavior_model_ref is not None:
            _proto.particle_group_behavior_model_ref = self.particle_group_behavior_model_ref
        if isinstance(self.particle_group_type, ActuatorDisk):
            _proto.particle_group_type = clientpb.ACTUATOR_DISK
            _proto.actuator_disk_inner_radius.CopyFrom(
                _to_ad_proto(self.particle_group_type.inner_radius)
            )
            _proto.actuator_disk_outer_radius.CopyFrom(
                _to_ad_proto(self.particle_group_type.outer_radius)
            )
            _proto.actuator_disk_center.CopyFrom(self.particle_group_type.center._to_ad_proto())
            if isinstance(
                self.particle_group_type.actuator_disk_orientation_selection,
                ActuatorDiskSpecifyRotationAngles,
            ):
                _proto.actuator_disk_orientation_selection = (
                    clientpb.ACTUATOR_DISK_SPECIFY_ROTATION_ANGLES
                )
                _proto.actuator_disk_rotation_angle.CopyFrom(
                    self.particle_group_type.actuator_disk_orientation_selection.rotation_angles._to_ad_proto()
                )
            if isinstance(
                self.particle_group_type.actuator_disk_orientation_selection,
                ActuatorDiskSpecifyNormalVector,
            ):
                _proto.actuator_disk_orientation_selection = (
                    clientpb.ACTUATOR_DISK_SPECIFY_NORMAL_VECTOR
                )
                _proto.actuator_disk_normal_vector.CopyFrom(
                    self.particle_group_type.actuator_disk_orientation_selection.normal._to_ad_proto()
                )
        if isinstance(self.particle_group_type, ActuatorLine):
            _proto.particle_group_type = clientpb.ACTUATOR_LINE
        if isinstance(self.particle_group_type, SourcePoints):
            _proto.particle_group_type = clientpb.SOURCE_POINTS
            if self.particle_group_type.particle_positions_table is not None:
                if (
                    self.particle_group_type.particle_positions_table.table_type
                    != _param_name_to_table_type("particle_positions_table")
                ):
                    raise TypeError(
                        "Wrong TableType used for self.particle_group_type.particle_positions_table"
                    )
                _proto.particle_positions_table = (
                    self.particle_group_type.particle_positions_table.id
                )
        if isinstance(self.particle_group_type, ProbePoints):
            _proto.particle_group_type = clientpb.PROBE_POINTS
            if self.particle_group_type.particle_positions_table is not None:
                if (
                    self.particle_group_type.particle_positions_table.table_type
                    != _param_name_to_table_type("particle_positions_table")
                ):
                    raise TypeError(
                        "Wrong TableType used for self.particle_group_type.particle_positions_table"
                    )
                _proto.particle_positions_table = (
                    self.particle_group_type.particle_positions_table.id
                )
        return _proto

    def _from_proto(self, proto: clientpb.ParticleGroup) -> None:
        self.id = proto.particle_group_id
        self.name = proto.particle_group_name
        self.particle_group_behavior_model_ref = proto.particle_group_behavior_model_ref
        if proto.particle_group_type == clientpb.INVALID_PARTICLE_GROUP_TYPE:
            raise ValueError("Invalid particle_group_type")
        elif proto.particle_group_type == clientpb.ACTUATOR_DISK:
            self.particle_group_type = ActuatorDisk()
            self.particle_group_type.inner_radius = _from_ad_proto(proto.actuator_disk_inner_radius)
            self.particle_group_type.outer_radius = _from_ad_proto(proto.actuator_disk_outer_radius)
            self.particle_group_type.center._from_ad_proto(proto.actuator_disk_center)
            if (
                proto.actuator_disk_orientation_selection
                == clientpb.INVALID_ACTUATOR_DISK_ORIENTATION_SELECTION
            ):
                raise ValueError("Invalid actuator_disk_orientation_selection")
            elif (
                proto.actuator_disk_orientation_selection
                == clientpb.ACTUATOR_DISK_SPECIFY_ROTATION_ANGLES
            ):
                self.particle_group_type.actuator_disk_orientation_selection = (
                    ActuatorDiskSpecifyRotationAngles()
                )
                self.particle_group_type.actuator_disk_orientation_selection.rotation_angles._from_ad_proto(
                    proto.actuator_disk_rotation_angle
                )
            elif (
                proto.actuator_disk_orientation_selection
                == clientpb.ACTUATOR_DISK_SPECIFY_NORMAL_VECTOR
            ):
                self.particle_group_type.actuator_disk_orientation_selection = (
                    ActuatorDiskSpecifyNormalVector()
                )
                self.particle_group_type.actuator_disk_orientation_selection.normal._from_ad_proto(
                    proto.actuator_disk_normal_vector
                )
        elif proto.particle_group_type == clientpb.ACTUATOR_LINE:
            self.particle_group_type = ActuatorLine()
        elif proto.particle_group_type == clientpb.SOURCE_POINTS:
            self.particle_group_type = SourcePoints()
            if proto.particle_positions_table != "":
                self.particle_group_type.particle_positions_table = RectilinearTable(
                    id=proto.particle_positions_table,
                    name=proto.particle_positions_table,
                    table_type=_param_name_to_table_type("particle_positions_table"),
                )
        elif proto.particle_group_type == clientpb.PROBE_POINTS:
            self.particle_group_type = ProbePoints()
            if proto.particle_positions_table != "":
                self.particle_group_type.particle_positions_table = RectilinearTable(
                    id=proto.particle_positions_table,
                    name=proto.particle_positions_table,
                    table_type=_param_name_to_table_type("particle_positions_table"),
                )
        return None
