# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import (
    BoundaryConditionsFluid,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.turbulence_boundary_conditions_ import (
    TurbulenceBoundaryConditions,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.turbulence_boundary_conditions_ import *


@dataclass(kw_only=True)
class Farfield(BoundaryConditionsFluid):
    """Farfield boundary condition."""

    momentum: enum.FarfieldMomentum = enum.FarfieldMomentum.FARFIELD_MACH_NUMBER
    "Method of defining the farfield momentum conditions."
    mach_number: LcFloat = 0.5
    "Mach number at the boundary."
    velocity: LcFloat = 1.0
    "Velocity magnitude at the boundary."
    pressure: LcFloat = 101325
    "Static pressure at the boundary relative to the material reference pressure."
    temperature: LcFloat = 288.15
    "Static temperature at the boundary."
    direction_specification: enum.FarFieldFlowDirectionSpecification = (
        enum.FarFieldFlowDirectionSpecification.FARFIELD_DIRECTION
    )
    "Method of defining the flow direction at the far-field."
    direction: Vector3 = field(default_factory=lambda: Vector3(1.0, 0.0, 0.0))
    "Vector specifying the flow direction at the far-field boundary. Automatically scaled to a unit vector internally."
    angle_alpha: LcFloat = 0.0
    "Angle of attack. Positive angle of attack results in a non-zero far-field velocity component in the negative body-z direction."
    angle_beta: LcFloat = 0.0
    "Angle of sideslip. Positive angle of sideslip results in a non-zero far-field velocity component in the positive body-y direction."
    turbulence: TurbulenceBoundaryConditions = field(default_factory=TurbulenceBoundaryConditions)
    "Turbulence boundary conditions."

    def _to_proto(self) -> clientpb.BoundaryConditionsFluid:
        _proto = super()._to_proto()
        _proto.physical_boundary = clientpb.PhysicalBoundary.FARFIELD
        _proto.farfield_momentum = self.momentum.value
        _proto.farfield_mach_number.CopyFrom(_to_ad_proto(self.mach_number))
        _proto.farfield_velocity_magnitude.CopyFrom(_to_ad_proto(self.velocity))
        _proto.farfield_pressure.CopyFrom(_to_ad_proto(self.pressure))
        _proto.farfield_temperature.CopyFrom(_to_ad_proto(self.temperature))
        _proto.far_field_flow_direction_specification = self.direction_specification.value
        _proto.farfield_flow_direction.CopyFrom(self.direction._to_ad_proto())
        _proto.farfield_angle_alpha.CopyFrom(_to_ad_proto(self.angle_alpha))
        _proto.farfield_angle_beta.CopyFrom(_to_ad_proto(self.angle_beta))
        _proto.turbulence_specification_spalart_allmaras = self.turbulence.spalart_allmaras.value
        _proto.turbulence_specification_komega = self.turbulence.komega.value
        _proto.turbulent_viscosity_ratio.CopyFrom(_to_ad_proto(self.turbulence.viscosity_ratio))
        _proto.turbulent_viscosity.CopyFrom(_to_ad_proto(self.turbulence.viscosity))
        _proto.turbulence_intensity.CopyFrom(_to_ad_proto(self.turbulence.intensity))
        _proto.bc_uniform_nu_tilde.CopyFrom(_to_ad_proto(self.turbulence.sa_variable))
        _proto.bc_nu_tilde_col.value = self.turbulence.sa_variable_column_index
        _proto.bc_uniform_tke.CopyFrom(_to_ad_proto(self.turbulence.tke))
        _proto.bc_tke_col.value = self.turbulence.tke_column_index
        _proto.bc_uniform_omega.CopyFrom(_to_ad_proto(self.turbulence.omega))
        _proto.bc_omega_col.value = self.turbulence.omega_column_index
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsFluid) -> None:
        super()._from_proto(proto)
        assert proto.physical_boundary == clientpb.PhysicalBoundary.FARFIELD
        self.momentum = enum.FarfieldMomentum(proto.farfield_momentum)
        self.mach_number = _from_ad_proto(proto.farfield_mach_number)
        self.velocity = _from_ad_proto(proto.farfield_velocity_magnitude)
        self.pressure = _from_ad_proto(proto.farfield_pressure)
        self.temperature = _from_ad_proto(proto.farfield_temperature)
        self.direction_specification = enum.FarFieldFlowDirectionSpecification(
            proto.far_field_flow_direction_specification
        )
        self.direction._from_ad_proto(proto.farfield_flow_direction)
        self.angle_alpha = _from_ad_proto(proto.farfield_angle_alpha)
        self.angle_beta = _from_ad_proto(proto.farfield_angle_beta)
        self.turbulence.spalart_allmaras = enum.TurbulenceSpecificationSpalartAllmaras(
            proto.turbulence_specification_spalart_allmaras
        )
        self.turbulence.komega = enum.TurbulenceSpecificationKomega(
            proto.turbulence_specification_komega
        )
        self.turbulence.viscosity_ratio = _from_ad_proto(proto.turbulent_viscosity_ratio)
        self.turbulence.viscosity = _from_ad_proto(proto.turbulent_viscosity)
        self.turbulence.intensity = _from_ad_proto(proto.turbulence_intensity)
        self.turbulence.sa_variable = _from_ad_proto(proto.bc_uniform_nu_tilde)
        self.turbulence.sa_variable_column_index = proto.bc_nu_tilde_col.value
        self.turbulence.tke = _from_ad_proto(proto.bc_uniform_tke)
        self.turbulence.tke_column_index = proto.bc_tke_col.value
        self.turbulence.omega = _from_ad_proto(proto.bc_uniform_omega)
        self.turbulence.omega_column_index = proto.bc_omega_col.value
        return None
