# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import Inlet
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import *


@dataclass(kw_only=True)
class FanCurveInlet(Inlet):
    """Fan curve."""

    total_pressure: LcFloat = 101325
    "Total pressure at the boundary relative to the material reference pressure."
    direction_specification: enum.DirectionSpecification = (
        enum.DirectionSpecification.NORMAL_TO_BOUNDARY
    )
    "Method of defining the flow direction at the inlet."
    direction: Vector3 = field(default_factory=lambda: Vector3(1.0, 0.0, 0.0))
    "Vector (x,y,z) or (ρ,φ,z) defining the flow direction. Automatically scaled to a unit vector internally."
    fan_curve_table: RectilinearTable | None = None
    "Correlation between fan pressure rise and volume flow rate."
    head_loss_coefficient: LcFloat = 0.0
    "Fraction of dynamic pressure lost through the fan."

    def _to_proto(self) -> clientpb.BoundaryConditionsFluid:
        _proto = super()._to_proto()
        _proto.inlet_momentum = clientpb.InletMomentum.FAN_CURVE_INLET
        _proto.total_pressure.CopyFrom(_to_ad_proto(self.total_pressure))
        _proto.direction_specification = self.direction_specification.value
        _proto.flow_direction.CopyFrom(self.direction._to_ad_proto())
        if self.fan_curve_table is not None:
            if self.fan_curve_table.table_type != _param_name_to_table_type("fan_curve_table_data"):
                raise TypeError("Wrong TableType used for self.fan_curve_table")
            _proto.fan_curve_table_data = self.fan_curve_table.id
        _proto.head_loss_coefficient.CopyFrom(_to_ad_proto(self.head_loss_coefficient))
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsFluid) -> None:
        super()._from_proto(proto)
        assert proto.inlet_momentum == clientpb.InletMomentum.FAN_CURVE_INLET
        self.total_pressure = _from_ad_proto(proto.total_pressure)
        self.direction_specification = enum.DirectionSpecification(proto.direction_specification)
        self.direction._from_ad_proto(proto.flow_direction)
        if proto.fan_curve_table_data != "":
            self.fan_curve_table = RectilinearTable(
                id=proto.fan_curve_table_data,
                name=proto.fan_curve_table_data,
                table_type=_param_name_to_table_type("fan_curve_table_data"),
            )
        self.head_loss_coefficient = _from_ad_proto(proto.head_loss_coefficient)
        return None
