# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import Inlet
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import *


@dataclass(kw_only=True)
class MachInlet(Inlet):
    """Mach inlet boundary condition."""

    mach_number: LcFloat = 0.5
    "Mach number at the boundary."
    pressure: LcFloat = 101325
    "Static pressure at the boundary relative to the material reference pressure."
    direction_specification: enum.DirectionSpecification = (
        enum.DirectionSpecification.NORMAL_TO_BOUNDARY
    )
    "Method of defining the flow direction at the inlet."
    direction_frame: enum.DirectionFrame = enum.DirectionFrame.DIRECTION_FRAME_GLOBAL
    "Frame used to define the flow direction."
    direction: Vector3 = field(default_factory=lambda: Vector3(1.0, 0.0, 0.0))
    "Vector (x,y,z) or (ρ,φ,z) defining the flow direction. Automatically scaled to a unit vector internally."

    def _to_proto(self) -> clientpb.BoundaryConditionsFluid:
        _proto = super()._to_proto()
        _proto.inlet_momentum = clientpb.InletMomentum.MACH_INLET
        _proto.farfield_mach_number.CopyFrom(_to_ad_proto(self.mach_number))
        _proto.farfield_pressure.CopyFrom(_to_ad_proto(self.pressure))
        _proto.direction_specification = self.direction_specification.value
        _proto.direction_frame = self.direction_frame.value
        _proto.flow_direction.CopyFrom(self.direction._to_ad_proto())
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsFluid) -> None:
        super()._from_proto(proto)
        assert proto.inlet_momentum == clientpb.InletMomentum.MACH_INLET
        self.mach_number = _from_ad_proto(proto.farfield_mach_number)
        self.pressure = _from_ad_proto(proto.farfield_pressure)
        self.direction_specification = enum.DirectionSpecification(proto.direction_specification)
        self.direction_frame = enum.DirectionFrame(proto.direction_frame)
        self.direction._from_ad_proto(proto.flow_direction)
        return None
