# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import Inlet
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import *


@dataclass(kw_only=True)
class VelocityComponentsInlet(Inlet):
    """Velocity components inlet boundary condition."""

    velocity: Vector3 = field(default_factory=lambda: Vector3(1.0, 0.0, 0.0))
    "Vector (x,y,z) defining the velocity vector."
    pressure: LcFloat = 101325
    "Static pressure at the boundary relative to the material reference pressure."

    def _to_proto(self) -> clientpb.BoundaryConditionsFluid:
        _proto = super()._to_proto()
        _proto.inlet_momentum = clientpb.InletMomentum.VELOCITY_COMPONENTS_INLET
        _proto.inlet_velocity_components.CopyFrom(self.velocity._to_ad_proto())
        _proto.farfield_pressure.CopyFrom(_to_ad_proto(self.pressure))
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsFluid) -> None:
        super()._from_proto(proto)
        assert proto.inlet_momentum == clientpb.InletMomentum.VELOCITY_COMPONENTS_INLET
        self.velocity._from_ad_proto(proto.inlet_velocity_components)
        self.pressure = _from_ad_proto(proto.farfield_pressure)
        return None
