# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import (
    BoundaryConditionsFluid,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.turbulence_boundary_conditions_ import (
    TurbulenceBoundaryConditions,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.turbulence_boundary_conditions_ import *


@dataclass(kw_only=True)
class Inlet(BoundaryConditionsFluid, ABC):
    """Inlet boundary condition.
    NOTE: This is a base class, please use the derived classes from the inlet module."""

    enable_profile: bool = False
    "Turn on or off the ability to use tabulated data to define spatially varying boundary conditions."
    profile_table: RectilinearTable | None = None
    "Tabulated data for spatially varying boundary conditions."
    profile_type: enum.ProfileType = enum.ProfileType.CARTESIAN_X
    "Types of boundary condition profile."
    inlet_energy: enum.InletEnergy = enum.InletEnergy.TOTAL_TEMPERATURE_INLET
    "Method of defining the inlet energy conditions."
    total_temperature: LcFloat = 300
    "Total temperature at the inlet boundary."
    total_temperature_column_index: int = 0
    "Index of the column of the table in profile_bc_data for Total Temperature."
    turbulence: TurbulenceBoundaryConditions = field(default_factory=TurbulenceBoundaryConditions)
    "Turbulence boundary conditions."

    def _to_proto(self) -> clientpb.BoundaryConditionsFluid:
        _proto = super()._to_proto()
        _proto.physical_boundary = clientpb.PhysicalBoundary.INLET
        _proto.profile_bc = self.enable_profile
        if self.profile_table is not None:
            if self.profile_table.table_type != _param_name_to_table_type("profile_bc_data"):
                raise TypeError("Wrong TableType used for self.profile_table")
            _proto.profile_bc_data = self.profile_table.id
        _proto.profile_type = self.profile_type.value
        _proto.inlet_energy = self.inlet_energy.value
        _proto.total_temperature.CopyFrom(_to_ad_proto(self.total_temperature))
        _proto.total_temperature_col.value = self.total_temperature_column_index
        _proto.turbulence_specification_spalart_allmaras = self.turbulence.spalart_allmaras.value
        _proto.turbulence_specification_komega = self.turbulence.komega.value
        _proto.turbulent_viscosity_ratio.CopyFrom(_to_ad_proto(self.turbulence.viscosity_ratio))
        _proto.turbulent_viscosity.CopyFrom(_to_ad_proto(self.turbulence.viscosity))
        _proto.turbulence_intensity.CopyFrom(_to_ad_proto(self.turbulence.intensity))
        _proto.bc_uniform_nu_tilde.CopyFrom(_to_ad_proto(self.turbulence.sa_variable))
        _proto.bc_nu_tilde_col.value = self.turbulence.sa_variable_column_index
        _proto.bc_uniform_tke.CopyFrom(_to_ad_proto(self.turbulence.tke))
        _proto.bc_tke_col.value = self.turbulence.tke_column_index
        _proto.bc_uniform_omega.CopyFrom(_to_ad_proto(self.turbulence.omega))
        _proto.bc_omega_col.value = self.turbulence.omega_column_index
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsFluid) -> None:
        super()._from_proto(proto)
        assert proto.physical_boundary == clientpb.PhysicalBoundary.INLET
        self.enable_profile = proto.profile_bc
        if proto.profile_bc_data != "":
            self.profile_table = RectilinearTable(
                id=proto.profile_bc_data,
                name=proto.profile_bc_data,
                table_type=_param_name_to_table_type("profile_bc_data"),
            )
        self.profile_type = enum.ProfileType(proto.profile_type)
        self.inlet_energy = enum.InletEnergy(proto.inlet_energy)
        self.total_temperature = _from_ad_proto(proto.total_temperature)
        self.total_temperature_column_index = proto.total_temperature_col.value
        self.turbulence.spalart_allmaras = enum.TurbulenceSpecificationSpalartAllmaras(
            proto.turbulence_specification_spalart_allmaras
        )
        self.turbulence.komega = enum.TurbulenceSpecificationKomega(
            proto.turbulence_specification_komega
        )
        self.turbulence.viscosity_ratio = _from_ad_proto(proto.turbulent_viscosity_ratio)
        self.turbulence.viscosity = _from_ad_proto(proto.turbulent_viscosity)
        self.turbulence.intensity = _from_ad_proto(proto.turbulence_intensity)
        self.turbulence.sa_variable = _from_ad_proto(proto.bc_uniform_nu_tilde)
        self.turbulence.sa_variable_column_index = proto.bc_nu_tilde_col.value
        self.turbulence.tke = _from_ad_proto(proto.bc_uniform_tke)
        self.turbulence.tke_column_index = proto.bc_tke_col.value
        self.turbulence.omega = _from_ad_proto(proto.bc_uniform_omega)
        self.turbulence.omega_column_index = proto.bc_omega_col.value
        return None
