# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import (
    BoundaryConditionsFluid,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.fan_curve_outlet_ import (
    FanCurveOutlet,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.fan_curve_outlet_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.outlet_pressure_ import (
    OutletPressure,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.outlet_pressure_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy_ import (
    OutletStrategy,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.outlet_target_corrected_mass_flow_rate_ import (
    OutletTargetCorrectedMassFlowRate,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.outlet_target_corrected_mass_flow_rate_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.outlet_target_mass_flow_rate_ import (
    OutletTargetMassFlowRate,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet.outlet_strategy.outlet_target_mass_flow_rate_ import *


@dataclass(kw_only=True)
class Outlet(BoundaryConditionsFluid):
    """Outlet boundary condition."""

    outlet_strategy: OutletStrategy = field(default_factory=OutletPressure)
    "Outlet strategy. Possible types: ``OutletPressure``, ``OutletTargetMassFlowRate``, ``OutletTargetCorrectedMassFlowRate``, ``FanCurveOutlet`` from the ``outlet_strategy`` module."
    pressure_constraint: enum.OutletPressureConstraint = (
        enum.OutletPressureConstraint.OUTLET_LOCAL_CONSTRAINT
    )
    "Mode of imposing pressure at the outlet."

    def _to_proto(self) -> clientpb.BoundaryConditionsFluid:
        _proto = super()._to_proto()
        _proto.physical_boundary = clientpb.PhysicalBoundary.OUTLET
        if isinstance(self.outlet_strategy, OutletPressure):
            _proto.outlet_strategy = clientpb.OUTLET_PRESSURE
            _proto.outlet_pressure.CopyFrom(_to_ad_proto(self.outlet_strategy.pressure))
        if isinstance(self.outlet_strategy, OutletTargetMassFlowRate):
            _proto.outlet_strategy = clientpb.OUTLET_TARGET_MASS_FLOW_RATE
            _proto.outlet_pressure.CopyFrom(_to_ad_proto(self.outlet_strategy.pressure))
            _proto.outlet_target_mass_flow_rate.CopyFrom(
                _to_ad_proto(self.outlet_strategy.target_mass_flow_rate)
            )
        if isinstance(self.outlet_strategy, OutletTargetCorrectedMassFlowRate):
            _proto.outlet_strategy = clientpb.OUTLET_TARGET_CORRECTED_MASS_FLOW_RATE
            _proto.outlet_pressure.CopyFrom(_to_ad_proto(self.outlet_strategy.pressure))
            _proto.outlet_target_mass_flow_rate.CopyFrom(
                _to_ad_proto(self.outlet_strategy.target_mass_flow_rate)
            )
            _proto.outlet_reference_pressure.CopyFrom(
                _to_ad_proto(self.outlet_strategy.reference_pressure)
            )
            _proto.outlet_reference_temperature.CopyFrom(
                _to_ad_proto(self.outlet_strategy.reference_temperature)
            )
        if isinstance(self.outlet_strategy, FanCurveOutlet):
            _proto.outlet_strategy = clientpb.FAN_CURVE_OUTLET
            _proto.outlet_pressure.CopyFrom(_to_ad_proto(self.outlet_strategy.pressure))
            if self.outlet_strategy.fan_curve_table is not None:
                if self.outlet_strategy.fan_curve_table.table_type != _param_name_to_table_type(
                    "fan_curve_table_data"
                ):
                    raise TypeError("Wrong TableType used for self.outlet_strategy.fan_curve_table")
                _proto.fan_curve_table_data = self.outlet_strategy.fan_curve_table.id
            _proto.head_loss_coefficient.CopyFrom(
                _to_ad_proto(self.outlet_strategy.head_loss_coefficient)
            )
        _proto.outlet_pressure_constraint = self.pressure_constraint.value
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsFluid) -> None:
        super()._from_proto(proto)
        assert proto.physical_boundary == clientpb.PhysicalBoundary.OUTLET
        if proto.outlet_strategy == clientpb.INVALID_OUTLET_STRATEGY:
            raise ValueError("Invalid outlet_strategy")
        elif proto.outlet_strategy == clientpb.OUTLET_PRESSURE:
            self.outlet_strategy = OutletPressure()
            self.outlet_strategy.pressure = _from_ad_proto(proto.outlet_pressure)
        elif proto.outlet_strategy == clientpb.OUTLET_TARGET_MASS_FLOW_RATE:
            self.outlet_strategy = OutletTargetMassFlowRate()
            self.outlet_strategy.pressure = _from_ad_proto(proto.outlet_pressure)
            self.outlet_strategy.target_mass_flow_rate = _from_ad_proto(
                proto.outlet_target_mass_flow_rate
            )
        elif proto.outlet_strategy == clientpb.OUTLET_TARGET_CORRECTED_MASS_FLOW_RATE:
            self.outlet_strategy = OutletTargetCorrectedMassFlowRate()
            self.outlet_strategy.pressure = _from_ad_proto(proto.outlet_pressure)
            self.outlet_strategy.target_mass_flow_rate = _from_ad_proto(
                proto.outlet_target_mass_flow_rate
            )
            self.outlet_strategy.reference_pressure = _from_ad_proto(
                proto.outlet_reference_pressure
            )
            self.outlet_strategy.reference_temperature = _from_ad_proto(
                proto.outlet_reference_temperature
            )
        elif proto.outlet_strategy == clientpb.FAN_CURVE_OUTLET:
            self.outlet_strategy = FanCurveOutlet()
            self.outlet_strategy.pressure = _from_ad_proto(proto.outlet_pressure)
            if proto.fan_curve_table_data != "":
                self.outlet_strategy.fan_curve_table = RectilinearTable(
                    id=proto.fan_curve_table_data,
                    name=proto.fan_curve_table_data,
                    table_type=_param_name_to_table_type("fan_curve_table_data"),
                )
            self.outlet_strategy.head_loss_coefficient = _from_ad_proto(proto.head_loss_coefficient)
        self.pressure_constraint = enum.OutletPressureConstraint(proto.outlet_pressure_constraint)
        return None
