# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import (
    BoundaryConditionsFluid,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.momentum.no_slip_ import (
    NoSlip,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.momentum.no_slip_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.energy.prescribed_heat_flux_ import (
    PrescribedHeatFlux,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.energy.prescribed_heat_flux_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.energy.prescribed_temperature_ import (
    PrescribedTemperature,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.energy.prescribed_temperature_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.momentum.slip_ import (
    Slip,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.momentum.slip_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.wall_energy_ import (
    WallEnergy,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.wall_energy_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.momentum.wall_model_ import (
    WallModel,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.momentum.wall_model_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.wall_momentum_ import (
    WallMomentum,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall.wall_momentum_ import *


@dataclass(kw_only=True)
class Wall(BoundaryConditionsFluid):
    """Wall boundary condition."""

    momentum: WallMomentum = field(default_factory=NoSlip)
    "Condition applied to the momentum equations at a solid wall boundary. Possible types: ``NoSlip``, ``Slip``, ``WallModel`` from the ``momentum`` module."
    energy: WallEnergy = field(default_factory=PrescribedHeatFlux)
    "Condition applied to the energy equation at a solid wall boundary. Possible types: ``PrescribedHeatFlux``, ``PrescribedTemperature`` from the ``energy`` module."

    def _to_proto(self) -> clientpb.BoundaryConditionsFluid:
        _proto = super()._to_proto()
        _proto.physical_boundary = clientpb.PhysicalBoundary.WALL
        if isinstance(self.momentum, NoSlip):
            _proto.wall_momentum = clientpb.NO_SLIP
            _proto.roughness_control = self.momentum.enable_roughness
            _proto.equivalent_sand_grain_roughness.CopyFrom(
                _to_ad_proto(self.momentum.equivalent_sand_grain_roughness)
            )
        if isinstance(self.momentum, Slip):
            _proto.wall_momentum = clientpb.SLIP
        if isinstance(self.momentum, WallModel):
            _proto.wall_momentum = clientpb.WALL_MODEL
            _proto.roughness_control = self.momentum.enable_roughness
            _proto.equivalent_sand_grain_roughness.CopyFrom(
                _to_ad_proto(self.momentum.equivalent_sand_grain_roughness)
            )
        if isinstance(self.energy, PrescribedHeatFlux):
            _proto.wall_energy = clientpb.FIXED_HEAT_FLUX
            _proto.fixed_heat_flux.CopyFrom(_to_ad_proto(self.energy.heat_flux))
        if isinstance(self.energy, PrescribedTemperature):
            _proto.wall_energy = clientpb.FIXED_TEMPERATURE
            _proto.fixed_temperature.CopyFrom(_to_ad_proto(self.energy.temperature))
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsFluid) -> None:
        super()._from_proto(proto)
        assert proto.physical_boundary == clientpb.PhysicalBoundary.WALL
        if proto.wall_momentum == clientpb.INVALID_WALL_MOMENTUM:
            raise ValueError("Invalid wall_momentum")
        elif proto.wall_momentum == clientpb.NO_SLIP:
            self.momentum = NoSlip()
            self.momentum.enable_roughness = proto.roughness_control
            self.momentum.equivalent_sand_grain_roughness = _from_ad_proto(
                proto.equivalent_sand_grain_roughness
            )
        elif proto.wall_momentum == clientpb.SLIP:
            self.momentum = Slip()
        elif proto.wall_momentum == clientpb.WALL_MODEL:
            self.momentum = WallModel()
            self.momentum.enable_roughness = proto.roughness_control
            self.momentum.equivalent_sand_grain_roughness = _from_ad_proto(
                proto.equivalent_sand_grain_roughness
            )
        if proto.wall_energy == clientpb.INVALID_WALL_ENERGY:
            raise ValueError("Invalid wall_energy")
        elif proto.wall_energy == clientpb.FIXED_HEAT_FLUX:
            self.energy = PrescribedHeatFlux()
            self.energy.heat_flux = _from_ad_proto(proto.fixed_heat_flux)
        elif proto.wall_energy == clientpb.FIXED_TEMPERATURE:
            self.energy = PrescribedTemperature()
            self.energy.temperature = _from_ad_proto(proto.fixed_temperature)
        return None
