# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.initialization_fluid_ import InitializationFluid
from luminarycloud.params.simulation.physics.fluid.initialization_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.initialization.turbulence_initialization_ import (
    TurbulenceInitialization,
)
from luminarycloud.params.simulation.physics.fluid.initialization.turbulence_initialization_ import *


@dataclass(kw_only=True)
class FluidExistingSolution(InitializationFluid):
    """Apply the starting values from an existing solution for the same mesh."""

    solution_id: str = ""
    "ID for the existing solution to use for initialization."
    turbulence: TurbulenceInitialization = field(default_factory=TurbulenceInitialization)
    ""

    def _to_proto(self) -> clientpb.InitializationFluid:
        _proto = super()._to_proto()
        _proto.initialization_type = clientpb.InitializationType.EXISTING_SOLUTION
        if self.solution_id is not None:
            _proto.existing_solution_id = self.solution_id
        _proto.turbulent_variable_initialization_type_sa = self.turbulence.spalart_allmaras.value
        _proto.turbulent_variable_initialization_type_komega = self.turbulence.komega.value
        _proto.init_turbulent_viscosity_ratio.CopyFrom(
            _to_ad_proto(self.turbulence.viscosity_ratio)
        )
        _proto.init_turbulent_viscosity.CopyFrom(_to_ad_proto(self.turbulence.viscosity))
        _proto.init_turbulence_intensity.CopyFrom(_to_ad_proto(self.turbulence.intensity))
        _proto.uniform_nu_tilde.CopyFrom(_to_ad_proto(self.turbulence.sa_variable))
        _proto.uniform_tke.CopyFrom(_to_ad_proto(self.turbulence.tke))
        _proto.uniform_omega.CopyFrom(_to_ad_proto(self.turbulence.omega))
        return _proto

    def _from_proto(self, proto: clientpb.InitializationFluid) -> None:
        super()._from_proto(proto)
        assert proto.initialization_type == clientpb.InitializationType.EXISTING_SOLUTION
        self.solution_id = proto.existing_solution_id
        self.turbulence.spalart_allmaras = enum.TurbulentVariableInitializationTypeSa(
            proto.turbulent_variable_initialization_type_sa
        )
        self.turbulence.komega = enum.TurbulentVariableInitializationTypeKomega(
            proto.turbulent_variable_initialization_type_komega
        )
        self.turbulence.viscosity_ratio = _from_ad_proto(proto.init_turbulent_viscosity_ratio)
        self.turbulence.viscosity = _from_ad_proto(proto.init_turbulent_viscosity)
        self.turbulence.intensity = _from_ad_proto(proto.init_turbulence_intensity)
        self.turbulence.sa_variable = _from_ad_proto(proto.uniform_nu_tilde)
        self.turbulence.tke = _from_ad_proto(proto.uniform_tke)
        self.turbulence.omega = _from_ad_proto(proto.uniform_omega)
        return None
