# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.initialization_fluid_ import InitializationFluid
from luminarycloud.params.simulation.physics.fluid.initialization_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.initialization.turbulence_initialization_ import (
    TurbulenceInitialization,
)
from luminarycloud.params.simulation.physics.fluid.initialization.turbulence_initialization_ import *


@dataclass(kw_only=True)
class FluidPrescribedValues(InitializationFluid):
    """Apply a uniform initial condition for all fields in space."""

    pressure: LcFloat = 101325.0
    "Uniform initial condition for the static pressure relative to the material reference pressure."
    velocity: Vector3 = field(default_factory=lambda: Vector3(1.0, 0.0, 0.0))
    "Uniform initial condition for velocity."
    temperature: LcFloat = 288.15
    "Uniform initial condition for static temperature."
    turbulence: TurbulenceInitialization = field(default_factory=TurbulenceInitialization)
    ""

    def _to_proto(self) -> clientpb.InitializationFluid:
        _proto = super()._to_proto()
        _proto.initialization_type = clientpb.InitializationType.UNIFORM_VALUES
        _proto.uniform_p.CopyFrom(_to_ad_proto(self.pressure))
        _proto.uniform_v.CopyFrom(self.velocity._to_ad_proto())
        _proto.uniform_t.CopyFrom(_to_ad_proto(self.temperature))
        _proto.turbulent_variable_initialization_type_sa = self.turbulence.spalart_allmaras.value
        _proto.turbulent_variable_initialization_type_komega = self.turbulence.komega.value
        _proto.init_turbulent_viscosity_ratio.CopyFrom(
            _to_ad_proto(self.turbulence.viscosity_ratio)
        )
        _proto.init_turbulent_viscosity.CopyFrom(_to_ad_proto(self.turbulence.viscosity))
        _proto.init_turbulence_intensity.CopyFrom(_to_ad_proto(self.turbulence.intensity))
        _proto.uniform_nu_tilde.CopyFrom(_to_ad_proto(self.turbulence.sa_variable))
        _proto.uniform_tke.CopyFrom(_to_ad_proto(self.turbulence.tke))
        _proto.uniform_omega.CopyFrom(_to_ad_proto(self.turbulence.omega))
        return _proto

    def _from_proto(self, proto: clientpb.InitializationFluid) -> None:
        super()._from_proto(proto)
        assert proto.initialization_type == clientpb.InitializationType.UNIFORM_VALUES
        self.pressure = _from_ad_proto(proto.uniform_p)
        self.velocity._from_ad_proto(proto.uniform_v)
        self.temperature = _from_ad_proto(proto.uniform_t)
        self.turbulence.spalart_allmaras = enum.TurbulentVariableInitializationTypeSa(
            proto.turbulent_variable_initialization_type_sa
        )
        self.turbulence.komega = enum.TurbulentVariableInitializationTypeKomega(
            proto.turbulent_variable_initialization_type_komega
        )
        self.turbulence.viscosity_ratio = _from_ad_proto(proto.init_turbulent_viscosity_ratio)
        self.turbulence.viscosity = _from_ad_proto(proto.init_turbulent_viscosity)
        self.turbulence.intensity = _from_ad_proto(proto.init_turbulence_intensity)
        self.turbulence.sa_variable = _from_ad_proto(proto.uniform_nu_tilde)
        self.turbulence.tke = _from_ad_proto(proto.uniform_tke)
        self.turbulence.omega = _from_ad_proto(proto.uniform_omega)
        return None
