# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class BladeElementAirfoilData(CodeRepr, ParamGroupWrapper[clientpb.BladeElementAirfoilData]):
    """Construct a blade by assigning airfoil profiles to different radial stations"""

    id: str = field(default_factory=create_unique_id, init=False)
    "Assign a unique ID to this airfoil."
    name: str = ""
    "Apply a descriptive name to this airfoil."
    radial_station: LcFloat = 0
    "Airfoil shape on the blade at this r/R."
    airfoil_performance_table: RectilinearTable | None = None
    "Lift, drag, and pitching moment coefficients vs. alpha & Mach number."

    def _to_proto(self) -> clientpb.BladeElementAirfoilData:
        _proto = clientpb.BladeElementAirfoilData()
        if self.id is not None:
            _proto.airfoil_id = self.id
        if self.name is not None:
            _proto.airfoil_name = self.name
        _proto.airfoil_radial_station.CopyFrom(_to_ad_proto(self.radial_station))
        if self.airfoil_performance_table is not None:
            if self.airfoil_performance_table.table_type != _param_name_to_table_type(
                "airfoil_performance_data"
            ):
                raise TypeError("Wrong TableType used for self.airfoil_performance_table")
            _proto.airfoil_performance_data = self.airfoil_performance_table.id
        return _proto

    def _from_proto(self, proto: clientpb.BladeElementAirfoilData) -> None:
        self.id = proto.airfoil_id
        self.name = proto.airfoil_name
        self.radial_station = _from_ad_proto(proto.airfoil_radial_station)
        if proto.airfoil_performance_data != "":
            self.airfoil_performance_table = RectilinearTable(
                id=proto.airfoil_performance_data,
                name=proto.airfoil_performance_data,
                table_type=_param_name_to_table_type("airfoil_performance_data"),
            )
        return None
