# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.actuator_disk_blade_element_ import (
    ActuatorDiskBladeElement,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.actuator_disk_blade_element_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model_ import (
    ActuatorDiskModel,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.actuator_disk_radial_distribution_ import (
    ActuatorDiskRadialDistribution,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.actuator_disk_radial_distribution_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.actuator_disk_uniform_thrust_ import (
    ActuatorDiskUniformThrust,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.actuator_disk_uniform_thrust_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_line_model.actuator_line_blade_element_ import (
    ActuatorLineBladeElement,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_line_model.actuator_line_blade_element_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_line_model_ import (
    ActuatorLineModel,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_line_model_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.blade_element_airfoil_data_ import (
    BladeElementAirfoilData,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.blade_element_airfoil_data_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.fan_curve_internal_ import (
    FanCurveInternal,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.actuator_disk_model.fan_curve_internal_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.particle_source_model.general_acceleration_source_ import (
    GeneralAccelerationSource,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.particle_source_model.general_acceleration_source_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.particle_source_model.general_mass_source_ import (
    GeneralMassSource,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.particle_source_model.general_mass_source_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.particle_source_model_ import (
    ParticleSourceModel,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model.particle_source_model_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model_ import (
    PhysicalBehaviorModel,
)
from luminarycloud.params.simulation.physics.fluid.physical_behavior.physical_behavior_model_ import *


@dataclass(kw_only=True)
class PhysicalBehavior(CodeRepr, ParamGroupWrapper[clientpb.PhysicalBehavior]):
    """Physical behavior settings for a fluid flow physics solver."""

    id: str = field(default_factory=create_unique_id, init=False)
    ""
    name: str = ""
    ""
    physical_behavior_model: PhysicalBehaviorModel = field(default_factory=ActuatorDiskModel)
    "Defines the physical behavior type. Possible types: ``ActuatorDiskModel``, ``ActuatorLineModel``, ``ParticleSourceModel`` from the ``physical_behavior_model`` module."
    blade_element_airfoil_data: list[BladeElementAirfoilData] = field(default_factory=list)
    "Construct a blade by assigning airfoil profiles to different radial stations."

    def _to_proto(self) -> clientpb.PhysicalBehavior:
        _proto = clientpb.PhysicalBehavior()
        if self.id is not None:
            _proto.physical_behavior_id = self.id
        if self.name is not None:
            _proto.physical_behavior_name = self.name
        if isinstance(self.physical_behavior_model, ActuatorDiskModel):
            _proto.physical_behavior_model = clientpb.ACTUATOR_DISK_MODEL
            if isinstance(self.physical_behavior_model, ActuatorDiskUniformThrust):
                _proto.actuator_disk_model = clientpb.ACTUATOR_DISK_UNIFORM_THRUST
                _proto.actuator_disk_thrust.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.thrust)
                )
            if isinstance(self.physical_behavior_model, ActuatorDiskRadialDistribution):
                _proto.actuator_disk_model = clientpb.ACTUATOR_DISK_RADIAL_DISTRIBUTION
                _proto.actuator_disk_thrust.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.thrust)
                )
                _proto.actuator_disk_torque.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.torque)
                )
                _proto.actuator_disk_radial_force.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.radial_force)
                )
                if self.physical_behavior_model.radial_distribution_table is not None:
                    if (
                        self.physical_behavior_model.radial_distribution_table.table_type
                        != _param_name_to_table_type("actuator_disk_radial_table_data")
                    ):
                        raise TypeError(
                            "Wrong TableType used for self.physical_behavior_model.radial_distribution_table"
                        )
                    _proto.actuator_disk_radial_table_data = (
                        self.physical_behavior_model.radial_distribution_table.id
                    )
            if isinstance(self.physical_behavior_model, ActuatorDiskBladeElement):
                _proto.actuator_disk_model = clientpb.ACTUATOR_DISK_BLADE_ELEMENT
                _proto.actuator_disk_rotation_rate.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.blade_element_params.rotation_rate)
                )
                _proto.actuator_disk_bem_strategy = (
                    self.physical_behavior_model.blade_element_params.bem_strategy.value
                )
                _proto.actuator_disk_blade_count.value = (
                    self.physical_behavior_model.blade_element_params.blade_count
                )
                _proto.blade_element_pitch_schedule.CopyFrom(
                    self.physical_behavior_model.blade_element_params.pitch_schedule._to_ad_proto()
                )
                if (
                    self.physical_behavior_model.blade_element_params.blade_geometry_table
                    is not None
                ):
                    if (
                        self.physical_behavior_model.blade_element_params.blade_geometry_table.table_type
                        != _param_name_to_table_type("blade_element_geometry_data")
                    ):
                        raise TypeError(
                            "Wrong TableType used for self.physical_behavior_model.blade_element_params.blade_geometry_table"
                        )
                    _proto.blade_element_geometry_data = (
                        self.physical_behavior_model.blade_element_params.blade_geometry_table.id
                    )
                _proto.blade_element_reference_sound_speed.CopyFrom(
                    _to_ad_proto(
                        self.physical_behavior_model.blade_element_params.reference_sound_speed
                    )
                )
            if isinstance(self.physical_behavior_model, FanCurveInternal):
                _proto.actuator_disk_model = clientpb.FAN_CURVE_INTERNAL
                if self.physical_behavior_model.fan_curve_table is not None:
                    if (
                        self.physical_behavior_model.fan_curve_table.table_type
                        != _param_name_to_table_type("fan_curve_table_data")
                    ):
                        raise TypeError(
                            "Wrong TableType used for self.physical_behavior_model.fan_curve_table"
                        )
                    _proto.fan_curve_table_data = self.physical_behavior_model.fan_curve_table.id
                _proto.head_loss_coefficient.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.head_loss_coefficient)
                )
        if isinstance(self.physical_behavior_model, ActuatorLineModel):
            _proto.physical_behavior_model = clientpb.ACTUATOR_LINE_MODEL
            if isinstance(self.physical_behavior_model, ActuatorLineBladeElement):
                _proto.actuator_line_model = clientpb.ACTUATOR_LINE_BLADE_ELEMENT
                _proto.actuator_disk_rotation_rate.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.blade_element_params.rotation_rate)
                )
                _proto.actuator_disk_bem_strategy = (
                    self.physical_behavior_model.blade_element_params.bem_strategy.value
                )
                _proto.actuator_disk_blade_count.value = (
                    self.physical_behavior_model.blade_element_params.blade_count
                )
                _proto.blade_element_pitch_schedule.CopyFrom(
                    self.physical_behavior_model.blade_element_params.pitch_schedule._to_ad_proto()
                )
                if (
                    self.physical_behavior_model.blade_element_params.blade_geometry_table
                    is not None
                ):
                    if (
                        self.physical_behavior_model.blade_element_params.blade_geometry_table.table_type
                        != _param_name_to_table_type("blade_element_geometry_data")
                    ):
                        raise TypeError(
                            "Wrong TableType used for self.physical_behavior_model.blade_element_params.blade_geometry_table"
                        )
                    _proto.blade_element_geometry_data = (
                        self.physical_behavior_model.blade_element_params.blade_geometry_table.id
                    )
                _proto.blade_element_reference_sound_speed.CopyFrom(
                    _to_ad_proto(
                        self.physical_behavior_model.blade_element_params.reference_sound_speed
                    )
                )
        if isinstance(self.physical_behavior_model, ParticleSourceModel):
            _proto.physical_behavior_model = clientpb.SOURCE_POINTS_MODEL
            if isinstance(self.physical_behavior_model, GeneralMassSource):
                _proto.particle_source_model = clientpb.GENERAL_MASS_SOURCE
                _proto.source_particle_mass_injection_rate.CopyFrom(
                    _to_ad_proto(self.physical_behavior_model.mass_injection_rate)
                )
            if isinstance(self.physical_behavior_model, GeneralAccelerationSource):
                _proto.particle_source_model = clientpb.GENERAL_ACCELERATION_SOURCE
                _proto.source_particle_acceleration_vector.CopyFrom(
                    self.physical_behavior_model.acceleration._to_ad_proto()
                )
        if self.blade_element_airfoil_data is not None:
            _proto.blade_element_airfoil_data.extend(
                v._to_proto() for v in self.blade_element_airfoil_data
            )
        return _proto

    def _from_proto(self, proto: clientpb.PhysicalBehavior) -> None:
        self.id = proto.physical_behavior_id
        self.name = proto.physical_behavior_name
        if proto.physical_behavior_model == clientpb.INVALID_PHYSICAL_BEHAVIOR_MODEL:
            raise ValueError("Invalid physical_behavior_model")
        elif proto.physical_behavior_model == clientpb.ACTUATOR_DISK_MODEL:
            self.physical_behavior_model = ActuatorDiskModel()
            if proto.actuator_disk_model == clientpb.INVALID_ACTUATOR_DISK_MODEL:
                raise ValueError("Invalid actuator_disk_model")
            elif proto.actuator_disk_model == clientpb.ACTUATOR_DISK_UNIFORM_THRUST:
                self.physical_behavior_model = ActuatorDiskUniformThrust()
                self.physical_behavior_model.thrust = _from_ad_proto(proto.actuator_disk_thrust)
            elif proto.actuator_disk_model == clientpb.ACTUATOR_DISK_RADIAL_DISTRIBUTION:
                self.physical_behavior_model = ActuatorDiskRadialDistribution()
                self.physical_behavior_model.thrust = _from_ad_proto(proto.actuator_disk_thrust)
                self.physical_behavior_model.torque = _from_ad_proto(proto.actuator_disk_torque)
                self.physical_behavior_model.radial_force = _from_ad_proto(
                    proto.actuator_disk_radial_force
                )
                if proto.actuator_disk_radial_table_data != "":
                    self.physical_behavior_model.radial_distribution_table = RectilinearTable(
                        id=proto.actuator_disk_radial_table_data,
                        name=proto.actuator_disk_radial_table_data,
                        table_type=_param_name_to_table_type("actuator_disk_radial_table_data"),
                    )
            elif proto.actuator_disk_model == clientpb.ACTUATOR_DISK_BLADE_ELEMENT:
                self.physical_behavior_model = ActuatorDiskBladeElement()
                self.physical_behavior_model.blade_element_params.rotation_rate = _from_ad_proto(
                    proto.actuator_disk_rotation_rate
                )
                self.physical_behavior_model.blade_element_params.bem_strategy = (
                    enum.ActuatorDiskBemStrategy(proto.actuator_disk_bem_strategy)
                )
                self.physical_behavior_model.blade_element_params.blade_count = (
                    proto.actuator_disk_blade_count.value
                )
                self.physical_behavior_model.blade_element_params.pitch_schedule._from_ad_proto(
                    proto.blade_element_pitch_schedule
                )
                if proto.blade_element_geometry_data != "":
                    self.physical_behavior_model.blade_element_params.blade_geometry_table = (
                        RectilinearTable(
                            id=proto.blade_element_geometry_data,
                            name=proto.blade_element_geometry_data,
                            table_type=_param_name_to_table_type("blade_element_geometry_data"),
                        )
                    )
                self.physical_behavior_model.blade_element_params.reference_sound_speed = (
                    _from_ad_proto(proto.blade_element_reference_sound_speed)
                )
            elif proto.actuator_disk_model == clientpb.FAN_CURVE_INTERNAL:
                self.physical_behavior_model = FanCurveInternal()
                if proto.fan_curve_table_data != "":
                    self.physical_behavior_model.fan_curve_table = RectilinearTable(
                        id=proto.fan_curve_table_data,
                        name=proto.fan_curve_table_data,
                        table_type=_param_name_to_table_type("fan_curve_table_data"),
                    )
                self.physical_behavior_model.head_loss_coefficient = _from_ad_proto(
                    proto.head_loss_coefficient
                )
        elif proto.physical_behavior_model == clientpb.ACTUATOR_LINE_MODEL:
            self.physical_behavior_model = ActuatorLineModel()
            if proto.actuator_line_model == clientpb.INVALID_ACTUATOR_LINE_MODEL:
                raise ValueError("Invalid actuator_line_model")
            elif proto.actuator_line_model == clientpb.ACTUATOR_LINE_BLADE_ELEMENT:
                self.physical_behavior_model = ActuatorLineBladeElement()
                self.physical_behavior_model.blade_element_params.rotation_rate = _from_ad_proto(
                    proto.actuator_disk_rotation_rate
                )
                self.physical_behavior_model.blade_element_params.bem_strategy = (
                    enum.ActuatorDiskBemStrategy(proto.actuator_disk_bem_strategy)
                )
                self.physical_behavior_model.blade_element_params.blade_count = (
                    proto.actuator_disk_blade_count.value
                )
                self.physical_behavior_model.blade_element_params.pitch_schedule._from_ad_proto(
                    proto.blade_element_pitch_schedule
                )
                if proto.blade_element_geometry_data != "":
                    self.physical_behavior_model.blade_element_params.blade_geometry_table = (
                        RectilinearTable(
                            id=proto.blade_element_geometry_data,
                            name=proto.blade_element_geometry_data,
                            table_type=_param_name_to_table_type("blade_element_geometry_data"),
                        )
                    )
                self.physical_behavior_model.blade_element_params.reference_sound_speed = (
                    _from_ad_proto(proto.blade_element_reference_sound_speed)
                )
        elif proto.physical_behavior_model == clientpb.SOURCE_POINTS_MODEL:
            self.physical_behavior_model = ParticleSourceModel()
            if proto.particle_source_model == clientpb.INVALID_PARTICLE_SOURCE_MODEL:
                raise ValueError("Invalid particle_source_model")
            elif proto.particle_source_model == clientpb.GENERAL_MASS_SOURCE:
                self.physical_behavior_model = GeneralMassSource()
                self.physical_behavior_model.mass_injection_rate = _from_ad_proto(
                    proto.source_particle_mass_injection_rate
                )
            elif proto.particle_source_model == clientpb.GENERAL_ACCELERATION_SOURCE:
                self.physical_behavior_model = GeneralAccelerationSource()
                self.physical_behavior_model.acceleration._from_ad_proto(
                    proto.source_particle_acceleration_vector
                )
        self.blade_element_airfoil_data = [
            BladeElementAirfoilData.from_proto(v) for v in proto.blade_element_airfoil_data
        ]
        return None
