# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class PorousBehavior(CodeRepr, ParamGroupWrapper[clientpb.PorousBehavior]):
    """Porous model settings for a fluid flow physics solver."""

    id: str = field(default_factory=create_unique_id, init=False)
    ""
    name: str = ""
    ""
    volumes: list[str] = field(default_factory=list)
    ""
    porous_model_type: enum.PorousModelType = enum.PorousModelType.DARCY_FORCHHEIMER
    "Type of porous model."
    darcy_coeff: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "(x,y,z) components of the Darcy coefficients."
    forchheimer_coeff: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "(x,y,z) components of the Forchheimer coefficients."
    power_per_unit_volume: LcFloat = 0
    "Power per unit volume of the heat source."
    ref_frame_id: str = ""
    "Frame that defines the principal directions used by the Darcy-Forchheimer coefficients."

    def _to_proto(self) -> clientpb.PorousBehavior:
        _proto = clientpb.PorousBehavior()
        if self.id is not None:
            _proto.porous_behavior_id = self.id
        if self.name is not None:
            _proto.porous_behavior_name = self.name
        if self.volumes is not None:
            _proto.zone_ids.extend(self.volumes)
        _proto.porous_model_type = self.porous_model_type.value
        _proto.darcy_coeff.CopyFrom(self.darcy_coeff._to_ad_proto())
        _proto.forchheimer_coeff.CopyFrom(self.forchheimer_coeff._to_ad_proto())
        _proto.porous_heat_source_power_per_unit_volume.CopyFrom(
            _to_ad_proto(self.power_per_unit_volume)
        )
        if self.ref_frame_id is not None:
            _proto.ref_frame_id = self.ref_frame_id
        return _proto

    def _from_proto(self, proto: clientpb.PorousBehavior) -> None:
        self.id = proto.porous_behavior_id
        self.name = proto.porous_behavior_name
        self.volumes.extend(proto.zone_ids)
        self.porous_model_type = enum.PorousModelType(proto.porous_model_type)
        self.darcy_coeff._from_ad_proto(proto.darcy_coeff)
        self.forchheimer_coeff._from_ad_proto(proto.forchheimer_coeff)
        self.power_per_unit_volume = _from_ad_proto(proto.porous_heat_source_power_per_unit_volume)
        self.ref_frame_id = proto.ref_frame_id
        return None
