# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.solution_controls.pseudo_time_step_method.cfl_based_ import (
    CflBased,
)
from luminarycloud.params.simulation.physics.fluid.solution_controls.pseudo_time_step_method.cfl_based_ import *
from luminarycloud.params.simulation.physics.fluid.solution_controls.pseudo_time_step_method.fixed_pseudo_time_step_ import (
    FixedPseudoTimeStep,
)
from luminarycloud.params.simulation.physics.fluid.solution_controls.pseudo_time_step_method.fixed_pseudo_time_step_ import *
from luminarycloud.params.simulation.physics.fluid.solution_controls.fluid_relaxation_method.fluid_explicit_relaxation_ import (
    FluidExplicitRelaxation,
)
from luminarycloud.params.simulation.physics.fluid.solution_controls.fluid_relaxation_method.fluid_explicit_relaxation_ import *
from luminarycloud.params.simulation.physics.fluid.solution_controls.fluid_relaxation_method.fluid_implicit_relaxation_ import (
    FluidImplicitRelaxation,
)
from luminarycloud.params.simulation.physics.fluid.solution_controls.fluid_relaxation_method.fluid_implicit_relaxation_ import *
from luminarycloud.params.simulation.physics.fluid.solution_controls.fluid_relaxation_method_ import (
    FluidRelaxationMethod,
)
from luminarycloud.params.simulation.physics.fluid.solution_controls.fluid_relaxation_method_ import *
from luminarycloud.params.simulation.physics.fluid.solution_controls.pseudo_time_step_method_ import (
    PseudoTimeStepMethod,
)
from luminarycloud.params.simulation.physics.fluid.solution_controls.pseudo_time_step_method_ import *


@dataclass(kw_only=True)
class SolutionControlsFluid(CodeRepr, ParamGroupWrapper[clientpb.SolutionControlsFluid]):
    """Solution controls for a fluid flow physics solver."""

    pseudo_time_step_method: PseudoTimeStepMethod = field(default_factory=CflBased)
    "Method for obtaining the pseudo time step in a steady-state simulation or for the inner iterations of the dual time stepping method. Possible types: ``CflBased``, ``FixedPseudoTimeStep`` from the ``pseudo_time_step_method`` module."
    fluid_relaxation_method: FluidRelaxationMethod = field(default_factory=FluidImplicitRelaxation)
    "Relaxation scheme for steady-state simulations or time implicit transient simulations. Possible types: ``FluidImplicitRelaxation``, ``FluidExplicitRelaxation`` from the ``fluid_relaxation_method`` module."
    preset: enum.SolutionControlsFluidPreset = (
        enum.SolutionControlsFluidPreset.DEFAULT_SOLUTION_CONTROLS_FLUID
    )
    "Select suggested control settings or allow a custom choice. In general, assume a trade-off between speed and robustness (i.e. the ability to converge)."

    def _to_proto(self) -> clientpb.SolutionControlsFluid:
        _proto = clientpb.SolutionControlsFluid()
        if isinstance(self.pseudo_time_step_method, CflBased):
            _proto.pseudo_time_step_method = clientpb.CFL_BASED
            _proto.cfl.CopyFrom(_to_ad_proto(self.pseudo_time_step_method.cfl))
        if isinstance(self.pseudo_time_step_method, FixedPseudoTimeStep):
            _proto.pseudo_time_step_method = clientpb.FIXED_PSEUDO_TIME_STEP
            _proto.pseudo_time_step_val.CopyFrom(
                _to_ad_proto(self.pseudo_time_step_method.pseudo_time_step)
            )
        if isinstance(self.fluid_relaxation_method, FluidImplicitRelaxation):
            _proto.relaxation_method = clientpb.IMPLICIT
            _proto.implicit_method = self.fluid_relaxation_method.implicit_method.value
            _proto.linsol_iterations.value = (
                self.fluid_relaxation_method.linear_solver_type.iterations
            )
            _proto.linsol_tolerance.CopyFrom(
                _to_ad_proto(self.fluid_relaxation_method.linear_solver_type.tolerance)
            )
            if isinstance(self.fluid_relaxation_method.linear_solver_type, GaussSeidel):
                _proto.linear_solver_type = clientpb.GS
            if isinstance(self.fluid_relaxation_method.linear_solver_type, KrylovAmg):
                _proto.linear_solver_type = clientpb.AMG_KRYLOV_AMGX
                _proto.linsol_amg_pre_sweeps.value = (
                    self.fluid_relaxation_method.linear_solver_type.pre_sweeps
                )
                _proto.linsol_amg_post_sweeps.value = (
                    self.fluid_relaxation_method.linear_solver_type.post_sweeps
                )
                _proto.linsol_amg_coarsening_size.value = (
                    self.fluid_relaxation_method.linear_solver_type.coarsening_size
                )
                _proto.linsol_amg_levels.value = (
                    self.fluid_relaxation_method.linear_solver_type.levels
                )
                _proto.linsol_amg_relaxation.CopyFrom(
                    _to_ad_proto(self.fluid_relaxation_method.linear_solver_type.relaxation)
                )
                _proto.linsol_amg_cycle_type = (
                    self.fluid_relaxation_method.linear_solver_type.multigrid_cycle.value
                )
                _proto.linsol_amg_freeze_levels_threshold.value = (
                    self.fluid_relaxation_method.linear_solver_type.freeze_levels_threshold
                )
                _proto.linsol_amg_smoother = (
                    self.fluid_relaxation_method.linear_solver_type.smoother.value
                )
            _proto.jacobian_update_method = (
                self.fluid_relaxation_method.jacobian_update_method.value
            )
            _proto.jacobian_update_interval.CopyFrom(
                _to_ad_proto(self.fluid_relaxation_method.jacobian_update_interval)
            )
            _proto.jacobian_warmup_threshold.value = (
                self.fluid_relaxation_method.jacobian_warmup_threshold
            )
            if isinstance(self.fluid_relaxation_method.robust_startup, RobustStartupOn):
                _proto.robust_startup = clientpb.ROBUST_STARTUP_ON
                _proto.robust_startup_initial_cfl.CopyFrom(
                    _to_ad_proto(
                        self.fluid_relaxation_method.robust_startup.robust_startup_initial_cfl
                    )
                )
                _proto.robust_startup_iterations.value = (
                    self.fluid_relaxation_method.robust_startup.robust_startup_iterations
                )
            if isinstance(self.fluid_relaxation_method.robust_startup, RobustStartupAuto):
                _proto.robust_startup = clientpb.ROBUST_STARTUP_AUTO
            if isinstance(self.fluid_relaxation_method.robust_startup, RobustStartupOff):
                _proto.robust_startup = clientpb.ROBUST_STARTUP_OFF
            _proto.relax_flow.CopyFrom(_to_ad_proto(self.fluid_relaxation_method.relaxation_flow))
            _proto.relax_turb.CopyFrom(_to_ad_proto(self.fluid_relaxation_method.relaxation_turb))
            _proto.update_limit_flow.CopyFrom(
                _to_ad_proto(self.fluid_relaxation_method.update_limit_flow)
            )
            _proto.update_limit_turb.CopyFrom(
                _to_ad_proto(self.fluid_relaxation_method.update_limit_turb)
            )
        if isinstance(self.fluid_relaxation_method, FluidExplicitRelaxation):
            _proto.relaxation_method = clientpb.EXPLICIT
            _proto.explicit_method = self.fluid_relaxation_method.explicit_method.value
        _proto.solution_controls_fluid_preset = self.preset.value
        return _proto

    def _from_proto(self, proto: clientpb.SolutionControlsFluid) -> None:
        if proto.pseudo_time_step_method == clientpb.INVALID_PSEUDO_TIME_STEP_METHOD:
            raise ValueError("Invalid pseudo_time_step_method")
        elif proto.pseudo_time_step_method == clientpb.CFL_BASED:
            self.pseudo_time_step_method = CflBased()
            self.pseudo_time_step_method.cfl = _from_ad_proto(proto.cfl)
        elif proto.pseudo_time_step_method == clientpb.FIXED_PSEUDO_TIME_STEP:
            self.pseudo_time_step_method = FixedPseudoTimeStep()
            self.pseudo_time_step_method.pseudo_time_step = _from_ad_proto(
                proto.pseudo_time_step_val
            )
        if proto.relaxation_method == clientpb.INVALID_RELAXATION_METHOD:
            raise ValueError("Invalid fluid_relaxation_method")
        elif proto.relaxation_method == clientpb.IMPLICIT:
            self.fluid_relaxation_method = FluidImplicitRelaxation()
            self.fluid_relaxation_method.implicit_method = enum.ImplicitMethod(
                proto.implicit_method
            )
            self.fluid_relaxation_method.linear_solver_type.iterations = (
                proto.linsol_iterations.value
            )
            self.fluid_relaxation_method.linear_solver_type.tolerance = _from_ad_proto(
                proto.linsol_tolerance
            )
            if proto.linear_solver_type == clientpb.INVALID_LINEAR_SOLVER_TYPE:
                raise ValueError("Invalid linear_solver_type")
            elif proto.linear_solver_type == clientpb.GS:
                self.fluid_relaxation_method.linear_solver_type = GaussSeidel()
            elif proto.linear_solver_type == clientpb.AMG_KRYLOV_AMGX:
                self.fluid_relaxation_method.linear_solver_type = KrylovAmg()
                self.fluid_relaxation_method.linear_solver_type.pre_sweeps = (
                    proto.linsol_amg_pre_sweeps.value
                )
                self.fluid_relaxation_method.linear_solver_type.post_sweeps = (
                    proto.linsol_amg_post_sweeps.value
                )
                self.fluid_relaxation_method.linear_solver_type.coarsening_size = (
                    proto.linsol_amg_coarsening_size.value
                )
                self.fluid_relaxation_method.linear_solver_type.levels = (
                    proto.linsol_amg_levels.value
                )
                self.fluid_relaxation_method.linear_solver_type.relaxation = _from_ad_proto(
                    proto.linsol_amg_relaxation
                )
                self.fluid_relaxation_method.linear_solver_type.multigrid_cycle = (
                    enum.LinsolAmgCycleType(proto.linsol_amg_cycle_type)
                )
                self.fluid_relaxation_method.linear_solver_type.freeze_levels_threshold = (
                    proto.linsol_amg_freeze_levels_threshold.value
                )
                self.fluid_relaxation_method.linear_solver_type.smoother = enum.LinsolAmgSmoother(
                    proto.linsol_amg_smoother
                )
            self.fluid_relaxation_method.jacobian_update_method = enum.JacobianUpdateMethod(
                proto.jacobian_update_method
            )
            self.fluid_relaxation_method.jacobian_update_interval = _from_ad_proto(
                proto.jacobian_update_interval
            )
            self.fluid_relaxation_method.jacobian_warmup_threshold = (
                proto.jacobian_warmup_threshold.value
            )
            if proto.robust_startup == clientpb.INVALID_ROBUST_STARTUP:
                raise ValueError("Invalid robust_startup")
            elif proto.robust_startup == clientpb.ROBUST_STARTUP_ON:
                self.fluid_relaxation_method.robust_startup = RobustStartupOn()
                self.fluid_relaxation_method.robust_startup.robust_startup_initial_cfl = (
                    _from_ad_proto(proto.robust_startup_initial_cfl)
                )
                self.fluid_relaxation_method.robust_startup.robust_startup_iterations = (
                    proto.robust_startup_iterations.value
                )
            elif proto.robust_startup == clientpb.ROBUST_STARTUP_AUTO:
                self.fluid_relaxation_method.robust_startup = RobustStartupAuto()
            elif proto.robust_startup == clientpb.ROBUST_STARTUP_OFF:
                self.fluid_relaxation_method.robust_startup = RobustStartupOff()
            self.fluid_relaxation_method.relaxation_flow = _from_ad_proto(proto.relax_flow)
            self.fluid_relaxation_method.relaxation_turb = _from_ad_proto(proto.relax_turb)
            self.fluid_relaxation_method.update_limit_flow = _from_ad_proto(proto.update_limit_flow)
            self.fluid_relaxation_method.update_limit_turb = _from_ad_proto(proto.update_limit_turb)
        elif proto.relaxation_method == clientpb.EXPLICIT:
            self.fluid_relaxation_method = FluidExplicitRelaxation()
            self.fluid_relaxation_method.explicit_method = enum.ExplicitMethod(
                proto.explicit_method
            )
        self.preset = enum.SolutionControlsFluidPreset(proto.solution_controls_fluid_preset)
        return None
