# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_ import (
    ConvectiveScheme,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_order_ import (
    ConvectiveSchemeOrder,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_order_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.ec2_ import (
    Ec2,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.ec2_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.fds_ import (
    Fds,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.fds_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_order.first_order_ import (
    FirstOrder,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_order.first_order_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.ld2_ import (
    Ld2,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.ld2_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.rhie_chow_ import (
    RhieChow,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme.rhie_chow_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_order.second_order_ import (
    SecondOrder,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization.convective_scheme_order.second_order_ import *


@dataclass(kw_only=True)
class SpatialDiscretizationFluid(CodeRepr, ParamGroupWrapper[clientpb.SpatialDiscretizationFluid]):
    """Spatial discretization settings for a fluid flow physics solver."""

    gradient_method: enum.GradientMethod = enum.GradientMethod.NODAL_GRADIENT
    "Method for computing the spatial gradients of fluid variables."
    hlsq_blend: LcFloat = 2.0
    "Blending parameter in the hybrid least squares gradient methods in [1,2]."
    convective_scheme: ConvectiveScheme = field(default_factory=Fds)
    "Type of scheme for discretizing the convective terms of the fluid equations. Possible types: ``Fds``, ``Ld2``, ``Ec2``, ``RhieChow`` from the ``convective_scheme`` module."
    convective_scheme_order: ConvectiveSchemeOrder = field(default_factory=SecondOrder)
    "Spatial order of accuracy of the convective scheme used for the fluid equations. Possible types: ``SecondOrder``, ``FirstOrder`` from the ``convective_scheme_order`` module."
    preset: enum.SpatialDiscretizationFluidPreset = (
        enum.SpatialDiscretizationFluidPreset.DEFAULT_SPATIAL_DISCRETIZATION_FLUID
    )
    "Select suggested control settings or allow a custom choice. In general, assume a trade-off between accuracy and robustness (i.e. the ability to converge)."

    def _to_proto(self) -> clientpb.SpatialDiscretizationFluid:
        _proto = clientpb.SpatialDiscretizationFluid()
        _proto.gradient_method = self.gradient_method.value
        _proto.hlsq_blend.CopyFrom(_to_ad_proto(self.hlsq_blend))
        if isinstance(self.convective_scheme, Fds):
            _proto.convective_schemes_density_based = clientpb.ROE
            _proto.entropy_epsilon.CopyFrom(_to_ad_proto(self.convective_scheme.entropy_epsilon))
            _proto.preconditioning = self.convective_scheme.preconditioning.value
            _proto.fds_min_low_dissipation.CopyFrom(
                _to_ad_proto(self.convective_scheme.fds_min_low_dissipation)
            )
        if isinstance(self.convective_scheme, Ld2):
            _proto.convective_schemes_density_based = clientpb.LD2
            _proto.entropy_epsilon.CopyFrom(_to_ad_proto(self.convective_scheme.entropy_epsilon))
            _proto.alpha_hybrid.CopyFrom(_to_ad_proto(self.convective_scheme.alpha_hybrid))
            _proto.artificial_viscosity_model = (
                self.convective_scheme.artificial_viscosity_model.value
            )
        if isinstance(self.convective_scheme, Ec2):
            _proto.convective_schemes_density_based = clientpb.EC2
            _proto.skew_symmetric_formulation = (
                self.convective_scheme.skew_symmetric_formulation.value
            )
            _proto.artificial_viscosity_model = (
                self.convective_scheme.artificial_viscosity_model.value
            )
        if isinstance(self.convective_scheme, RhieChow):
            _proto.convective_schemes_density_based = clientpb.RHIE_CHOW
            _proto.alpha_hybrid.CopyFrom(_to_ad_proto(self.convective_scheme.alpha_hybrid))
        if isinstance(self.convective_scheme_order, SecondOrder):
            _proto.upwind_scheme_order = clientpb.SECOND
            _proto.robust_dissipation = self.convective_scheme_order.robust_dissipation.value
            _proto.limiter = self.convective_scheme_order.limiter.value
            _proto.limiter_kappa.CopyFrom(_to_ad_proto(self.convective_scheme_order.limiter_kappa))
            _proto.umuscl_chi.CopyFrom(_to_ad_proto(self.convective_scheme_order.umuscl_chi))
            _proto.alpha_ld2.CopyFrom(_to_ad_proto(self.convective_scheme_order.alpha_ld2))
            _proto.geometry_fixes = self.convective_scheme_order.geometry_fixes.value
            _proto.geometry_fixes_mitigations.CopyFrom(
                _to_ad_proto(self.convective_scheme_order.geometry_fixes_mitigations)
            )
            _proto.order_blend.CopyFrom(_to_ad_proto(self.convective_scheme_order.order_blend))
        if isinstance(self.convective_scheme_order, FirstOrder):
            _proto.upwind_scheme_order = clientpb.FIRST
        _proto.spatial_discretization_fluid_preset = self.preset.value
        return _proto

    def _from_proto(self, proto: clientpb.SpatialDiscretizationFluid) -> None:
        self.gradient_method = enum.GradientMethod(proto.gradient_method)
        self.hlsq_blend = _from_ad_proto(proto.hlsq_blend)
        if (
            proto.convective_schemes_density_based
            == clientpb.INVALID_CONVECTIVE_SCHEMES_DENSITY_BASED
        ):
            raise ValueError("Invalid convective_scheme")
        elif proto.convective_schemes_density_based == clientpb.ROE:
            self.convective_scheme = Fds()
            self.convective_scheme.entropy_epsilon = _from_ad_proto(proto.entropy_epsilon)
            self.convective_scheme.preconditioning = enum.Preconditioning(proto.preconditioning)
            self.convective_scheme.fds_min_low_dissipation = _from_ad_proto(
                proto.fds_min_low_dissipation
            )
        elif proto.convective_schemes_density_based == clientpb.LD2:
            self.convective_scheme = Ld2()
            self.convective_scheme.entropy_epsilon = _from_ad_proto(proto.entropy_epsilon)
            self.convective_scheme.alpha_hybrid = _from_ad_proto(proto.alpha_hybrid)
            self.convective_scheme.artificial_viscosity_model = enum.ArtificialViscosityModel(
                proto.artificial_viscosity_model
            )
        elif proto.convective_schemes_density_based == clientpb.EC2:
            self.convective_scheme = Ec2()
            self.convective_scheme.skew_symmetric_formulation = enum.SkewSymmetricFormulation(
                proto.skew_symmetric_formulation
            )
            self.convective_scheme.artificial_viscosity_model = enum.ArtificialViscosityModel(
                proto.artificial_viscosity_model
            )
        elif proto.convective_schemes_density_based == clientpb.RHIE_CHOW:
            self.convective_scheme = RhieChow()
            self.convective_scheme.alpha_hybrid = _from_ad_proto(proto.alpha_hybrid)
        if proto.upwind_scheme_order == clientpb.INVALID_UPWIND_SCHEME_ORDER:
            raise ValueError("Invalid convective_scheme_order")
        elif proto.upwind_scheme_order == clientpb.SECOND:
            self.convective_scheme_order = SecondOrder()
            self.convective_scheme_order.robust_dissipation = enum.RobustDissipation(
                proto.robust_dissipation
            )
            self.convective_scheme_order.limiter = enum.Limiter(proto.limiter)
            self.convective_scheme_order.limiter_kappa = _from_ad_proto(proto.limiter_kappa)
            self.convective_scheme_order.umuscl_chi = _from_ad_proto(proto.umuscl_chi)
            self.convective_scheme_order.alpha_ld2 = _from_ad_proto(proto.alpha_ld2)
            self.convective_scheme_order.geometry_fixes = enum.GeometryFixes(proto.geometry_fixes)
            self.convective_scheme_order.geometry_fixes_mitigations = _from_ad_proto(
                proto.geometry_fixes_mitigations
            )
            self.convective_scheme_order.order_blend = _from_ad_proto(proto.order_blend)
        elif proto.upwind_scheme_order == clientpb.FIRST:
            self.convective_scheme_order = FirstOrder()
        self.preset = enum.SpatialDiscretizationFluidPreset(
            proto.spatial_discretization_fluid_preset
        )
        return None
