# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.turbulence_ import Turbulence
from luminarycloud.params.simulation.physics.fluid.turbulence_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst.constants.custom_komega_sst_constants_ import (
    CustomKomegaSstConstants,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst.constants.custom_komega_sst_constants_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst.constants.default_komega_sst_constants_ import (
    DefaultKomegaSstConstants,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst.constants.default_komega_sst_constants_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst.komega_sst_constants_ import (
    KomegaSstConstants,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst.komega_sst_constants_ import *


@dataclass(kw_only=True)
class KomegaSst(Turbulence):
    """SST 2003m model."""

    qcr: enum.QcrSst = enum.QcrSst.SST_QCR_OFF
    "Modification of the traditional linear Boussinesq relation for the SST turbulence model via the quadratic constitutive relation (QCR)."
    kato_launder: bool = False
    "Modification of the traditional SST source term (SΩ instead of S<sup>2</sup>)."
    constants: KomegaSstConstants = field(default_factory=DefaultKomegaSstConstants)
    "Apply default constants for the RANS turbulence model or choose to customize. Possible types: ``DefaultKomegaSstConstants``, ``CustomKomegaSstConstants`` from the ``constants`` module."

    def _to_proto(self) -> clientpb.Turbulence:
        _proto = super()._to_proto()
        _proto.turbulence_model = clientpb.TurbulenceModel.KOMEGA_SST
        _proto.qcr_sst = self.qcr.value
        _proto.kato_launder = self.kato_launder
        if isinstance(self.constants, DefaultKomegaSstConstants):
            _proto.turbulence_model_constants = clientpb.DEFAULT_TURB_CONSTANTS
        if isinstance(self.constants, CustomKomegaSstConstants):
            _proto.turbulence_model_constants = clientpb.CUSTOM_TURB_CONSTANTS
            _proto.C_sst_des1.CopyFrom(_to_ad_proto(self.constants.c_des1))
            _proto.C_sst_des2.CopyFrom(_to_ad_proto(self.constants.c_des2))
            _proto.sigma_k_1.CopyFrom(_to_ad_proto(self.constants.sigma_k_1))
            _proto.sigma_k_2.CopyFrom(_to_ad_proto(self.constants.sigma_k_2))
            _proto.sigma_w_1.CopyFrom(_to_ad_proto(self.constants.sigma_w_1))
            _proto.sigma_w_2.CopyFrom(_to_ad_proto(self.constants.sigma_w_2))
            _proto.beta_1.CopyFrom(_to_ad_proto(self.constants.beta_1))
            _proto.beta_2.CopyFrom(_to_ad_proto(self.constants.beta_2))
            _proto.beta_star.CopyFrom(_to_ad_proto(self.constants.beta_star))
            _proto.kappa_sst.CopyFrom(_to_ad_proto(self.constants.kappa))
            _proto.a_1.CopyFrom(_to_ad_proto(self.constants.a_1))
            _proto.gamma_1.CopyFrom(_to_ad_proto(self.constants.gamma_1))
            _proto.gamma_2.CopyFrom(_to_ad_proto(self.constants.gamma_2))
        return _proto

    def _from_proto(self, proto: clientpb.Turbulence) -> None:
        super()._from_proto(proto)
        assert proto.turbulence_model == clientpb.TurbulenceModel.KOMEGA_SST
        self.qcr = enum.QcrSst(proto.qcr_sst)
        self.kato_launder = proto.kato_launder
        if proto.turbulence_model_constants == clientpb.INVALID_TURBULENCE_MODEL_CONSTANTS:
            raise ValueError("Invalid komega_sst_constants")
        elif proto.turbulence_model_constants == clientpb.DEFAULT_TURB_CONSTANTS:
            self.constants = DefaultKomegaSstConstants()
        elif proto.turbulence_model_constants == clientpb.CUSTOM_TURB_CONSTANTS:
            self.constants = CustomKomegaSstConstants()
            self.constants.c_des1 = _from_ad_proto(proto.C_sst_des1)
            self.constants.c_des2 = _from_ad_proto(proto.C_sst_des2)
            self.constants.sigma_k_1 = _from_ad_proto(proto.sigma_k_1)
            self.constants.sigma_k_2 = _from_ad_proto(proto.sigma_k_2)
            self.constants.sigma_w_1 = _from_ad_proto(proto.sigma_w_1)
            self.constants.sigma_w_2 = _from_ad_proto(proto.sigma_w_2)
            self.constants.beta_1 = _from_ad_proto(proto.beta_1)
            self.constants.beta_2 = _from_ad_proto(proto.beta_2)
            self.constants.beta_star = _from_ad_proto(proto.beta_star)
            self.constants.kappa = _from_ad_proto(proto.kappa_sst)
            self.constants.a_1 = _from_ad_proto(proto.a_1)
            self.constants.gamma_1 = _from_ad_proto(proto.gamma_1)
            self.constants.gamma_2 = _from_ad_proto(proto.gamma_2)
        return None
