# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.turbulence_ import Turbulence
from luminarycloud.params.simulation.physics.fluid.turbulence_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras.constants.custom_spalart_allmaras_constants_ import (
    CustomSpalartAllmarasConstants,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras.constants.custom_spalart_allmaras_constants_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras.constants.default_spalart_allmaras_constants_ import (
    DefaultSpalartAllmarasConstants,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras.constants.default_spalart_allmaras_constants_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras.spalart_allmaras_constants_ import (
    SpalartAllmarasConstants,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras.spalart_allmaras_constants_ import *


@dataclass(kw_only=True)
class SpalartAllmaras(Turbulence):
    """'Standard' Spalart-Allmaras one-equation turbulence model."""

    qcr: enum.QcrSa = enum.QcrSa.QCR_OFF
    "Modification of the traditional linear Boussinesq relation for the Spalart-Allmaras turbulence model via the quadratic constitutive relation (QCR)."
    rotation_correction: enum.RotationCorrectionSa = (
        enum.RotationCorrectionSa.ROTATION_CORRECTION_OFF
    )
    "Apply a rotation correction to the Spalart-Allmaras turbulence model."
    constants: SpalartAllmarasConstants = field(default_factory=DefaultSpalartAllmarasConstants)
    "Apply default constants for the RANS turbulence model or choose to customize. Possible types: ``DefaultSpalartAllmarasConstants``, ``CustomSpalartAllmarasConstants`` from the ``constants`` module."

    def _to_proto(self) -> clientpb.Turbulence:
        _proto = super()._to_proto()
        _proto.turbulence_model = clientpb.TurbulenceModel.SPALART_ALLMARAS
        _proto.qcr_sa = self.qcr.value
        _proto.rotation_correction_sa = self.rotation_correction.value
        if isinstance(self.constants, DefaultSpalartAllmarasConstants):
            _proto.turbulence_model_constants = clientpb.DEFAULT_TURB_CONSTANTS
        if isinstance(self.constants, CustomSpalartAllmarasConstants):
            _proto.turbulence_model_constants = clientpb.CUSTOM_TURB_CONSTANTS
            _proto.c_rot.CopyFrom(_to_ad_proto(self.constants.c_rot))
            _proto.C_sa_des.CopyFrom(_to_ad_proto(self.constants.c_des))
            _proto.c_b_1.CopyFrom(_to_ad_proto(self.constants.c_b_1))
            _proto.sigma.CopyFrom(_to_ad_proto(self.constants.sigma))
            _proto.c_b_2.CopyFrom(_to_ad_proto(self.constants.c_b_2))
            _proto.kappa.CopyFrom(_to_ad_proto(self.constants.kappa))
            _proto.c_w_2.CopyFrom(_to_ad_proto(self.constants.c_w_2))
            _proto.c_w_3.CopyFrom(_to_ad_proto(self.constants.c_w_3))
            _proto.c_v_1.CopyFrom(_to_ad_proto(self.constants.c_v_1))
            _proto.c_t_3.CopyFrom(_to_ad_proto(self.constants.c_t_3))
            _proto.c_t_4.CopyFrom(_to_ad_proto(self.constants.c_t_4))
            _proto.c_r_1.CopyFrom(_to_ad_proto(self.constants.c_r_1))
        return _proto

    def _from_proto(self, proto: clientpb.Turbulence) -> None:
        super()._from_proto(proto)
        assert proto.turbulence_model == clientpb.TurbulenceModel.SPALART_ALLMARAS
        self.qcr = enum.QcrSa(proto.qcr_sa)
        self.rotation_correction = enum.RotationCorrectionSa(proto.rotation_correction_sa)
        if proto.turbulence_model_constants == clientpb.INVALID_TURBULENCE_MODEL_CONSTANTS:
            raise ValueError("Invalid spalart_allmaras_constants")
        elif proto.turbulence_model_constants == clientpb.DEFAULT_TURB_CONSTANTS:
            self.constants = DefaultSpalartAllmarasConstants()
        elif proto.turbulence_model_constants == clientpb.CUSTOM_TURB_CONSTANTS:
            self.constants = CustomSpalartAllmarasConstants()
            self.constants.c_rot = _from_ad_proto(proto.c_rot)
            self.constants.c_des = _from_ad_proto(proto.C_sa_des)
            self.constants.c_b_1 = _from_ad_proto(proto.c_b_1)
            self.constants.sigma = _from_ad_proto(proto.sigma)
            self.constants.c_b_2 = _from_ad_proto(proto.c_b_2)
            self.constants.kappa = _from_ad_proto(proto.kappa)
            self.constants.c_w_2 = _from_ad_proto(proto.c_w_2)
            self.constants.c_w_3 = _from_ad_proto(proto.c_w_3)
            self.constants.c_v_1 = _from_ad_proto(proto.c_v_1)
            self.constants.c_t_3 = _from_ad_proto(proto.c_t_3)
            self.constants.c_t_4 = _from_ad_proto(proto.c_t_4)
            self.constants.c_r_1 = _from_ad_proto(proto.c_r_1)
        return None
