# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.amd_ import Amd
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.amd_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation.ddes_ import Ddes
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation.ddes_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation.ddes_vtm_ import (
    DdesVtm,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation.ddes_vtm_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation_ import DesFormulation
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation.iddes_ import Iddes
from luminarycloud.params.simulation.physics.fluid.turbulence.des_formulation.iddes_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.sigma_ import (
    Sigma,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.sigma_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.smagorinsky_ import (
    Smagorinsky,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.smagorinsky_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model_ import (
    SubGridScaleModel,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.vreman_ import (
    Vreman,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.vreman_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.wale_ import Wale
from luminarycloud.params.simulation.physics.fluid.turbulence.sub_grid_scale_model.wale_ import *


@dataclass(kw_only=True)
class Turbulence(CodeRepr, ParamGroupWrapper[clientpb.Turbulence]):
    """Turbulence settings for a fluid flow physics solver."""

    des_formulation: DesFormulation = field(default_factory=DdesVtm)
    "Select a Detached Eddy Simulation (DES) formulation. Possible types: ``DdesVtm``, ``Iddes``, ``Ddes`` from the ``des_formulation`` module."
    sub_grid_scale_model: SubGridScaleModel | None = field(default_factory=Vreman)
    "Sub-grid scale models available for Large Eddy Simulation (LES). Possible types: ``Smagorinsky``, ``Vreman``, ``Wale``, ``Sigma``, ``Amd`` from the ``sub_grid_scale_model`` module."
    turbulent_prandtl_number: LcFloat = 0.85
    "Turbulent Prandtl number for computing an effective thermal conductivity for heat transport."
    transition_model: enum.TransitionModel = enum.TransitionModel.NO_TRANSITION
    "Laminar-turbulent transition models available for Reynolds-averaged Navier-Stokes (RANS)."
    transition_model_cross_flow: enum.TransitionModelCrossFlow = (
        enum.TransitionModelCrossFlow.TRANSITION_MODEL_CROSS_FLOW_OFF
    )
    "Crossflow instability treatment for transition model."
    transition_free_stream_turbulence_intensity: LcFloat = 0.002
    "The ratio of the root-mean-square velocity fluctuations to the free stream velocity. A higher number indicates a greater degree of turbulence in the incoming flow."

    def _to_proto(self) -> clientpb.Turbulence:
        _proto = clientpb.Turbulence()
        if isinstance(self.des_formulation, DdesVtm):
            _proto.des_formulation = clientpb.DDES_VTM
        if isinstance(self.des_formulation, Iddes):
            _proto.des_formulation = clientpb.IDDES
        if isinstance(self.des_formulation, Ddes):
            _proto.des_formulation = clientpb.DDES
        if self.sub_grid_scale_model is None:
            _proto.sub_grid_scale_model = clientpb.NONE
        if isinstance(self.sub_grid_scale_model, Smagorinsky):
            _proto.sub_grid_scale_model = clientpb.SMAGORINSKY
            _proto.c_s.CopyFrom(_to_ad_proto(self.sub_grid_scale_model.c_s))
        if isinstance(self.sub_grid_scale_model, Vreman):
            _proto.sub_grid_scale_model = clientpb.VREMAN
            _proto.c_vreman.CopyFrom(_to_ad_proto(self.sub_grid_scale_model.c_vreman))
        if isinstance(self.sub_grid_scale_model, Wale):
            _proto.sub_grid_scale_model = clientpb.WALE
            _proto.c_wale.CopyFrom(_to_ad_proto(self.sub_grid_scale_model.c_wale))
        if isinstance(self.sub_grid_scale_model, Sigma):
            _proto.sub_grid_scale_model = clientpb.SIGMA
            _proto.c_sigma.CopyFrom(_to_ad_proto(self.sub_grid_scale_model.c_sigma))
        if isinstance(self.sub_grid_scale_model, Amd):
            _proto.sub_grid_scale_model = clientpb.AMD
            _proto.c_amd.CopyFrom(_to_ad_proto(self.sub_grid_scale_model.c_amd))
        _proto.turbulent_thermal_conductivity_prandtl_constant.CopyFrom(
            _to_ad_proto(self.turbulent_prandtl_number)
        )
        _proto.transition_model = self.transition_model.value
        _proto.transition_model_cross_flow = self.transition_model_cross_flow.value
        _proto.transition_free_stream_turbulence_intensity.CopyFrom(
            _to_ad_proto(self.transition_free_stream_turbulence_intensity)
        )
        return _proto

    def _from_proto(self, proto: clientpb.Turbulence) -> None:
        if proto.des_formulation == clientpb.INVALID_DES_FORMULATION:
            raise ValueError("Invalid des_formulation")
        elif proto.des_formulation == clientpb.DDES_VTM:
            self.des_formulation = DdesVtm()
        elif proto.des_formulation == clientpb.IDDES:
            self.des_formulation = Iddes()
        elif proto.des_formulation == clientpb.DDES:
            self.des_formulation = Ddes()
        if proto.sub_grid_scale_model == clientpb.INVALID_SUB_GRID_SCALE_MODEL:
            raise ValueError("Invalid sub_grid_scale_model")
        elif proto.sub_grid_scale_model == clientpb.NONE:
            self.sub_grid_scale_model = None
        elif proto.sub_grid_scale_model == clientpb.SMAGORINSKY:
            self.sub_grid_scale_model = Smagorinsky()
            self.sub_grid_scale_model.c_s = _from_ad_proto(proto.c_s)
        elif proto.sub_grid_scale_model == clientpb.VREMAN:
            self.sub_grid_scale_model = Vreman()
            self.sub_grid_scale_model.c_vreman = _from_ad_proto(proto.c_vreman)
        elif proto.sub_grid_scale_model == clientpb.WALE:
            self.sub_grid_scale_model = Wale()
            self.sub_grid_scale_model.c_wale = _from_ad_proto(proto.c_wale)
        elif proto.sub_grid_scale_model == clientpb.SIGMA:
            self.sub_grid_scale_model = Sigma()
            self.sub_grid_scale_model.c_sigma = _from_ad_proto(proto.c_sigma)
        elif proto.sub_grid_scale_model == clientpb.AMD:
            self.sub_grid_scale_model = Amd()
            self.sub_grid_scale_model.c_amd = _from_ad_proto(proto.c_amd)
        self.turbulent_prandtl_number = _from_ad_proto(
            proto.turbulent_thermal_conductivity_prandtl_constant
        )
        self.transition_model = enum.TransitionModel(proto.transition_model)
        self.transition_model_cross_flow = enum.TransitionModelCrossFlow(
            proto.transition_model_cross_flow
        )
        self.transition_free_stream_turbulence_intensity = _from_ad_proto(
            proto.transition_free_stream_turbulence_intensity
        )
        return None
