# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid.adjoint_controls_fluid_ import (
    AdjointControlsFluid,
)
from luminarycloud.params.simulation.physics.fluid.adjoint_controls_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.basic_fluid_ import BasicFluid
from luminarycloud.params.simulation.physics.fluid.basic_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import (
    BoundaryConditionsFluid,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.fan_curve_inlet_ import (
    FanCurveInlet,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.fan_curve_inlet_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.farfield_ import Farfield
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.farfield_ import *
from luminarycloud.params.simulation.physics.fluid.initialization.fluid_existing_solution_ import (
    FluidExistingSolution,
)
from luminarycloud.params.simulation.physics.fluid.initialization.fluid_existing_solution_ import *
from luminarycloud.params.simulation.physics.fluid.initialization.fluid_farfield_values_ import (
    FluidFarfieldValues,
)
from luminarycloud.params.simulation.physics.fluid.initialization.fluid_farfield_values_ import *
from luminarycloud.params.simulation.physics.fluid.initialization.fluid_prescribed_values_ import (
    FluidPrescribedValues,
)
from luminarycloud.params.simulation.physics.fluid.initialization.fluid_prescribed_values_ import *
from luminarycloud.params.simulation.physics.fluid.initialization_fluid_ import InitializationFluid
from luminarycloud.params.simulation.physics.fluid.initialization_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import Inlet
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst_ import KomegaSst
from luminarycloud.params.simulation.physics.fluid.turbulence.komega_sst_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.mach_inlet_ import (
    MachInlet,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.mach_inlet_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.mass_flow_inlet_ import (
    MassFlowInlet,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.mass_flow_inlet_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet_ import Outlet
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.outlet_ import *
from luminarycloud.params.simulation.physics.periodic_pair_ import PeriodicPair
from luminarycloud.params.simulation.physics.periodic_pair_ import *
from luminarycloud.params.simulation.physics.fluid.physical_behavior_ import PhysicalBehavior
from luminarycloud.params.simulation.physics.fluid.physical_behavior_ import *
from luminarycloud.params.simulation.physics.fluid.porous_behavior_ import PorousBehavior
from luminarycloud.params.simulation.physics.fluid.porous_behavior_ import *
from luminarycloud.params.simulation.sliding_interfaces_ import SlidingInterfaces
from luminarycloud.params.simulation.sliding_interfaces_ import *
from luminarycloud.params.simulation.physics.fluid.solution_controls_fluid_ import (
    SolutionControlsFluid,
)
from luminarycloud.params.simulation.physics.fluid.solution_controls_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras_ import (
    SpalartAllmaras,
)
from luminarycloud.params.simulation.physics.fluid.turbulence.spalart_allmaras_ import *
from luminarycloud.params.simulation.physics.fluid.spatial_discretization_fluid_ import (
    SpatialDiscretizationFluid,
)
from luminarycloud.params.simulation.physics.fluid.spatial_discretization_fluid_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.symmetry_ import Symmetry
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.symmetry_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.total_pressure_inlet_ import (
    TotalPressureInlet,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.total_pressure_inlet_ import *
from luminarycloud.params.simulation.physics.fluid.turbulence_ import Turbulence
from luminarycloud.params.simulation.physics.fluid.turbulence_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.velocity_components_inlet_ import (
    VelocityComponentsInlet,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.velocity_components_inlet_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.velocity_magnitude_inlet_ import (
    VelocityMagnitudeInlet,
)
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.inlet.velocity_magnitude_inlet_ import *
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall_ import Wall
from luminarycloud.params.simulation.physics.fluid.boundary_conditions.wall_ import *


@dataclass(kw_only=True)
class Fluid(CodeRepr, ParamGroupWrapper[clientpb.Fluid]):
    """Configuration for a fluid flow physics solver - simulates the flow of liquids and gases."""

    basic: BasicFluid = field(default_factory=BasicFluid)
    "Basic settings for a fluid flow physics solver."
    turbulence: Turbulence = field(default_factory=SpalartAllmaras)
    "Turbulence settings for a fluid flow physics solver. Possible types: ``SpalartAllmaras``, ``KomegaSst`` from the ``turbulence`` module."
    solution_controls: SolutionControlsFluid = field(default_factory=SolutionControlsFluid)
    "Solution controls for a fluid flow physics solver."
    adjoint_controls: AdjointControlsFluid = field(default_factory=AdjointControlsFluid)
    ""
    spatial_discretization: SpatialDiscretizationFluid = field(
        default_factory=SpatialDiscretizationFluid
    )
    "Spatial discretization settings for a fluid flow physics solver."
    boundary_conditions: list[BoundaryConditionsFluid] = field(default_factory=list)
    "Boundary conditions for a fluid flow physics solver. Possible types: ``Wall``, ``Inlet``, ``Outlet``, ``Symmetry``, ``Farfield`` from the ``boundary_conditions`` module."
    sliding_interfaces: list[SlidingInterfaces] = field(default_factory=list)
    "Defines the two sides that form a sliding interface. The two sides are abutting, possibly in combination with a periodic transformation, and should have the same normal grid velocity. The tangential grid velocity can, and usually will, be different. Each side of the sliding interface can be composed out of an arbitrary number of surfaces."
    periodic_pair: list[PeriodicPair] = field(default_factory=list)
    "Defines the input options needed for periodic boundaries. We assume each periodic BC can have translational OR rotational periodicity. To transform a point on boundary A to its periodically matching point on boundary B, we first subtract the center of rotation from the point coordinates to get the distance vector from the center to the point of interest, then we apply rotation around the periodicity axis and add back the center of rotation to get the coordinates of the transformed point."
    initialization: InitializationFluid = field(default_factory=FluidPrescribedValues)
    "Type of initial condition for the field variables. Possible types: ``FluidPrescribedValues``, ``FluidFarfieldValues``, ``FluidExistingSolution`` from the ``initialization`` module."
    physical_behavior: list[PhysicalBehavior] = field(default_factory=list)
    "Physical behavior settings for a fluid flow physics solver."
    porous_behavior: list[PorousBehavior] = field(default_factory=list)
    "Porous model settings for a fluid flow physics solver."

    def _to_proto(self) -> clientpb.Fluid:
        _proto = clientpb.Fluid()
        if self.basic is not None:
            _proto.basic_fluid.CopyFrom(self.basic._to_proto())
        if self.turbulence is not None:
            _proto.turbulence.CopyFrom(self.turbulence._to_proto())
        if self.solution_controls is not None:
            _proto.solution_controls_fluid.CopyFrom(self.solution_controls._to_proto())
        if self.adjoint_controls is not None:
            _proto.adjoint_controls_fluid.CopyFrom(self.adjoint_controls._to_proto())
        if self.spatial_discretization is not None:
            _proto.spatial_discretization_fluid.CopyFrom(self.spatial_discretization._to_proto())
        if self.boundary_conditions is not None:
            _proto.boundary_conditions_fluid.extend(v._to_proto() for v in self.boundary_conditions)
        if self.sliding_interfaces is not None:
            _proto.sliding_interfaces.extend(v._to_proto() for v in self.sliding_interfaces)
        if self.periodic_pair is not None:
            _proto.periodic_pair.extend(v._to_proto() for v in self.periodic_pair)
        if self.initialization is not None:
            _proto.initialization_fluid.CopyFrom(self.initialization._to_proto())
        if self.physical_behavior is not None:
            _proto.physical_behavior.extend(v._to_proto() for v in self.physical_behavior)
        if self.porous_behavior is not None:
            _proto.porous_behavior.extend(v._to_proto() for v in self.porous_behavior)
        return _proto

    def _from_proto(self, proto: clientpb.Fluid) -> None:
        self.basic = BasicFluid.from_proto(proto.basic_fluid)
        if proto.turbulence.turbulence_model == clientpb.INVALID_TURBULENCE_MODEL:
            raise ValueError("Invalid turbulence")
        elif proto.turbulence.turbulence_model == clientpb.SPALART_ALLMARAS:
            self.turbulence = SpalartAllmaras()
        elif proto.turbulence.turbulence_model == clientpb.KOMEGA_SST:
            self.turbulence = KomegaSst()
        if self.turbulence is not None:
            self.turbulence._from_proto(proto.turbulence)
        self.solution_controls = SolutionControlsFluid.from_proto(proto.solution_controls_fluid)
        self.adjoint_controls = AdjointControlsFluid.from_proto(proto.adjoint_controls_fluid)
        self.spatial_discretization = SpatialDiscretizationFluid.from_proto(
            proto.spatial_discretization_fluid
        )
        for proto_boundary_conditions_fluid in proto.boundary_conditions_fluid:
            if (
                proto_boundary_conditions_fluid.physical_boundary
                == clientpb.INVALID_PHYSICAL_BOUNDARY
            ):
                raise ValueError("Invalid boundary_conditions_fluid")
            elif proto_boundary_conditions_fluid.physical_boundary == clientpb.WALL:
                self.boundary_conditions.append(Wall())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_fluid)
            elif proto_boundary_conditions_fluid.physical_boundary == clientpb.INLET:
                self.boundary_conditions.append(Inlet())
                if (
                    proto_boundary_conditions_fluid.inlet_momentum
                    == clientpb.INVALID_INLET_MOMENTUM
                ):
                    raise ValueError("Invalid inlet")
                elif proto_boundary_conditions_fluid.inlet_momentum == clientpb.VELOCITY_INLET:
                    self.boundary_conditions[-1] = VelocityMagnitudeInlet()
                elif (
                    proto_boundary_conditions_fluid.inlet_momentum
                    == clientpb.VELOCITY_COMPONENTS_INLET
                ):
                    self.boundary_conditions[-1] = VelocityComponentsInlet()
                elif (
                    proto_boundary_conditions_fluid.inlet_momentum == clientpb.TOTAL_PRESSURE_INLET
                ):
                    self.boundary_conditions[-1] = TotalPressureInlet()
                elif proto_boundary_conditions_fluid.inlet_momentum == clientpb.MASS_FLOW_INLET:
                    self.boundary_conditions[-1] = MassFlowInlet()
                elif proto_boundary_conditions_fluid.inlet_momentum == clientpb.FAN_CURVE_INLET:
                    self.boundary_conditions[-1] = FanCurveInlet()
                elif proto_boundary_conditions_fluid.inlet_momentum == clientpb.MACH_INLET:
                    self.boundary_conditions[-1] = MachInlet()
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_fluid)
            elif proto_boundary_conditions_fluid.physical_boundary == clientpb.OUTLET:
                self.boundary_conditions.append(Outlet())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_fluid)
            elif proto_boundary_conditions_fluid.physical_boundary == clientpb.SYMMETRY:
                self.boundary_conditions.append(Symmetry())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_fluid)
            elif proto_boundary_conditions_fluid.physical_boundary == clientpb.FARFIELD:
                self.boundary_conditions.append(Farfield())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_fluid)
        self.sliding_interfaces = [
            SlidingInterfaces.from_proto(v) for v in proto.sliding_interfaces
        ]
        self.periodic_pair = [PeriodicPair.from_proto(v) for v in proto.periodic_pair]
        if proto.initialization_fluid.initialization_type == clientpb.INVALID_INITIALIZATION_TYPE:
            raise ValueError("Invalid initialization_fluid")
        elif proto.initialization_fluid.initialization_type == clientpb.UNIFORM_VALUES:
            self.initialization = FluidPrescribedValues()
        elif proto.initialization_fluid.initialization_type == clientpb.FARFIELD_VALUES:
            self.initialization = FluidFarfieldValues()
        elif proto.initialization_fluid.initialization_type == clientpb.EXISTING_SOLUTION:
            self.initialization = FluidExistingSolution()
        if self.initialization is not None:
            self.initialization._from_proto(proto.initialization_fluid)
        self.physical_behavior = [PhysicalBehavior.from_proto(v) for v in proto.physical_behavior]
        self.porous_behavior = [PorousBehavior.from_proto(v) for v in proto.porous_behavior]
        return None
