# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.heat.boundary_conditions_heat_ import (
    BoundaryConditionsHeat,
)
from luminarycloud.params.simulation.physics.heat.boundary_conditions_heat_ import *


@dataclass(kw_only=True)
class HeatBcHeatFlux(BoundaryConditionsHeat):
    """Heat flux."""

    heat_flux: LcFloat = 0.0
    "Heat flux per unit area at wall boundary surfaces. Negative values increase temperatures at the wall while positive values decrease it. Enter 0 for an adiabatic wall."
    heat_flux_column_index: int = 0
    "Index of the column of the table in profile_bc_data for heat flux."

    def _to_proto(self) -> clientpb.BoundaryConditionsHeat:
        _proto = super()._to_proto()
        _proto.heat_physical_boundary = clientpb.HeatPhysicalBoundary.HEAT_BC_HEAT_FLUX
        _proto.fixed_heat_flux.CopyFrom(_to_ad_proto(self.heat_flux))
        _proto.heat_flux_col.value = self.heat_flux_column_index
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsHeat) -> None:
        super()._from_proto(proto)
        assert proto.heat_physical_boundary == clientpb.HeatPhysicalBoundary.HEAT_BC_HEAT_FLUX
        self.heat_flux = _from_ad_proto(proto.fixed_heat_flux)
        self.heat_flux_column_index = proto.heat_flux_col.value
        return None
