# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class BoundaryConditionsHeat(CodeRepr, ParamGroupWrapper[clientpb.BoundaryConditionsHeat]):
    """Boundary conditions for a heat transfer physics solver."""

    surfaces: list[str] = field(default_factory=list)
    ""
    id: str = field(default_factory=create_unique_id, init=False)
    ""
    name: str = ""
    ""
    enable_profile: bool = False
    "Turn on or off the ability to use tabulated data to define spatially varying boundary conditions."
    profile_table: RectilinearTable | None = None
    "Tabulated data for spatially varying boundary conditions."
    profile_type: enum.ProfileType = enum.ProfileType.CARTESIAN_X
    "Types of boundary condition profile."

    def _to_proto(self) -> clientpb.BoundaryConditionsHeat:
        _proto = clientpb.BoundaryConditionsHeat()
        if self.surfaces is not None:
            _proto.surfaces.extend(self.surfaces)
        if self.id is not None:
            _proto.boundary_condition_name = self.id
        if self.name is not None:
            _proto.boundary_condition_display_name = self.name
        _proto.profile_bc = self.enable_profile
        if self.profile_table is not None:
            if self.profile_table.table_type != _param_name_to_table_type("profile_bc_data"):
                raise TypeError("Wrong TableType used for self.profile_table")
            _proto.profile_bc_data = self.profile_table.id
        _proto.profile_type = self.profile_type.value
        return _proto

    def _from_proto(self, proto: clientpb.BoundaryConditionsHeat) -> None:
        self.surfaces.extend(proto.surfaces)
        self.id = proto.boundary_condition_name
        self.name = proto.boundary_condition_display_name
        self.enable_profile = proto.profile_bc
        if proto.profile_bc_data != "":
            self.profile_table = RectilinearTable(
                id=proto.profile_bc_data,
                name=proto.profile_bc_data,
                table_type=_param_name_to_table_type("profile_bc_data"),
            )
        self.profile_type = enum.ProfileType(proto.profile_type)
        return None
