# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.heat.heat_source.heat_source_type_ import (
    HeatSourceType,
)
from luminarycloud.params.simulation.physics.heat.heat_source.heat_source_type_ import *
from luminarycloud.params.simulation.physics.heat.heat_source.heat_source_type.heat_source_type_power_ import (
    HeatSourceTypePower,
)
from luminarycloud.params.simulation.physics.heat.heat_source.heat_source_type.heat_source_type_power_ import *
from luminarycloud.params.simulation.physics.heat.heat_source.heat_source_type.heat_source_type_power_per_unit_of_volume_ import (
    HeatSourceTypePowerPerUnitOfVolume,
)
from luminarycloud.params.simulation.physics.heat.heat_source.heat_source_type.heat_source_type_power_per_unit_of_volume_ import *


@dataclass(kw_only=True)
class HeatSource(CodeRepr, ParamGroupWrapper[clientpb.HeatSource]):
    """"""

    enable_profile: bool = False
    "Turn on or off the ability to use tabulated data to define time varying heat sources."
    profile_table: RectilinearTable | None = None
    "Tabulated data for time varying heat sources."
    profile_type: enum.ProfileType = enum.ProfileType.CARTESIAN_X
    "Types of boundary condition profile."
    heat_source_column_index: int = 0
    "Index of the column of the table for heat source."
    id: str = field(default_factory=create_unique_id, init=False)
    ""
    name: str = ""
    "Name of the heat source."
    volumes: list[str] = field(default_factory=list)
    "Ids of the zones the heat source is applied to."
    heat_source_type: HeatSourceType = field(default_factory=HeatSourceTypePower)
    "Heat source specification. Possible types: ``HeatSourceTypePower``, ``HeatSourceTypePowerPerUnitOfVolume`` from the ``heat_source_type`` module."

    def _to_proto(self) -> clientpb.HeatSource:
        _proto = clientpb.HeatSource()
        _proto.profile_source = self.enable_profile
        if self.profile_table is not None:
            if self.profile_table.table_type != _param_name_to_table_type("profile_source_data"):
                raise TypeError("Wrong TableType used for self.profile_table")
            _proto.profile_source_data = self.profile_table.id
        _proto.profile_type = self.profile_type.value
        _proto.heat_source_col.value = self.heat_source_column_index
        if self.id is not None:
            _proto.heat_source_id = self.id
        if self.name is not None:
            _proto.heat_source_name = self.name
        if self.volumes is not None:
            _proto.heat_source_zone_ids.extend(self.volumes)
        if isinstance(self.heat_source_type, HeatSourceTypePower):
            _proto.heat_source_type = clientpb.HEAT_SOURCE_TYPE_POWER
            _proto.heat_source_power.CopyFrom(_to_ad_proto(self.heat_source_type.power))
        if isinstance(self.heat_source_type, HeatSourceTypePowerPerUnitOfVolume):
            _proto.heat_source_type = clientpb.HEAT_SOURCE_TYPE_POWER_PER_UNIT_OF_VOLUME
            _proto.heat_source_power_per_unit_volume.CopyFrom(
                _to_ad_proto(self.heat_source_type.power_per_unit_volume)
            )
        return _proto

    def _from_proto(self, proto: clientpb.HeatSource) -> None:
        self.enable_profile = proto.profile_source
        if proto.profile_source_data != "":
            self.profile_table = RectilinearTable(
                id=proto.profile_source_data,
                name=proto.profile_source_data,
                table_type=_param_name_to_table_type("profile_source_data"),
            )
        self.profile_type = enum.ProfileType(proto.profile_type)
        self.heat_source_column_index = proto.heat_source_col.value
        self.id = proto.heat_source_id
        self.name = proto.heat_source_name
        self.volumes.extend(proto.heat_source_zone_ids)
        if proto.heat_source_type == clientpb.INVALID_HEAT_SOURCE_TYPE:
            raise ValueError("Invalid heat_source_type")
        elif proto.heat_source_type == clientpb.HEAT_SOURCE_TYPE_POWER:
            self.heat_source_type = HeatSourceTypePower()
            self.heat_source_type.power = _from_ad_proto(proto.heat_source_power)
        elif proto.heat_source_type == clientpb.HEAT_SOURCE_TYPE_POWER_PER_UNIT_OF_VOLUME:
            self.heat_source_type = HeatSourceTypePowerPerUnitOfVolume()
            self.heat_source_type.power_per_unit_volume = _from_ad_proto(
                proto.heat_source_power_per_unit_volume
            )
        return None
