# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.heat.solution_controls.heat_relaxation_method.heat_implicit_relaxation_ import (
    HeatImplicitRelaxation,
)
from luminarycloud.params.simulation.physics.heat.solution_controls.heat_relaxation_method.heat_implicit_relaxation_ import *
from luminarycloud.params.simulation.physics.heat.solution_controls.heat_relaxation_method_ import (
    HeatRelaxationMethod,
)
from luminarycloud.params.simulation.physics.heat.solution_controls.heat_relaxation_method_ import *


@dataclass(kw_only=True)
class SolutionControlsHeat(CodeRepr, ParamGroupWrapper[clientpb.SolutionControlsHeat]):
    """Solution controls for a heat transfer physics solver."""

    heat_relaxation_method: HeatRelaxationMethod = field(default_factory=HeatImplicitRelaxation)
    "Relaxation scheme for steady-state simulations or time implicit transient simulations. Possible types: ``HeatImplicitRelaxation`` from the ``heat_relaxation_method`` module."
    preset: enum.SolutionControlsHeatPreset = (
        enum.SolutionControlsHeatPreset.DEFAULT_SOLUTION_CONTROLS_HEAT
    )
    "Select suggested control settings or allow a custom choice. In general, assume a trade-off between speed and robustness (i.e. the ability to converge)."

    def _to_proto(self) -> clientpb.SolutionControlsHeat:
        _proto = clientpb.SolutionControlsHeat()
        if isinstance(self.heat_relaxation_method, HeatImplicitRelaxation):
            _proto.relaxation_method = clientpb.IMPLICIT
            _proto.implicit_method = self.heat_relaxation_method.implicit_method.value
            _proto.linsol_iterations.value = (
                self.heat_relaxation_method.linear_solver_type.iterations
            )
            _proto.linsol_tolerance.CopyFrom(
                _to_ad_proto(self.heat_relaxation_method.linear_solver_type.tolerance)
            )
            if isinstance(self.heat_relaxation_method.linear_solver_type, GaussSeidel):
                _proto.linear_solver_type = clientpb.GS
            if isinstance(self.heat_relaxation_method.linear_solver_type, KrylovAmg):
                _proto.linear_solver_type = clientpb.AMG_KRYLOV_AMGX
                _proto.linsol_amg_pre_sweeps.value = (
                    self.heat_relaxation_method.linear_solver_type.pre_sweeps
                )
                _proto.linsol_amg_post_sweeps.value = (
                    self.heat_relaxation_method.linear_solver_type.post_sweeps
                )
                _proto.linsol_amg_coarsening_size.value = (
                    self.heat_relaxation_method.linear_solver_type.coarsening_size
                )
                _proto.linsol_amg_levels.value = (
                    self.heat_relaxation_method.linear_solver_type.levels
                )
                _proto.linsol_amg_relaxation.CopyFrom(
                    _to_ad_proto(self.heat_relaxation_method.linear_solver_type.relaxation)
                )
                _proto.linsol_amg_cycle_type = (
                    self.heat_relaxation_method.linear_solver_type.multigrid_cycle.value
                )
                _proto.linsol_amg_freeze_levels_threshold.value = (
                    self.heat_relaxation_method.linear_solver_type.freeze_levels_threshold
                )
                _proto.linsol_amg_smoother = (
                    self.heat_relaxation_method.linear_solver_type.smoother.value
                )
        _proto.solution_controls_heat_preset = self.preset.value
        return _proto

    def _from_proto(self, proto: clientpb.SolutionControlsHeat) -> None:
        if proto.relaxation_method == clientpb.INVALID_RELAXATION_METHOD:
            raise ValueError("Invalid heat_relaxation_method")
        elif proto.relaxation_method == clientpb.IMPLICIT:
            self.heat_relaxation_method = HeatImplicitRelaxation()
            self.heat_relaxation_method.implicit_method = enum.ImplicitMethod(proto.implicit_method)
            self.heat_relaxation_method.linear_solver_type.iterations = (
                proto.linsol_iterations.value
            )
            self.heat_relaxation_method.linear_solver_type.tolerance = _from_ad_proto(
                proto.linsol_tolerance
            )
            if proto.linear_solver_type == clientpb.INVALID_LINEAR_SOLVER_TYPE:
                raise ValueError("Invalid linear_solver_type")
            elif proto.linear_solver_type == clientpb.GS:
                self.heat_relaxation_method.linear_solver_type = GaussSeidel()
            elif proto.linear_solver_type == clientpb.AMG_KRYLOV_AMGX:
                self.heat_relaxation_method.linear_solver_type = KrylovAmg()
                self.heat_relaxation_method.linear_solver_type.pre_sweeps = (
                    proto.linsol_amg_pre_sweeps.value
                )
                self.heat_relaxation_method.linear_solver_type.post_sweeps = (
                    proto.linsol_amg_post_sweeps.value
                )
                self.heat_relaxation_method.linear_solver_type.coarsening_size = (
                    proto.linsol_amg_coarsening_size.value
                )
                self.heat_relaxation_method.linear_solver_type.levels = (
                    proto.linsol_amg_levels.value
                )
                self.heat_relaxation_method.linear_solver_type.relaxation = _from_ad_proto(
                    proto.linsol_amg_relaxation
                )
                self.heat_relaxation_method.linear_solver_type.multigrid_cycle = (
                    enum.LinsolAmgCycleType(proto.linsol_amg_cycle_type)
                )
                self.heat_relaxation_method.linear_solver_type.freeze_levels_threshold = (
                    proto.linsol_amg_freeze_levels_threshold.value
                )
                self.heat_relaxation_method.linear_solver_type.smoother = enum.LinsolAmgSmoother(
                    proto.linsol_amg_smoother
                )
        self.preset = enum.SolutionControlsHeatPreset(proto.solution_controls_heat_preset)
        return None
