# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class SpatialDiscretizationHeat(CodeRepr, ParamGroupWrapper[clientpb.SpatialDiscretizationHeat]):
    """Spatial discretization settings for a heat transfer physics solver."""

    gradient_method: enum.GradientMethod = enum.GradientMethod.NODAL_GRADIENT
    "Method for computing the spatial gradients of fluid variables."
    hlsq_blend: LcFloat = 2.0
    "Blending parameter in the hybrid least squares gradient methods in [1,2]."
    geometry_fixes: enum.GeometryFixes = enum.GeometryFixes.GEOMETRY_FIXES_ON
    "Strategies to cope with problematic mesh regions (e.g. high skewness angles)."
    geometry_fixes_mitigations: LcFloat = 0.25
    "Magnitude of the geometrical fixes mitigations. Expected value within [0,1]. The higher this value, the more numerical dissipation is added at control volumes with low-quality topological properties."
    preset: enum.SpatialDiscretizationHeatPreset = (
        enum.SpatialDiscretizationHeatPreset.DEFAULT_SPATIAL_DISCRETIZATION_HEAT
    )
    "Select suggested control settings or allow a custom choice. In general, assume a trade-off between accuracy and robustness (i.e. the ability to converge)."

    def _to_proto(self) -> clientpb.SpatialDiscretizationHeat:
        _proto = clientpb.SpatialDiscretizationHeat()
        _proto.gradient_method = self.gradient_method.value
        _proto.hlsq_blend.CopyFrom(_to_ad_proto(self.hlsq_blend))
        _proto.geometry_fixes = self.geometry_fixes.value
        _proto.geometry_fixes_mitigations.CopyFrom(_to_ad_proto(self.geometry_fixes_mitigations))
        _proto.spatial_discretization_heat_preset = self.preset.value
        return _proto

    def _from_proto(self, proto: clientpb.SpatialDiscretizationHeat) -> None:
        self.gradient_method = enum.GradientMethod(proto.gradient_method)
        self.hlsq_blend = _from_ad_proto(proto.hlsq_blend)
        self.geometry_fixes = enum.GeometryFixes(proto.geometry_fixes)
        self.geometry_fixes_mitigations = _from_ad_proto(proto.geometry_fixes_mitigations)
        self.preset = enum.SpatialDiscretizationHeatPreset(proto.spatial_discretization_heat_preset)
        return None
