# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.heat.adjoint_controls_heat_ import AdjointControlsHeat
from luminarycloud.params.simulation.physics.heat.adjoint_controls_heat_ import *
from luminarycloud.params.simulation.physics.heat.boundary_conditions_heat_ import (
    BoundaryConditionsHeat,
)
from luminarycloud.params.simulation.physics.heat.boundary_conditions_heat_ import *
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_convection_ import (
    HeatBcConvection,
)
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_convection_ import *
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_heat_flux_ import (
    HeatBcHeatFlux,
)
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_heat_flux_ import *
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_integrated_heat_flux_ import (
    HeatBcIntegratedHeatFlux,
)
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_integrated_heat_flux_ import *
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_symmetry_ import (
    HeatBcSymmetry,
)
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_symmetry_ import *
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_temperature_ import (
    HeatBcTemperature,
)
from luminarycloud.params.simulation.physics.heat.boundary_conditions.heat_bc_temperature_ import *
from luminarycloud.params.simulation.physics.heat.initialization.heat_existing_solution_ import (
    HeatExistingSolution,
)
from luminarycloud.params.simulation.physics.heat.initialization.heat_existing_solution_ import *
from luminarycloud.params.simulation.physics.heat.initialization.heat_prescribed_values_ import (
    HeatPrescribedValues,
)
from luminarycloud.params.simulation.physics.heat.initialization.heat_prescribed_values_ import *
from luminarycloud.params.simulation.physics.heat.heat_source_ import HeatSource
from luminarycloud.params.simulation.physics.heat.heat_source_ import *
from luminarycloud.params.simulation.physics.heat.initialization_heat_ import InitializationHeat
from luminarycloud.params.simulation.physics.heat.initialization_heat_ import *
from luminarycloud.params.simulation.physics.periodic_pair_ import PeriodicPair
from luminarycloud.params.simulation.physics.periodic_pair_ import *
from luminarycloud.params.simulation.sliding_interfaces_ import SlidingInterfaces
from luminarycloud.params.simulation.sliding_interfaces_ import *
from luminarycloud.params.simulation.physics.heat.solution_controls_heat_ import (
    SolutionControlsHeat,
)
from luminarycloud.params.simulation.physics.heat.solution_controls_heat_ import *
from luminarycloud.params.simulation.physics.heat.spatial_discretization_heat_ import (
    SpatialDiscretizationHeat,
)
from luminarycloud.params.simulation.physics.heat.spatial_discretization_heat_ import *


@dataclass(kw_only=True)
class Heat(CodeRepr, ParamGroupWrapper[clientpb.Heat]):
    """Configuration for a heat transfer physics solver - simulates heat transfer in solid media."""

    solution_controls: SolutionControlsHeat = field(default_factory=SolutionControlsHeat)
    "Solution controls for a heat transfer physics solver."
    adjoint_controls: AdjointControlsHeat = field(default_factory=AdjointControlsHeat)
    ""
    spatial_discretization: SpatialDiscretizationHeat = field(
        default_factory=SpatialDiscretizationHeat
    )
    "Spatial discretization settings for a heat transfer physics solver."
    boundary_conditions: list[BoundaryConditionsHeat] = field(default_factory=list)
    "Boundary conditions for a heat transfer physics solver. Possible types: ``HeatBcTemperature``, ``HeatBcHeatFlux``, ``HeatBcIntegratedHeatFlux``, ``HeatBcSymmetry``, ``HeatBcConvection`` from the ``boundary_conditions`` module."
    initialization: InitializationHeat = field(default_factory=HeatPrescribedValues)
    "Type of initial condition for the field variables. Possible types: ``HeatPrescribedValues``, ``HeatExistingSolution`` from the ``initialization`` module."
    heat_source: list[HeatSource] = field(default_factory=list)
    ""
    sliding_interfaces: list[SlidingInterfaces] = field(default_factory=list)
    "Defines the two sides that form a sliding interface. The two sides are abutting, possibly in combination with a periodic transformation, and should have the same normal grid velocity. The tangential grid velocity can, and usually will, be different. Each side of the sliding interface can be composed out of an arbitrary number of surfaces."
    periodic_pair: list[PeriodicPair] = field(default_factory=list)
    "Defines the input options needed for periodic boundaries. We assume each periodic BC can have translational OR rotational periodicity. To transform a point on boundary A to its periodically matching point on boundary B, we first subtract the center of rotation from the point coordinates to get the distance vector from the center to the point of interest, then we apply rotation around the periodicity axis and add back the center of rotation to get the coordinates of the transformed point."

    def _to_proto(self) -> clientpb.Heat:
        _proto = clientpb.Heat()
        if self.solution_controls is not None:
            _proto.solution_controls_heat.CopyFrom(self.solution_controls._to_proto())
        if self.adjoint_controls is not None:
            _proto.adjoint_controls_heat.CopyFrom(self.adjoint_controls._to_proto())
        if self.spatial_discretization is not None:
            _proto.spatial_discretization_heat.CopyFrom(self.spatial_discretization._to_proto())
        if self.boundary_conditions is not None:
            _proto.boundary_conditions_heat.extend(v._to_proto() for v in self.boundary_conditions)
        if self.initialization is not None:
            _proto.initialization_heat.CopyFrom(self.initialization._to_proto())
        if self.heat_source is not None:
            _proto.heat_source.extend(v._to_proto() for v in self.heat_source)
        if self.sliding_interfaces is not None:
            _proto.sliding_interfaces.extend(v._to_proto() for v in self.sliding_interfaces)
        if self.periodic_pair is not None:
            _proto.periodic_pair.extend(v._to_proto() for v in self.periodic_pair)
        return _proto

    def _from_proto(self, proto: clientpb.Heat) -> None:
        self.solution_controls = SolutionControlsHeat.from_proto(proto.solution_controls_heat)
        self.adjoint_controls = AdjointControlsHeat.from_proto(proto.adjoint_controls_heat)
        self.spatial_discretization = SpatialDiscretizationHeat.from_proto(
            proto.spatial_discretization_heat
        )
        for proto_boundary_conditions_heat in proto.boundary_conditions_heat:
            if (
                proto_boundary_conditions_heat.heat_physical_boundary
                == clientpb.INVALID_HEAT_PHYSICAL_BOUNDARY
            ):
                raise ValueError("Invalid boundary_conditions_heat")
            elif (
                proto_boundary_conditions_heat.heat_physical_boundary == clientpb.HEAT_BC_ISOTHERMAL
            ):
                self.boundary_conditions.append(HeatBcTemperature())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_heat)
            elif (
                proto_boundary_conditions_heat.heat_physical_boundary == clientpb.HEAT_BC_HEAT_FLUX
            ):
                self.boundary_conditions.append(HeatBcHeatFlux())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_heat)
            elif (
                proto_boundary_conditions_heat.heat_physical_boundary
                == clientpb.HEAT_BC_INTEGRATED_HEAT_FLUX
            ):
                self.boundary_conditions.append(HeatBcIntegratedHeatFlux())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_heat)
            elif proto_boundary_conditions_heat.heat_physical_boundary == clientpb.HEAT_BC_SYMMETRY:
                self.boundary_conditions.append(HeatBcSymmetry())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_heat)
            elif (
                proto_boundary_conditions_heat.heat_physical_boundary == clientpb.HEAT_BC_CONVECTION
            ):
                self.boundary_conditions.append(HeatBcConvection())
                self.boundary_conditions[-1]._from_proto(proto_boundary_conditions_heat)
        if proto.initialization_heat.initialization_type == clientpb.INVALID_INITIALIZATION_TYPE:
            raise ValueError("Invalid initialization_heat")
        elif proto.initialization_heat.initialization_type == clientpb.UNIFORM_VALUES:
            self.initialization = HeatPrescribedValues()
        elif proto.initialization_heat.initialization_type == clientpb.EXISTING_SOLUTION:
            self.initialization = HeatExistingSolution()
        if self.initialization is not None:
            self.initialization._from_proto(proto.initialization_heat)
        self.heat_source = [HeatSource.from_proto(v) for v in proto.heat_source]
        self.sliding_interfaces = [
            SlidingInterfaces.from_proto(v) for v in proto.sliding_interfaces
        ]
        self.periodic_pair = [PeriodicPair.from_proto(v) for v in proto.periodic_pair]
        return None
