# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class PeriodicPair(CodeRepr, ParamGroupWrapper[clientpb.PeriodicPair]):
    """Defines the input options needed for periodic boundaries. We assume each periodic BC can have translational OR rotational periodicity. To transform a point on boundary A to its periodically matching point on boundary B, we first subtract the center of rotation from the point coordinates to get the distance vector from the center to the point of interest, then we apply rotation around the periodicity axis and add back the center of rotation to get the coordinates of the transformed point."""

    name: str = ""
    ""
    surfaces_side_a: list[str] = field(default_factory=list)
    ""
    surfaces_side_b: list[str] = field(default_factory=list)
    ""
    translation: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "Holds the translation vector in the x,y,z directions from each point on the first periodic boundary to its matching point on the second periodic boundary."
    center: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "Origin for the rotational periodicity transformation."
    rotation_vector: Vector3 = field(default_factory=lambda: Vector3(0.0, 0.0, 0.0))
    "Holds the rotation vector needed to transform each point on the first periodic boundary to its matching point on the second periodic boundary. The vector direction defines the periodicity axis and its magnitude defines the periodicity angle, in degrees, from A to B according to the right-hand rule."

    def _to_proto(self) -> clientpb.PeriodicPair:
        _proto = clientpb.PeriodicPair()
        if self.name is not None:
            _proto.periodic_pair_name = self.name
        if self.surfaces_side_a is not None:
            _proto.bound_a.extend(self.surfaces_side_a)
        if self.surfaces_side_b is not None:
            _proto.bound_b.extend(self.surfaces_side_b)
        _proto.periodic_translation.CopyFrom(self.translation._to_ad_proto())
        _proto.periodic_center_of_rotation.CopyFrom(self.center._to_ad_proto())
        _proto.periodic_rotation_angles.CopyFrom(self.rotation_vector._to_ad_proto())
        return _proto

    def _from_proto(self, proto: clientpb.PeriodicPair) -> None:
        self.name = proto.periodic_pair_name
        self.surfaces_side_a.extend(proto.bound_a)
        self.surfaces_side_b.extend(proto.bound_b)
        self.translation._from_ad_proto(proto.periodic_translation)
        self.center._from_ad_proto(proto.periodic_center_of_rotation)
        self.rotation_vector._from_ad_proto(proto.periodic_rotation_angles)
        return None
