# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.physics.fluid_ import Fluid
from luminarycloud.params.simulation.physics.fluid_ import *
from luminarycloud.params.simulation.physics.heat_ import Heat
from luminarycloud.params.simulation.physics.heat_ import *


@dataclass(kw_only=True)
class Physics(CodeRepr, ParamGroupWrapper[clientpb.Physics]):
    """Single physics solver entity."""

    physics_identifier: EntityIdentifier = field(
        default_factory=_create_entity_identifier, init=True
    )
    "Unique identifier for a physics entity."
    heat: Heat | None = None
    "Configuration for a heat transfer physics solver - simulates heat transfer in solid media."
    fluid: Fluid | None = None
    "Configuration for a fluid flow physics solver - simulates the flow of liquids and gases."

    def _to_proto(self) -> clientpb.Physics:
        _proto = clientpb.Physics()
        if self.physics_identifier is not None:
            _proto.physics_identifier.id = self.physics_identifier.id
            _proto.physics_identifier.name = self.physics_identifier.name
        if self.heat is not None:
            _proto.heat.CopyFrom(self.heat._to_proto())
        if self.fluid is not None:
            _proto.fluid.CopyFrom(self.fluid._to_proto())
        return _proto

    def _from_proto(self, proto: clientpb.Physics) -> None:
        self.physics_identifier = proto.physics_identifier
        if proto.heat.ByteSize() > 0:
            self.heat = Heat.from_proto(proto.heat)
        if proto.fluid.ByteSize() > 0:
            self.fluid = Fluid.from_proto(proto.fluid)
        return None
