# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.adaptive_mesh_refinement_ import AdaptiveMeshRefinement
from luminarycloud.params.simulation.adaptive_mesh_refinement_ import *
from luminarycloud.params.simulation.adjoint_ import Adjoint
from luminarycloud.params.simulation.adjoint_ import *
from luminarycloud.params.simulation.body_frame_ import BodyFrame
from luminarycloud.params.simulation.body_frame_ import *
from luminarycloud.params.simulation.entity_relationships_ import EntityRelationships
from luminarycloud.params.simulation.entity_relationships_ import *
from luminarycloud.params.simulation.general_ import General
from luminarycloud.params.simulation.general_ import *
from luminarycloud.params.simulation.material_entity_ import MaterialEntity
from luminarycloud.params.simulation.material_entity_ import *
from luminarycloud.params.simulation.monitor_plane_ import MonitorPlane
from luminarycloud.params.simulation.monitor_plane_ import *
from luminarycloud.params.simulation.motion_data_ import MotionData
from luminarycloud.params.simulation.motion_data_ import *
from luminarycloud.params.simulation.multi_physics_coupling_options_ import (
    MultiPhysicsCouplingOptions,
)
from luminarycloud.params.simulation.multi_physics_coupling_options_ import *
from luminarycloud.params.simulation.output_ import Output
from luminarycloud.params.simulation.output_ import *
from luminarycloud.params.simulation.particle_group_ import ParticleGroup
from luminarycloud.params.simulation.particle_group_ import *
from luminarycloud.params.simulation.physics_ import Physics
from luminarycloud.params.simulation.physics_ import *
from luminarycloud.params.simulation.sliding_interfaces_ import SlidingInterfaces
from luminarycloud.params.simulation.sliding_interfaces_ import *
from luminarycloud.params.simulation.surface_name_ import SurfaceName
from luminarycloud.params.simulation.surface_name_ import *
from luminarycloud.params.simulation.time_ import Time
from luminarycloud.params.simulation.time_ import *
from luminarycloud.params.simulation.volume_entity_ import VolumeEntity
from luminarycloud.params.simulation.volume_entity_ import *


@dataclass(kw_only=True)
class SimulationParam(CodeRepr, ParamGroupWrapper[clientpb.SimulationParam]):
    """Simulation configuration that supports multiple physics."""

    materials: list[MaterialEntity] = field(default_factory=list)
    "Material entity."
    volume_entity: list[VolumeEntity] = field(default_factory=list)
    "Volume entity."
    basic: General = field(default_factory=General)
    "Basic parameters used by a solution."
    adjoint: Adjoint = field(default_factory=Adjoint)
    "Settings for adjoint sensitivity analysis."
    time: Time = field(default_factory=Time)
    "Time parameters used by a transient solution (required if flow_behavior = transient)."
    motion_data: list[MotionData] = field(default_factory=list)
    "Motion data."
    particle_group: list[ParticleGroup] = field(default_factory=list)
    "Particle groups."
    monitor_plane: list[MonitorPlane] = field(default_factory=list)
    "Monitor plane."
    body_frame: BodyFrame = field(default_factory=BodyFrame)
    "Body frame."
    surface_name: dict[str, SurfaceName] = field(default_factory=dict)
    "Surface name map."
    _table_references: dict[str, Any] = field(default_factory=dict)
    "Solution inputs - metadata for general n-dimensional rectilinear grid data (Monitor points, radial distribution, blade geometry, airfoil performance)."
    output: Output = field(default_factory=Output)
    "Solution output settings."
    entity_relationships: EntityRelationships = field(default_factory=EntityRelationships)
    "Relationships between different entities."
    adaptive_mesh_refinement: AdaptiveMeshRefinement = field(default_factory=AdaptiveMeshRefinement)
    "Adaptive Mesh Refinement."
    physics: list[Physics] = field(default_factory=list)
    "Single physics solver entity."
    interfaces: list[SlidingInterfaces] = field(default_factory=list)
    "Defines the two sides that form a sliding interface. The two sides are abutting, possibly in combination with a periodic transformation, and should have the same normal grid velocity. The tangential grid velocity can, and usually will, be different. Each side of the sliding interface can be composed out of an arbitrary number of surfaces."
    mp_coupling_options: MultiPhysicsCouplingOptions | None = field(
        default_factory=MultiPhysicsCouplingOptions
    )
    "Defines coupling solution strategies between different physics."

    def _to_proto(self) -> clientpb.SimulationParam:
        _proto = clientpb.SimulationParam()
        if self.materials is not None:
            _proto.material_entity.extend(v._to_proto() for v in self.materials)
        if self.volume_entity is not None:
            _proto.volume_entity.extend(v._to_proto() for v in self.volume_entity)
        if self.basic is not None:
            _proto.general.CopyFrom(self.basic._to_proto())
        if self.adjoint is not None:
            _proto.adjoint.CopyFrom(self.adjoint._to_proto())
        if self.time is not None:
            _proto.time.CopyFrom(self.time._to_proto())
        if self.motion_data is not None:
            _proto.motion_data.extend(v._to_proto() for v in self.motion_data)
        if self.particle_group is not None:
            _proto.particle_group.extend(v._to_proto() for v in self.particle_group)
        if self.monitor_plane is not None:
            _proto.monitor_plane.extend(v._to_proto() for v in self.monitor_plane)
        if self.body_frame is not None:
            _proto.body_frame.CopyFrom(self.body_frame._to_proto())
        if self.surface_name is not None:
            for k, v in self.surface_name.items():
                _proto.surface_name[k].CopyFrom(v._to_proto())
        if self._table_references is not None:
            for k, v in self._table_references.items():
                _proto.table_references[k].CopyFrom(v)
        if self.output is not None:
            _proto.output.CopyFrom(self.output._to_proto())
        if self.entity_relationships is not None:
            _proto.entity_relationships.CopyFrom(self.entity_relationships._to_proto())
        if self.adaptive_mesh_refinement is not None:
            _proto.adaptive_mesh_refinement.CopyFrom(self.adaptive_mesh_refinement._to_proto())
        if self.physics is not None:
            _proto.physics.extend(v._to_proto() for v in self.physics)
        if self.interfaces is not None:
            _proto.interfaces.extend(v._to_proto() for v in self.interfaces)
        if self.mp_coupling_options is not None:
            _proto.mp_coupling_options.CopyFrom(self.mp_coupling_options._to_proto())
        return _proto

    def _from_proto(self, proto: clientpb.SimulationParam) -> None:
        self.materials = [MaterialEntity.from_proto(v) for v in proto.material_entity]
        self.volume_entity = [VolumeEntity.from_proto(v) for v in proto.volume_entity]
        self.basic = General.from_proto(proto.general)
        self.adjoint = Adjoint.from_proto(proto.adjoint)
        self.time = Time.from_proto(proto.time)
        self.motion_data = [MotionData.from_proto(v) for v in proto.motion_data]
        self.particle_group = [ParticleGroup.from_proto(v) for v in proto.particle_group]
        self.monitor_plane = [MonitorPlane.from_proto(v) for v in proto.monitor_plane]
        self.body_frame = BodyFrame.from_proto(proto.body_frame)
        self.surface_name = {k: SurfaceName.from_proto(v) for k, v in proto.surface_name.items()}
        self._table_references.update(proto.table_references)
        self.output = Output.from_proto(proto.output)
        self.entity_relationships = EntityRelationships.from_proto(proto.entity_relationships)
        self.adaptive_mesh_refinement = AdaptiveMeshRefinement.from_proto(
            proto.adaptive_mesh_refinement
        )
        self.physics = [Physics.from_proto(v) for v in proto.physics]
        self.interfaces = [SlidingInterfaces.from_proto(v) for v in proto.interfaces]
        self.mp_coupling_options = MultiPhysicsCouplingOptions.from_proto(proto.mp_coupling_options)
        return None
